/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.matches;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.StyledDocument;
import org.omegat.core.Core;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.core.matching.DiffDriver;
import org.omegat.core.matching.NearString;
import org.omegat.core.matching.external.IExternalMemory;
import org.omegat.filters2.master.PluginUtils;
import org.omegat.gui.common.EntryInfoThreadPane;
import org.omegat.gui.main.DockableScrollPane;
import org.omegat.gui.main.MainWindow;
import org.omegat.gui.matches.FindMatchesThread;
import org.omegat.gui.matches.IMatcher;
import org.omegat.gui.matches.MatchesVarExpansion;
import org.omegat.tokenizer.ITokenizer;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.PatternConsts;
import org.omegat.util.Preferences;
import org.omegat.util.StringUtil;
import org.omegat.util.TMXProp;
import org.omegat.util.Token;
import org.omegat.util.gui.DragTargetOverlay;
import org.omegat.util.gui.StaticUIUtils;
import org.omegat.util.gui.Styles;
import org.omegat.util.gui.UIThreadsUtil;

public class MatchesTextArea
extends EntryInfoThreadPane<List<NearString>>
implements IMatcher {
    private static final String EXPLANATION = OStrings.getString("GUI_MATCHWINDOW_explanation");
    private static final AttributeSet ATTRIBUTES_EMPTY = Styles.createAttributeSet(null, null, null, null);
    private static final AttributeSet ATTRIBUTES_CHANGED = Styles.createAttributeSet(Styles.EditorColor.COLOR_MATCHES_CHANGED.getColor(), null, null, null);
    private static final AttributeSet ATTRIBUTES_UNCHANGED = Styles.createAttributeSet(Styles.EditorColor.COLOR_MATCHES_UNCHANGED.getColor(), null, null, null);
    private static final AttributeSet ATTRIBUTES_SELECTED = Styles.createAttributeSet(null, null, true, null);
    private static final AttributeSet ATTRIBUTES_DELETED_ACTIVE = Styles.createAttributeSet(Styles.EditorColor.COLOR_MATCHES_DEL_ACTIVE.getColor(), null, true, null, true, null);
    private static final AttributeSet ATTRIBUTES_DELETED_INACTIVE = Styles.createAttributeSet(Styles.EditorColor.COLOR_MATCHES_DEL_INACTIVE.getColor(), null, null, null, true, null);
    private static final AttributeSet ATTRIBUTES_INSERTED_ACTIVE = Styles.createAttributeSet(Styles.EditorColor.COLOR_MATCHES_INS_ACTIVE.getColor(), null, true, null, null, true);
    private static final AttributeSet ATTRIBUTES_INSERTED_INACTIVE = Styles.createAttributeSet(Styles.EditorColor.COLOR_MATCHES_INS_INACTIVE.getColor(), null, null, null, null, true);
    private final List<NearString> matches = new ArrayList<NearString>();
    private final List<Integer> delimiters = new ArrayList<Integer>();
    private final List<Integer> sourcePos = new ArrayList<Integer>();
    private final List<Map<Integer, List<DiffDriver.TextRun>>> diffInfos = new ArrayList<Map<Integer, List<DiffDriver.TextRun>>>();
    private int activeMatch;
    private final MainWindow mw;
    private final IExternalMemory[] externalMemories;
    private FindMatchesThread theThread;
    protected MouseListener mouseListener = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent e) {
            if (MatchesTextArea.this.matches == null || MatchesTextArea.this.matches.isEmpty()) {
                return;
            }
            int clickedItem = -1;
            int mousepos = MatchesTextArea.this.viewToModel(e.getPoint());
            for (int i = 0; i < MatchesTextArea.this.delimiters.size() - 1; ++i) {
                int start = (Integer)MatchesTextArea.this.delimiters.get(i);
                int end = (Integer)MatchesTextArea.this.delimiters.get(i + 1);
                if (mousepos < start || mousepos >= end) continue;
                clickedItem = i;
                break;
            }
            if (clickedItem == -1) {
                clickedItem = MatchesTextArea.this.delimiters.size() - 1;
            }
            if (clickedItem >= MatchesTextArea.this.matches.size()) {
                return;
            }
            if (e.isPopupTrigger() || e.getButton() == 3) {
                MatchesTextArea.this.mouseRightClick(clickedItem, e.getPoint());
            }
            if (e.getButton() == 1 && e.getClickCount() > 1) {
                MatchesTextArea.this.setActiveMatch(clickedItem);
            }
        }
    };

    public MatchesTextArea(MainWindow mw) {
        super(true);
        this.mw = mw;
        String title = OStrings.getString("GUI_MATCHWINDOW_SUBWINDOWTITLE_Fuzzy_Matches");
        final DockableScrollPane scrollPane = new DockableScrollPane("MATCHES", title, this, true);
        Core.getMainWindow().addDockable(scrollPane);
        this.setEditable(false);
        StaticUIUtils.makeCaretAlwaysVisible(this);
        this.setText(EXPLANATION);
        this.setDragEnabled(true);
        this.setMinimumSize(new Dimension(100, 50));
        this.addMouseListener(this.mouseListener);
        ArrayList<IExternalMemory> list = new ArrayList<IExternalMemory>();
        for (Class<?> mtc : PluginUtils.getTranslationMemoryClasses()) {
            try {
                list.add((IExternalMemory)mtc.newInstance());
            }
            catch (Exception ex) {
                Log.log(ex);
            }
        }
        this.externalMemories = list.toArray(new IExternalMemory[list.size()]);
        for (int i = 0; i < 5; ++i) {
            KeyStroke key = KeyStroke.getKeyStroke(97 + i, 2, false);
            mw.getRootPane().getInputMap(2).put(key, "SET" + i);
            class SelectAction
            extends AbstractAction {
                private int num;

                public SelectAction(int num) {
                    this.num = num;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    MatchesTextArea.this.setActiveMatch(this.num);
                }
            }
            mw.getRootPane().getActionMap().put("SET" + i, new SelectAction(i));
        }
        DragTargetOverlay.apply(this, new DragTargetOverlay.FileDropInfo(mw, false){

            @Override
            public String getImportDestination() {
                return Core.getProject().getProjectProperties().getTMRoot();
            }

            @Override
            public boolean acceptFile(File pathname) {
                return pathname.getName().toLowerCase().endsWith(".tmx");
            }

            @Override
            public String getOverlayMessage() {
                return OStrings.getString("DND_ADD_TM_FILE");
            }

            @Override
            public boolean canAcceptDrop() {
                return Core.getProject().isProjectLoaded();
            }

            @Override
            public Component getComponentToOverlay() {
                return scrollPane;
            }
        });
    }

    @Override
    protected void startSearchThread(SourceTextEntry newEntry) {
        this.matches.clear();
        this.theThread = new FindMatchesThread(this, Core.getProject(), this.externalMemories, newEntry);
        this.theThread.start();
    }

    @Override
    protected void setFoundResult(SourceTextEntry se, List<NearString> newMatches) {
        UIThreadsUtil.mustBeSwingThread();
        this.clear();
        if (newMatches == null) {
            return;
        }
        Collections.sort(newMatches, Collections.reverseOrder(new NearString.ScoresComparator()));
        this.matches.addAll(newMatches);
        this.delimiters.add(0);
        StringBuilder displayBuffer = new StringBuilder();
        MatchesVarExpansion template = new MatchesVarExpansion(Preferences.getPreferenceDefault("ext_tmx_match_template", "${id}. ${fuzzyFlag}${sourceText}\n${targetText}\n<${score}% ${filePath}>"));
        for (int i = 0; i < newMatches.size(); ++i) {
            NearString match = newMatches.get(i);
            MatchesVarExpansion.Result result = template.apply(match, i + 1);
            displayBuffer.append(result.text);
            this.sourcePos.add(result.sourcePos);
            this.diffInfos.add(result.diffInfo);
            if (i < newMatches.size() - 1) {
                displayBuffer.append("\n\n");
            }
            this.delimiters.add(displayBuffer.length());
        }
        this.setText(displayBuffer.toString());
        this.setActiveMatch(0);
        this.checkForReplaceTranslation();
    }

    @Override
    protected void onProjectOpen() {
        this.clear();
    }

    @Override
    protected void onProjectClose() {
        this.clear();
        this.setText(EXPLANATION);
        StyledDocument doc = (StyledDocument)this.getDocument();
        doc.setCharacterAttributes(0, doc.getLength(), ATTRIBUTES_EMPTY, true);
    }

    @Override
    public NearString getActiveMatch() {
        UIThreadsUtil.mustBeSwingThread();
        if (this.activeMatch < 0 || this.activeMatch >= this.matches.size()) {
            return null;
        }
        return this.matches.get(this.activeMatch);
    }

    @Override
    public String substituteNumbers(String source, String sourceMatch, String targetMatch) {
        ITokenizer sourceTok = Core.getProject().getSourceTokenizer();
        ITokenizer targetTok = Core.getProject().getTargetTokenizer();
        Token[] sourceMatchStrTokensAll = sourceTok.tokenizeVerbatim(sourceMatch);
        List<String> sourceMatchNumbers = this.getNumberList(sourceMatchStrTokensAll, sourceMatch);
        Token[] targetMatchStrTokensAll = targetTok.tokenizeVerbatim(targetMatch);
        List<String> targetMatchNumbers = this.getNumberList(targetMatchStrTokensAll, targetMatch);
        Token[] sourceStrTokensAll = sourceTok.tokenizeVerbatim(source);
        List<String> sourceNumbers = this.getNumberList(sourceStrTokensAll, source);
        if (sourceMatchNumbers.size() != targetMatchNumbers.size() || sourceMatchNumbers.size() != sourceNumbers.size()) {
            return targetMatch;
        }
        ArrayList<Integer> matchingNumbers = new ArrayList<Integer>();
        ArrayList<Integer> foundLocation = new ArrayList<Integer>();
        for (String oneNumber : sourceMatchNumbers) {
            int pos = -1;
            for (Token oneToken : targetMatchStrTokensAll) {
                if (!oneNumber.equals(oneToken.getTextFromString(targetMatch)) || foundLocation.contains(++pos)) continue;
                matchingNumbers.add(pos);
                foundLocation.add(pos);
            }
            if (pos != -1) continue;
            return targetMatch;
        }
        Object finalString = "";
        int pos = -1;
        for (Token oneToken : targetMatchStrTokensAll) {
            ++pos;
            boolean replaced = false;
            for (int numberRank = 0; numberRank < matchingNumbers.size(); ++numberRank) {
                if ((Integer)matchingNumbers.get(numberRank) != pos) continue;
                finalString = (String)finalString + sourceNumbers.get(numberRank);
                replaced = true;
            }
            if (replaced) continue;
            finalString = (String)finalString + oneToken.getTextFromString(targetMatch);
        }
        return finalString;
    }

    private List<String> getNumberList(Token[] strTokenAll, String text) {
        ArrayList<String> numberList = new ArrayList<String>();
        for (Token oneToken : strTokenAll) {
            try {
                Integer.parseInt(oneToken.getTextFromString(text));
                numberList.add(oneToken.getTextFromString(text));
            }
            catch (NumberFormatException nfe) {
                try {
                    Double.parseDouble(oneToken.getTextFromString(text));
                    numberList.add(oneToken.getTextFromString(text));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return numberList;
    }

    @Override
    public boolean isInsertMatch() {
        try {
            this.theThread.join();
        }
        catch (Exception e) {
            return false;
        }
        if (this.matches.isEmpty()) {
            return false;
        }
        if (Preferences.isPreference("wf_insertBestMatch")) {
            int percentage = Preferences.getPreferenceDefault("wf_minimalSimilarity", 80);
            NearString thebest = this.matches.get(0);
            if (thebest.scoreImproved >= percentage) {
                String traLang1 = null;
                if (thebest.props != null) {
                    for (TMXProp prop : thebest.props) {
                        if (!prop.getType().equals("x-target-lang")) continue;
                        traLang1 = prop.getValue();
                    }
                }
                if (traLang1 == null) {
                    return true;
                }
                Matcher matcher = PatternConsts.LANG_AND_COUNTRY.matcher(traLang1);
                if (!matcher.find()) {
                    return false;
                }
                traLang1 = matcher.group(1);
                if (traLang1.equalsIgnoreCase(Core.getProject().getProjectProperties().getTargetLanguage().getLanguageCode())) {
                    return true;
                }
                String prefForeign = Preferences.getPreferenceDefault("keep_foreign_matches", "30 false");
                if (!prefForeign.contains(";")) {
                    return false;
                }
                String[] prefForeigns = prefForeign.split(";");
                for (int i = 0; i < prefForeigns.length - 1; ++i) {
                    String traLang2 = prefForeigns[i].substring(0, prefForeigns[i].indexOf(32));
                    if (traLang1.equalsIgnoreCase(traLang2)) {
                        return prefForeigns[i].contains("with-insert");
                    }
                    matcher = PatternConsts.LANG_AND_COUNTRY.matcher(traLang2);
                    if (matcher.find()) {
                        traLang2 = matcher.group(1);
                    }
                    if (!traLang1.equalsIgnoreCase(traLang2)) continue;
                    return prefForeigns[i].contains("with-insert");
                }
                return false;
            }
            return false;
        }
        return false;
    }

    private void checkForReplaceTranslation() {
        if (this.isInsertMatch()) {
            NearString thebest = this.matches.get(0);
            SourceTextEntry currentEntry = Core.getEditor().getCurrentEntry();
            TMXEntry te = Core.getProject().getTranslationInfo(currentEntry.getKey());
            if (te != null && !te.isTranslated()) {
                String prefix = "";
                if (!Preferences.getPreferenceDefaultAllowEmptyString("wf_explanatoryText").equals("")) {
                    prefix = Preferences.getPreferenceDefault("wf_explanatoryText", OStrings.getString("WF_DEFAULT_PREFIX"));
                }
                String translation = thebest.translation;
                if (Preferences.isPreference("wf_convertNumbers")) {
                    translation = this.substituteNumbers(currentEntry.getSrcText(), thebest.source, thebest.translation);
                }
                Core.getEditor().insertInfo(this.mw.formatComesFromMatch(thebest));
                Core.getEditor().replaceEditTextWithColor(prefix + translation, thebest.adjustedScore == 100 ? Styles.EditorColor.COLOR_MARK_COMES_FROM_TM_PERFECT.getColor() : Styles.EditorColor.COLOR_MARK_COMES_FROM_TM_FUZZY.getColor(), false);
            }
        }
    }

    @Override
    public void setActiveMatch(int activeMatch) {
        UIThreadsUtil.mustBeSwingThread();
        if (activeMatch < 0 || activeMatch >= this.matches.size() || this.activeMatch == activeMatch) {
            return;
        }
        this.activeMatch = activeMatch;
        StyledDocument doc = (StyledDocument)this.getDocument();
        doc.setCharacterAttributes(0, doc.getLength(), ATTRIBUTES_EMPTY, true);
        int start = this.delimiters.get(activeMatch);
        int end = this.delimiters.get(activeMatch + 1);
        NearString match = this.matches.get(activeMatch);
        ITokenizer tokenizer = Core.getProject().getSourceTokenizer();
        if (tokenizer == null) {
            return;
        }
        if (this.sourcePos.get(activeMatch) != -1) {
            Token[] tokens = tokenizer.tokenizeVerbatim(match.source);
            byte[] attributes = match.attr;
            for (int i = 0; i < tokens.length; ++i) {
                Token token = tokens[i];
                int tokstart = start + this.sourcePos.get(activeMatch) + token.getOffset();
                int toklength = token.getLength();
                if ((attributes[i] & 1) != 0) {
                    doc.setCharacterAttributes(tokstart, toklength, ATTRIBUTES_CHANGED, false);
                    continue;
                }
                if ((attributes[i] & 2) == 0) continue;
                doc.setCharacterAttributes(tokstart, toklength, ATTRIBUTES_UNCHANGED, false);
            }
        }
        for (int i = 0; i < this.diffInfos.size(); ++i) {
            Map<Integer, List<DiffDriver.TextRun>> diffInfo = this.diffInfos.get(i);
            for (Map.Entry<Integer, List<DiffDriver.TextRun>> e : diffInfo.entrySet()) {
                int diffPos = e.getKey();
                if (diffPos == -1) continue;
                for (DiffDriver.TextRun r : e.getValue()) {
                    int tokstart = this.delimiters.get(i) + diffPos + r.start;
                    switch (r.type) {
                        case DELETE: {
                            doc.setCharacterAttributes(tokstart, r.length, i == activeMatch ? ATTRIBUTES_DELETED_ACTIVE : ATTRIBUTES_DELETED_INACTIVE, false);
                            break;
                        }
                        case INSERT: {
                            doc.setCharacterAttributes(tokstart, r.length, i == activeMatch ? ATTRIBUTES_INSERTED_ACTIVE : ATTRIBUTES_INSERTED_INACTIVE, false);
                        }
                    }
                }
            }
        }
        doc.setCharacterAttributes(start, end - start, ATTRIBUTES_SELECTED, false);
        this.setCaretPosition(end - 2);
        final int fstart = start;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MatchesTextArea.this.setCaretPosition(fstart);
            }
        });
    }

    @Override
    public void clear() {
        super.clear();
        this.activeMatch = -1;
        this.matches.clear();
        this.delimiters.clear();
        this.sourcePos.clear();
        this.diffInfos.clear();
    }

    private void mouseRightClick(final int clickedItem, Point clickedPoint) {
        JMenuItem item;
        JPopupMenu popup = new JPopupMenu();
        NearString m = this.matches.get(clickedItem);
        Iterator<NearString> I = m.getMergedEntries();
        if (I.hasNext()) {
            item = popup.add(OStrings.getString("MATCHES_PROJECTS"));
            item.setEnabled(false);
            while (I.hasNext()) {
                m = I.next();
                StringBuilder b = new StringBuilder();
                if (m.proj.equals("")) {
                    b.append(OStrings.getString("MATCHES_THIS_PROJECT"));
                } else {
                    b.append(m.proj);
                }
                b.append(" ");
                b.append(m.scoresToString());
                JMenuItem pItem = popup.add(b.toString());
                pItem.setEnabled(false);
            }
            popup.addSeparator();
        }
        item = popup.add(OStrings.getString("MATCHES_INSERT"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (StringUtil.isEmpty(MatchesTextArea.this.getSelectedText())) {
                    MatchesTextArea.this.setActiveMatch(clickedItem);
                }
                MatchesTextArea.this.mw.doInsertTrans();
            }
        });
        item = popup.add(OStrings.getString("MATCHES_REPLACE"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (StringUtil.isEmpty(MatchesTextArea.this.getSelectedText())) {
                    MatchesTextArea.this.setActiveMatch(clickedItem);
                }
                MatchesTextArea.this.mw.doRecycleTrans();
            }
        });
        popup.addSeparator();
        final NearString ns = this.matches.get(clickedItem);
        String proj = ns.proj;
        item = popup.add(OStrings.getString("MATCHES_GO_TO_SEGMENT_SOURCE"));
        if (StringUtil.isEmpty(proj)) {
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Core.getEditor().gotoEntry(ns.source, ns.key);
                }
            });
        } else {
            item.setEnabled(false);
        }
        popup.show(this, clickedPoint.x, clickedPoint.y);
    }

    @Override
    public void setNextActiveMatch() {
        if (this.activeMatch < this.matches.size() - 1) {
            this.setActiveMatch(this.activeMatch + 1);
        }
    }

    @Override
    public void setPrevActiveMatch() {
        if (this.activeMatch > 0) {
            this.setActiveMatch(this.activeMatch - 1);
        }
    }
}

