/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.matches;

import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.omegat.core.Core;
import org.omegat.core.data.ProjectProperties;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.core.matching.DiffDriver;
import org.omegat.core.matching.NearString;
import org.omegat.util.OStrings;
import org.omegat.util.StringUtil;
import org.omegat.util.VarExpansion;

public class MatchesVarExpansion
extends VarExpansion<NearString> {
    public static final String VAR_NOTE = "${note}";
    public static final String VAR_ID = "${id}";
    public static final String VAR_SCORE_BASE = "${score}";
    public static final String VAR_SCORE_STEM = "${scoreStem}";
    public static final String VAR_SCORE_NOSTEM = "${noStemScore}";
    public static final String VAR_SCORE_ADJUSTED = "${adjustedScore}";
    public static final String VAR_SCORE_IMPROVED = "${improvedScore}";
    @Deprecated
    public static final String VAR_CREATION_ID = "${creationId}";
    @Deprecated
    public static final String VAR_CREATION_DATE = "${creationDate}";
    public static final String VAR_INITIAL_CREATION_ID = "${initialCreationId}";
    public static final String VAR_INITIAL_CREATION_DATE = "${initialCreationDate}";
    public static final String VAR_CHANGED_ID = "${changedId}";
    public static final String VAR_CHANGED_DATE = "${changedDate}";
    public static final String VAR_FUZZY_FLAG = "${fuzzyFlag}";
    public static final String VAR_DIFF = "${diff}";
    public static final String VAR_DIFF_TRA = "${diffTra}";
    public static final String VAR_DIFF_REVERSED = "${diffReversed}";
    public static final String[] MATCHES_VARIABLES = new String[]{"${id}", "${note}", "${sourceText}", "${diff}", "${diffReversed}", "${targetText}", "${diffTra}", "${score}", "${scoreStem}", "${noStemScore}", "${adjustedScore}", "${fileNameOnly}", "${filePath}", "${fileShortPath}", "${initialCreationId}", "${initialCreationDate}", "${changedId}", "${changedDate}", "${fuzzyFlag}", "@{file}", "@{id}", "@{prev}", "@{next}", "@{path}", "@{revisor}", "@{revised}", "@{Att::Req. Serv}", "@{Att::Year}", "@{Att::Doc. Type}", "@{Txt::Doc. No.}", "@{Txt::Stored by}", "@{Txt::Translator}", "@{Txt::TM Database}"};
    public static final String DEFAULT_TEMPLATE = "${id}. ${fuzzyFlag}${sourceText}\n${targetText}\n<${score}% ${filePath}>";
    private static Replacer sourceTextReplacer = new Replacer(){

        @Override
        public void replace(Result R, NearString match) {
            R.sourcePos = R.text.indexOf("${sourceText}");
            R.text = R.text.replace("${sourceText}", match.source);
        }
    };
    private static Replacer diffReplacer = new Replacer(){

        @Override
        public void replace(Result R, NearString match) {
            int diffPos = R.text.indexOf(MatchesVarExpansion.VAR_DIFF);
            SourceTextEntry ste = Core.getEditor().getCurrentEntry();
            if (diffPos != -1 && ste != null) {
                DiffDriver.Render diffRender = DiffDriver.render(match.source, ste.getSrcText(), true, true);
                R.diffInfo.put(diffPos, diffRender.formatting);
                if (diffRender.text != null) {
                    R.text = R.text.replace(MatchesVarExpansion.VAR_DIFF, diffRender.text);
                }
            }
        }
    };
    private static Replacer diffTraReplacer = new Replacer(){

        @Override
        public void replace(Result R, NearString match) {
            int diffPos = R.text.indexOf(MatchesVarExpansion.VAR_DIFF_TRA);
            try {
                SourceTextEntry ste = Core.getEditor().getCurrentEntry();
                TMXEntry tmxEntry = Core.getProject().getTranslationInfo(ste.getKey());
                if (diffPos != -1 && ste != null) {
                    String tra = tmxEntry.translation;
                    if (tra == null) {
                        tra = match.translation;
                    }
                    if (tra.trim().length() == 0) {
                        tra = match.translation;
                    }
                    DiffDriver.Render diffRender = DiffDriver.render(match.translation, tra, false, true);
                    R.diffInfo.put(diffPos, diffRender.formatting);
                    if (diffRender.text != null) {
                        R.text = R.text.replace(MatchesVarExpansion.VAR_DIFF_TRA, diffRender.text);
                    }
                }
            }
            catch (Exception e) {
                R.text = R.text.replace(MatchesVarExpansion.VAR_DIFF_TRA, match.translation);
            }
        }
    };
    private static Replacer diffReversedReplacer = new Replacer(){

        @Override
        public void replace(Result R, NearString match) {
            int diffPos = R.text.indexOf(MatchesVarExpansion.VAR_DIFF_REVERSED);
            SourceTextEntry ste = Core.getEditor().getCurrentEntry();
            if (diffPos != -1 && ste != null) {
                DiffDriver.Render diffRender = DiffDriver.render(ste.getSrcText(), match.source, true, true);
                R.diffInfo.put(diffPos, diffRender.formatting);
                R.text = R.text.replace(MatchesVarExpansion.VAR_DIFF_REVERSED, diffRender.text);
            }
        }
    };
    private Map<Integer, Replacer> styledComponents = new TreeMap<Integer, Replacer>();

    public MatchesVarExpansion(String template) {
        super(template);
    }

    @Override
    public String expandVariables(NearString match) {
        String localTemplate = this.template;
        localTemplate = localTemplate.replace(VAR_INITIAL_CREATION_ID, match.creator == null ? "" : match.creator);
        localTemplate = localTemplate.replace(VAR_NOTE, match.note == null ? "" : match.note);
        for (String s : new String[]{VAR_CHANGED_ID, VAR_CREATION_ID}) {
            localTemplate = localTemplate.replace(s, match.changer == null ? "" : match.changer);
        }
        localTemplate = match.creationDate > 0L ? localTemplate.replace(VAR_INITIAL_CREATION_DATE, DateFormat.getInstance().format(new Date(match.creationDate))) : localTemplate.replace(VAR_INITIAL_CREATION_DATE, "");
        for (String s : new String[]{VAR_CHANGED_DATE, VAR_CREATION_DATE}) {
            localTemplate = match.changedDate > 0L ? localTemplate.replace(s, DateFormat.getInstance().format(new Date(match.changedDate))) : localTemplate.replace(s, "");
        }
        localTemplate = localTemplate.replace(VAR_SCORE_IMPROVED, Integer.toString(match.scoreImproved));
        localTemplate = localTemplate.replace(VAR_SCORE_STEM, Integer.toString(match.scoreStem));
        localTemplate = localTemplate.replace(VAR_SCORE_BASE, Integer.toString(match.scoreStem));
        localTemplate = localTemplate.replace(VAR_SCORE_NOSTEM, Integer.toString(match.scoreNoStem));
        localTemplate = localTemplate.replace(VAR_SCORE_ADJUSTED, Integer.toString(match.adjustedScore));
        localTemplate = localTemplate.replace("${targetText}", match.translation);
        localTemplate = localTemplate.replace(VAR_FUZZY_FLAG, (CharSequence)(match.fuzzyMark ? OStrings.getString("MATCHES_FUZZY_MARK") + " " : ""));
        localTemplate = localTemplate.replace("@{revisor}", StringUtil.nvl(match.revisor, match.props != null ? this.getPropValue(match.props, "revisor") : "", ""));
        localTemplate = localTemplate.replace("@{revised}", match.revisor != null ? "revised" : (match.props != null ? (this.getPropValue(match.props, "revisor") != null ? "revised" : "") : ""));
        ProjectProperties props = Core.getProject().getProjectProperties();
        if (props != null) {
            Iterator<NearString> I;
            Object proj = match.proj;
            if (proj == null || ((String)proj).length() == 0) {
                proj = OStrings.getString("MATCHES_THIS_PROJECT");
            }
            if ((I = match.getMergedEntries()).hasNext()) {
                int more = 0;
                while (I.hasNext()) {
                    I.next();
                    ++more;
                }
                proj = (String)proj + " " + StringUtil.format(OStrings.getString("MATCHES_MULTI_FILE_HINT"), more);
            }
            localTemplate = this.expandFileName(localTemplate, (String)proj, props.getTMRoot());
        }
        return localTemplate;
    }

    public Result apply(NearString match, int id) {
        Result R = new Result();
        this.styledComponents.clear();
        R.text = this.expandVariables(match);
        R.text = R.text.replace(VAR_ID, Integer.toString(id));
        if (match.props != null) {
            R.text = this.expandProperties(R.text, match.props);
        } else {
            R.text = R.text.replaceAll(patternSingleProperty.pattern(), "");
            R.text = R.text.replaceAll(patternPropertyGroup.pattern(), "");
        }
        this.styledComponents.put(R.text.indexOf("${sourceText}"), sourceTextReplacer);
        this.styledComponents.put(R.text.indexOf(VAR_DIFF), diffReplacer);
        this.styledComponents.put(R.text.indexOf(VAR_DIFF_REVERSED), diffReversedReplacer);
        this.styledComponents.put(R.text.indexOf(VAR_DIFF_TRA), diffTraReplacer);
        for (Map.Entry<Integer, Replacer> e : this.styledComponents.entrySet()) {
            e.getValue().replace(R, match);
        }
        return R;
    }

    public static class Result {
        public String text = null;
        public int sourcePos = -1;
        public final Map<Integer, List<DiffDriver.TextRun>> diffInfo = new HashMap<Integer, List<DiffDriver.TextRun>>();
    }

    private static interface Replacer {
        public void replace(Result var1, NearString var2);
    }
}

