/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.scripting;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.ScriptEngineFactory;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.events.IApplicationEventListener;
import org.omegat.gui.common.OmegaTIcons;
import org.omegat.gui.editor.mark.Mark;
import org.omegat.gui.scripting.IScriptLogger;
import org.omegat.gui.scripting.ScriptItem;
import org.omegat.gui.scripting.ScriptRunner;
import org.omegat.gui.scripting.ScriptsMonitor;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.StaticUtils;
import org.omegat.util.StringUtil;
import org.omegat.util.gui.OSXIntegration;
import org.omegat.util.gui.StaticUIUtils;
import org.openide.awt.Mnemonics;

public class ScriptingWindow
extends JFrame {
    private static final long serialVersionUID = 1L;
    static ScriptingWindow window;
    private static final String DEFAULT_SCRIPTS_DIR = "scripts";
    private static final int NUMBERS_OF_QUICK_SCRIPTS = 12;
    private JList m_scriptList;
    private JEditorPane m_txtResult;
    private JTextArea m_txtScriptEditor;
    private JButton m_btnRunScript;
    protected ScriptsMonitor monitor;
    private File m_scriptsDirectory;
    private ScriptItem m_currentScriptItem;
    private JTextField m_txtScriptsDir;
    private final JFileChooser m_fileChooser = new JFileChooser();
    private final String[] m_quickScripts = new String[12];
    private final JMenuItem[] m_quickMenus = new JMenuItem[12];
    private final JButton[] m_quickScriptButtons = new JButton[12];

    public static void loadPlugins() {
        CoreEvents.registerApplicationEventListener(new IApplicationEventListener(){

            @Override
            public void onApplicationStartup() {
                window = new ScriptingWindow();
            }

            @Override
            public void onApplicationShutdown() {
            }
        });
    }

    @Override
    public void dispose() {
        this.savePreferences();
        this.monitor.stop();
        super.dispose();
    }

    public static void unloadPlugins() {
        if (window != null) {
            window.dispose();
        }
    }

    public ScriptingWindow() {
        this.setTitle(OStrings.getString("SCW_TITLE"));
        OmegaTIcons.setIconImages(this);
        StaticUIUtils.setEscapeClosable(this);
        this.initWindowLayout();
        this.addScriptCommandToOmegaT();
        this.addRunShortcutToOmegaT();
        this.setScriptsDirectory(Preferences.getPreferenceDefault("scripts_dir", DEFAULT_SCRIPTS_DIR));
        this.monitor = new ScriptsMonitor(this);
        if (this.m_scriptsDirectory != null) {
            this.monitor.start(this.m_scriptsDirectory);
        }
        this.logResult(this.listScriptEngines());
    }

    private String listScriptEngines() {
        StringBuilder sb = new StringBuilder(OStrings.getString("SCW_LIST_ENGINES") + "\n");
        for (ScriptEngineFactory engine : ScriptRunner.MANAGER.getEngineFactories()) {
            sb.append(" - ");
            sb.append(engine.getEngineName());
            sb.append(" ");
            sb.append(engine.getLanguageName());
            sb.append(" v.");
            sb.append(engine.getLanguageVersion());
            sb.append(" (").append(OStrings.getString("SCW_EXTENSIONS")).append(" ");
            boolean hasMore = false;
            for (String ext : engine.getExtensions()) {
                if (hasMore) {
                    sb.append(", ");
                }
                sb.append(ext);
                hasMore = true;
            }
            sb.append(")");
            sb.append("\n");
        }
        return sb.toString();
    }

    private void addScriptCommandToOmegaT() {
        JMenu toolsMenu = Core.getMainWindow().getMainMenu().getToolsMenu();
        toolsMenu.add(new JSeparator());
        JMenuItem scriptMenu = new JMenuItem();
        Mnemonics.setLocalizedText(scriptMenu, OStrings.getString("TF_MENU_TOOLS_SCRIPTING"));
        scriptMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScriptingWindow.this.setVisible(true);
            }
        });
        toolsMenu.add(scriptMenu);
        for (int i = 0; i < 12; ++i) {
            JMenuItem menuItem;
            this.m_quickMenus[i] = menuItem = new JMenuItem();
            this.unsetQuickScriptMenu(i);
            this.m_quickMenus[i].setAccelerator(KeyStroke.getKeyStroke("shift ctrl F" + (i + 1)));
            toolsMenu.add(menuItem);
        }
    }

    private int scriptKey(int i) {
        return i + 1;
    }

    private void unsetQuickScriptMenu(int index) {
        this.m_quickScripts[index] = null;
        this.removeAllQuickScriptActionListenersFrom(this.m_quickMenus[index]);
        this.m_quickMenus[index].setEnabled(false);
        Mnemonics.setLocalizedText(this.m_quickMenus[index], "&" + this.scriptKey(index) + " - " + OStrings.getString("SCW_SCRIPTS_NONE"));
    }

    private void setQuickScriptMenu(ScriptItem scriptItem, int index) {
        this.m_quickScripts[index] = scriptItem.getFile().getName();
        this.removeAllQuickScriptActionListenersFrom(this.m_quickMenus[index]);
        this.m_quickMenus[index].addActionListener(new QuickScriptActionListener(index));
        this.m_quickMenus[index].setAccelerator(KeyStroke.getKeyStroke("shift ctrl F" + (index + 1)));
        this.m_quickMenus[index].setEnabled(true);
        if ("".equals(scriptItem.getDescription())) {
            this.m_quickMenus[index].setToolTipText(scriptItem.getDescription());
        }
        Mnemonics.setLocalizedText(this.m_quickMenus[index], "&" + this.scriptKey(index) + " - " + scriptItem.getScriptName());
    }

    private void removeAllQuickScriptActionListenersFrom(JMenuItem menu) {
        if (menu == null) {
            return;
        }
        for (ActionListener l : menu.getActionListeners()) {
            if (!(l instanceof QuickScriptActionListener)) continue;
            menu.removeActionListener(l);
        }
    }

    private void runQuickScript(int index) {
        if (this.m_quickScripts[index] == null) {
            this.logResult(OStrings.getString("SCW_NO_SCRIPT_SELECTED"));
            return;
        }
        this.logResult(StringUtil.format(OStrings.getString("SCW_QUICK_RUN"), index + 1));
        ScriptItem scriptFile = new ScriptItem(new File(this.m_scriptsDirectory, this.m_quickScripts[index]));
        this.executeScriptFile(scriptFile, true);
    }

    private void addRunShortcutToOmegaT() {
        JRootPane appliRootPane = Core.getMainWindow().getApplicationFrame().getRootPane();
        appliRootPane.getInputMap(1).put(KeyStroke.getKeyStroke(82, 640, false), "RUN_CURRENT_SCRIPT");
        appliRootPane.getActionMap().put("RUN_CURRENT_SCRIPT", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ScriptingWindow.this.runScript();
            }
        });
    }

    private void initWindowLayout() {
        this.loadPreferences();
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        JPanel panelNorth = new JPanel();
        FlowLayout fl_panelNorth = (FlowLayout)panelNorth.getLayout();
        fl_panelNorth.setAlignment(0);
        this.getContentPane().add((Component)panelNorth, "North");
        this.setupDirectorySelection(panelNorth);
        this.m_scriptList = new JList();
        JScrollPane scrollPaneList = new JScrollPane(this.m_scriptList);
        this.m_scriptList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                if (!evt.getValueIsAdjusting()) {
                    ScriptingWindow.this.onListSelectionChanged();
                }
            }
        });
        this.m_txtResult = new JEditorPane();
        JScrollPane scrollPaneResults = new JScrollPane(this.m_txtResult);
        this.m_txtScriptEditor = new JTextArea();
        JPopupMenu editorPopUp = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem(OStrings.getString("SCW_SAVE_SCRIPT"));
        menuItem.setAccelerator(KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    ScriptingWindow.this.m_currentScriptItem.setText(ScriptingWindow.this.m_txtScriptEditor.getText());
                    ScriptingWindow.this.logResult(StringUtil.format(OStrings.getString("SCW_SAVE_OK"), ScriptingWindow.this.m_currentScriptItem.getFile().getAbsolutePath()));
                }
                catch (IOException e) {
                    ScriptingWindow.this.logResult(OStrings.getString("SCW_SAVE_ERROR"));
                    ScriptingWindow.this.logResult(e.getMessage());
                }
            }
        });
        editorPopUp.add(menuItem);
        this.m_txtScriptEditor.setComponentPopupMenu(editorPopUp);
        this.m_txtScriptEditor.setFont(new Font("Monospaced", 0, this.m_txtScriptEditor.getFont().getSize()));
        JScrollPane scrollPaneEditor = new JScrollPane(this.m_txtScriptEditor);
        JSplitPane splitPane1 = new JSplitPane(0, scrollPaneEditor, scrollPaneResults);
        splitPane1.setOneTouchExpandable(true);
        splitPane1.setDividerLocation(430);
        Dimension minimumSize1 = new Dimension(100, 50);
        scrollPaneEditor.setMinimumSize(minimumSize1);
        scrollPaneResults.setMinimumSize(minimumSize1);
        JSplitPane splitPane = new JSplitPane(1, scrollPaneList, splitPane1);
        splitPane.setOneTouchExpandable(true);
        splitPane.setDividerLocation(250);
        Dimension minimumSize = new Dimension(100, 50);
        scrollPaneList.setMinimumSize(minimumSize);
        scrollPaneResults.setMinimumSize(minimumSize);
        this.getContentPane().add((Component)splitPane, "Center");
        JPanel panelSouth = new JPanel();
        FlowLayout fl_panelSouth = (FlowLayout)panelSouth.getLayout();
        fl_panelSouth.setAlignment(0);
        this.getContentPane().add((Component)panelSouth, "South");
        this.setupRunButtons(panelSouth);
        this.setDefaultCloseOperation(2);
    }

    private void setupDirectorySelection(JPanel panel) {
        JLabel lblScriptsDirectory = new JLabel(OStrings.getString("SCW_SCRIPTS_FOLDER"));
        panel.add(lblScriptsDirectory);
        this.m_txtScriptsDir = new JTextField();
        panel.add(this.m_txtScriptsDir);
        if (this.m_scriptsDirectory != null) {
            this.m_txtScriptsDir.setText(this.m_scriptsDirectory.getPath());
        }
        this.m_txtScriptsDir.setColumns(40);
        this.m_txtScriptsDir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScriptingWindow.this.directoryTextFieldActionPerformed(evt);
            }
        });
        JButton btnBrowse = new JButton();
        Mnemonics.setLocalizedText(btnBrowse, OStrings.getString("SCW_SCRIPTS_FOLDER_CHOOSE"));
        btnBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScriptingWindow.this.directoryChooserButtonActionPerformed(evt);
            }
        });
        panel.add(btnBrowse);
    }

    private void setupRunButtons(JPanel panel) {
        this.m_btnRunScript = new JButton();
        Mnemonics.setLocalizedText(this.m_btnRunScript, OStrings.getString("SCW_RUN_SCRIPT"));
        this.m_btnRunScript.setAlignmentX(0.0f);
        this.m_btnRunScript.setHorizontalAlignment(2);
        this.m_btnRunScript.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent a) {
                ScriptingWindow.this.runScript();
            }
        });
        panel.add(this.m_btnRunScript);
        for (int i = 0; i < 12; ++i) {
            final int index = i;
            final int scriptKey = this.scriptKey(index);
            this.m_quickScriptButtons[i] = new JButton(String.valueOf(scriptKey));
            this.m_quickScriptButtons[i].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent a) {
                    if (Preferences.existsPreference("scripts_quick_" + scriptKey)) {
                        ScriptingWindow.this.runQuickScript(index);
                    } else {
                        ScriptingWindow.this.logResult(StringUtil.format(OStrings.getString("SCW_NO_SCRIPT_BOUND"), scriptKey));
                    }
                }
            });
            JPopupMenu quickScriptPopup = new JPopupMenu();
            final JMenuItem addQuickScriptMenuItem = new JMenuItem(OStrings.getString("SCW_ADD_SCRIPT"));
            addQuickScriptMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ScriptItem scriptItem = (ScriptItem)ScriptingWindow.this.m_scriptList.getSelectedValue();
                    Preferences.setPreference("scripts_quick_" + scriptKey, scriptItem.getFile().getName());
                    ScriptingWindow.this.m_quickScriptButtons[index].setToolTipText(scriptItem.getToolTip());
                    ScriptingWindow.this.m_quickScriptButtons[index].setText("<" + scriptKey + ">");
                    ScriptingWindow.this.setQuickScriptMenu(scriptItem, index);
                    ScriptingWindow.this.logResult(StringUtil.format(OStrings.getString("SCW_SAVE_QUICK_SCRIPT"), scriptItem, scriptKey));
                }
            });
            quickScriptPopup.add(addQuickScriptMenuItem);
            final JMenuItem removeQuickScriptMenuItem = new JMenuItem(OStrings.getString("SCW_REMOVE_SCRIPT"));
            removeQuickScriptMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    String scriptName = Preferences.getPreferenceDefault("scripts_quick_" + scriptKey, "(unknown)");
                    ScriptingWindow.this.logResult(StringUtil.format(OStrings.getString("SCW_REMOVED_QUICK_SCRIPT"), scriptName, scriptKey));
                    Preferences.setPreference("scripts_quick_" + scriptKey, "");
                    ScriptingWindow.this.m_quickScriptButtons[index].setToolTipText(OStrings.getString("SCW_NO_SCRIPT_SET"));
                    ScriptingWindow.this.m_quickScriptButtons[index].setText(" " + scriptKey + " ");
                    ScriptingWindow.this.unsetQuickScriptMenu(index);
                }
            });
            quickScriptPopup.add(removeQuickScriptMenuItem);
            quickScriptPopup.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    addQuickScriptMenuItem.setEnabled(!ScriptingWindow.this.m_scriptList.isSelectionEmpty());
                    String scriptName = Preferences.getPreferenceDefault("scripts_quick_" + scriptKey, null);
                    removeQuickScriptMenuItem.setEnabled(!StringUtil.isEmpty(scriptName));
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                }
            });
            this.m_quickScriptButtons[i].setComponentPopupMenu(quickScriptPopup);
            panel.add(this.m_quickScriptButtons[i]);
        }
    }

    private void runScript() {
        if (this.m_currentScriptItem == null) {
            this.logResult(OStrings.getString("SCW_NO_SCRIPT_SELECTED"));
            return;
        }
        if (!this.m_currentScriptItem.getFile().canRead()) {
            this.logResult(OStrings.getString("SCW_CANNOT_READ_SCRIPT"));
            return;
        }
        this.m_txtResult.setText("");
        this.logResult(StringUtil.format(OStrings.getString("SCW_RUNNING_SCRIPT"), this.m_currentScriptItem.getFile().getAbsolutePath()));
        this.executeScriptFile(this.m_currentScriptItem, false);
    }

    public void executeScriptFile(ScriptItem scriptItem, boolean forceFromFile) {
        this.executeScriptFile(scriptItem, forceFromFile, null);
    }

    public void executeScriptFile(ScriptItem scriptItem, boolean forceFromFile, Map<String, Object> additionalBindings) {
        try {
            Object scriptString;
            if (forceFromFile) {
                scriptString = scriptItem.getText();
            } else if (this.m_txtScriptEditor.getText().trim().isEmpty()) {
                scriptString = scriptItem.getText();
                this.m_txtScriptEditor.setText((String)scriptString);
            } else {
                scriptString = this.m_txtScriptEditor.getText();
            }
            if (!((String)scriptString).endsWith("\n")) {
                scriptString = (String)scriptString + "\n";
            }
            HashMap<String, Object> bindings = new HashMap<String, Object>();
            if (additionalBindings != null) {
                bindings.putAll(additionalBindings);
            }
            bindings.put("console", new IScriptLogger(){

                @Override
                public void print(Object o) {
                    Document doc = ScriptingWindow.this.m_txtResult.getDocument();
                    try {
                        doc.insertString(doc.getLength(), o.toString(), null);
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }

                @Override
                public void println(Object o) {
                    this.print(o.toString() + "\n");
                }

                @Override
                public void clear() {
                    ScriptingWindow.this.m_txtResult.setText("");
                }
            });
            String result = ScriptRunner.executeScript((String)scriptString, scriptItem, bindings);
            this.logResult(result);
        }
        catch (Throwable e) {
            this.logResult(OStrings.getString("SCW_SCRIPT_ERROR"));
            this.logResult(e.getMessage());
        }
    }

    private void logResult(String s) {
        this.logResult(this.m_txtResult, s + "\n");
    }

    private void logResult(JEditorPane e, String s) {
        Document doc = e.getDocument();
        try {
            doc.insertString(doc.getLength(), s, null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private void directoryTextFieldActionPerformed(ActionEvent evt) {
        this.setScriptsDirectory(this.m_txtScriptsDir.getText());
    }

    private void directoryChooserButtonActionPerformed(ActionEvent evt) {
        this.m_fileChooser.setFileSelectionMode(1);
        this.m_fileChooser.setDialogTitle(OStrings.getString("SCW_SCRIPTS_FOLDER_CHOOSE_TITLE"));
        int result = this.m_fileChooser.showOpenDialog(this);
        if (result == 0) {
            File file = this.m_fileChooser.getSelectedFile();
            this.setScriptsDirectory(file);
        }
    }

    private void setScriptsDirectory(String scriptsDir) {
        this.setScriptsDirectory(ScriptingWindow.toJavaFile(scriptsDir));
    }

    public static File toJavaFile(String scriptsDir) {
        if (scriptsDir == null) {
            scriptsDir = StaticUtils.installDir() + "/scripts";
        }
        if (((String)scriptsDir).length() == 0) {
            scriptsDir = StaticUtils.installDir() + "/scripts";
        }
        if (((String)scriptsDir).indexOf(36) >= 0) {
            scriptsDir = ((String)scriptsDir).replace("${omegat.home}", StaticUtils.installDir());
            scriptsDir = ((String)scriptsDir).replace("${user.home}", System.getProperty("user.home"));
        }
        if (((String)scriptsDir).indexOf(37) >= 0) {
            scriptsDir = ((String)scriptsDir).replace("%OMEGAT_DIR%", StaticUtils.installDir());
            scriptsDir = ((String)scriptsDir).replace("%USER_HOME%", System.getProperty("user.home"));
        }
        try {
            return new File((String)scriptsDir).getCanonicalFile();
        }
        catch (IOException ex) {
            return new File((String)scriptsDir).getAbsoluteFile();
        }
    }

    private void setScriptsDirectory(File scriptsDir) {
        if (!scriptsDir.isDirectory()) {
            this.updateQuickScripts();
            return;
        }
        this.m_scriptsDirectory = scriptsDir;
        Preferences.setPreference("scripts_dir", scriptsDir.getPath());
        OSXIntegration.setProxyIcon(this.getRootPane(), this.m_scriptsDirectory);
        if (this.m_txtScriptsDir != null) {
            this.m_txtScriptsDir.setText(scriptsDir.getPath());
        }
        if (this.monitor != null) {
            this.monitor.stop();
            this.monitor.start(this.m_scriptsDirectory);
        }
        this.updateQuickScripts();
    }

    private void updateQuickScripts() {
        for (int i = 0; i < 12; ++i) {
            int key = this.scriptKey(i);
            String scriptName = Preferences.getPreferenceDefault("scripts_quick_" + key, null);
            if (this.m_scriptsDirectory != null && !StringUtil.isEmpty(scriptName)) {
                this.setQuickScriptMenu(new ScriptItem(new File(this.m_scriptsDirectory, scriptName)), i);
                this.m_quickScriptButtons[i].setToolTipText(scriptName);
                this.m_quickScriptButtons[i].setText("<" + key + ">");
                continue;
            }
            this.unsetQuickScriptMenu(i);
            this.m_quickScriptButtons[i].setToolTipText(OStrings.getString("SCW_NO_SCRIPT_SET"));
            this.m_quickScriptButtons[i].setText(String.valueOf(key));
        }
    }

    void setScriptItems(Collection<ScriptItem> items) {
        this.m_scriptList.setListData(items.toArray(new ScriptItem[items.size()]));
    }

    private void loadPreferences() {
        try {
            String dx = Preferences.getPreference("script_window_x");
            String dy = Preferences.getPreference("script_window_y");
            int x = Integer.parseInt(dx);
            int y = Integer.parseInt(dy);
            this.setLocation(x, y);
            String dw = Preferences.getPreference("script_window_width");
            String dh = Preferences.getPreference("script_window_height");
            int w = Integer.parseInt(dw);
            int h = Integer.parseInt(dh);
            this.setSize(w, h);
        }
        catch (NumberFormatException nfe) {
            this.setBounds(50, 80, 1150, 650);
        }
    }

    private void savePreferences() {
        Preferences.setPreference("script_window_width", this.getWidth());
        Preferences.setPreference("script_window_height", this.getHeight());
        Preferences.setPreference("script_window_x", this.getX());
        Preferences.setPreference("script_window_y", this.getY());
    }

    public Highlighter.HighlightPainter getPainter() {
        return null;
    }

    public List<Mark> getMarksForEntry(String sourceText, String translationText, boolean isActive) throws Exception {
        return Collections.emptyList();
    }

    private void onListSelectionChanged() {
        if (this.m_scriptList.isSelectionEmpty()) {
            return;
        }
        try {
            this.m_currentScriptItem = (ScriptItem)this.m_scriptList.getSelectedValue();
            this.m_txtScriptEditor.setText(this.m_currentScriptItem.getText());
            this.m_txtScriptEditor.setCaretPosition(0);
        }
        catch (IOException e) {
            this.logResult(OStrings.getString("SCW_CANNOT_READ_SCRIPT"));
        }
    }

    private class QuickScriptActionListener
    implements ActionListener {
        private final int index;

        QuickScriptActionListener(int index) {
            this.index = index;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ScriptingWindow.this.runQuickScript(this.index);
        }
    }
}

