/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.search;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JRadioButton;
import org.omegat.core.Core;
import org.omegat.core.search.TextExpression;
import org.omegat.gui.search.ReplaceDialog;
import org.omegat.gui.search.SearchWindow;
import org.omegat.tokenizer.ITokenizer;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.openide.awt.Mnemonics;

public class SearchModeBox
extends Box {
    private JCheckBox m_caseCB;
    private JRadioButton m_exactSearchRB;
    private JRadioButton m_keywordSearchRB;
    private JRadioButton m_regexpSearchRB;
    private JRadioButton m_expressionWordsRB;
    private JRadioButton m_expressionStringsRB;
    private JRadioButton m_expressionTokensRB;
    private JRadioButton m_regexPartial;
    private JRadioButton m_regexWhole;
    private JRadioButton m_regexFull;
    private final Box bWord_RB;
    private final Box bRegex_RB;
    private ITokenizer.StemmingMode mode;
    private static final String SEARCH_WORD_WHOLE = "WHOLE";
    private static final String SEARCH_WORD_STRINGS = "STRINGS";
    private static final String SEARCH_WORD_TOKENS = "TOKENS";
    private static final String SEARCH_TYPE_EXACT = "EXACT";
    private static final String SEARCH_TYPE_KEYWORD = "KEYWORD";
    private static final String SEARCH_TYPE_REGEXP = "REGEXP";
    private static final String SEARCH_REGEX_PARTIAL = "PARTIAL";
    private static final String SEARCH_REGEX_WHOLE = "WHOLE";
    private static final String SEARCH_REGEX_FULL = "FULL";
    public static final int H_MARGIN = 10;

    public SearchModeBox(int axis, ITokenizer.StemmingMode mode, final SearchWindow win) {
        super(axis);
        this.mode = mode;
        this.m_exactSearchRB = new JRadioButton();
        this.m_keywordSearchRB = new JRadioButton();
        this.m_regexpSearchRB = new JRadioButton();
        Mnemonics.setLocalizedText(this.m_exactSearchRB, OStrings.getString("SW_EXACT_SEARCH"));
        Mnemonics.setLocalizedText(this.m_keywordSearchRB, OStrings.getString("SW_WORD_SEARCH"));
        Mnemonics.setLocalizedText(this.m_regexpSearchRB, OStrings.getString("SW_REGEXP_SEARCH"));
        this.m_caseCB = new JCheckBox();
        Mnemonics.setLocalizedText(this.m_caseCB, OStrings.getString("SW_CASE_SENSITIVE"));
        ButtonGroup bgExpr = new ButtonGroup();
        bgExpr.add(this.m_exactSearchRB);
        bgExpr.add(this.m_keywordSearchRB);
        bgExpr.add(this.m_regexpSearchRB);
        Box bexpr_RB = Box.createHorizontalBox();
        bexpr_RB.add(this.m_exactSearchRB);
        bexpr_RB.add(Box.createHorizontalStrut(10));
        if (!(win instanceof ReplaceDialog)) {
            bexpr_RB.add(this.m_keywordSearchRB);
        } else {
            this.m_keywordSearchRB.setEnabled(false);
        }
        bexpr_RB.add(Box.createHorizontalStrut(10));
        if (mode != ITokenizer.StemmingMode.GLOSSARY) {
            bexpr_RB.add(this.m_regexpSearchRB);
        }
        bexpr_RB.add(Box.createHorizontalGlue());
        bexpr_RB.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), OStrings.getString("SW_ZONE_EXPRESSION_MODE")));
        bexpr_RB.add(Box.createHorizontalStrut(10));
        bexpr_RB.add(this.m_caseCB);
        this.add(bexpr_RB);
        this.m_expressionWordsRB = new JRadioButton();
        this.m_expressionStringsRB = new JRadioButton();
        this.m_expressionTokensRB = new JRadioButton();
        Mnemonics.setLocalizedText(this.m_expressionWordsRB, OStrings.getString("SW_WORD_MODE_WHOLE"));
        Mnemonics.setLocalizedText(this.m_expressionStringsRB, OStrings.getString("SW_WORD_MODE_STRINGS"));
        Mnemonics.setLocalizedText(this.m_expressionTokensRB, OStrings.getString("SW_WORD_MODE_LEMMAS"));
        ButtonGroup bgWords = new ButtonGroup();
        bgWords.add(this.m_expressionWordsRB);
        bgWords.add(this.m_expressionStringsRB);
        bgWords.add(this.m_expressionTokensRB);
        this.bWord_RB = Box.createHorizontalBox();
        this.bWord_RB.add(this.m_expressionStringsRB);
        this.bWord_RB.add(Box.createHorizontalStrut(10));
        this.bWord_RB.add(this.m_expressionWordsRB);
        this.bWord_RB.add(Box.createHorizontalStrut(10));
        this.bWord_RB.add(this.m_expressionTokensRB);
        this.bWord_RB.add(Box.createHorizontalStrut(10));
        this.bWord_RB.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), OStrings.getString("SW_ZONE_WORD_MODE")));
        this.add(this.bWord_RB);
        this.bWord_RB.setVisible(true);
        ButtonGroup bgRegex = new ButtonGroup();
        this.m_regexPartial = new JRadioButton(OStrings.getString("SW_ZONE_REGEX_MODE_PARTIAL"));
        bgRegex.add(this.m_regexPartial);
        this.m_regexWhole = new JRadioButton(OStrings.getString("SW_ZONE_REGEX_MODE_WHOLE"));
        bgRegex.add(this.m_regexWhole);
        this.m_regexFull = new JRadioButton(OStrings.getString("SW_ZONE_REGEX_MODE_FULL"));
        bgRegex.add(this.m_regexFull);
        this.bRegex_RB = Box.createHorizontalBox();
        this.bRegex_RB.add(this.m_regexPartial);
        this.bRegex_RB.add(Box.createHorizontalStrut(10));
        this.bRegex_RB.add(this.m_regexWhole);
        this.bRegex_RB.add(Box.createHorizontalStrut(10));
        this.bRegex_RB.add(this.m_regexFull);
        this.bRegex_RB.add(Box.createHorizontalStrut(10));
        this.bRegex_RB.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), OStrings.getString("SW_ZONE_REGEX_MODE")));
        this.add(this.bRegex_RB);
        this.bRegex_RB.setVisible(false);
        ActionListener regexListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean regexSelected = SearchModeBox.this.m_regexpSearchRB.isSelected();
                SearchModeBox.this.bWord_RB.setVisible(!regexSelected);
                SearchModeBox.this.bRegex_RB.setVisible(regexSelected);
                if (win != null) {
                    win.refreshLists(regexSelected);
                }
            }
        };
        this.m_exactSearchRB.addActionListener(regexListener);
        this.m_keywordSearchRB.addActionListener(regexListener);
        this.m_regexpSearchRB.addActionListener(regexListener);
    }

    public void loadPreferences(String prefix) {
        String searchWord = Preferences.getPreferenceDefault(prefix + "search_window_search_word", Preferences.getPreferenceDefault("search_window_search_word", SEARCH_WORD_STRINGS));
        this.m_expressionWordsRB.setSelected(searchWord.equals("WHOLE"));
        this.m_expressionStringsRB.setSelected(searchWord.equals(SEARCH_WORD_STRINGS));
        this.m_expressionTokensRB.setSelected(searchWord.equals(SEARCH_WORD_TOKENS));
        String searchRegex = Preferences.getPreferenceDefault(prefix + "search_window_search_regex", Preferences.getPreferenceDefault("search_window_search_regex", prefix.startsWith("R") || prefix.startsWith("P") ? SEARCH_REGEX_FULL : SEARCH_REGEX_PARTIAL));
        this.m_regexPartial.setSelected(searchRegex.equals(SEARCH_REGEX_PARTIAL));
        this.m_regexFull.setSelected(searchRegex.equals(SEARCH_REGEX_FULL));
        this.m_regexWhole.setSelected(searchRegex.equals("WHOLE"));
        String searchType = Preferences.getPreferenceDefault(prefix + "search_window_search_type", Preferences.getPreferenceDefault("search_window_search_type", SEARCH_TYPE_EXACT));
        this.m_exactSearchRB.setSelected(searchType.equals(SEARCH_TYPE_EXACT));
        this.m_keywordSearchRB.setSelected(searchType.equals(SEARCH_TYPE_KEYWORD));
        this.m_regexpSearchRB.setSelected(searchType.equals(SEARCH_TYPE_REGEXP));
        String caseSens = Preferences.getPreferenceDefault(prefix + "search_window_case_sensitive", Preferences.getPreferenceDefault("search_window_case_sensitive", "false"));
        this.m_caseCB.setSelected(Boolean.valueOf(caseSens));
        if (this.m_regexpSearchRB.isSelected()) {
            this.bWord_RB.setVisible(false);
            this.bRegex_RB.setVisible(true);
        } else {
            this.bWord_RB.setVisible(true);
            this.bRegex_RB.setVisible(false);
        }
    }

    public void savePreferences(String prefix) {
        Preferences.setPreference(prefix + "search_window_case_sensitive", Boolean.toString(this.m_caseCB.isSelected()));
        if (this.m_expressionWordsRB.isSelected()) {
            Preferences.setPreference(prefix + "search_window_search_word", "WHOLE");
        } else if (this.m_expressionStringsRB.isSelected()) {
            Preferences.setPreference(prefix + "search_window_search_word", SEARCH_WORD_STRINGS);
        } else if (this.m_expressionTokensRB.isSelected()) {
            Preferences.setPreference(prefix + "search_window_search_word", SEARCH_WORD_TOKENS);
        }
        if (this.m_regexPartial.isSelected()) {
            Preferences.setPreference(prefix + "search_window_search_regex", SEARCH_REGEX_PARTIAL);
        } else if (this.m_regexFull.isSelected()) {
            Preferences.setPreference(prefix + "search_window_search_regex", SEARCH_REGEX_FULL);
        } else if (this.m_regexWhole.isSelected()) {
            Preferences.setPreference(prefix + "search_window_search_regex", "WHOLE");
        }
        if (this.m_exactSearchRB.isSelected()) {
            Preferences.setPreference(prefix + "search_window_search_type", SEARCH_TYPE_EXACT);
        } else if (this.m_keywordSearchRB.isSelected()) {
            Preferences.setPreference(prefix + "search_window_search_type", SEARCH_TYPE_KEYWORD);
        } else if (this.m_regexpSearchRB.isSelected()) {
            Preferences.setPreference(prefix + "search_window_search_type", SEARCH_TYPE_REGEXP);
        }
    }

    public String searchTypeString() {
        if (this.m_exactSearchRB.isSelected()) {
            return SEARCH_TYPE_EXACT;
        }
        if (this.m_keywordSearchRB.isSelected()) {
            return SEARCH_TYPE_KEYWORD;
        }
        if (this.m_regexpSearchRB.isSelected()) {
            return SEARCH_TYPE_REGEXP;
        }
        return "";
    }

    public String wordModeString() {
        if (this.m_expressionStringsRB.isSelected()) {
            return "S" + (this.m_caseCB.isSelected() ? "C" : "c");
        }
        if (this.m_expressionWordsRB.isSelected()) {
            return "W" + (this.m_caseCB.isSelected() ? "C" : "c");
        }
        if (this.m_expressionTokensRB.isSelected()) {
            return "T" + (this.m_caseCB.isSelected() ? "C" : "c");
        }
        return "";
    }

    public TextExpression buildExpression(String text, boolean isNot, boolean isSource) {
        if (isNot) {
            return new TextExpression.NotExpression(this.buildExpression(text, false, isSource));
        }
        if (this.m_regexpSearchRB.isSelected()) {
            if (this.m_regexFull.isSelected()) {
                return new TextExpression.RegexTextExpression("^" + text + "$", this.m_caseCB.isSelected());
            }
            if (this.m_regexWhole.isSelected()) {
                return new TextExpression.RegexTextExpression("\\b" + text + "\\b", this.m_caseCB.isSelected());
            }
            return new TextExpression.RegexTextExpression(text, this.m_caseCB.isSelected());
        }
        if (this.m_expressionTokensRB.isSelected()) {
            ITokenizer tokenizer;
            ITokenizer iTokenizer = tokenizer = isSource ? Core.getProject().getSourceTokenizer() : Core.getProject().getTargetTokenizer();
            if (this.m_exactSearchRB.isSelected()) {
                return new TextExpression.ExactTokenExpression(tokenizer, this.mode, text, this.m_caseCB.isSelected());
            }
            if (this.m_keywordSearchRB.isSelected()) {
                return new TextExpression.WordsTokenExpression(tokenizer, this.mode, text, this.m_caseCB.isSelected());
            }
        } else {
            if (this.m_exactSearchRB.isSelected()) {
                if (this.m_expressionWordsRB.isSelected()) {
                    return TextExpression.RegexTextExpression.exactWholeWordsExpression(text, this.m_caseCB.isSelected());
                }
                return TextExpression.RegexTextExpression.exactStringExpression(text, this.m_caseCB.isSelected());
            }
            if (this.m_keywordSearchRB.isSelected()) {
                return new TextExpression.WordsTextExpression(text, this.m_caseCB.isSelected(), this.m_expressionWordsRB.isSelected());
            }
        }
        return null;
    }

    public TextExpression buildReplaceExpression(String text, boolean isSource, String replaceText, boolean useVars) {
        if (this.m_expressionTokensRB.isSelected() && !this.m_regexpSearchRB.isSelected()) {
            ITokenizer tokenizer;
            ITokenizer iTokenizer = tokenizer = isSource ? Core.getProject().getSourceTokenizer() : Core.getProject().getTargetTokenizer();
            if (this.m_exactSearchRB.isSelected()) {
                if (useVars) {
                    return new TextExpression.ExactReplaceTokenExpression(tokenizer, this.mode, (String)text, replaceText, this.m_caseCB.isSelected());
                }
                return new TextExpression.ExactTokenExpression(tokenizer, this.mode, (String)text, this.m_caseCB.isSelected());
            }
            if (this.m_keywordSearchRB.isSelected()) {
                return new TextExpression.WordsTokenExpression(tokenizer, this.mode, (String)text, this.m_caseCB.isSelected());
            }
        } else {
            if (this.m_exactSearchRB.isSelected()) {
                if (this.m_expressionWordsRB.isSelected()) {
                    if (useVars) {
                        return TextExpression.RegexReplaceExpression.exactWholeWordsExpression((String)text, this.m_caseCB.isSelected(), replaceText);
                    }
                    return TextExpression.RegexTextExpression.exactWholeWordsExpression((String)text, this.m_caseCB.isSelected());
                }
                if (useVars) {
                    return TextExpression.RegexReplaceExpression.exactStringExpression((String)text, this.m_caseCB.isSelected(), replaceText);
                }
                return TextExpression.RegexTextExpression.exactStringExpression((String)text, this.m_caseCB.isSelected());
            }
            if (this.m_keywordSearchRB.isSelected()) {
                return new TextExpression.WordsTextExpression((String)text, this.m_caseCB.isSelected(), this.m_expressionWordsRB.isSelected());
            }
            if (this.m_regexpSearchRB.isSelected()) {
                if (this.m_regexFull.isSelected()) {
                    text = "^" + (String)text + "$";
                }
                if (this.m_regexWhole.isSelected()) {
                    text = "\\b" + (String)text + "\\b";
                }
                if (useVars) {
                    return new TextExpression.RegexReplaceExpression((String)text, this.m_caseCB.isSelected(), replaceText);
                }
                return new TextExpression.RegexTextExpression((String)text, this.m_caseCB.isSelected());
            }
        }
        return null;
    }

    public AbstractButton[] getOptionsComponents() {
        return new AbstractButton[]{this.m_exactSearchRB, this.m_keywordSearchRB, this.m_regexpSearchRB, this.m_expressionWordsRB, this.m_expressionStringsRB, this.m_expressionTokensRB, this.m_regexPartial, this.m_regexFull, this.m_caseCB};
    }

    public boolean englobeWords() {
        return !this.m_expressionWordsRB.isSelected();
    }

    public void addModeChangeListener(ActionListener l) {
        this.m_exactSearchRB.addActionListener(l);
        this.m_keywordSearchRB.addActionListener(l);
        this.m_regexpSearchRB.addActionListener(l);
    }

    public static class MemorizedExpression {
        private String mode;
        private String expression;

        private MemorizedExpression(String txt) {
            if (txt.startsWith("{")) {
                this.expression = txt.substring(txt.indexOf(125) + 1);
                this.mode = txt.substring(1, txt.indexOf(125));
            } else {
                this.expression = txt;
                this.mode = "";
            }
        }

        public static Object forString(String txt) {
            if (txt.startsWith("{")) {
                return new MemorizedExpression(txt);
            }
            return txt;
        }

        public void applyTo(SearchModeBox box) {
            if (this.mode.contains("C")) {
                box.m_caseCB.setSelected(true);
            } else if (this.mode.contains("c")) {
                box.m_caseCB.setSelected(false);
            }
            if (this.mode.toUpperCase().contains("S")) {
                box.m_expressionStringsRB.setSelected(true);
            }
            if (this.mode.toUpperCase().contains("W")) {
                box.m_expressionWordsRB.setSelected(true);
            }
            if (this.mode.toUpperCase().contains("T")) {
                box.m_expressionTokensRB.setSelected(true);
            }
            if (this.mode.toUpperCase().contains("L")) {
                box.m_expressionTokensRB.setSelected(true);
            }
        }

        public String toString() {
            return this.expression;
        }
    }
}

