/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Logger;

public class DirectoryMonitor
extends Thread {
    private static final Logger LOGGER = Logger.getLogger(DirectoryMonitor.class.getName());
    private boolean stopped = false;
    protected final File dir;
    protected final Callback callback;
    protected final DirectoryCallback directoryCallback;
    private final Map<String, FileInfo> existFiles = new TreeMap<String, FileInfo>();
    protected static final long LOOKUP_PERIOD = 1000L;
    private SimpleFileVisitor<Path> adder = new SimpleFileVisitor<Path>(){
        int pass_dir = -1;

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            if (DirectoryMonitor.this.stopped) {
                return FileVisitResult.TERMINATE;
            }
            if (this.pass_dir < 0) {
                this.pass_dir = DirectoryMonitor.this.dir.toString().length() + 1;
            }
            String fn = file.toString().substring(this.pass_dir);
            if (!attrs.isDirectory() && !DirectoryMonitor.this.existFiles.containsKey(fn)) {
                File f = file.toFile();
                LOGGER.finer("File '" + fn + "' (" + new Date(f.lastModified()) + ") added");
                DirectoryMonitor.this.existFiles.put(fn, new FileInfo(f));
                DirectoryMonitor.this.callback.fileChanged(f);
            }
            return FileVisitResult.CONTINUE;
        }
    };

    public DirectoryMonitor(File dir, Callback callback) {
        if (dir == null) {
            throw new IllegalArgumentException("Dir cannot be null.");
        }
        this.dir = dir;
        this.callback = callback;
        this.directoryCallback = null;
    }

    public DirectoryMonitor(File dir, Callback callback, DirectoryCallback directoryCallback) {
        if (dir == null) {
            throw new IllegalArgumentException("Dir cannot be null.");
        }
        this.dir = dir;
        this.callback = callback;
        this.directoryCallback = directoryCallback;
    }

    public File getDir() {
        return this.dir;
    }

    public void fin() {
        this.stopped = true;
    }

    @Override
    public void run() {
        this.setName(this.getClass().getSimpleName());
        this.setPriority(1);
        while (!this.stopped) {
            this.checkChanges();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ex) {
                this.stopped = true;
            }
        }
    }

    public synchronized Set<File> getExistFiles() {
        TreeSet<File> result = new TreeSet<File>();
        for (String fn : this.existFiles.keySet()) {
            result.add(new File(fn));
        }
        return result;
    }

    public synchronized void checkChanges() {
        boolean directoryChanged = false;
        Iterator<Map.Entry<String, FileInfo>> I = this.existFiles.entrySet().iterator();
        while (I.hasNext()) {
            if (this.stopped) {
                return;
            }
            Map.Entry<String, FileInfo> me = I.next();
            File f = new File(this.dir, me.getKey());
            if (!f.exists()) {
                LOGGER.finer("File '" + f + "' removed");
                I.remove();
                this.callback.fileChanged(f);
                directoryChanged = true;
                continue;
            }
            FileInfo info = me.getValue();
            if (info.equals(f)) continue;
            LOGGER.finer("File '" + f + "' changed");
            this.callback.fileChanged(f);
            info.lastModified = f.lastModified();
            info.length = f.length();
            directoryChanged = true;
        }
        try {
            int sizeBefore = this.existFiles.size();
            Files.walkFileTree(this.dir.toPath(), this.adder);
            directoryChanged = directoryChanged || this.existFiles.size() > sizeBefore;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.directoryCallback != null && directoryChanged) {
            this.directoryCallback.directoryChanged(this.dir);
        }
    }

    public static interface Callback {
        public void fileChanged(File var1);
    }

    public static interface DirectoryCallback {
        public void directoryChanged(File var1);
    }

    protected static class FileInfo {
        public long lastModified;
        public long length;

        public FileInfo(File file) {
            this.lastModified = file.lastModified();
            this.length = file.length();
        }

        public boolean equals(Object obj) {
            try {
                File f = (File)obj;
                return f.lastModified() == this.lastModified && f.length() == this.length;
            }
            catch (ClassCastException cce1) {
                try {
                    FileInfo i = (FileInfo)obj;
                    return this.lastModified == i.lastModified && this.length == i.length;
                }
                catch (ClassCastException cce2) {
                    return false;
                }
            }
        }
    }
}

