/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.mozilla.universalchardet.UniversalDetector;

public class EncodingDetector {
    public static String detectEncoding(File inFile) throws IOException {
        try (FileInputStream stream = new FileInputStream(inFile);){
            String string = EncodingDetector.detectEncoding(stream);
            return string;
        }
    }

    public static String detectEncoding(InputStream stream) throws IOException {
        int read;
        UniversalDetector detector = new UniversalDetector(null);
        byte[] buffer = new byte[4096];
        while ((read = stream.read(buffer)) > 0 && !detector.isDone()) {
            detector.handleData(buffer, 0, read);
        }
        detector.dataEnd();
        String encoding = detector.getDetectedCharset();
        detector.reset();
        return encoding;
    }

    public static String detectEncodingDefault(File inFile, String defaultEncoding) {
        String detected = null;
        try {
            detected = EncodingDetector.detectEncoding(inFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return detected == null ? defaultEncoding : detected;
    }
}

