/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util;

import java.util.regex.Pattern;
import org.omegat.util.Preferences;

public class PatternConsts {
    public static final String RE_OMEGAT_TAG = "<\\/?[a-zA-Z]+[0-9]+\\/?>";
    private static final String RE_PRINTF_VARS = "%([1-9]+\\$)?([+-])?('.)?(-)?([0-9]*)(\\.[0-9]*)?[bcdeEfFgGinopsuxX%]";
    private static final String RE_SIMPLE_PRINTF_VARS = "%([1-9]+\\$)?([0-9]*)(\\.[0-9]*)?[bcdeEfFgGinopsuxX%]";
    private static final String RE_SIMPLE_JAVA_MESSAGEFORMAT_PATTERN_VARS = "\\{([0-9])+\\}";
    public static final Pattern XML_ENCODING = Pattern.compile("<\\?xml.*?encoding\\s*=\\s*\"(\\S+?)\".*?\\?>");
    public static final Pattern XML_HEADER = Pattern.compile("(<\\?xml.*?\\?>)");
    public static final Pattern XML_DOCTYPE = Pattern.compile("<\\!DOCTYPE\\s+(\\w+)\\s+(PUBLIC\\s+\"(-//.*)\"\\s+)?");
    public static final Pattern XML_ROOTTAG = Pattern.compile("<(\\w+)");
    public static final Pattern XML_XMLNS = Pattern.compile("xmlns(:\\w+)?=\"(.*?)\"");
    public static final Pattern HTML_ENCODING = Pattern.compile("<meta.*?content\\s*=\\s*[\"']\\s*text/html\\s*;\\s*charset\\s*=\\s*(\\S+?)[\"'].*?/?\\s*>", 2);
    public static final Pattern HTML5_ENCODING = Pattern.compile("<meta.*?charset\\s*=\\s*[\"'](\\S+?)[\"'].*?/?\\s*>", 2);
    public static final Pattern HTML_HEAD = Pattern.compile("<head[^e]*?>", 2);
    public static final Pattern HTML_HTML = Pattern.compile("<html.*?>", 2);
    public static final Pattern HTML_BR = Pattern.compile("<BR>", 2);
    public static final Pattern OMEGAT_TAG_ONLY = Pattern.compile("^\\/?[a-zA-Z]+[0-9]+\\/?$");
    public static final Pattern OMEGAT_TAG = Pattern.compile("<\\/?[a-zA-Z]+[0-9]+\\/?>");
    public static final Pattern OMEGAT_TAG_SPACE = Pattern.compile("<\\/?[a-zA-Z]+[0-9]+\\/?>\\s");
    public static final Pattern SPACE_OMEGAT_TAG = Pattern.compile("\\s<\\/?[a-zA-Z]+[0-9]+\\/?>");
    public static final Pattern OMEGAT_TAG_DECOMPILE = Pattern.compile("<(\\/?)([a-zA-Z]+)([0-9]+)(\\/?)>");
    public static final Pattern PROTECTED_PARTS_PAIRED_TAG_DECOMPILE = Pattern.compile("^(<.+?>)([^<]+?)(<\\/.+?>)");
    public static final Pattern EQUIV_TEXT_ATTRIBUTE_DECOMPILE = Pattern.compile("equiv-text=\"([^\"]+)\"");
    public static final Pattern SPACY_REGEX = Pattern.compile("((\\s|\\\\n|\\\\t|\\\\s)(\\+|\\*)?)+");
    public static final Pattern LANG_AND_COUNTRY = Pattern.compile("([A-Za-z]{1,8})(?:(?:-|_)(?:[A-Za-z]{4}(?:-|_))?([A-Za-z0-9]{1,8}))?");
    public static final Pattern DICTIONARY_ZIP = Pattern.compile("\"([a-z]{1,8})(_([A-Z]{1,8})?)(_1-3-2)?\\.zip\"");
    public static final Pattern SPACE_TAB = Pattern.compile("( |\t)+");
    public static final Pattern PRINTF_VARS = Pattern.compile("%([1-9]+\\$)?([+-])?('.)?(-)?([0-9]*)(\\.[0-9]*)?[bcdeEfFgGinopsuxX%]");
    public static final Pattern SIMPLE_PRINTF_VARS = Pattern.compile("%([1-9]+\\$)?([0-9]*)(\\.[0-9]*)?[bcdeEfFgGinopsuxX%]");
    public static final Pattern SIMPLE_JAVA_MESSAGEFORMAT_PATTERN_VARS = Pattern.compile("\\{([0-9])+\\}");
    public static final Pattern SIMPLE_PLACEHOLDERS = Pattern.compile("<\\/?[a-zA-Z]+[0-9]+\\/?>|%([1-9]+\\$)?([+-])?('.)?(-)?([0-9]*)(\\.[0-9]*)?[bcdeEfFgGinopsuxX%]");
    private static Pattern PLACEHOLDERS;
    private static Pattern REMOVE;
    private static Pattern CUSTOM_TAGS;

    public static Pattern getPlaceholderPattern() {
        if (PLACEHOLDERS == null) {
            String customRegExp;
            Object regexp = RE_OMEGAT_TAG;
            if ("true".equalsIgnoreCase(Preferences.getPreference("tagValidation_elaborateCheck"))) {
                regexp = (String)regexp + "|%([1-9]+\\$)?([+-])?('.)?(-)?([0-9]*)(\\.[0-9]*)?[bcdeEfFgGinopsuxX%]";
            } else if ("true".equalsIgnoreCase(Preferences.getPreference("tagValidation_simpleCheck"))) {
                regexp = (String)regexp + "|%([1-9]+\\$)?([0-9]*)(\\.[0-9]*)?[bcdeEfFgGinopsuxX%]";
            }
            if ("true".equalsIgnoreCase(Preferences.getPreference("tagValidation_javaMessageFormatSimplePatternCheck"))) {
                regexp = (String)regexp + "|\\{([0-9])+\\}";
            }
            if (!"".equalsIgnoreCase(customRegExp = Preferences.getPreferenceDefaultAllowEmptyString("tagValidation_customPattern"))) {
                regexp = (String)regexp + "|" + customRegExp;
            }
            PLACEHOLDERS = Pattern.compile((String)regexp);
        }
        return PLACEHOLDERS;
    }

    public static void updatePlaceholderPattern() {
        PLACEHOLDERS = null;
    }

    public static Pattern getRemovePattern() {
        String removeRegExp;
        if (REMOVE == null && !"".equalsIgnoreCase(removeRegExp = Preferences.getPreferenceDefaultAllowEmptyString("tagValidation_removePattern"))) {
            REMOVE = Pattern.compile(removeRegExp);
        }
        return REMOVE;
    }

    public static void updateRemovePattern() {
        REMOVE = null;
    }

    public static Pattern getCustomTagPattern() {
        String customTagsRegex;
        if (CUSTOM_TAGS == null && !"".equalsIgnoreCase(customTagsRegex = Preferences.getPreferenceDefaultAllowEmptyString("tagValidation_customPattern"))) {
            CUSTOM_TAGS = Pattern.compile(customTagsRegex);
        }
        return CUSTOM_TAGS;
    }

    public static void updateCustomTagPattern() {
        CUSTOM_TAGS = null;
    }
}

