/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.omegat.core.data.ProjectProperties;
import org.omegat.core.segmentation.ISegmentationData;
import org.omegat.filters2.TranslationException;
import org.omegat.filters2.master.FilterMaster;
import org.omegat.filters2.master.PluginUtils;
import org.omegat.util.Language;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.StringUtil;

public class ProjectFileStorage {
    private static final XMLInputFactory staxInputFactory = XMLInputFactory.newInstance();
    private static final XMLOutputFactory staxOutputFactory = XMLOutputFactory.newInstance();

    public static ProjectProperties loadProjectProperties(File projectDir) throws Exception {
        ProjectProperties result = new ProjectProperties(projectDir);
        File inFile = new File(projectDir, "omegat.project");
        result.getSourceRootExcludes().clear();
        result.getSourceRootExcludes().addAll(Arrays.asList(ProjectProperties.DEFAULT_EXCLUDES));
        XMLStreamReader reader = staxInputFactory.createXMLStreamReader(new FileInputStream(inFile));
        boolean inProj = false;
        HashMap<String, String> params = new HashMap<String, String>();
        block0: while (reader.hasNext()) {
            if (reader.next() != 1) continue;
            if (reader.getName().getLocalPart().equals("project")) {
                if (!"1.0".equals(reader.getAttributeValue(null, "version"))) {
                    throw new TranslationException(StringUtil.format(OStrings.getString("PFR_ERROR_UNSUPPORTED_PROJECT_VERSION"), reader.getAttributeValue(null, "version")));
                }
                inProj = true;
                continue;
            }
            if (!inProj) continue;
            String name = reader.getName().getLocalPart();
            StringBuffer buf = new StringBuffer();
            if (name.equals("source_dir_excludes")) {
                result.getSourceRootExcludes().clear();
                while (reader.hasNext()) {
                    int next = reader.next();
                    if (next == 1 && reader.getName().getLocalPart().equals("mask")) {
                        buf.setLength(0);
                        continue;
                    }
                    if (reader.hasText()) {
                        buf.append(reader.getText());
                        continue;
                    }
                    if (next != 2) continue;
                    result.getSourceRootExcludes().add(buf.toString());
                    if (!reader.getName().getLocalPart().equals("source_dir_excludes")) continue;
                    continue block0;
                }
                continue;
            }
            while (reader.next() != 2 || !reader.getName().getLocalPart().equals(name)) {
                buf.append(reader.getText());
            }
            params.put(name, buf.toString());
        }
        String m_root = inFile.getParentFile().getAbsolutePath() + File.separator;
        result.setSourceRoot(ProjectFileStorage.computeAbsolutePath(m_root, (String)params.get("source_dir"), "source"));
        result.setTMRoot(ProjectFileStorage.computeAbsolutePath(m_root, (String)params.get("tm_dir"), "tm"));
        result.setGlossaryRoot(ProjectFileStorage.computeAbsolutePath(m_root, (String)params.get("glossary_dir"), "glossary"));
        String glossaryFile = (String)params.get("glossary_file");
        if (StringUtil.isEmpty(glossaryFile)) {
            glossaryFile = "__DEFAULT__";
        }
        if (glossaryFile.equalsIgnoreCase("__DEFAULT__")) {
            glossaryFile = result.computeDefaultWriteableGlossaryFile();
        } else if (!new File(glossaryFile).isAbsolute()) {
            String absGlossaryRoot = ProjectFileStorage.computeAbsolutePath(m_root, result.getGlossaryRoot(), "glossary");
            glossaryFile = new File(absGlossaryRoot, glossaryFile).getPath();
        }
        result.setWriteableGlossary(glossaryFile);
        result.setDictRoot(ProjectFileStorage.computeAbsolutePath(m_root, (String)params.get("dictionary_dir"), "dictionary"));
        result.setSourceLanguage((String)params.get("source_lang"));
        result.setTargetLanguage((String)params.get("target_lang"));
        result.setSourceTokenizer(ProjectFileStorage.loadTokenizer((String)params.get("source_tok"), result.getSourceLanguage()));
        result.setTargetTokenizer(ProjectFileStorage.loadTokenizer((String)params.get("target_tok"), result.getTargetLanguage()));
        result.setSentenceSegmentingEnabled("true".equalsIgnoreCase((String)params.get("sentence_seg")));
        result.setTagsFormatHandles("true".equalsIgnoreCase((String)params.get("seg_tags_format_handles")));
        result.setSegmentNbsp("true".equalsIgnoreCase((String)params.get("seg_accept_nbsp")));
        result.setSupportDefaultTranslations("true".equalsIgnoreCase((String)params.get("support_default_translations")));
        result.setRemoveTags("true".equalsIgnoreCase((String)params.get("remove_tags")));
        result.setExternalCommand((String)params.get("external_command"));
        return result;
    }

    public static void writeProjectFile(ProjectProperties props) throws Exception {
        File outFile = new File(props.getProjectRoot(), "omegat.project");
        String m_root = outFile.getParentFile().getAbsolutePath() + File.separator;
        try (FileOutputStream fos = new FileOutputStream(outFile);){
            XMLStreamWriter writer = staxOutputFactory.createXMLStreamWriter(fos, "UTF-8");
            writer.writeStartDocument("UTF-8", "1.0");
            writer.writeStartElement("omegat");
            writer.writeStartElement("project");
            writer.writeAttribute("version", "1.0");
            ProjectFileStorage.writeKeyValue(writer, "\n        ", "source_dir", ProjectFileStorage.computeRelativePath(m_root, props.getSourceRoot(), "source"));
            writer.writeStartElement("source_dir_excludes");
            for (String mask : props.getSourceRootExcludes()) {
                ProjectFileStorage.writeKeyValue(writer, "\n            ", "source_dir_excludes", mask);
            }
            writer.writeEndElement();
            ProjectFileStorage.writeKeyValue(writer, "\n        ", "tm_dir", ProjectFileStorage.computeRelativePath(m_root, props.getTMRoot(), "tm"));
            String glossaryFile = ProjectFileStorage.computeRelativePath(props.getGlossaryRoot(), props.getWriteableGlossary(), null);
            String glossaryDir = ProjectFileStorage.computeRelativePath(m_root, props.getGlossaryRoot(), "glossary");
            if (glossaryDir.equalsIgnoreCase("__DEFAULT__") && props.isDefaultWriteableGlossaryFile()) {
                glossaryFile = "__DEFAULT__";
            }
            ProjectFileStorage.writeKeyValue(writer, "\n        ", "glossary_dir", glossaryDir);
            ProjectFileStorage.writeKeyValue(writer, "\n        ", "glossary_file", glossaryFile);
            ProjectFileStorage.writeKeyValue(writer, "\n        ", "dictionary_dir", ProjectFileStorage.computeRelativePath(m_root, props.getDictRoot(), "dictionary"));
            ProjectFileStorage.writeKeyValue(writer, "\n        ", "source_lang", props.getSourceLanguage().toString());
            ProjectFileStorage.writeKeyValue(writer, "\n        ", "target_lang", props.getTargetLanguage().toString());
            ProjectFileStorage.writeKeyValue(writer, "\n        ", "source_tok", props.getSourceTokenizer().getCanonicalName());
            ProjectFileStorage.writeKeyValue(writer, "\n        ", "target_tok", props.getTargetTokenizer().getCanonicalName());
            ProjectFileStorage.writeKeyValue(writer, "\n        ", "sentence_seg", Boolean.toString(props.isSentenceSegmentingEnabled()));
            ProjectFileStorage.writeKeyValue(writer, "\n        ", "remove_tags", Boolean.toString(props.isRemoveTags()));
            ProjectFileStorage.writeKeyValue(writer, "\n        ", "support_default_translations", Boolean.toString(props.isSupportDefaultTranslations()));
            ProjectFileStorage.writeKeyValue(writer, "\n        ", "external_command", props.getExternalCommand());
            if (props.isTagsFormatHandles() != null) {
                ProjectFileStorage.writeKeyValue(writer, "\n        ", "seg_tags_format_handles", Boolean.toString(props.isTagsFormatHandles()));
            }
            if (props.isSegmentNbsp() != null) {
                ProjectFileStorage.writeKeyValue(writer, "\n        ", "seg_accept_nbsp", Boolean.toString(props.isSegmentNbsp()));
            }
            writer.writeCharacters("\n    ");
            writer.writeEndElement();
            writer.writeCharacters("\n");
            writer.writeEndElement();
            writer.close();
        }
        ISegmentationData.saveTo(props.getProjectSegmentationData(), new File(props.getProjectInternal()));
        FilterMaster.saveConfig(props.getProjectFilters(), props.getProjectInternal());
    }

    private static void writeKeyValue(XMLStreamWriter writer, String indent, String key, String value) throws XMLStreamException {
        writer.writeCharacters(indent);
        writer.writeStartElement(key);
        writer.writeCharacters(value);
        writer.writeEndElement();
    }

    private static String computeAbsolutePath(String m_root, String relativePath, String defaultName) {
        if (relativePath == null) {
            return m_root + defaultName + File.separator;
        }
        if ("__DEFAULT__".equals(relativePath)) {
            return m_root + defaultName + File.separator;
        }
        try {
            boolean startsWithRoot = false;
            for (File root : File.listRoots()) {
                try {
                    String platformRelativePath = relativePath.replace('/', File.separatorChar);
                    startsWithRoot = platformRelativePath.startsWith(root.getCanonicalPath());
                }
                catch (IOException e) {
                    startsWithRoot = false;
                }
                if (!startsWithRoot) continue;
                return new File(relativePath).getCanonicalPath() + File.separator;
            }
            return new File(m_root, relativePath).getCanonicalPath() + File.separator;
        }
        catch (IOException e) {
            return relativePath;
        }
    }

    private static String computeRelativePath(String m_root, String absolutePath, String defaultName) {
        if (defaultName != null && new File(absolutePath).equals(new File(m_root, defaultName))) {
            return "__DEFAULT__";
        }
        try {
            Object res = absolutePath;
            File abs = new File(absolutePath).getCanonicalFile();
            File root = new File(m_root).getCanonicalFile();
            Object prefix = "";
            for (int i = 0; i < 0; ++i) {
                if ((abs.getPath() + File.separator).startsWith(root.getPath() + File.separator)) {
                    res = (String)prefix + abs.getPath().substring(root.getPath().length());
                    if (!((String)res).startsWith(File.separator)) break;
                    res = ((String)res).substring(1);
                    break;
                }
                root = root.getParentFile();
                prefix = (String)prefix + File.separator + "..";
                if (root == null) break;
            }
            return ((String)res).replace(File.separatorChar, '/');
        }
        catch (IOException e) {
            return absolutePath.replace(File.separatorChar, '/');
        }
    }

    private static Class<?> loadTokenizer(String className, Language fallback) {
        if (!StringUtil.isEmpty(className)) {
            try {
                return ProjectFileStorage.class.getClassLoader().loadClass(className);
            }
            catch (ClassNotFoundException e) {
                Log.log(e.toString());
            }
        }
        return PluginUtils.getTokenizerClassForLanguage(fallback);
    }
}

