/*
 * Decompiled with CFR 0.152.
 */
package org.silvestrislab.cyclotis.omegat.proj.ctx;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.omegat.core.data.EntryKey;
import org.omegat.core.data.SourceTextEntry;
import org.silvestrislab.cyclotis.omegat.Cyclotis;
import org.silvestrislab.cyclotis.omegat.proj.ContextTMXEntry;
import org.silvestrislab.cyclotis.omegat.proj.ctx.ContextMode;
import org.silvestrislab.cyclotis.omegat.proj.ctx.DigestStringContextMode;
import org.silvestrislab.cyclotis.omegat.proj.ctx.HashContextMode;
import org.silvestrislab.cyclotis.omegat.proj.ctx.IntContextMode;
import org.silvestrislab.cyclotis.omegat.proj.ctx.StringWrapperContextMode;

public abstract class StringContextMode
extends ContextMode<String> {
    public static final StringContextMode DEFAULT = new StringWrapperContextMode(new HashContextMode());

    @Override
    public final void fillEntry(Cyclotis origin, ContextTMXEntry entry, ResultSet data) throws SQLException {
        this.fillEntry(origin, entry, data.getString("CONTEXT"));
    }

    @Override
    public void setStatementValue(PreparedStatement stmt, int pos, SourceTextEntry key, boolean isDefault) throws SQLException {
        stmt.setString(pos, (String)this.toDatabase(key, isDefault));
    }

    @Override
    public String getValue(ResultSet rs) throws SQLException {
        return rs.getString("CONTEXT");
    }

    public StringContextMode nullWrapper(final int sqlType) {
        return new StringContextMode(){

            @Override
            protected String convert(String val) {
                return StringContextMode.this.convert(val);
            }

            @Override
            public String defaultValueForSource(String sourceText) {
                return null;
            }

            @Override
            public String nonDefaultValueForEntry(SourceTextEntry key) {
                return (String)StringContextMode.this.nonDefaultValueForEntry(key);
            }

            @Override
            public boolean isDefault(String srcText, String value) {
                return value == null;
            }

            @Override
            public boolean isCorrectKey(SourceTextEntry key, String value) {
                return StringContextMode.this.isCorrectKey(key, value);
            }

            @Override
            public EntryKey findEntryKey(String value) throws Exception {
                return StringContextMode.this.findEntryKey(value);
            }

            @Override
            public void setStatementValue(PreparedStatement stmt, int pos, SourceTextEntry entry, boolean isDefault) throws SQLException {
                if (isDefault) {
                    stmt.setNull(pos, sqlType);
                } else {
                    super.setStatementValue(stmt, pos, entry, false);
                }
            }

            public String toString() {
                return "null or " + StringContextMode.this.toString();
            }
        };
    }

    protected abstract String convert(String var1);

    public StringContextMode constWrapper(final String constVal, final boolean convert) {
        return new StringContextMode(){
            private String constConverted;
            {
                this.constConverted = convert ? StringContextMode.this.convert(constVal) : constVal;
            }

            @Override
            protected String convert(String val) {
                return StringContextMode.this.convert(val);
            }

            @Override
            public String defaultValueForSource(String sourceText) {
                return this.constConverted;
            }

            @Override
            public String nonDefaultValueForEntry(SourceTextEntry key) {
                return (String)StringContextMode.this.nonDefaultValueForEntry(key);
            }

            @Override
            public boolean isDefault(String srcText, String value) {
                return value == null || value.equals(this.constConverted);
            }

            @Override
            public boolean isCorrectKey(SourceTextEntry entry, String value) {
                return StringContextMode.this.isCorrectKey(entry, value);
            }

            @Override
            public EntryKey findEntryKey(String value) throws Exception {
                return StringContextMode.this.findEntryKey(value);
            }

            @Override
            public void setStatementValue(PreparedStatement stmt, int pos, SourceTextEntry entry, boolean isDefault) throws SQLException {
                if (isDefault) {
                    stmt.setString(pos, this.constConverted);
                } else {
                    stmt.setString(pos, this.nonDefaultValueForEntry(entry));
                }
            }

            public String toString() {
                return "default(" + constVal + ") or " + StringContextMode.this.toString();
            }
        };
    }

    public static StringContextMode forProperties(Properties propList, int col_context_type) {
        block20: {
            StringContextMode mode = null;
            try {
                mode = ContextMode.forProperties(propList);
            }
            catch (Exception e1) {
                mode = DEFAULT;
            }
            if (mode == null) {
                try {
                    switch (col_context_type) {
                        case -32: 
                        case 32: {
                            mode = new DigestStringContextMode("MD5");
                            break;
                        }
                        case -40: 
                        case 40: {
                            mode = new DigestStringContextMode("SHA1");
                            break;
                        }
                        default: {
                            mode = DEFAULT;
                            break;
                        }
                    }
                }
                catch (Exception eTyp) {
                    mode = DEFAULT;
                }
            }
            try {
                StringContextMode sMode = mode;
                String contextDefault = propList.getProperty("context.default");
                if (contextDefault != null) {
                    if (contextDefault.equalsIgnoreCase("null")) {
                        return sMode.nullWrapper(col_context_type > 0 ? 12 : 1);
                    }
                    if (contextDefault.toLowerCase().startsWith("const")) {
                        contextDefault = contextDefault.substring(6);
                        if (col_context_type < 0) {
                            while (contextDefault.length() < -col_context_type) {
                                contextDefault = contextDefault + " ";
                            }
                            contextDefault = contextDefault.substring(0, -col_context_type);
                        }
                        return sMode.constWrapper(contextDefault, false);
                    }
                    if (contextDefault.toLowerCase().startsWith("convert")) {
                        return sMode.constWrapper(contextDefault.substring(8), true);
                    }
                    if (contextDefault.toLowerCase().startsWith("empty")) {
                        return sMode.constWrapper("", contextDefault.toLowerCase().contains("conv"));
                    }
                    break block20;
                }
                return sMode;
            }
            catch (Exception sNo) {
                try {
                    IntContextMode iMode = (IntContextMode)((Object)mode);
                    return new StringWrapperContextMode(iMode);
                }
                catch (Exception e) {
                    return DEFAULT;
                }
            }
        }
        return DEFAULT;
    }
}

