/*
 * Decompiled with CFR 0.152.
 */
package net.moraleboost.io;

import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.StringReader;
import net.moraleboost.io.BasicCodePointReader;
import net.moraleboost.io.CodePointReader;
import org.junit.Assert;
import org.junit.Test;

public class BasicCodePointReaderTest {
    @Test
    public void testBasic() throws IOException {
        long[] positions;
        String str = "\u3042a\u3044b\u3046c\u3048d\u304a";
        BasicCodePointReader reader = new BasicCodePointReader(new StringReader(str));
        int[] answer = this.getCodePoints(str);
        if (!this.match(reader, answer, positions = this.getPositions(str))) {
            Assert.fail((String)"\u30b3\u30fc\u30c9\u30dd\u30a4\u30f3\u30c8\u304c\u4e00\u81f4\u3057\u307e\u305b\u3093\u3002");
        }
    }

    @Test
    public void testSurrogatePair() throws IOException {
        int scp = 66560;
        int[] answer = new int[]{scp, 12354, 97, 12356, scp, scp, 100, 12362, scp};
        long[] lArray = new long[10];
        lArray[1] = 2L;
        lArray[2] = 3L;
        lArray[3] = 4L;
        lArray[4] = 5L;
        lArray[5] = 7L;
        lArray[6] = 9L;
        lArray[7] = 10L;
        lArray[8] = 11L;
        lArray[9] = 13L;
        String str = new String(answer, 0, answer.length);
        BasicCodePointReader reader = new BasicCodePointReader(new StringReader(str));
        long[] positions = lArray;
        if (!this.match(reader, answer, positions)) {
            Assert.fail((String)"\u30b3\u30fc\u30c9\u30dd\u30a4\u30f3\u30c8\u304c\u4e00\u81f4\u3057\u307e\u305b\u3093\u3002");
        }
    }

    @Test
    public void testEndWithHighSurrogate() throws IOException {
        int scp = 66560;
        String base = "\u672c\u65e5\u306f\u6674\u5929\u306a\u308a";
        char highSurrogate = Character.toChars(scp)[0];
        Assert.assertTrue((boolean)Character.isHighSurrogate(highSurrogate));
        CharArrayWriter writer = new CharArrayWriter();
        writer.write(base);
        writer.write(highSurrogate);
        int[] answer = this.getCodePoints(String.valueOf(base) + '\u3013');
        long[] positions = this.getPositions(String.valueOf(base) + '\u3013');
        BasicCodePointReader reader = new BasicCodePointReader(new CharArrayReader(writer.toCharArray()));
        if (!this.match(reader, answer, positions)) {
            Assert.fail((String)"\u30b3\u30fc\u30c9\u30dd\u30a4\u30f3\u30c8\u304c\u4e00\u81f4\u3057\u307e\u305b\u3093\u3002");
        }
    }

    @Test
    public void testEndWithLowSurrogate() throws IOException {
        int scp = 66560;
        String base = "\u672c\u65e5\u306f\u6674\u5929\u306a\u308a";
        char lowSurrogate = Character.toChars(scp)[1];
        Assert.assertTrue((boolean)Character.isLowSurrogate(lowSurrogate));
        CharArrayWriter writer = new CharArrayWriter();
        writer.write(base);
        writer.write(lowSurrogate);
        int[] answer = this.getCodePoints(String.valueOf(base) + '\u3013');
        long[] positions = this.getPositions(String.valueOf(base) + '\u3013');
        BasicCodePointReader reader = new BasicCodePointReader(new CharArrayReader(writer.toCharArray()));
        if (!this.match(reader, answer, positions)) {
            Assert.fail((String)"\u30b3\u30fc\u30c9\u30dd\u30a4\u30f3\u30c8\u304c\u4e00\u81f4\u3057\u307e\u305b\u3093\u3002");
        }
    }

    @Test
    public void testStartWithHighSurrogate() throws IOException {
        int scp = 66560;
        String base = "\u672c\u65e5\u306f\u6674\u5929\u306a\u308a";
        char highSurrogate = Character.toChars(scp)[0];
        Assert.assertTrue((boolean)Character.isHighSurrogate(highSurrogate));
        CharArrayWriter writer = new CharArrayWriter();
        writer.write(highSurrogate);
        writer.write(base);
        int[] answer = this.getCodePoints(String.valueOf('\u3013') + base);
        long[] positions = this.getPositions(String.valueOf('\u3013') + base);
        BasicCodePointReader reader = new BasicCodePointReader(new CharArrayReader(writer.toCharArray()));
        if (!this.match(reader, answer, positions)) {
            Assert.fail((String)"\u30b3\u30fc\u30c9\u30dd\u30a4\u30f3\u30c8\u304c\u4e00\u81f4\u3057\u307e\u305b\u3093\u3002");
        }
    }

    @Test
    public void testStartWithLowSurrogate() throws IOException {
        int scp = 66560;
        String base = "\u672c\u65e5\u306f\u6674\u5929\u306a\u308a";
        char lowSurrogate = Character.toChars(scp)[1];
        Assert.assertTrue((boolean)Character.isLowSurrogate(lowSurrogate));
        CharArrayWriter writer = new CharArrayWriter();
        writer.write(lowSurrogate);
        writer.write(base);
        int[] answer = this.getCodePoints(String.valueOf('\u3013') + base);
        long[] positions = this.getPositions(String.valueOf('\u3013') + base);
        BasicCodePointReader reader = new BasicCodePointReader(new CharArrayReader(writer.toCharArray()));
        if (!this.match(reader, answer, positions)) {
            Assert.fail((String)"\u30b3\u30fc\u30c9\u30dd\u30a4\u30f3\u30c8\u304c\u4e00\u81f4\u3057\u307e\u305b\u3093\u3002");
        }
    }

    @Test
    public void testIllformedSurrogate() throws IOException {
        int scp = 66560;
        int[] original = new int[]{12354, 97, 12356, scp, scp, 100, 12362};
        int[] answer1 = new int[]{12354, 97, 12356, 97, 12307, scp, 100, 12362};
        long[] lArray = new long[9];
        lArray[1] = 1L;
        lArray[2] = 2L;
        lArray[3] = 3L;
        lArray[4] = 4L;
        lArray[5] = 5L;
        lArray[6] = 7L;
        lArray[7] = 8L;
        lArray[8] = 9L;
        long[] positions1 = lArray;
        int[] answer2 = new int[]{12354, 97, 12356, 12307, 97, scp, 100, 12362};
        long[] lArray2 = new long[9];
        lArray2[1] = 1L;
        lArray2[2] = 2L;
        lArray2[3] = 3L;
        lArray2[4] = 4L;
        lArray2[5] = 5L;
        lArray2[6] = 7L;
        lArray2[7] = 8L;
        lArray2[8] = 9L;
        long[] positions2 = lArray2;
        char[] chars1 = new String(original, 0, original.length).toCharArray();
        char[] chars2 = new String(original, 0, original.length).toCharArray();
        chars1[3] = 97;
        String ill1 = new String(chars1);
        chars2[4] = 97;
        String ill2 = new String(chars2);
        if (!this.match(new BasicCodePointReader(new StringReader(ill1)), answer1, positions1)) {
            Assert.fail((String)"Low surrogate\u304c\u5358\u72ec\u3067\u5b58\u5728\u3059\u308b\u5834\u5408\u306e\u30b3\u30fc\u30c9\u30dd\u30a4\u30f3\u30c8\u304c\u4e00\u81f4\u3057\u307e\u305b\u3093\u3002");
        }
        if (!this.match(new BasicCodePointReader(new StringReader(ill2)), answer2, positions2)) {
            Assert.fail((String)"High surrogate\u304c\u5358\u72ec\u3067\u5b58\u5728\u3059\u308b\u5834\u5408\u306e\u30b3\u30fc\u30c9\u30dd\u30a4\u30f3\u30c8\u304c\u4e00\u81f4\u3057\u307e\u305b\u3093\u3002");
        }
    }

    private boolean match(CodePointReader reader, int[] answer, long[] positions) throws IOException {
        int cp;
        int i = 0;
        while ((cp = reader.read()) >= 0) {
            if (cp != answer[i]) {
                return false;
            }
            if (reader.getPosition() != positions[i + 1]) {
                return false;
            }
            ++i;
        }
        return i == answer.length;
    }

    private int[] getCodePoints(String str) {
        int count = str.codePointCount(0, str.length());
        int[] result = new int[count];
        int cpIndex = 0;
        int charIndex = 0;
        while (charIndex < str.length()) {
            int cp = str.codePointAt(charIndex);
            result[cpIndex++] = cp;
            charIndex += Character.charCount(cp);
        }
        return result;
    }

    private long[] getPositions(String str) {
        int count = str.codePointCount(0, str.length());
        long[] positions = new long[count + 1];
        int cpIndex = 0;
        int charIndex = 0;
        while (charIndex < str.length()) {
            int cp = str.codePointAt(charIndex);
            positions[cpIndex++] = charIndex;
            charIndex += Character.charCount(cp);
        }
        positions[cpIndex] = charIndex;
        return positions;
    }
}

