/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.segment.srx;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.sourceforge.segment.srx.LanguageRule;
import net.sourceforge.segment.srx.Rule;
import net.sourceforge.segment.srx.SrxDocument;
import net.sourceforge.segment.util.Util;

public class RuleManager {
    private SrxDocument document;
    private int maxLookbehindConstructLength;
    private List<Rule> breakRuleList;
    private Map<Rule, Pattern> exceptionPatternMap;

    public RuleManager(SrxDocument document, List<LanguageRule> languageRuleList, int maxLookbehindConstructLength) {
        this.document = document;
        this.maxLookbehindConstructLength = maxLookbehindConstructLength;
        this.breakRuleList = new ArrayList<Rule>();
        this.exceptionPatternMap = new HashMap<Rule, Pattern>();
        StringBuilder exceptionPatternBuilder = new StringBuilder();
        for (LanguageRule languageRule : languageRuleList) {
            for (Rule rule : languageRule.getRuleList()) {
                if (rule.isBreak()) {
                    Pattern exceptionPattern;
                    this.breakRuleList.add(rule);
                    if (exceptionPatternBuilder.length() > 0) {
                        String exceptionPatternString = exceptionPatternBuilder.toString();
                        exceptionPattern = Util.compile(document, exceptionPatternString);
                    } else {
                        exceptionPattern = null;
                    }
                    this.exceptionPatternMap.put(rule, exceptionPattern);
                    continue;
                }
                if (exceptionPatternBuilder.length() > 0) {
                    exceptionPatternBuilder.append('|');
                }
                String patternString = this.createExceptionPatternString(rule);
                exceptionPatternBuilder.append(patternString);
            }
        }
    }

    public List<Rule> getBreakRuleList() {
        return this.breakRuleList;
    }

    public Pattern getExceptionPattern(Rule breakRule) {
        return this.exceptionPatternMap.get(breakRule);
    }

    private String createExceptionPatternString(Rule rule) {
        StringBuilder patternBuilder = new StringBuilder();
        String beforePattern = Util.finitize(rule.getBeforePattern(), this.maxLookbehindConstructLength);
        String afterPattern = rule.getAfterPattern();
        patternBuilder.append("(?:");
        if (beforePattern.length() > 0) {
            patternBuilder.append("(?<=" + beforePattern + ")");
        }
        if (afterPattern.length() > 0) {
            patternBuilder.append("(?=" + afterPattern + ")");
        }
        patternBuilder.append(")");
        return patternBuilder.toString();
    }
}

