/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.machinetranslators.net;

import java.io.StringReader;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.omegat.core.machinetranslators.BaseTranslate;
import org.omegat.core.machinetranslators.CachedTranslate;
import org.omegat.core.machinetranslators.net.YTPPostResponse;
import org.omegat.util.Language;
import org.omegat.util.OStrings;
import org.omegat.util.WikiGet;
import org.xml.sax.InputSource;

public class YandexTranslate
extends CachedTranslate {
    public static final int ERR_OK = 200;
    public static final int ERR_KEY_INVALID = 401;
    public static final int ERR_KEY_BLOCKED = 402;
    public static final int ERR_DAILY_REQ_LIMIT_EXCEEDED = 403;
    public static final int ERR_DAILY_CHAR_LIMIT_EXCEEDED = 404;
    public static final int ERR_TEXT_TOO_LONG = 413;
    public static final int ERR_UNPROCESSABLE_TEXT = 422;
    public static final int ERR_LANG_NOT_SUPPORTED = 501;
    protected static final String USER_AGENT = "Mozilla/5.0";
    protected static final String GT_URL = "https://translate.yandex.net/api/v1.5/tr/translate";
    protected static String mvYandexKey = System.getProperty("yandex.api.key");

    protected String getPreferenceName() {
        return "allow_yandex_translate";
    }

    public String getName() {
        if (mvYandexKey == null) {
            return OStrings.getString((String)"MT_ENGINE_YANDEX_KEY_NOTFOUND");
        }
        return OStrings.getString((String)"MT_ENGINE_YANDEX");
    }

    protected String translate(Language sLang, Language tLang, String text) throws Exception {
        if (mvYandexKey == null) {
            return "";
        }
        String lvSourceLang = sLang.getLanguageCode().substring(0, 2).toLowerCase();
        String lvTargetLang = tLang.getLanguageCode().substring(0, 2).toLowerCase();
        String lvShorText = text.length() > 10000 ? text.substring(0, 9999) + "\u2026" : text;
        TreeMap<String, String> p = new TreeMap<String, String>();
        p.put("key", mvYandexKey);
        p.put("lang", lvSourceLang + '-' + lvTargetLang);
        p.put("text", lvShorText);
        YTPPostResponse response = this.requestTranslate(p);
        XPathFactory xPathFactory = XPathFactory.newInstance();
        switch (response.code) {
            case 200: {
                break;
            }
            case 401: {
                throw new BaseTranslate.KeyException(response.code + ": " + OStrings.getString((String)"MT_ENGINE_YANDEX_INVALID_KEY"));
            }
            case 402: {
                throw new BaseTranslate.KeyException(response.code + ": " + OStrings.getString((String)"MT_ENGINE_YANDEX_API_BLOCKED"));
            }
            case 403: {
                throw new BaseTranslate.LimitException(response.code + ": " + OStrings.getString((String)"MT_ENGINE_YANDEX_DAILY_LIMIT_DETECT"));
            }
            case 404: {
                throw new BaseTranslate.LimitException(response.code + ": " + OStrings.getString((String)"MT_ENGINE_YANDEX_DAILY_LIMIT_VOLUME"));
            }
            case 413: {
                throw new Exception(response.code + ": " + OStrings.getString((String)"MT_ENGINE_YANDEX_MAZ_SIZE"));
            }
            case 422: {
                throw new Exception(response.code + ": " + OStrings.getString((String)"MT_ENGINE_YANDEX_TRANSLATION_NOT_POSSIBLE"));
            }
            case 501: {
                throw new Exception(response.code + ": " + OStrings.getString((String)"MT_ENGINE_YANDEX_DIRECTION_NOT_SUPPORTED"));
            }
        }
        XPath xPathText = xPathFactory.newXPath();
        String pathText = "/Translation[@code='200']/text";
        return xPathText.evaluate(pathText, new InputSource(new StringReader(response.response)));
    }

    protected YTPPostResponse requestTranslate(Map params) throws Exception {
        YTPPostResponse response = new YTPPostResponse();
        try {
            response.response = WikiGet.post((String)GT_URL, (Map)params);
            response.code = 200;
        }
        catch (WikiGet.ResponseError ex) {
            response.response = null;
            response.code = ex.code;
        }
        return response;
    }
}

