/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.glossary.taas;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import javax.swing.AbstractButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.events.IApplicationEventListener;
import org.omegat.core.events.IProjectEventListener;
import org.omegat.core.glossaries.IGlossary;
import org.omegat.gui.glossary.taas.BrowseTaasCollectionsController;
import org.omegat.gui.glossary.taas.SelectDomainController;
import org.omegat.gui.glossary.taas.TaaSClient;
import org.omegat.gui.glossary.taas.TaaSGlossary;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.openide.awt.Mnemonics;

public class TaaSPlugin {
    public static TaaSClient client;
    static JMenuItem browse;
    static Transformer filterTransformer;
    static Transformer filterTransformerContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadPlugins() {
        TaaSGlossary glossary;
        block7: {
            try {
                client = new TaaSClient();
                if (client.isAllowed()) {
                    glossary = new TaaSGlossary();
                    InputStream in = TaaSGlossary.class.getResourceAsStream("filter.xslt");
                    if (in == null) {
                        throw new Exception("filter.xslt is unaccessible");
                    }
                    try {
                        TransformerFactory factory = TransformerFactory.newInstance();
                        StreamSource xslt = new StreamSource(in);
                        filterTransformer = factory.newTransformer(xslt);
                        break block7;
                    }
                    finally {
                        in.close();
                    }
                }
                glossary = null;
            }
            catch (Exception ex) {
                Log.log((Throwable)ex);
                return;
            }
        }
        CoreEvents.registerApplicationEventListener((IApplicationEventListener)new IApplicationEventListener(){

            public void onApplicationStartup() {
                JMenu menu = Core.getMainWindow().getMainMenu().getGlossaryMenu();
                browse = new JMenuItem();
                Mnemonics.setLocalizedText((AbstractButton)browse, (String)OStrings.getString((String)"TAAS_MENU_BROWSE"));
                browse.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (client.isAllowed()) {
                            BrowseTaasCollectionsController.show();
                        } else {
                            JOptionPane.showMessageDialog(Core.getMainWindow().getApplicationFrame(), OStrings.getString((String)"TAAS_API_KEY_NOT_FOUND"), OStrings.getString((String)"TF_WARNING"), 2);
                        }
                    }
                });
                browse.setEnabled(false);
                menu.add(browse);
                JMenuItem select = new JMenuItem();
                Mnemonics.setLocalizedText((AbstractButton)select, (String)OStrings.getString((String)"TAAS_MENU_DOMAINS"));
                select.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (client.isAllowed()) {
                            SelectDomainController.show();
                        } else {
                            JOptionPane.showMessageDialog(Core.getMainWindow().getApplicationFrame(), OStrings.getString((String)"TAAS_API_KEY_NOT_FOUND"), OStrings.getString((String)"TF_WARNING"), 2);
                        }
                    }
                });
                menu.add(select);
                final JCheckBoxMenuItem lookup = new JCheckBoxMenuItem();
                lookup.setSelected(Preferences.isPreferenceDefault((String)"taas_lookup", (boolean)false));
                Mnemonics.setLocalizedText((AbstractButton)lookup, (String)OStrings.getString((String)"TAAS_MENU_LOOKUP"));
                lookup.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Preferences.setPreference((String)"taas_lookup", (Object)lookup.isSelected());
                        Preferences.save();
                        if (!client.isAllowed()) {
                            JOptionPane.showMessageDialog(Core.getMainWindow().getApplicationFrame(), OStrings.getString((String)"TAAS_API_KEY_NOT_FOUND"), OStrings.getString((String)"TF_WARNING"), 2);
                        }
                    }
                });
                menu.add(lookup);
                if (client.isAllowed()) {
                    Core.getGlossaryManager().addGlossaryProvider((IGlossary)glossary);
                }
            }

            public void onApplicationShutdown() {
            }
        });
        CoreEvents.registerProjectChangeListener((IProjectEventListener)new IProjectEventListener(){

            public void onProjectChanged(IProjectEventListener.PROJECT_CHANGE_TYPE eventType) {
                if (browse == null) {
                    return;
                }
                switch (eventType) {
                    case CLOSE: {
                        browse.setEnabled(false);
                        break;
                    }
                    case CREATE: 
                    case LOAD: {
                        browse.setEnabled(true);
                        break;
                    }
                }
            }
        });
    }

    static String filterTaasResult(String xml) throws Exception {
        StreamSource src = new StreamSource(new StringReader(xml));
        StringWriter out = new StringWriter();
        filterTransformer.transform(src, new StreamResult(out));
        return out.toString();
    }

    static void filterTaasResult(InputStream in, OutputStream out) throws Exception {
        StreamSource src = new StreamSource(in);
        filterTransformer.transform(src, new StreamResult(out));
    }

    public static void unloadPlugins() {
    }
}

