/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.spelling.morfologik;

import java.io.IOException;
import java.net.URL;
import java.nio.charset.CharacterCodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import morfologik.speller.Speller;
import morfologik.stemming.Dictionary;
import org.languagetool.JLanguageTool;
import org.languagetool.tools.StringTools;

public class MorfologikSpeller {
    private static final String LANGUAGETOOL = "LanguageTool";
    private final Speller speller;
    private final Locale conversionLocale;

    public MorfologikSpeller(String filename, Locale conversionLocale, int maxEditDistance) throws IOException {
        if (maxEditDistance <= 0) {
            throw new RuntimeException("maxEditDistance must be > 0: " + maxEditDistance);
        }
        URL url = JLanguageTool.getDataBroker().getFromResourceDirAsUrl(filename);
        this.speller = new Speller(Dictionary.read((URL)url), maxEditDistance);
        this.conversionLocale = conversionLocale != null ? conversionLocale : Locale.getDefault();
    }

    public MorfologikSpeller(String filename, Locale conversionLocale) throws IOException {
        this(filename, conversionLocale, 1);
    }

    public MorfologikSpeller(String filename) throws IOException {
        this(filename, null);
    }

    public boolean isMisspelled(String word) {
        boolean isAlphabetic = true;
        if (word.length() == 1) {
            isAlphabetic = StringTools.isAlphabetic(word.charAt(0));
        }
        return word.length() > 0 && isAlphabetic && !this.containsDigit(word) && !LANGUAGETOOL.equals(word) && !this.speller.isInDictionary((CharSequence)word) && (StringTools.isMixedCase(word) || !this.speller.isInDictionary((CharSequence)word.toLowerCase(this.conversionLocale)));
    }

    public List<String> getSuggestions(String word) {
        ArrayList<String> suggestions = new ArrayList<String>();
        try {
            suggestions.addAll(this.speller.findReplacements(word));
            if (!word.toLowerCase(this.conversionLocale).equals(word)) {
                suggestions.addAll(this.speller.findReplacements(word.toLowerCase(this.conversionLocale)));
            }
            suggestions.addAll(this.speller.replaceRunOnWords(word));
        }
        catch (CharacterCodingException e) {
            throw new RuntimeException(e);
        }
        return suggestions;
    }

    private boolean containsDigit(String s) {
        for (int k = 0; k < s.length(); ++k) {
            if (!Character.isDigit(s.charAt(k))) continue;
            return true;
        }
        return false;
    }
}

