/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.euramis.concordance;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.StringReader;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.text.MessageFormat;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.omegat.core.Core;
import org.omegat.gui.editor.EditorController;
import org.omegat.gui.editor.PopupMenuDisplayer;
import org.omegat.gui.editor.SegmentBuilder;
import org.omegat.gui.main.ToolBar;

public class ConcordanceWindow
extends JFrame
implements PopupMenuDisplayer.IPopupMenuConstructor {
    public static final String SERVICE_URL = "http://wltdgt01.cc.cec.eu.int:1061/euramis/robot/concordance/search.do?robotId=omegat@dgt&robotPassword=0m3G4t&output=xml&bean.direction=DRI&bean.method=B&bean.rowsByPage=30&bean.sourceLanguage={1}&sbean.targetLanguages={2}&bean.searchText={0}";
    private EditorController editor;
    private JEditorPane pane;

    public ConcordanceWindow(EditorController ec) {
        this.setTitle("Euramis Concordance");
        this.setBounds(100, 100, 742, 546);
        this.editor = ec;
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConcordanceWindow.this.dispose();
            }
        };
        this.getRootPane().getInputMap(2).put(escape, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
        this.pane = new JEditorPane();
        this.getContentPane().add(new JScrollPane(this.pane));
        if (ToolBar.INSTANCE != null) {
            ImageIcon icon = new ImageIcon(ConcordanceWindow.class.getResource("/eu/europa/euramis/concordance/Euramis.png"));
            JButton btn = new JButton(icon);
            btn.setToolTipText("Euramis Concordance (ctrl shift E)");
            AbstractAction concordanceAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    String selection = ConcordanceWindow.this.editor.getSelectedText();
                    if (selection == null) {
                        JOptionPane.showMessageDialog((JFrame)Core.getMainWindow(), "You must select a text before to call this window", "ERROR", 0);
                    } else {
                        ConcordanceWindow.this.pane.setText("Search for '" + selection + "'...");
                        new Thread(new ConcordanceSearchThread(selection)).start();
                        ConcordanceWindow.this.setVisible(true);
                    }
                }
            };
            btn.addActionListener(concordanceAction);
            btn.getInputMap(2).put(KeyStroke.getKeyStroke("ctrl shift E"), "concordanceAction");
            btn.getActionMap().put("concordanceAction", concordanceAction);
            ToolBar.INSTANCE.add((Component)btn);
        }
    }

    public void addItems(JPopupMenu menu, JTextComponent comp, int mousepos, boolean isInActiveEntry, boolean isInActiveTranslation, SegmentBuilder sb) {
        final String selection = this.editor.getSelectedText();
        JMenuItem item = new JMenuItem("Euramis Concordance");
        menu.add(item);
        menu.add(new JSeparator());
        if (selection == null) {
            item.setEnabled(false);
        } else {
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    ConcordanceWindow.this.pane.setText("Search for '" + selection + "'...");
                    new Thread(new ConcordanceSearchThread(selection)).start();
                    ConcordanceWindow.this.setVisible(true);
                }
            });
        }
    }

    private class ConcordanceSearchThread
    implements Runnable {
        private String searchText;

        public ConcordanceSearchThread(String searchText) {
            this.searchText = searchText;
        }

        @Override
        public void run() {
            String source = Core.getProject().getProjectProperties().getSourceLanguage().getLanguageCode().substring(0, 2).toUpperCase();
            String target = Core.getProject().getProjectProperties().getTargetLanguage().getLanguageCode().substring(0, 2).toUpperCase();
            try {
                String line;
                URL url = new URL(MessageFormat.format(ConcordanceWindow.SERVICE_URL, URLEncoder.encode(this.searchText, "UTF-8"), source, target));
                URLConnection conn = url.openConnection();
                BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                StringBuffer answer = new StringBuffer();
                while ((line = rd.readLine()) != null) {
                    answer.append(line);
                }
                rd.close();
                if (answer.indexOf("<result") > 0) {
                    TransformerFactory tFactory = TransformerFactory.newInstance();
                    InputStream xslt = ConcordanceWindow.class.getResourceAsStream("/eu/europa/euramis/concordance/concordance.xsl");
                    Transformer transformer = tFactory.newTransformer(new StreamSource(xslt));
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    PrintStream ps = new PrintStream(baos);
                    transformer.transform(new StreamSource(new StringReader(answer.toString())), new StreamResult(ps));
                    ConcordanceWindow.this.pane.setContentType("text/html");
                    ConcordanceWindow.this.pane.setText(baos.toString("UTF8"));
                } else {
                    ConcordanceWindow.this.pane.setContentType("text/html");
                    ConcordanceWindow.this.pane.setText("<h1>Search for '" + this.searchText + "'</h1> <br> <h2>No result found</h2>");
                }
            }
            catch (Exception e) {
                ConcordanceWindow.this.pane.setContentType("text/plain");
                ConcordanceWindow.this.pane.setText(e.getMessage());
                e.printStackTrace();
            }
        }
    }
}

