/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.quest;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.data.ProjectProperties;
import org.omegat.core.events.IProjectEventListener;
import org.omegat.gui.editor.EditorController;
import org.omegat.gui.editor.PopupMenuDisplayer;
import org.omegat.gui.editor.SegmentBuilder;
import org.omegat.gui.main.ToolBar;

public class WebToolsPopup
implements PopupMenuDisplayer.IPopupMenuConstructor {
    protected final EditorController ec;
    public static final ResourceBundle menus = ResourceBundle.getBundle("eu.europa.quest.menus");
    public static final ResourceBundle icons = ResourceBundle.getBundle("eu.europa.quest.icons");
    public static final ResourceBundle shortcuts = ResourceBundle.getBundle("eu.europa.quest.shortcuts");
    private static boolean isInsideDgt = WebToolsPopup.checkInsideDgt();

    public WebToolsPopup(EditorController ec) {
        this.ec = ec;
        if (ToolBar.INSTANCE != null) {
            JButton btnQuit = null;
            for (int i = 0; i < ToolBar.INSTANCE.getComponentCount(); ++i) {
                try {
                    btnQuit = (JButton)ToolBar.INSTANCE.getComponent(i);
                    if (!btnQuit.getActionCommand().equals("projectExitMenuItem")) continue;
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ToolBar.INSTANCE.remove(btnQuit);
            Enumeration<String> I = icons.getKeys();
            while (I.hasMoreElements()) {
                String key = I.nextElement();
                String url = menus.getString(key);
                String iconPath = icons.getString(key);
                if (url.contains("|")) {
                    String[] alternatives = url.split("\\|");
                    url = isInsideDgt ? alternatives[0] : alternatives[1];
                }
                ImageIcon icon = new ImageIcon(WebToolsPopup.class.getResource(iconPath));
                final JButton btn = new JButton(icon);
                btn.addActionListener(new WebTool(url));
                String shortcut = shortcuts.getString(key);
                btn.getInputMap(2).put(KeyStroke.getKeyStroke(shortcut), key + "Action");
                btn.getActionMap().put(key + "Action", new WebTool(url));
                btn.setToolTipText(key + " (" + shortcut + ")");
                ToolBar.INSTANCE.add((Component)btn);
                btn.setEnabled(false);
                if (!isInsideDgt && url.contains("gate")) continue;
                CoreEvents.registerProjectChangeListener((IProjectEventListener)new IProjectEventListener(){

                    public void onProjectChanged(IProjectEventListener.PROJECT_CHANGE_TYPE eventType) {
                        switch (eventType) {
                            case CREATE: 
                            case LOAD: {
                                btn.setEnabled(true);
                                break;
                            }
                            case CLOSE: {
                                btn.setEnabled(false);
                            }
                        }
                    }
                });
            }
            ToolBar.INSTANCE.addSeparator();
            ToolBar.INSTANCE.add((Component)btnQuit);
        }
    }

    private static boolean checkInsideDgt() {
        try {
            String quest = menus.getString("Quest");
            System.out.println("---------- Try to access " + quest);
            HttpURLConnection conn = (HttpURLConnection)new URL(quest.substring(0, quest.lastIndexOf("/"))).openConnection();
            conn.setRequestMethod("HEAD");
            int code = conn.getResponseCode();
            System.out.println("------------- Returned code " + code + " => Quest availability = " + (code < 400));
            return code < 400;
        }
        catch (UnknownHostException uhn) {
            System.out.println("------------- Cannot reach Quest => Quest availability = false");
        }
        catch (Exception ex1) {
            ex1.printStackTrace();
        }
        return false;
    }

    public void addItems(JPopupMenu menu, JTextComponent comp, int mousepos, boolean isInActiveEntry, boolean isInActiveTranslation, SegmentBuilder sb) {
        Enumeration<String> I = menus.getKeys();
        while (I.hasMoreElements()) {
            String key = I.nextElement();
            String iconPath = icons.getString(key);
            if (iconPath != null) continue;
            String url = menus.getString(key);
            JMenuItem quest = menu.add(key);
            if (isInsideDgt) {
                quest.addActionListener(new WebTool(url));
                continue;
            }
            quest.setEnabled(false);
        }
    }

    final class WebTool
    extends AbstractAction {
        private String queryFormat;

        public WebTool(String format) {
            this.queryFormat = format;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String selection = WebToolsPopup.this.ec.getSelectedText();
            if (!(selection != null && selection.length() != 0 || (selection = Core.getGlossary().getSelectedText()) != null && selection.length() != 0)) {
                selection = WebToolsPopup.this.ec.getCurrentEntry().getSrcText();
            }
            ProjectProperties prop = Core.getProject().getProjectProperties();
            String source = prop.getSourceLanguage().getLanguageCode().substring(0, 2).toUpperCase();
            String target = prop.getTargetLanguage().getLanguageCode().substring(0, 2).toUpperCase();
            try {
                String url = MessageFormat.format(this.queryFormat, URLEncoder.encode(selection, "UTF-8"), source, target);
                System.err.println("Call : " + url);
                Desktop.getDesktop().browse(new URI(url));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

