/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.fileview;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.text.Highlighter;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.events.IProjectEventListener;
import org.omegat.gui.editor.mark.IMarker;
import org.omegat.gui.editor.mark.Mark;

public abstract class FileViewer
extends JDialog
implements IProjectEventListener,
IMarker {
    private JEditorPane output = new JEditorPane();
    private JMenuItem menuItem;

    protected FileViewer() {
        super((Frame)Core.getMainWindow().getApplicationFrame(), true);
        this.add((Component)new JScrollPane(this.output), "Center");
        this.output.setEditable(false);
        this.setDefaultCloseOperation(2);
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileViewer.this.dispose();
            }
        };
        this.getRootPane().getInputMap(2).put(escape, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
        JMenu toolsMenu = Core.getMainWindow().getMainMenu().getToolsMenu();
        toolsMenu.add(new JSeparator());
        this.menuItem = new JMenuItem(this.getActionMenuText());
        this.menuItem.setEnabled(this.isMenuEnabled());
        toolsMenu.add(this.menuItem);
        this.menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileViewer.this.displayData("Loading...", "text/plain");
                FileViewer.this.displayFile();
                FileViewer.this.setVisible(true);
            }
        });
        CoreEvents.registerProjectChangeListener((IProjectEventListener)this);
        this.setSize(600, 300);
    }

    protected abstract String getActionMenuText();

    protected abstract File getFile();

    protected abstract boolean isMenuEnabled();

    public Highlighter.HighlightPainter getPainter() {
        return null;
    }

    public List<Mark> getMarksForEntry(SourceTextEntry entry, String src, String tra, boolean active) throws Exception {
        return Collections.EMPTY_LIST;
    }

    public void onProjectChanged(IProjectEventListener.PROJECT_CHANGE_TYPE eventType) {
        if (eventType != IProjectEventListener.PROJECT_CHANGE_TYPE.COMPILE) {
            this.menuItem.setEnabled(this.isMenuEnabled());
        }
    }

    public void displayData(String result, String format) {
        this.output.setText(result);
        this.output.setContentType(format);
    }

    public void displayFile() {
        this.output.setContentType("text/html");
        try {
            this.output.setPage(this.getFile().toURL());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.output.setText(e.getMessage());
        }
    }
}

