/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc;

import java.io.File;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.wc2.compat.SvnCodec;
import org.tmatesoft.svn.core.wc.DefaultSVNCommitHandler;
import org.tmatesoft.svn.core.wc.DefaultSVNCommitParameters;
import org.tmatesoft.svn.core.wc.ISVNCommitHandler;
import org.tmatesoft.svn.core.wc.ISVNCommitParameters;
import org.tmatesoft.svn.core.wc.ISVNExternalsHandler;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNRepositoryPool;
import org.tmatesoft.svn.core.wc.SVNBasicClient;
import org.tmatesoft.svn.core.wc.SVNCopySource;
import org.tmatesoft.svn.core.wc2.SvnCopy;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import org.tmatesoft.svn.core.wc2.SvnRemoteCopy;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class SVNCopyClient
extends SVNBasicClient {
    private ISVNCommitHandler commitHandler;
    private ISVNCommitParameters commitParamaters;
    private ISVNExternalsHandler externalsHandler;
    private boolean disableLocalModifications;

    public SVNCopyClient(ISVNAuthenticationManager authManager, ISVNOptions options) {
        super(authManager, options);
    }

    public SVNCopyClient(ISVNRepositoryPool repositoryPool, ISVNOptions options) {
        super(repositoryPool, options);
    }

    public SVNCopyClient(SvnOperationFactory of) {
        super(of);
    }

    protected void initDefaults() {
        this.setCommitParameters(null);
        this.setCommitHandler(null);
        this.setExternalsHandler(null);
    }

    public void setCommitHandler(ISVNCommitHandler handler) {
        if (handler == null) {
            handler = new DefaultSVNCommitHandler();
        }
        this.commitHandler = handler;
    }

    public ISVNCommitHandler getCommitHandler() {
        return this.commitHandler;
    }

    public void setCommitParameters(ISVNCommitParameters parameters) {
        if (parameters == null) {
            parameters = new DefaultSVNCommitParameters();
        }
        this.commitParamaters = parameters;
    }

    public ISVNCommitParameters getCommitParameters() {
        return this.commitParamaters;
    }

    public void setExternalsHandler(ISVNExternalsHandler externalsHandler) {
        if (externalsHandler == null) {
            externalsHandler = ISVNExternalsHandler.DEFAULT;
        }
        this.externalsHandler = externalsHandler;
    }

    public void setDisableLocalModificationCopying(boolean disable) {
        this.disableLocalModifications = disable;
    }

    public ISVNExternalsHandler getExternalsHandler() {
        return this.externalsHandler;
    }

    public void doCopy(SVNCopySource[] sources, File dst, boolean isMove, boolean makeParents, boolean failWhenDstExists) throws SVNException {
        SvnCopy cp = this.getOperationsFactory().createCopy();
        cp.setSingleTarget(SvnTarget.fromFile(dst));
        cp.setMove(isMove);
        cp.setFailWhenDstExists(failWhenDstExists);
        cp.setMakeParents(makeParents);
        for (int i = 0; i < sources.length; ++i) {
            cp.addCopySource(SvnCodec.copySource(sources[i]));
        }
        cp.run();
    }

    public void doCopy(SVNCopySource[] sources, File dst, boolean isMove, boolean makeParents, boolean failWhenDstExists, boolean allowMixedRevisions, boolean metadataOnly) throws SVNException {
        SvnCopy cp = this.getOperationsFactory().createCopy();
        cp.setSingleTarget(SvnTarget.fromFile(dst));
        cp.setMove(isMove);
        cp.setFailWhenDstExists(failWhenDstExists);
        cp.setMakeParents(makeParents);
        cp.setIgnoreExternals(this.isIgnoreExternals());
        cp.setAllowMixedRevisions(allowMixedRevisions);
        cp.setMetadataOnly(metadataOnly);
        for (int i = 0; i < sources.length; ++i) {
            cp.addCopySource(SvnCodec.copySource(sources[i]));
        }
        cp.run();
    }

    public SVNCommitInfo doCopy(SVNCopySource[] sources, SVNURL dst, boolean isMove, boolean makeParents, boolean failWhenDstExists, String commitMessage, SVNProperties revisionProperties) throws SVNException {
        SvnRemoteCopy cp = this.getOperationsFactory().createRemoteCopy();
        cp.setSingleTarget(SvnTarget.fromURL(dst));
        cp.setMove(isMove);
        cp.setFailWhenDstExists(failWhenDstExists);
        cp.setMakeParents(makeParents);
        cp.setCommitMessage(commitMessage);
        cp.setRevisionProperties(revisionProperties);
        cp.setExternalsHandler(SvnCodec.externalsHandler(this.getExternalsHandler()));
        cp.setCommitHandler(SvnCodec.commitHandler(this.getCommitHandler()));
        cp.setDisableLocalModifications(this.disableLocalModifications);
        cp.setCommitParameters(SvnCodec.commitParameters(this.getCommitParameters()));
        for (int i = 0; i < sources.length; ++i) {
            cp.addCopySource(SvnCodec.copySource(sources[i]));
        }
        return cp.run();
    }

    public void doCopy(File nestedWC) throws SVNException {
        SvnCopy cp = this.getOperationsFactory().createCopy();
        cp.setDisjoint(true);
        cp.setSingleTarget(SvnTarget.fromFile(nestedWC));
        cp.run();
    }
}

