/*
 * Decompiled with CFR 0.152.
 */
package org.silvestrislab.cyclotis.omegat.glos;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.omegat.core.glossaries.GlossaryEntryStore;
import org.omegat.core.glossaries.IGlossary;
import org.omegat.core.glossaries.IWritableGlossary;
import org.omegat.util.Language;
import org.silvestrislab.cyclotis.omegat.HttpCyclotis;
import org.silvestrislab.cyclotis.omegat.http.HttpOutputFormat;

public class HttpGlossary
extends HttpCyclotis<GlossaryEntryStore>
implements IGlossary,
IWritableGlossary {
    protected static final String LINE_FORMAT = "otn";

    public HttpGlossary(Properties propList) {
        super(propList);
    }

    @Override
    public final GlossaryEntryStore analyzeLine(HttpOutputFormat fmt, Object args) {
        return fmt.buildGlossaryEntry(args, this);
    }

    public void addEntry(Language sLang, Language tLang, GlossaryEntryStore entry) throws Exception {
        this.registerTranslation(entry);
        this.logEntry("update-contents", entry, false);
    }

    @Override
    protected Map<String, String> encodeArgs(GlossaryEntryStore entry) {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("src", this.reformatText(entry.getSrcText(), false));
        args.put("tra", this.reformatText(entry.getCommentText(), false));
        args.put("note", entry.getCommentText());
        return args;
    }

    public List<GlossaryEntryStore> search(Language sLang, Language tLang, String srcText) throws Exception {
        this.logMessage("search", "Searching for '" + srcText + "'");
        return this.httpGetAll("glosSrc", "otn&langSrc=" + sLang.getLanguageCode(), srcText);
    }

    public String getEngineName() {
        return this.getProviderName();
    }

    public String getShortName() {
        return this.getMemoryName();
    }

    public String getLongName() {
        return this.getMemoryName() + " (" + this.getProviderName() + "/HTTP)";
    }

    public boolean isExternal() {
        return true;
    }

    public boolean hasContents() {
        return true;
    }

    public StringBuffer entryToLogString(GlossaryEntryStore entry, boolean detailed, boolean digest) {
        StringBuffer buf = new StringBuffer("\t<Glossary Entry>\n");
        if (!digest) {
            buf.append("\t\t<source>" + entry.getSrcText() + "</source>\n");
            buf.append("\t\t<target>" + entry.getLocText() + "</target>\n");
        } else {
            buf.append("\t\t<source digest='" + this.digest(entry.getSrcText()) + "'>" + entry.getSrcText() + "</source>\n");
            buf.append("\t\t<target digest='" + this.digest(entry.getLocText()) + "'>" + entry.getLocText() + "</target>\n");
        }
        buf.append("\t</Glossary Entry>");
        return buf;
    }
}

