/*
 * Decompiled with CFR 0.152.
 */
package org.silvestrislab.cyclotis.omegat.proj;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.omegat.core.data.EntryKey;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.core.matching.external.IEntryCursor;
import org.omegat.core.matching.external.ProjectMemory;
import org.omegat.util.TMXProp;
import org.silvestrislab.cyclotis.omegat.HttpCyclotisTMX;
import org.silvestrislab.cyclotis.omegat.http.HttpOutputFormat;
import org.silvestrislab.cyclotis.omegat.proj.ContextTMXEntry;
import org.silvestrislab.cyclotis.omegat.proj.EntryKeyStore;
import org.silvestrislab.cyclotis.omegat.proj.ctx.StringContextMode;

public class HttpProjectMemory
extends HttpCyclotisTMX<ContextTMXEntry>
implements ProjectMemory.IExternalProjectMemory {
    public static final int COL_CONTEXT = 8;
    public final EntryKeyStore keyStore;
    public final StringContextMode contextMode;
    private long timeStampDiff;

    public HttpProjectMemory(Properties propList) {
        super(propList);
        this.keyStore = new EntryKeyStore(propList);
        this.logMessage("struct", "Storing properties as " + this.keyStore);
        this.contextMode = StringContextMode.forProperties(propList, 1);
        this.logMessage("struct", "Context mode  is " + this.contextMode);
        try {
            String serverTime = propList.getProperty("server-time");
            if (serverTime.contains(";")) {
                serverTime = serverTime.substring(0, serverTime.indexOf(59));
            }
            this.timeStampDiff = Long.parseLong(serverTime) - System.currentTimeMillis();
            this.logMessage("", "Server to client timestamp difference: " + this.timeStampDiff);
        }
        catch (Exception e) {
            this.logMessage("", "Cannot find server timestamp : " + e.getMessage());
        }
    }

    @Override
    public ContextTMXEntry analyzeLine(HttpOutputFormat fmt, Object args) {
        return null;
    }

    public IEntryCursor findChanges(final long timeStamp) throws Exception {
        this.logMessage("search", "Searching for segments after " + LONG_LOG_DATE_FORMAT.format(new Date(timeStamp + this.timeStampDiff)));
        return new IEntryCursor(){
            IEntryCursor base;
            private Iterator<TMXProp> propIter;
            private TMXProp currentProp;
            {
                this.base = HttpProjectMemory.this.httpGetCursor("all", "otadcupni", new Timestamp(timeStamp + HttpProjectMemory.this.timeStampDiff).toString());
                this.propIter = null;
                this.currentProp = null;
            }

            public boolean next() throws Exception {
                return this.base.next();
            }

            public String getEntrySource() throws Exception {
                return this.base.getEntrySource();
            }

            public String getEntryTranslation() throws Exception {
                return this.base.getEntryTranslation();
            }

            public String getEntryAuthor() throws Exception {
                return this.base.getEntryAuthor();
            }

            public String getEntryLastModifier() throws Exception {
                return this.base.getEntryLastModifier();
            }

            public long getEntryCreationDate() throws Exception {
                return this.base.getEntryCreationDate();
            }

            public long getEntryLastModificationDate() throws Exception {
                return this.base.getEntryLastModificationDate();
            }

            public String getEntryNote() throws Exception {
                return this.base.getEntryNote();
            }

            public boolean nextProperty() throws Exception {
                if (this.propIter == null) {
                    if (!this.base.nextProperty()) {
                        return false;
                    }
                    String context = this.base.getCurrentPropertyValue();
                    if (this.base.getCurrentPropertyName().equals("CONTEXT") && HttpProjectMemory.this.contextMode.isDefault(this.base.getEntrySource(), context)) {
                        return false;
                    }
                    ArrayList<TMXProp> baseProps = new ArrayList<TMXProp>();
                    while (this.base.nextProperty()) {
                        baseProps.add(new TMXProp(this.base.getCurrentPropertyName(), this.base.getCurrentPropertyValue()));
                    }
                    try {
                        this.propIter = HttpProjectMemory.this.keyStore.findKey(baseProps, false).iterator();
                    }
                    catch (Exception e1) {
                        try {
                            EntryKey key = HttpProjectMemory.this.contextMode.findEntryKey(context);
                            ArrayList<TMXProp> props = new ArrayList<TMXProp>(5);
                            props.add(new TMXProp("id", key.id));
                            props.add(new TMXProp("prev", key.prev));
                            props.add(new TMXProp("next", key.next));
                            props.add(new TMXProp("path", key.path));
                            props.add(new TMXProp("file", key.file));
                            this.propIter = props.iterator();
                        }
                        catch (Exception e2) {
                            HttpProjectMemory.this.logMessage("", e2.getMessage());
                        }
                    }
                }
                if (this.propIter.hasNext()) {
                    this.currentProp = this.propIter.next();
                    return true;
                }
                return false;
            }

            public String getCurrentPropertyName() {
                return this.currentProp.getType();
            }

            public String getCurrentPropertyValue() {
                return this.currentProp.getValue();
            }
        };
    }

    @Override
    protected Map<String, String> encodeArgs(ContextTMXEntry entry) {
        Map<String, String> args = super.encodeArgs(entry);
        args.put("context", (String)this.contextMode.toDatabase(entry.entryNum, entry.isDefault));
        if (this.keyStore.shouldWrite(entry)) {
            for (TMXProp prop : this.keyStore.buildProperties(entry)) {
                args.put("props." + prop.getType(), prop.getValue());
            }
        }
        return args;
    }

    public void removeTranslation(SourceTextEntry ste, boolean isDefault) throws Exception {
        String line;
        StringBuffer urlString = new StringBuffer(this.urlSave);
        urlString.append("?context=").append((String)this.contextMode.toDatabase(ste.entryNum(), isDefault));
        if (!this.contextMode.isUnique()) {
            urlString.append("&src=").append(URLEncoder.encode(ste.getSrcText(), "UTF-8"));
        }
        URL httpUrl = new URL(urlString.toString());
        HttpURLConnection connection = (HttpURLConnection)httpUrl.openConnection();
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setInstanceFollowRedirects(false);
        connection.setRequestMethod("DELETE");
        BufferedReader rd = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        while ((line = rd.readLine()) != null) {
            System.out.println("POST:" + line);
        }
        connection.disconnect();
    }

    public void registerTranslation(SourceTextEntry ste, TMXEntry te, boolean isDefault) throws Exception {
        if (te == null || te.translation == null) {
            this.removeTranslation(ste, isDefault);
            return;
        }
        ContextTMXEntry entry = new ContextTMXEntry(te, ste);
        List<Object> list = entry.otherProperties = this.store.storesSomeProperties() ? this.store.toDatabase(entry, ste) : new ArrayList();
        if (this.keyStore != null) {
            entry.otherProperties.addAll(this.keyStore.buildProperties(ste, te));
        }
        super.registerTranslation(entry);
    }
}

