/*
 * Decompiled with CFR 0.152.
 */
package org.silvestrislab.cyclotis.omegat.proj.ctx;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.omegat.core.data.EntryKey;
import org.omegat.core.data.SourceTextEntry;
import org.silvestrislab.cyclotis.omegat.Cyclotis;
import org.silvestrislab.cyclotis.omegat.proj.ContextTMXEntry;
import org.silvestrislab.cyclotis.omegat.proj.ctx.ContextMode;
import org.silvestrislab.cyclotis.omegat.proj.ctx.EntryCache;
import org.silvestrislab.cyclotis.omegat.proj.ctx.HashContextMode;
import org.silvestrislab.cyclotis.omegat.proj.ctx.StringContextMode;

public abstract class IntContextMode
extends ContextMode<Integer> {
    public static final IntContextMode DEFAULT = new HashContextMode();

    @Override
    public final void fillEntry(Cyclotis origin, ContextTMXEntry entry, ResultSet data) throws SQLException {
        this.fillEntry(origin, entry, data.getInt("CONTEXT"));
    }

    @Override
    public void setStatementValue(PreparedStatement stmt, int pos, SourceTextEntry key, boolean isDefault) throws SQLException {
        stmt.setInt(pos, (Integer)this.toDatabase(key, isDefault));
    }

    @Override
    public Integer getValue(ResultSet rs) throws SQLException {
        return rs.getInt("CONTEXT");
    }

    public IntContextMode nullWrapper() {
        return new IntContextMode(){

            @Override
            public Integer defaultValueForSource(String sourceText) {
                return null;
            }

            @Override
            public Integer nonDefaultValueForEntry(SourceTextEntry key) {
                return (Integer)IntContextMode.this.nonDefaultValueForEntry(key);
            }

            @Override
            public boolean isDefault(String srcText, Integer value) {
                return value == null;
            }

            @Override
            public boolean isCorrectKey(SourceTextEntry entry, Integer value) {
                return IntContextMode.this.isCorrectKey(entry, value);
            }

            @Override
            public EntryKey findEntryKey(Integer value) throws Exception {
                return IntContextMode.this.findEntryKey(value);
            }

            @Override
            public void setStatementValue(PreparedStatement stmt, int pos, SourceTextEntry entry, boolean isDefault) throws SQLException {
                if (isDefault) {
                    stmt.setNull(pos, 4);
                } else {
                    super.setStatementValue(stmt, pos, entry, false);
                }
            }

            public String toString() {
                return "null or " + IntContextMode.this.toString();
            }
        };
    }

    public IntContextMode constWrapper(final int constVal) {
        return new IntContextMode(){

            @Override
            public Integer defaultValueForSource(String sourceText) {
                return constVal;
            }

            @Override
            public Integer nonDefaultValueForEntry(SourceTextEntry entry) {
                return (Integer)IntContextMode.this.nonDefaultValueForEntry(entry);
            }

            @Override
            public boolean isDefault(String srcText, Integer value) {
                return value == null || value.equals(constVal);
            }

            @Override
            public boolean isCorrectKey(SourceTextEntry entry, Integer value) {
                return IntContextMode.this.isCorrectKey(entry, value);
            }

            @Override
            public EntryKey findEntryKey(Integer value) throws Exception {
                return IntContextMode.this.findEntryKey(value);
            }

            @Override
            public void setStatementValue(PreparedStatement stmt, int pos, SourceTextEntry entry, boolean isDefault) throws SQLException {
                if (isDefault) {
                    stmt.setInt(pos, constVal);
                } else {
                    stmt.setInt(pos, this.nonDefaultValueForEntry(entry));
                }
            }

            public String toString() {
                return "default(" + constVal + ") or " + IntContextMode.this.toString();
            }
        };
    }

    public static IntContextMode forProperties(Properties propList) {
        block11: {
            IntContextMode mode = null;
            try {
                mode = ContextMode.forProperties(propList);
            }
            catch (Exception e1) {
                mode = DEFAULT;
            }
            try {
                IntContextMode iMode = mode;
                String contextDefault = propList.getProperty("context.default");
                if (contextDefault != null) {
                    if (contextDefault.equalsIgnoreCase("setNull")) {
                        return iMode.nullWrapper();
                    }
                    if (contextDefault.toLowerCase().startsWith("const")) {
                        try {
                            int val = Integer.parseInt(contextDefault.substring(6));
                            return iMode.constWrapper(val);
                        }
                        catch (Exception valEx) {
                            return iMode.constWrapper(0);
                        }
                    }
                    break block11;
                }
                return iMode;
            }
            catch (Exception iNo) {
                try {
                    final StringContextMode sMode = (StringContextMode)((Object)mode);
                    return new IntContextMode(){
                        private EntryCache<Integer> cache = new EntryCache<Integer>(this);

                        @Override
                        public Integer defaultValueForSource(String sourceText) {
                            return ((String)sMode.defaultValueForSource(sourceText)).hashCode();
                        }

                        @Override
                        public Integer nonDefaultValueForEntry(SourceTextEntry key) {
                            return ((String)sMode.nonDefaultValueForEntry(key)).hashCode();
                        }

                        @Override
                        public boolean isDefault(String srcText, Integer value) {
                            try {
                                return ((String)sMode.defaultValueForSource(srcText)).hashCode() == value.intValue();
                            }
                            catch (Exception e) {
                                return false;
                            }
                        }

                        @Override
                        public boolean isCorrectKey(SourceTextEntry key, Integer value) {
                            try {
                                return ((String)sMode.nonDefaultValueForEntry(key)).hashCode() == value.intValue();
                            }
                            catch (Exception e) {
                                return false;
                            }
                        }

                        public String toString() {
                            return "hashCode(" + sMode + ")";
                        }

                        @Override
                        public boolean isUnique() {
                            return sMode.isUnique();
                        }

                        @Override
                        public EntryKey findEntryKey(Integer value) throws Exception {
                            return this.cache.findEntryKey(value);
                        }
                    };
                }
                catch (Exception iModeEx) {
                    return DEFAULT;
                }
            }
        }
        return DEFAULT;
    }
}

