/*
 * Decompiled with CFR 0.152.
 */
package org.omegat;

import java.util.Arrays;
import java.util.Locale;
import org.omegat.util.OStrings;

public class CLIParameters {
    public static final String HELP_SHORT = "-h";
    public static final String HELP = "--help";
    public static final String MODE = "mode";
    public static final String CONFIG_FILE = "config-file";
    public static final String RESOURCE_BUNDLE = "resource-bundle";
    public static final String CONFIG_DIR = "config-dir";
    public static final String DISABLE_PROJECT_LOCKING = "disable-project-locking";
    public static final String DISABLE_LOCATION_SAVE = "disable-location-save";
    public static final String NO_TEAM = "no-team";
    public static final String TOKENIZER_SOURCE = "ITokenizer";
    public static final String TOKENIZER_TARGET = "ITokenizerTarget";
    public static final String TOKENIZER_BEHAVIOR_SOURCE = "ITokenizerBehavior";
    public static final String TOKENIZER_BEHAVIOR_TARGET = "ITokenizerTargetBehavior";
    public static final String ALTERNATE_FILENAME_FROM = "alternate-filename-from";
    public static final String ALTERNATE_FILENAME_TO = "alternate-filename-to";
    public static final String QUIET = "quiet";
    public static final String SCRIPT = "script";
    public static final String TAG_VALIDATION = "tag-validation";
    public static final String SOURCE_PATTERN = "source-pattern";
    public static final String PSEUDOTRANSLATETMX = "pseudotranslatetmx";
    public static final String PSEUDOTRANSLATETYPE = "pseudotranslatetype";
    public static final String ALIGNDIR = "alignDir";

    private static String normalize(String s) {
        return s.toUpperCase(Locale.ENGLISH).replace('-', '_');
    }

    public static String help(String type) {
        StringBuilder builder = new StringBuilder();
        builder.append(OStrings.getNameAndVersion()).append("\n\n");
        builder.append(OStrings.getString("COMMAND_LINE_HELP_SYNTAX")).append("\n\n");
        if (type == null) {
            builder.append(OStrings.getString("COMMAND_LINE_HELP_SUB_OPTIONS")).append("\n\n");
        } else if (type.toLowerCase().startsWith("options")) {
            builder.append(OStrings.getString("COMMAND_LINE_HELP_OPTIONS")).append("\n");
            builder.append("\t").append(OStrings.getString("COMMAND_LINE_HELP_PATH_ONLY")).append("\n");
            builder.append("\t").append(OStrings.getString("COMMAND_LINE_HELP_NO_OPTION")).append("\n");
            builder.append("\t-h, --help\n").append("\t\t").append(OStrings.getString("COMMAND_LINE_HELP_OPTION_HELP")).append("\n");
            builder.append("\t--mode=[").append(String.join((CharSequence)"|", Arrays.stream(RUN_MODE.values()).map(rm -> rm.toCommandLineString())::iterator)).append("]\n");
            builder.append("\t\t").append(OStrings.getString("COMMAND_LINE_HELP_OPTION_MODE")).append("\n");
            builder.append("\t\t").append(OStrings.getString("COMMAND_LINE_HELP_SUB_MODE")).append("\n");
            builder.append("\t--config-file=<").append(OStrings.getString("COMMAND_LINE_HELP_PARAM_PATH")).append(">\n\t\t").append(OStrings.getString("COMMAND_LINE_HELP_OPTION_CONFIG_FILE")).append("\n");
            builder.append("\t--resource-bundle=<").append(OStrings.getString("COMMAND_LINE_HELP_PARAM_PATH")).append(">\n\t\t").append(OStrings.getString("COMMAND_LINE_HELP_OPTION_RESOURCE_BUNDLE")).append("\n");
            builder.append("\t--config-dir=<").append(OStrings.getString("COMMAND_LINE_HELP_PARAM_PATH")).append(">\n\t\t").append(OStrings.getString("COMMAND_LINE_HELP_OPTION_CONFIG_DIR")).append("\n");
            builder.append("\t--disable-project-locking\n\t\t").append(OStrings.getString("COMMAND_LINE_HELP_OPTION_DISABLE_PROJECT_LOCKING")).append("\n");
            builder.append("\t--disable-location-save\n\t\t").append(OStrings.getString("COMMAND_LINE_HELP_OPTION_DISABLE_LOCATION_SAVE")).append("\n");
            builder.append("\t--no-team\n\t\t").append(OStrings.getString("COMMAND_LINE_HELP_OPTION_NO_TEAM")).append("\n");
            builder.append("\t--ITokenizer=<").append(OStrings.getString("COMMAND_LINE_HELP_PARAM_CLASSNAME")).append(">\n");
            builder.append("\t--ITokenizerTarget=<").append(OStrings.getString("COMMAND_LINE_HELP_PARAM_CLASSNAME")).append(">\n");
            builder.append("\t\t").append(OStrings.getString("COMMAND_LINE_HELP_OPTION_TOKENIZER")).append("\n");
            builder.append("\t\t").append(OStrings.getString("COMMAND_LINE_HELP_OPTION_TOKENIZER_LIST")).append("\n");
            builder.append("\t--ITokenizerBehavior=<").append(OStrings.getString("COMMAND_LINE_HELP_PARAM_VERSION")).append(">\n");
            builder.append("\t--ITokenizerTargetBehavior=<").append(OStrings.getString("COMMAND_LINE_HELP_PARAM_VERSION")).append(">\n");
            builder.append("\t\t").append(OStrings.getString("COMMAND_LINE_HELP_OPTION_TOKENIZER_BEHAVIOUR")).append("\n");
            builder.append("\t\t").append(OStrings.getString("COMMAND_LINE_HELP_OPTION_TOKENIZER_BEHAVIOUR_DOC")).append("\n");
            builder.append("\t\thttps://lucene.apache.org/core/3_6_0/api/core/org/apache/lucene/util/Version.html\n");
            builder.append("\n").append(OStrings.getString("COMMAND_LINE_HELP_OPTION_NON_GUI")).append("\n");
            builder.append("\t--quiet\n").append("\t\t").append(OStrings.getString("COMMAND_LINE_HELP_OPTION_QUIET")).append("\n");
            builder.append("\t--script=<").append(OStrings.getString("COMMAND_LINE_HELP_PARAM_PATH")).append(">\n\t\t").append(OStrings.getString("COMMAND_LINE_HELP_OPTION_SCRIPT")).append("\n");
            builder.append("\t--tag-validation=[abort|warn]\n");
            builder.append("\t\t").append(OStrings.getString("COMMAND_LINE_HELP_OPTION_TAG_VALIDATION")).append("\n");
            builder.append("\t\t").append(OStrings.getString("COMMAND_LINE_HELP_OPTION_TAG_VALIDATION_WARN")).append("\n");
        } else if (type.toLowerCase().startsWith("mode:console-translate")) {
            builder.append("\n").append(OStrings.getString("COMMAND_LINE_HELP_MODE_CONSOLE_TRANSLATE")).append("\n");
            builder.append("\t--source-pattern=<").append(OStrings.getString("COMMAND_LINE_HELP_PARAM_PATTERN")).append(">\n\t\t").append(OStrings.getString("COMMAND_LINE_HELP_OPTION_SOURCE_PATTERN")).append("\n");
        } else if (type.toLowerCase().startsWith("mode:console-createpseudotranslatetmx")) {
            builder.append("\n").append(OStrings.getString("COMMAND_LINE_HELP_MODE_PSEUDO_TRANSLATE")).append("\n");
            builder.append("\t--pseudotranslatetmx=<").append(OStrings.getString("COMMAND_LINE_HELP_PARAM_PATH")).append(">\n\t\t").append(OStrings.getString("COMMAND_LINE_HELP_OPTION_PSEUDO_TRANSLATE_TMX")).append("\n");
            builder.append("\t--pseudotranslatetype=<").append(OStrings.getString("COMMAND_LINE_HELP_PARAM_CLASSNAME")).append(">\n\t\t").append(OStrings.getString("COMMAND_LINE_HELP_OPTION_PSEUDO_TRANSLATE_TYPE")).append("\n");
        } else if (type.toLowerCase().startsWith("mode:console-align")) {
            builder.append("\n").append(OStrings.getString("COMMAND_LINE_HELP_MODE_CONSOLE_ALIGN")).append("\n");
            builder.append("\t--alignDir=<").append(OStrings.getString("COMMAND_LINE_HELP_PARAM_PATH")).append(">\n\t\t").append(OStrings.getString("COMMAND_LINE_HELP_OPTION_ALIGN_DIR")).append("\n");
        } else if (type.toLowerCase().startsWith("mode:console-index-memory")) {
            builder.append("\n").append(OStrings.getString("COMMAND_LINE_HELP_MODE_CONSOLE_INDEX_MEMORY")).append("\n");
            builder.append("\n").append(OStrings.getString("COMMAND_LINE_HELP_SYNTAX_CONSOLE_INDEX_MEMORY_PATHS")).append("\n");
            builder.append("\n").append(OStrings.getString("COMMAND_LINE_HELP_ROLE_CONSOLE_INDEX_MEMORY_PATHS")).append("\n");
            builder.append("\t--source=<").append(OStrings.getString("COMMAND_LINE_HELP_PARAM_PATH")).append(">\n\t\t").append(OStrings.getString("COMMAND_LINE_HELP_OPTION_INDEX_MEMORY_SOURCE_PATH")).append("\n");
            builder.append("\t--target=<").append(OStrings.getString("COMMAND_LINE_HELP_PARAM_PATH")).append(">\n\t\t").append(OStrings.getString("COMMAND_LINE_HELP_OPTION_INDEX_MEMORY_TARGET_PATH")).append("\n");
            builder.append("\t--source-lang=<").append(OStrings.getString("COMMAND_LINE_HELP_PARAM_LANG")).append(">\n\t\t").append(OStrings.getString("COMMAND_LINE_HELP_OPTION_INDEX_MEMORY_SOURCE_LANG")).append("\n");
            builder.append("\t--target-lang=<").append(OStrings.getString("COMMAND_LINE_HELP_PARAM_LANG")).append(">\n\t\t").append(OStrings.getString("COMMAND_LINE_HELP_OPTION_INDEX_MEMORY_TARGET_LANG")).append("\n");
            builder.append("\n").append(OStrings.getString("COMMAND_LINE_HELP_SYNTAX_CONSOLE_INDEX_MEMORY_PROJECT")).append("\n");
            builder.append("\n").append(OStrings.getString("COMMAND_LINE_HELP_ROLE_CONSOLE_INDEX_MEMORY_PROJECT")).append("\n");
            builder.append("\t--save-files").append(OStrings.getString("COMMAND_LINE_HELP_OPTION_INDEX_MEMORY_SAVE_FILES")).append("\n");
            builder.append("\t--save-to=<").append(OStrings.getString("COMMAND_LINE_HELP_PARAM_PATH")).append(">\n\t\t").append(OStrings.getString("COMMAND_LINE_HELP_OPTION_INDEX_MEMORY_SAVE_TO")).append("\n");
        } else if (type.toLowerCase().startsWith("mode:console-extract-xliff")) {
            builder.append("\n").append(OStrings.getString("COMMAND_LINE_HELP_MODE_CONSOLE_EXTRACT_XLIFF")).append("\n");
            builder.append("\n").append(OStrings.getString("COMMAND_LINE_HELP_ROLE_CONSOLE_EXTRACT_XLIFF")).append("\n\n");
            builder.append("\n").append(OStrings.getString("COMMAND_LINE_HELP_SYNTAX_CONSOLE_EXTRACT_XLIFF_PROJ")).append("\n");
            builder.append("\t").append(OStrings.getString("COMMAND_LINE_HELP_ACTION_CONSOLE_EXTRACT_XLIFF_PROJ")).append("\n");
            builder.append("\n").append(OStrings.getString("COMMAND_LINE_HELP_SYNTAX_CONSOLE_EXTRACT_XLIFF_FILE")).append("\n");
            builder.append("\t").append(OStrings.getString("COMMAND_LINE_HELP_ACTION_CONSOLE_EXTRACT_XLIFF_FILE")).append("\n");
            builder.append("\n").append(OStrings.getString("COMMAND_LINE_HELP_SYNTAX_CONSOLE_EXTRACT_XLIFF_DIR")).append("\n");
            builder.append("\t").append(OStrings.getString("COMMAND_LINE_HELP_ACTION_CONSOLE_EXTRACT_XLIFF_DIR")).append("\n");
        } else if (type.toLowerCase().startsWith("mode:console-calc-stats")) {
            builder.append("\n").append(OStrings.getString("COMMAND_LINE_HELP_MODE_CONSOLE_EXTRACT_XLIFF")).append("\n");
            builder.append("\n").append(OStrings.getString("COMMAND_LINE_HELP_ROLE_CONSOLE_EXTRACT_XLIFF")).append("\n\n");
            builder.append("\n").append(OStrings.getString("COMMAND_LINE_HELP_SYNTAX_CONSOLE_CALC_STATS")).append("\n");
            builder.append("\t--stats-mode=(STANDARD|MATCHES|MATCHES_PER_FILE)\n").append("\t\t").append(OStrings.getString("COMMAND_LINE_HELP_OPTION_STATS_MODE")).append("\n");
        } else {
            builder.append(OStrings.getString("COMMAND_LINE_HELP_SUB_UNKNOWN")).append(type).append("\n\n");
        }
        builder.append("\n").append(OStrings.getString("COMMAND_LINE_HELP_MANUAL")).append("\n");
        return builder.toString();
    }

    static enum RUN_MODE {
        GUI,
        CONSOLE_TRANSLATE,
        CONSOLE_CREATEPSEUDOTRANSLATETMX,
        CONSOLE_ALIGN,
        CONSOLE_INDEX_MEMORY,
        CONSOLE_INDEX_GLOSSARY,
        CONSOLE_EXTRACT_XLIFF,
        CONSOLE_CALC_STATS;


        public static RUN_MODE parse(String s) {
            try {
                return RUN_MODE.valueOf(CLIParameters.normalize(s));
            }
            catch (Exception ex) {
                return GUI;
            }
        }

        public CharSequence toCommandLineString() {
            return this.toString().replace('_', '-').toLowerCase();
        }
    }

    public static enum TAG_VALIDATION_MODE {
        IGNORE,
        WARN,
        ABORT;


        public static TAG_VALIDATION_MODE parse(String s) {
            try {
                return TAG_VALIDATION_MODE.valueOf(CLIParameters.normalize(s));
            }
            catch (Exception ex) {
                return IGNORE;
            }
        }
    }
}

