/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.data;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.omegat.core.Core;
import org.omegat.core.data.PrepareTMXEntry;
import org.omegat.core.data.ProjectProperties;
import org.omegat.core.matching.external.IBrowsableMemory;
import org.omegat.core.matching.external.IEntryCursor;
import org.omegat.core.search.TextExpression;
import org.omegat.util.FileUtil;
import org.omegat.util.Language;
import org.omegat.util.Preferences;
import org.omegat.util.StringUtil;
import org.omegat.util.TMXProp;
import org.omegat.util.TMXReader2;

public class ExternalTMX
implements IBrowsableMemory {
    private final String name;
    private final List<PrepareTMXEntry> entries;

    public ExternalTMX(ProjectProperties props, File file, boolean extTmxLevel2, boolean useSlash) throws Exception {
        this(props.isSentenceSegmentingEnabled(), props.getSourceLanguage(), props.getTargetLanguage(), file, extTmxLevel2, useSlash);
    }

    public ExternalTMX(final boolean isSentenceSegmentingEnabled, final Language srcLang, final Language traLang, File file, boolean extTmxLevel2, boolean useSlash) throws Exception {
        String base;
        String path = file.getPath();
        if ((path.charAt(0) == '/' || path.charAt(1) == ':') && path.startsWith(base = Core.getProject().getProjectProperties().getTMRoot())) {
            path = path.substring(base.length());
        }
        this.name = path;
        this.entries = new ArrayList<PrepareTMXEntry>();
        TMXReader2.LoadCallback loader = new TMXReader2.LoadCallback(){
            final String prefForeign = Preferences.getPreferenceDefault("keep_foreign_matches", "30 false");

            @Override
            public boolean onEntry(TMXReader2.ParsedTu tu, TMXReader2.ParsedTuv tuvSource, TMXReader2.ParsedTuv tuvTarget, boolean isParagraphSegtype) {
                if (tuvSource == null) {
                    return false;
                }
                if (tuvTarget != null) {
                    this.addTuv(tu, tuvSource, tuvTarget, false, isParagraphSegtype);
                } else if (!this.prefForeign.endsWith("false")) {
                    if (this.prefForeign.contains(";")) {
                        String[] langs = this.prefForeign.split(";");
                        for (int i = 0; i < langs.length - 1; ++i) {
                            String[] parts = langs[i].split(" ");
                            TMXReader2.ParsedTuv tuv1 = tu.getTuvByLang(parts[0]);
                            if (tuv1 == null) continue;
                            this.addTuv(tu, tuvSource, tuv1, true, isParagraphSegtype);
                            if (langs[i].contains("with-cascade")) continue;
                            return true;
                        }
                    }
                    for (int i = 0; i < tu.tuvs.size(); ++i) {
                        if (tu.tuvs.get(i) == tuvSource) continue;
                        this.addTuv(tu, tuvSource, tu.tuvs.get(i), true, isParagraphSegtype);
                    }
                }
                return true;
            }

            private void addTuv(TMXReader2.ParsedTu tu, TMXReader2.ParsedTuv tuvSource, TMXReader2.ParsedTuv tuvTarget, boolean isForeign, boolean isParagraphSegtype) {
                String changer = StringUtil.nvl(tuvTarget.changeid, tuvTarget.creationid, tu.changeid, tu.creationid);
                String creator = StringUtil.nvl(tuvTarget.creationid, tu.creationid);
                long changed = StringUtil.nvlLong(tuvTarget.changedate, tuvTarget.creationdate, tu.changedate, tu.creationdate);
                long created = StringUtil.nvlLong(tuvTarget.creationdate, tu.creationdate);
                ArrayList<String> sources = new ArrayList<String>();
                ArrayList<String> targets = new ArrayList<String>();
                Core.getSegmenter().segmentEntries(isSentenceSegmentingEnabled && isParagraphSegtype, srcLang, tuvSource.text, traLang, tuvTarget.text, sources, targets);
                for (int i = 0; i < sources.size(); ++i) {
                    PrepareTMXEntry te = new PrepareTMXEntry();
                    te.source = (String)sources.get(i);
                    te.translation = (String)targets.get(i);
                    te.changer = changer;
                    te.changeDate = changed;
                    te.creator = creator;
                    te.creationDate = created;
                    te.note = tu.note;
                    if (isForeign) {
                        te.otherProperties = tu.props;
                        if (te.otherProperties == null) {
                            te.otherProperties = new ArrayList<TMXProp>();
                        }
                        te.otherProperties.add(new TMXProp("x-target-lang", tuvTarget.lang));
                    } else {
                        te.otherProperties = tu.props;
                    }
                    ExternalTMX.this.entries.add(te);
                }
            }
        };
        TMXReader2 reader = new TMXReader2();
        reader.readTMX(file, srcLang, traLang, isSentenceSegmentingEnabled, false, extTmxLevel2, useSlash, loader);
    }

    @Override
    public String getMemoryName() {
        return this.name;
    }

    @Override
    public String getProviderName() {
        return "tmx file";
    }

    public List<PrepareTMXEntry> findMatchingTranslations(Language sLang, Language tLang, String text, int minScore, int maxCount) {
        return this.entries;
    }

    @Override
    public IEntryCursor.TMXEntriesCursor browseAllEntries() {
        return new IEntryCursor.TMXEntriesCursor(this.entries);
    }

    public Iterable<PrepareTMXEntry> search(int numberOfResults, TextExpression searchSource, TextExpression searchTarget, TextExpression searchNotes, boolean andSearch, TextExpression author, long dateAfter, long dateBefore) {
        return this.entries;
    }

    public static boolean isInPath(File path, File tmxFile) {
        try {
            FileUtil.computeRelativePath(path, tmxFile);
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }
}

