/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.data;

import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import org.omegat.core.Core;
import org.omegat.util.DirectoryMonitor;
import org.omegat.util.Log;

abstract class MonitoredDirectoryMap<K, V> {
    private Map<K, V> theMap = new ConcurrentSkipListMap();
    private DirectoryMonitor monitor;

    public MonitoredDirectoryMap(String root) {
        File fRoot = new File(root);
        if (fRoot.exists()) {
            this.monitor = new DirectoryMonitor(fRoot, file -> {
                K key = this.accept(file);
                if (key == null) {
                    return;
                }
                if (file.exists()) {
                    try {
                        this.theMap.put(key, this.load(file));
                    }
                    catch (Exception e) {
                        String filename = file.getPath();
                        Log.logErrorRB(e, "TF_TM_LOAD_ERROR", filename);
                        Core.getMainWindow().displayErrorRB(e, "TF_TM_LOAD_ERROR", filename);
                    }
                } else {
                    this.theMap.remove(key);
                    this.onDelete(file);
                }
            });
            this.monitor.checkChanges();
            this.monitor.start();
        }
    }

    public Map<K, V> getMap() {
        return this.theMap;
    }

    public void clear() {
        this.theMap.clear();
    }

    public void end() {
        if (this.monitor != null) {
            this.monitor.fin();
        }
    }

    public abstract K accept(File var1);

    public abstract V load(File var1) throws Exception;

    public void onDelete(File f) {
    }
}

