/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.data;

import org.omegat.filters2.master.PluginUtils;
import org.omegat.util.Language;
import org.omegat.util.Preferences;
import org.omegat.util.StringUtil;

public class ProjectOptions {
    private Language sourceLanguage;
    private Language targetLanguage;
    private Class<?> sourceTokenizer;
    private Class<?> targetTokenizer;
    private boolean sentenceSegmentingOn;
    private boolean supportDefaultTranslations;
    private boolean removeTags;
    private Boolean tagsAsFormathandles;
    private Boolean segNbsp;

    public ProjectOptions() {
        this.setSentenceSegmentingEnabled(true);
        this.setSupportDefaultTranslations(true);
        this.setRemoveTags(false);
        this.setTagsFormatHandles(false);
        this.setSegmentNbsp(false);
        String sourceLocale = Preferences.getPreference("source_lang");
        if (!StringUtil.isEmpty(sourceLocale)) {
            this.setSourceLanguage(sourceLocale);
        } else {
            this.setSourceLanguage("EN-US");
        }
        String targetLocale = Preferences.getPreference("target_lang");
        if (!StringUtil.isEmpty(targetLocale)) {
            this.setTargetLanguage(targetLocale);
        } else {
            this.setTargetLanguage("EN-GB");
        }
        this.setSourceTokenizer(PluginUtils.getTokenizerClassForLanguage(this.getSourceLanguage()));
        this.setTargetTokenizer(PluginUtils.getTokenizerClassForLanguage(this.getTargetLanguage()));
    }

    public Language getSourceLanguage() {
        return this.sourceLanguage;
    }

    public void setSourceLanguage(Language sourceLanguage) {
        this.sourceLanguage = sourceLanguage;
    }

    public void setSourceLanguage(String sourceLanguage) {
        this.sourceLanguage = new Language(sourceLanguage);
    }

    public Language getTargetLanguage() {
        return this.targetLanguage;
    }

    public void setTargetLanguage(Language targetLanguage) {
        this.targetLanguage = targetLanguage;
    }

    public void setTargetLanguage(String targetLanguage) {
        this.targetLanguage = new Language(targetLanguage);
    }

    public Class<?> getSourceTokenizer() {
        if (this.sourceTokenizer == null) {
            Class<?> cls = PluginUtils.getTokenizerClassForLanguage(this.getSourceLanguage());
            this.setSourceTokenizer(cls);
        }
        return this.sourceTokenizer;
    }

    public void setSourceTokenizer(Class<?> sourceTokenizer) {
        this.sourceTokenizer = sourceTokenizer;
    }

    public Class<?> getTargetTokenizer() {
        return this.targetTokenizer;
    }

    public void setTargetTokenizer(Class<?> targetTokenizer) {
        this.targetTokenizer = targetTokenizer;
    }

    public boolean isSentenceSegmentingEnabled() {
        return this.sentenceSegmentingOn;
    }

    public void setSentenceSegmentingEnabled(boolean sentenceSegmentingOn) {
        this.sentenceSegmentingOn = sentenceSegmentingOn;
    }

    public boolean isSupportDefaultTranslations() {
        return this.supportDefaultTranslations;
    }

    public void setSupportDefaultTranslations(boolean supportDefaultTranslations) {
        this.supportDefaultTranslations = supportDefaultTranslations;
    }

    public boolean isRemoveTags() {
        return this.removeTags;
    }

    public void setRemoveTags(boolean removeTags) {
        this.removeTags = removeTags;
    }

    public Boolean isTagsFormatHandles() {
        return this.tagsAsFormathandles;
    }

    public void setTagsFormatHandles(Boolean useTags) {
        this.tagsAsFormathandles = useTags;
    }

    public Boolean isSegmentNbsp() {
        return this.segNbsp;
    }

    public void setSegmentNbsp(Boolean segNbsp) {
        this.segNbsp = segNbsp;
    }
}

