/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.data;

import java.util.List;
import org.omegat.core.data.ITMXEntry;
import org.omegat.core.data.PrepareTMXEntry;
import org.omegat.core.matching.external.IEntryCursor;
import org.omegat.util.StringUtil;
import org.omegat.util.TMXProp;

public class TMXEntry
implements ITMXEntry {
    public final String source;
    public final String translation;
    public final String changer;
    public final long changeDate;
    public final String creator;
    public final long creationDate;
    public final String note;
    public final boolean defaultTranslation;
    public final ExternalLinked linked;
    public String revisor = null;

    TMXEntry(PrepareTMXEntry from, boolean defaultTranslation, ExternalLinked linked) {
        this.source = from.source;
        this.translation = from.translation;
        this.changer = from.changer;
        this.changeDate = from.changeDate;
        this.creator = from.creator;
        this.creationDate = from.creationDate;
        this.note = from.note;
        this.defaultTranslation = defaultTranslation;
        this.linked = linked;
    }

    public TMXEntry(IEntryCursor from, boolean defaultTranslation) throws Exception {
        this.source = from.getEntrySource();
        this.translation = from.getEntryTranslation();
        this.creator = from.getEntryAuthor();
        this.creationDate = from.getEntryCreationDate();
        this.changer = from.getEntryLastModifier();
        this.changeDate = from.getEntryLastModificationDate();
        this.note = from.getEntryNote();
        this.defaultTranslation = defaultTranslation;
        this.linked = null;
    }

    @Override
    public boolean isTranslated() {
        return this.translation != null;
    }

    @Override
    public String getSourceText() {
        return this.source;
    }

    @Override
    public String getTranslationText() {
        return this.translation;
    }

    @Override
    public String getCreator() {
        return this.creator;
    }

    @Override
    public long getCreationDate() {
        return this.creationDate;
    }

    @Override
    public String getChanger() {
        return this.changer;
    }

    @Override
    public long getChangeDate() {
        return this.changeDate;
    }

    @Override
    public String getNote() {
        return this.note;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        return this.note.trim().length() > 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TMXEntry other = (TMXEntry)obj;
        if (this.changeDate / 1000L != other.changeDate / 1000L) {
            return false;
        }
        if (this.creationDate / 1000L != other.creationDate / 1000L) {
            return false;
        }
        if (!this.equalsTranslation(other)) {
            return false;
        }
        if (!StringUtil.equalsWithNulls(this.changer, other.changer)) {
            return false;
        }
        if (!StringUtil.equalsWithNulls(this.creator, other.creator)) {
            return false;
        }
        if (this.defaultTranslation != other.defaultTranslation) {
            return false;
        }
        return StringUtil.equalsWithNulls(this.source, other.source);
    }

    public boolean equalsTranslation(TMXEntry other) {
        if (other == null) {
            return false;
        }
        if (!StringUtil.equalsWithNulls(this.translation, other.translation)) {
            return false;
        }
        if (!StringUtil.equalsWithNulls(this.note, other.note)) {
            return false;
        }
        return StringUtil.equalsWithNulls(this.linked, other.linked);
    }

    @Override
    public boolean hasProperties() {
        return false;
    }

    @Override
    public String getPropValue(String propType) {
        return null;
    }

    @Override
    public boolean hasPropValue(String propType, String propValue) {
        return false;
    }

    @Override
    public List<TMXProp> getProperties() {
        return null;
    }

    public static enum ExternalLinked {
        xICE,
        x100PC,
        xAUTO,
        xSRC;

    }
}

