/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.glossaries;

import java.util.List;
import java.util.stream.Stream;
import org.omegat.core.glossaries.GlossaryEntryStore;
import org.omegat.core.glossaries.IGlossary;
import org.omegat.util.TMXProp;

public class GlossaryEntryWithProperties
extends GlossaryEntryStore {
    private final List<TMXProp> entryProp;
    private final List<TMXProp> srcProp;
    private final List<TMXProp> traProp;

    public GlossaryEntryWithProperties(String src, String loc, String note, List<TMXProp> entryProp, List<TMXProp> srcProp, List<TMXProp> traProp, IGlossary origin) {
        super(src, loc, note, origin);
        this.srcProp = srcProp;
        this.traProp = traProp;
        this.entryProp = entryProp;
    }

    @Override
    public String getCommentText() {
        StringBuffer buf = new StringBuffer();
        for (TMXProp pe : this.entryProp) {
            buf.append(pe.getType()).append(": ").append(pe.getValue()).append("\n");
        }
        for (TMXProp pe : this.srcProp) {
            buf.append(pe.getType()).append(": ").append(pe.getValue()).append("\n");
        }
        for (TMXProp pe : this.traProp) {
            buf.append(pe.getType()).append(": ").append(pe.getValue()).append("\n");
        }
        return buf.toString();
    }

    public String findProperty(String key) {
        String val;
        if (!((String)key).contains(":")) {
            key = "*:" + (String)key;
        }
        String prefix = ((String)key).substring(0, ((String)key).indexOf(58)).toLowerCase();
        String suffix = ((String)key).substring(((String)key).indexOf(58) + 1);
        if ((((String)key).startsWith("e") || ((String)key).startsWith("*")) && (val = GlossaryEntryWithProperties.findProperty(this.entryProp, suffix)) != null) {
            return val;
        }
        if ((((String)key).startsWith("t") || ((String)key).startsWith("*")) && (val = GlossaryEntryWithProperties.findProperty(this.traProp, suffix)) != null) {
            return val;
        }
        if ((((String)key).startsWith("s") || ((String)key).startsWith("*")) && (val = GlossaryEntryWithProperties.findProperty(this.srcProp, suffix)) != null) {
            return val;
        }
        return null;
    }

    private static String findProperty(List<TMXProp> theList, String key) {
        for (TMXProp pe : theList) {
            if (!pe.getType().equals(key)) continue;
            return pe.getValue();
        }
        return null;
    }

    public Iterable<TMXProp> getAllProperties() {
        return () -> Stream.concat(this.entryProp.stream(), Stream.concat(this.srcProp.stream(), this.traProp.stream())).iterator();
    }
}

