/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.matching;

import org.omegat.core.data.IProject;
import org.omegat.core.events.IStopped;
import org.omegat.core.matching.FindMatches;
import org.omegat.core.matching.FindMatchesKeep;
import org.omegat.core.matching.NearString;
import org.omegat.core.matching.external.IExternalMemory;
import org.omegat.tokenizer.ITokenizer;
import org.omegat.util.Preferences;

public class FindMatchesSingleton
extends FindMatchesKeep {
    private NearString result = null;

    public FindMatchesSingleton(ITokenizer sourceTokenizer, IExternalMemory[] externalMemories, String memoryPath, boolean allowSeparateSegmentMatch, boolean searchExactlyTheSame) {
        super(sourceTokenizer, externalMemories, memoryPath, allowSeparateSegmentMatch, searchExactlyTheSame);
    }

    public FindMatchesSingleton(ITokenizer sourceTokenizer, IExternalMemory[] externalMemories, boolean allowSeparateSegmentMatch, boolean searchExactlyTheSame) {
        super(sourceTokenizer, externalMemories, allowSeparateSegmentMatch, searchExactlyTheSame);
    }

    @Override
    public final int maxCount() {
        return 1;
    }

    @Override
    protected NearString lastKeptResult() {
        return this.result;
    }

    public NearString search(IProject project, String searchText, boolean requiresTranslation, boolean fillSimilarityData, IStopped stop) throws FindMatches.StoppedException {
        this.result = null;
        this.doSearch(project, searchText, requiresTranslation, fillSimilarityData, stop);
        if (fillSimilarityData) {
            this.buildSimilarityData(this.result);
        }
        return this.result;
    }

    @Override
    protected void doInsertion(NearString added) {
        if (this.result == null) {
            this.result = added;
            return;
        }
        if (this.result != null && Preferences.isPreferenceDefault("ext_tmx_do_merge", true) && added.source.equals(this.result.source) && (added.translation == null && this.result.translation == null || added.translation != null && added.translation.equals(this.result.translation))) {
            this.result = NearString.merge(this.result, added);
            return;
        }
        if (this.result.composedScoreForSorting(this.sortKey) < added.composedScoreForSorting(this.sortKey)) {
            this.result = added;
        }
    }
}

