/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.matching.external;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.omegat.core.Core;
import org.omegat.core.data.PrepareTMXEntry;
import org.omegat.core.data.ProtectedPart;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.matching.external.IBrowsableMemory;
import org.omegat.core.matching.external.IEntryCursor;
import org.omegat.core.search.TextExpression;
import org.omegat.filters2.FilterContext;
import org.omegat.filters2.IFilter;
import org.omegat.filters2.IParseCallback;
import org.omegat.filters2.master.FilterMaster;
import org.omegat.util.Language;

public class AlignFilesMemory
implements IBrowsableMemory {
    private String name;
    private Map<String, PrepareTMXEntry> entries = new HashMap<String, PrepareTMXEntry>();

    public AlignFilesMemory(Properties config) {
        this.name = config.getProperty("name");
        if (this.name == null) {
            this.name = config.getProperty("source");
        }
        FilterMaster master = Core.getFilterMaster();
        IParseCallback parseCallback1 = new IParseCallback(){

            @Override
            public void linkPrevNextSegments() {
            }

            @Override
            public void addEntry(String id, String path, String source, SourceTextEntry.SourceTranslationInfo traInfo, IFilter filter, List<ProtectedPart> protectedParts) {
                PrepareTMXEntry entry = traInfo.asPrepareEntry(source);
                if (id == null) {
                    id = path;
                } else if (path != null) {
                    id = (String)id + "/" + path;
                }
                AlignFilesMemory.this.entries.put(id, entry);
            }
        };
        try {
            master.loadFile(config.getProperty("source"), new FilterContext(Core.getProject().getProjectProperties()), parseCallback1);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        IParseCallback parseCallback2 = new IParseCallback(){

            @Override
            public void linkPrevNextSegments() {
            }

            @Override
            public void addEntry(String id, String path, String source, SourceTextEntry.SourceTranslationInfo traInfo, IFilter filter, List<ProtectedPart> protectedParts) {
                if (id == null) {
                    id = path;
                } else if (path != null) {
                    id = (String)id + "/" + path;
                }
                PrepareTMXEntry entry = (PrepareTMXEntry)AlignFilesMemory.this.entries.get(id);
                if (entry != null) {
                    entry.translation = source;
                }
            }
        };
        try {
            master.loadFile(config.getProperty("target"), new FilterContext(Core.getProject().getProjectProperties()), parseCallback2);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public String getProviderName() {
        return "Aligned files";
    }

    @Override
    public String getMemoryName() {
        return this.name;
    }

    public Iterable<PrepareTMXEntry> search(int numberOfResults, TextExpression searchSource, TextExpression searchTarget, TextExpression searchNotes, boolean andSearch, TextExpression author, long dateAfter, long dateBefore) {
        return this.entries.values();
    }

    @Override
    public IEntryCursor.TMXEntriesCursor browseAllEntries() {
        return new IEntryCursor.TMXEntriesCursor(this.entries.values());
    }

    public Iterable<PrepareTMXEntry> findMatchingTranslations(Language sLang, Language tLang, String text, int minScore, int maxCount) {
        return this.entries.values();
    }

    public List<PrepareTMXEntry> getEntries() {
        return new ArrayList<PrepareTMXEntry>(this.entries.values());
    }
}

