/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.matching.external;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.data.PrepareTMXEntry;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.core.events.IProjectEventListener;
import org.omegat.core.matching.external.IEntryCursor;
import org.omegat.core.matching.external.ProjectMemory;
import org.omegat.util.TMXProp;

public class NoDelaySaver
implements ProjectMemory.IExternalProjectMemory {
    private PrintStream out;
    public static final int COL_TYPE = 0;
    public static final int COL_SRC = 1;
    public static final int COL_KEY = 2;
    public static final int COL_TRA = 3;
    public static final int COL_AUTHOR = 4;
    public static final int COL_CREATION_DATE = 5;
    public static final int COL_CHANGER = 6;
    public static final int COL_CHANGE_DATE = 7;
    public static final int COL_NOTE = 8;

    public NoDelaySaver(Properties propList) {
        CoreEvents.registerProjectChangeListener(eventType -> {
            if (eventType == IProjectEventListener.PROJECT_CHANGE_TYPE.SAVE && this.out != null) {
                this.out.close();
                File outFile = new File(Core.getProject().getProjectProperties().getProjectInternal() + "project_save.tmp");
                outFile.delete();
                this.out = null;
                try {
                    this.out = new PrintStream(outFile, "UTF-8");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    @Override
    public IEntryCursor findChanges(long timeStamp) throws Exception {
        if (this.out != null) {
            return new IEntryCursor.TMXEntriesCursor(Collections.emptyList());
        }
        File outFile = new File(Core.getProject().getProjectProperties().getProjectInternal() + "project_save.tmp");
        System.err.println("Using " + outFile + " for immediate save");
        ArrayList<PrepareTMXEntry> res = new ArrayList<PrepareTMXEntry>();
        if (outFile.exists()) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(outFile), "UTF-8"));){
                String line;
                while ((line = reader.readLine()) != null) {
                    PrepareTMXEntry nEntry = new PrepareTMXEntry();
                    res.add(nEntry);
                    String[] fields = line.split("\t");
                    nEntry.source = fields[1] = fields[1].replaceAll("\\t", "\t");
                    if (!"default".equals(fields[2])) {
                        String[] key = fields[2].replaceAll("\\t", "\t").split("#");
                        nEntry.otherProperties = new ArrayList<TMXProp>(5);
                        nEntry.otherProperties.add(new TMXProp("file", key[0].replaceAll("\\t", "\t").replaceAll("\\SHARP", "#")));
                        if (key[1].length() > 0) {
                            nEntry.otherProperties.add(new TMXProp("id", key[1].replaceAll("\\t", "\t").replaceAll("\\SHARP", "#")));
                        }
                        if (key[2].length() > 0) {
                            nEntry.otherProperties.add(new TMXProp("path", key[2].replaceAll("\\t", "\t").replaceAll("\\SHARP", "#")));
                        }
                        if (key[3].length() > 0) {
                            nEntry.otherProperties.add(new TMXProp("prev", key[3].replaceAll("\\t", "\t").replaceAll("\\SHARP", "#")));
                        }
                        if (key[4].length() > 0) {
                            nEntry.otherProperties.add(new TMXProp("next", key[4].replaceAll("\\t", "\t").replaceAll("\\SHARP", "#")));
                        }
                    }
                    if ("-".equals(fields[0])) {
                        nEntry.translation = null;
                        continue;
                    }
                    nEntry.translation = fields[3] = fields[3].replaceAll("\\t", "\t");
                    nEntry.changer = fields[6];
                    nEntry.changeDate = Long.parseLong(fields[7]);
                    nEntry.creator = fields[4];
                    nEntry.creationDate = Long.parseLong(fields[5]);
                    if (fields.length < 9) continue;
                    nEntry.note = fields[8].replaceAll("\\t", "\t");
                }
            }
            outFile.delete();
        }
        this.out = new PrintStream(outFile, "UTF-8");
        return new IEntryCursor.TMXEntriesCursor(res);
    }

    @Override
    public void registerTranslation(SourceTextEntry ste, TMXEntry te, boolean isDefault) throws IOException {
        if (this.out == null) {
            return;
        }
        StringBuffer buf = te == null ? new StringBuffer("-\t") : new StringBuffer("+\t");
        buf.append(te.source.replaceAll("\t", "\\t")).append("\t");
        if (isDefault) {
            buf.append("default").append("\t");
        } else {
            buf.append(ste.getKey().file == null ? "" : ste.getKey().file.replaceAll("\t", "\\t").replaceAll("#", "\\SHARP")).append("#");
            buf.append(ste.getKey().id == null ? "" : ste.getKey().id.replaceAll("\t", "\\t").replaceAll("#", "\\SHARP")).append("#");
            buf.append(ste.getKey().path == null ? "" : ste.getKey().path.replaceAll("\t", "\\t").replaceAll("#", "\\SHARP")).append("#");
            buf.append(ste.getKey().prev == null ? "" : ste.getKey().prev.replaceAll("\t", "\\t").replaceAll("#", "\\SHARP")).append("#");
            buf.append(ste.getKey().next == null ? "" : ste.getKey().next.replaceAll("\t", "\\t").replaceAll("#", "\\SHARP")).append("#");
            buf.append("\t");
        }
        if (te != null) {
            buf.append(te.translation.replaceAll("\t", "\\t")).append("\t");
            buf.append(te.creator).append("\t");
            buf.append(te.creationDate).append("\t");
            buf.append(te.changer).append("\t");
            buf.append(te.changeDate).append("\t");
            if (te.note != null) {
                buf.append(te.note.replaceAll("\t", "\\t")).append("\t");
            }
        }
        this.out.println(buf);
        this.out.flush();
    }
}

