/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.matching.external.rmi;

import java.rmi.Naming;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.util.HashSet;
import java.util.Set;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.data.EntryKey;
import org.omegat.core.data.PrepareTMXEntry;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.events.IEntryEventListener;
import org.omegat.core.events.IProjectEventListener;
import org.omegat.core.matching.external.rmi.ProjectServer;

public class GUIServer
extends ProjectServer
implements IEntryEventListener {
    private Set<Integer> changesFromClients = new HashSet<Integer>();
    private boolean isUpdating = false;

    private GUIServer() throws RemoteException {
        CoreEvents.registerEntryEventListener(this);
    }

    public static GUIServer open(String portStr, String object) throws Exception {
        int port = 1099;
        if (portStr != null) {
            port = Integer.parseInt(portStr);
        }
        LocateRegistry.createRegistry(port);
        System.err.println("Listening server " + port);
        if (!((String)object).startsWith("//") && port != 1099) {
            object = "//localhost:" + port + "/" + (String)object;
        }
        GUIServer res = new GUIServer();
        Naming.bind((String)object, res);
        System.err.println("Listening server object " + (String)object);
        return res;
    }

    @Override
    public void onProjectChanged(IProjectEventListener.PROJECT_CHANGE_TYPE eventType) {
        switch (eventType) {
            case CLOSE: 
            case CREATE: 
            case LOAD: {
                this.changesFromClients.clear();
            }
        }
        super.onProjectChanged(eventType);
    }

    @Override
    public void onNewFile(String activeFileName) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onEntryActivated(SourceTextEntry newEntry) {
        if (this.isUpdating) {
            return;
        }
        Set<Integer> set = this.changesFromClients;
        synchronized (set) {
            try {
                if (this.changesFromClients.size() > 0) {
                    Core.getEditor().commitAndDeactivate();
                    Core.getEditor().refreshEntries(this.changesFromClients);
                    Core.getEditor().activateEntry();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.changesFromClients.clear();
            }
        }
        this.changesByDate.addLast(newEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerDefaultTranslation(String src, String tra) {
        SourceTextEntry ste = this.entries.existSource.get(src);
        if (ste == null) {
            return;
        }
        PrepareTMXEntry pe = new PrepareTMXEntry();
        pe.source = src;
        pe.translation = tra;
        Core.getProject().setTranslation(ste, pe, true, null);
        Set<Integer> set = this.changesFromClients;
        synchronized (set) {
            this.isUpdating = true;
            this.changesFromClients.add(ste.entryNum());
            this.isUpdating = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerAltTranslation(String src, String tra, String file, String id, String path, String prev, String next) {
        SourceTextEntry ste = this.entries.existKeys.get(new EntryKey(file, src, id, prev, next, path));
        if (ste == null) {
            return;
        }
        PrepareTMXEntry pe = new PrepareTMXEntry();
        pe.source = src;
        pe.translation = tra;
        Core.getProject().setTranslation(ste, pe, false, null);
        Set<Integer> set = this.changesFromClients;
        synchronized (set) {
            this.isUpdating = true;
            this.changesFromClients.add(ste.entryNum());
            this.isUpdating = false;
        }
    }
}

