/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.matching.external.rmi;

import java.rmi.Naming;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.omegat.core.data.PrepareTMXEntry;
import org.omegat.core.matching.external.rmi.IDistantExternalMemory;
import org.omegat.util.Log;
import org.omegat.util.TMXProp;

public class RAMServer
extends UnicastRemoteObject
implements IDistantExternalMemory {
    public static final long serialVersionUID = 1L;
    protected Deque<PrepareTMXEntry> changesByDate = new ConcurrentLinkedDeque<PrepareTMXEntry>();
    private Map<String, Iterator<PrepareTMXEntry>> openedCursors = new HashMap<String, Iterator<PrepareTMXEntry>>();
    private Map<String, PrepareTMXEntry> openedEntries = new HashMap<String, PrepareTMXEntry>();

    public static RAMServer open(String portStr, String object) throws Exception {
        int port = 1099;
        if (portStr != null) {
            port = Integer.parseInt(portStr);
        }
        LocateRegistry.createRegistry(port);
        System.err.println("Listening server " + port);
        if (!((String)object).startsWith("//") && port != 1099) {
            object = "//localhost:" + port + "/" + (String)object;
        }
        RAMServer res = new RAMServer();
        Naming.bind((String)object, res);
        System.err.println("Listening server object " + (String)object);
        return res;
    }

    @Override
    public String findChanges(long timeStamp) {
        Iterator<PrepareTMXEntry> iter = this.changesByDate.descendingIterator();
        this.openedCursors.put(iter.toString() + "#" + timeStamp, iter);
        return iter.toString() + "#" + timeStamp;
    }

    @Override
    public boolean next(String id) throws RemoteException {
        Iterator<PrepareTMXEntry> iter = this.openedCursors.get(id);
        if (iter == null) {
            throw new RemoteException("Cursor " + id + " does not exist");
        }
        if (iter.hasNext()) {
            try {
                PrepareTMXEntry te = iter.next();
                long timeStamp = Long.parseLong(id.substring(id.lastIndexOf(35) + 1));
                if (te.changeDate > timeStamp || te.creationDate > timeStamp) {
                    this.openedEntries.put(id, iter.next());
                    return true;
                }
            }
            catch (Exception e) {
                Log.log(e);
            }
        }
        this.openedEntries.remove(id);
        this.openedCursors.remove(id);
        return false;
    }

    @Override
    public String getEntrySource(String id) {
        return this.openedEntries.get((Object)id).source;
    }

    @Override
    public String getEntryTranslation(String id) {
        return this.openedEntries.get((Object)id).translation;
    }

    @Override
    public String getEntryAuthor(String id) {
        return this.openedEntries.get((Object)id).creator;
    }

    @Override
    public String getEntryLastModifier(String id) {
        return this.openedEntries.get((Object)id).changer;
    }

    @Override
    public long getEntryCreationDate(String id) {
        return this.openedEntries.get((Object)id).creationDate;
    }

    @Override
    public long getEntryLastModificationDate(String id) {
        return this.openedEntries.get((Object)id).changeDate;
    }

    @Override
    public String getEntryNote(String id) {
        return this.openedEntries.get((Object)id).note;
    }

    @Override
    public String[] getEntryKey(String id) {
        PrepareTMXEntry en = this.openedEntries.get(id);
        List<TMXProp> props = en.otherProperties;
        if (props == null) {
            return null;
        }
        if (props.size() == 0) {
            return null;
        }
        return new String[]{en.getPropValue("file"), this.getEntrySource(id), en.getPropValue("id"), en.getPropValue("prev"), en.getPropValue("next"), en.getPropValue("path")};
    }

    @Override
    public void registerDefaultTranslation(String src, String tra) {
        PrepareTMXEntry previous = null;
        Iterator<PrepareTMXEntry> iter = this.changesByDate.iterator();
        while (iter.hasNext()) {
            PrepareTMXEntry current = iter.next();
            if (!current.source.equals(src) || current.otherProperties != null) continue;
            iter.remove();
            if (previous != null) continue;
            previous = current;
        }
        if (previous != null) {
            previous.changeDate = System.currentTimeMillis();
            previous.translation = tra;
        } else {
            previous = new PrepareTMXEntry();
            previous.source = src;
            previous.translation = tra;
            previous.creationDate = System.currentTimeMillis();
        }
        this.changesByDate.addLast(previous);
    }

    @Override
    public void registerAltTranslation(String src, String tra, String file, String id, String path, String prev, String next) {
        PrepareTMXEntry previous = null;
        Iterator<PrepareTMXEntry> iter = this.changesByDate.iterator();
        while (iter.hasNext()) {
            PrepareTMXEntry current = iter.next();
            if (!current.source.equals(src) || current.otherProperties == null || !file.equals(current.getPropValue("file")) || !id.equals(current.getPropValue("id")) || !path.equals(current.getPropValue("path")) || !prev.equals(current.getPropValue("prev")) || !next.equals(current.getPropValue("next"))) continue;
            iter.remove();
            if (previous != null) continue;
            previous = current;
        }
        if (previous != null) {
            previous.changeDate = System.currentTimeMillis();
            previous.translation = tra;
        } else {
            previous = new PrepareTMXEntry();
            previous.source = src;
            previous.translation = tra;
            previous.creationDate = System.currentTimeMillis();
            previous.otherProperties = new ArrayList<TMXProp>(3);
            if (file != null) {
                previous.otherProperties.add(new TMXProp("file", file));
            }
            if (id != null) {
                previous.otherProperties.add(new TMXProp("id", id));
            }
            if (path != null) {
                previous.otherProperties.add(new TMXProp("path", path));
            }
            if (prev != null) {
                previous.otherProperties.add(new TMXProp("prev", prev));
            }
            if (next != null) {
                previous.otherProperties.add(new TMXProp("next", next));
            }
        }
        this.changesByDate.addLast(previous);
    }

    @Override
    public long timeStamp() {
        return System.currentTimeMillis();
    }
}

