/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.search;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.core.search.SearchMatch;
import org.omegat.core.search.SearchResultEntry;
import org.omegat.util.TMXProp;

public class ReplaceSearchResultEntry
extends SearchResultEntry {
    private List<SearchMatch> m_targetMatch;
    private SourceTextEntry m_sourceEntry;
    private TMXEntry m_tmxEntry;

    public ReplaceSearchResultEntry(SourceTextEntry sourceEntry, TMXEntry traEntry, List<SearchMatch> targetMatch) {
        this.m_targetMatch = targetMatch;
        this.m_tmxEntry = traEntry;
        this.m_sourceEntry = sourceEntry;
    }

    @Override
    public int getEntryNum() {
        return this.m_sourceEntry.entryNum();
    }

    @Override
    public String getPreamble() {
        return this.getEntryNum() + this.getMoreString();
    }

    @Override
    public String getSrcText() {
        return this.m_sourceEntry.getSrcText();
    }

    @Override
    public String getTranslation() {
        return this.m_tmxEntry.translation == null ? "" : this.m_tmxEntry.translation;
    }

    @Override
    public String getNote() {
        return this.m_tmxEntry.note == null ? "" : this.m_tmxEntry.note;
    }

    @Override
    public String getFileName() {
        return this.m_sourceEntry.getKey().file;
    }

    @Override
    public String getAuthor() {
        return this.m_tmxEntry.creator == null ? "" : this.m_tmxEntry.creator;
    }

    @Override
    public Date getDate() {
        return new Date(this.m_tmxEntry.creationDate);
    }

    @Override
    public List<TMXProp> getProperties() {
        return Collections.emptyList();
    }

    @Override
    public String getRevisor() {
        return this.m_tmxEntry.revisor;
    }

    @Override
    public List<SearchMatch> getSrcMatch() {
        return null;
    }

    @Override
    public List<SearchMatch> getTargetMatch() {
        return this.m_targetMatch;
    }

    @Override
    public List<SearchMatch> getNoteMatch() {
        return null;
    }

    @Override
    public boolean equals(SearchResultEntry entry) {
        if (!super.equals(entry)) {
            return false;
        }
        try {
            ReplaceSearchResultEntry rEntry = (ReplaceSearchResultEntry)entry;
            if (this.m_tmxEntry.defaultTranslation) {
                return rEntry.m_tmxEntry.defaultTranslation;
            }
            return false;
        }
        catch (ClassCastException cce) {
            return false;
        }
    }
}

