/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.statistics;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.omegat.core.Core;
import org.omegat.core.data.IProject;
import org.omegat.core.data.ProjectProperties;
import org.omegat.core.data.ProtectedPart;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.core.statistics.IStatisticsPanel;
import org.omegat.core.statistics.StatCount;
import org.omegat.core.threads.LongProcessThread;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.StaticUtils;
import org.omegat.util.gui.TextUtil;

public class CalcRevisionStatistics
extends LongProcessThread {
    private static final String[] htHeaders = new String[]{"", OStrings.getString("CT_STATS_Segments"), OStrings.getString("CT_STATS_Words"), OStrings.getString("CT_STATS_Characters_NOSP"), OStrings.getString("CT_STATS_Characters"), OStrings.getString("CT_STATS_Files")};
    private static final String[] htRows = new String[]{OStrings.getString("CT_STATS_Total"), OStrings.getString("CT_STATS_Unique"), OStrings.getString("CT_STATS_Revised"), OStrings.getString("CT_STATS_RevisedChanged")};
    private static final boolean[] htAlign = new boolean[]{false, true, true, true, true, true};
    private static final String[] ftHeaders = new String[]{OStrings.getString("CT_STATS_FILE_Name"), OStrings.getString("CT_STATS_FILE_Total_Segments"), OStrings.getString("CT_STATS_FILE_Unique_Segments"), OStrings.getString("CT_STATS_Revised"), OStrings.getString("CT_STATS_RevisedChanged")};
    private static final boolean[] ftAlign = new boolean[]{false, true, true, true, true};
    private final IStatisticsPanel.Standard callback;

    public CalcRevisionStatistics(IStatisticsPanel.Standard callback) {
        this.callback = callback;
    }

    @Override
    public void run() {
        IProject p = Core.getProject();
        String result = CalcRevisionStatistics.buildProjectStats(p, this.callback);
        this.callback.setTextData(result);
        this.callback.finishData();
    }

    public static String buildProjectStats(IProject project) {
        return CalcRevisionStatistics.buildProjectStats(project, null);
    }

    public static String buildProjectStats(IProject project, IStatisticsPanel.Standard callback) {
        FileData global = new FileData(null);
        ArrayList<FileData> counts = new ArrayList<FileData>();
        for (IProject.FileInfo file : project.getProjectFiles()) {
            FileData numbers = new FileData(file.filePath);
            counts.add(numbers);
            for (SourceTextEntry ste : file.entries) {
                global.register(project, ste);
                numbers.register(project, ste);
            }
            global.addFile(numbers);
        }
        StringBuilder result = new StringBuilder();
        result.append(OStrings.getString("CT_STATS_Project_Statistics"));
        result.append("\n\n");
        String[][] headerTable = CalcRevisionStatistics.calcHeaderTable(new StatCount[]{global.total, global.unique, global.revised, global.changed});
        if (callback != null) {
            callback.setProjectTableData(htHeaders, headerTable);
        }
        result.append(TextUtil.showTextTable(htHeaders, headerTable, htAlign));
        result.append("\n\n");
        result.append(OStrings.getString("CT_STATS_FILE_Statistics"));
        result.append("\n\n");
        String[][] filesTable = CalcRevisionStatistics.calcFilesTable(project.getProjectProperties(), counts);
        if (callback != null) {
            callback.setFilesTableData(ftHeaders, filesTable);
        }
        result.append(TextUtil.showTextTable(ftHeaders, filesTable, ftAlign));
        return result.toString();
    }

    protected static String[][] calcHeaderTable(StatCount[] result) {
        String[][] table = new String[result.length][6];
        for (int i = 0; i < result.length; ++i) {
            table[i][0] = htRows[i];
            table[i][1] = Integer.toString(result[i].segments);
            table[i][2] = Integer.toString(result[i].words);
            table[i][3] = Integer.toString(result[i].charsWithoutSpaces);
            table[i][4] = Integer.toString(result[i].charsWithSpaces);
            table[i][5] = Integer.toString(result[i].files);
        }
        return table;
    }

    protected static String[][] calcFilesTable(ProjectProperties m_config, List<FileData> counts) {
        String[][] table = new String[counts.size()][5];
        int r = 0;
        for (FileData numbers : counts) {
            table[r][0] = StaticUtils.makeFilenameRelative(numbers.filename, m_config.getSourceRoot());
            table[r][1] = Integer.toString(numbers.total.segments);
            table[r][2] = Integer.toString(numbers.unique.segments);
            table[r][3] = Integer.toString(numbers.revised.segments);
            table[r][4] = Integer.toString(numbers.changed.segments);
            ++r;
        }
        return table;
    }

    public static class FileData {
        public String filename;
        public StatCount total;
        public StatCount unique;
        public StatCount revised;
        public StatCount changed;
        private Set<String> translatedSegments = new HashSet<String>();
        private Set<String> uniqueSegments = new HashSet<String>();

        public FileData(String path) {
            this.filename = path;
            this.total = new StatCount();
            this.unique = new StatCount();
            this.revised = new StatCount();
            this.changed = new StatCount();
        }

        public void register(IProject project, SourceTextEntry ste) {
            String src = ste.getSrcText();
            for (ProtectedPart pp : ste.getProtectedParts()) {
                src = src.replace(pp.getTextInSourceSegment(), pp.getReplacementUniquenessCalculation());
            }
            StatCount count = new StatCount(ste);
            this.total.add(count);
            TMXEntry tr = project.getTranslationInfo(ste.getKey());
            if (tr != null && tr.revisor != null) {
                this.revised.add(count);
            }
            if (tr != null && tr.changer != null && !tr.changer.equals(Preferences.getPreferenceDefault("team_Author", System.getProperty("user.name")))) {
                this.changed.add(count);
            }
            if (!this.uniqueSegments.contains(src)) {
                this.unique.add(count);
                this.uniqueSegments.add(src);
            }
        }

        public void addFile(FileData file) {
            if (file.total.segments > 0) {
                this.total.addFiles(1);
            }
            if (file.unique.segments > 0) {
                this.unique.addFiles(1);
            }
            if (file.revised.segments > 0) {
                this.revised.addFiles(1);
            }
            if (file.changed.segments > 0) {
                this.changed.addFiles(1);
            }
        }
    }
}

