/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.statistics;

import gen.core.filters.Filters;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.omegat.core.Core;
import org.omegat.core.data.IProject;
import org.omegat.core.data.ParseEntry;
import org.omegat.core.data.ProjectOptions;
import org.omegat.core.data.ProtectedPart;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.statistics.CalcStandardStatistics;
import org.omegat.core.statistics.IStatisticsPanel;
import org.omegat.core.statistics.StatCount;
import org.omegat.core.statistics.Statistics;
import org.omegat.filters2.FilterContext;
import org.omegat.filters2.IParseCallback;
import org.omegat.filters2.master.FilterMaster;
import org.omegat.util.OStrings;
import org.omegat.util.StaticUtils;
import org.omegat.util.gui.TextUtil;

public class CalcStandardDirectoryStatistics
extends CalcStandardStatistics {
    private File m_searchFile;
    private ProjectOptions m_properties;
    private final SearchCallback searchCallback;
    private final FilterMaster fm;
    private final FilterContext ctxt;

    public CalcStandardDirectoryStatistics(IStatisticsPanel.Standard callback, File m_searchFile, ProjectOptions properties) {
        super(callback);
        this.m_searchFile = m_searchFile;
        this.m_properties = properties;
        this.searchCallback = new SearchCallback(this.m_properties);
        this.ctxt = new FilterContext(this.m_properties);
        Filters filterMasterConfig = FilterMaster.loadConfig(StaticUtils.getConfigDir());
        if (filterMasterConfig == null) {
            filterMasterConfig = FilterMaster.createDefaultFiltersConfig();
        }
        this.fm = new FilterMaster(filterMasterConfig);
        Core.setFilterMaster(this.fm);
    }

    @Override
    public void run() {
        try {
            if (this.m_searchFile.isDirectory()) {
                StaticUtils.iterateFileTree(this.m_searchFile, true, this::treatFile);
            } else {
                this.treatFile(this.m_searchFile);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        String result = this.searchCallback.buildProjectStats(this.callback);
        this.callback.setTextData(result);
        this.callback.finishData();
        File internalDir = this.m_searchFile.isDirectory() ? this.m_searchFile : this.m_searchFile.getParentFile();
        try {
            File oldstats = new File(internalDir, "word_counts");
            if (oldstats.exists()) {
                oldstats.delete();
            }
        }
        catch (Exception oldstats) {
            // empty catch block
        }
        String fn = internalDir + "/project_stats.txt";
        System.out.println("Writing statistics to " + fn);
        Statistics.writeStat(fn, result);
        this.callback.setDataFile(fn);
    }

    private void treatFile(File file) throws Exception {
        String filename = file.getPath();
        IProject.FileInfo fi = new IProject.FileInfo();
        fi.filePath = filename.substring(this.m_searchFile.toString().length());
        this.searchCallback.setCurrentFile(fi);
        this.fm.loadFile(filename, this.ctxt, this.searchCallback);
        this.searchCallback.fileFinished();
        this.checkInterrupted();
    }

    protected class SearchCallback
    extends ParseEntry
    implements IParseCallback {
        private File currentFile;
        private CalcStandardStatistics.FileData global;
        private List<CalcStandardStatistics.FileData> counts;
        private CalcStandardStatistics.FileData lastFileData;

        public SearchCallback(ProjectOptions config) {
            super(config);
            this.global = new CalcStandardStatistics.FileData(null);
            this.counts = new ArrayList<CalcStandardStatistics.FileData>();
        }

        @Override
        public void setCurrentFile(IProject.FileInfo fi) {
            super.setCurrentFile(fi);
            this.currentFile = new File(CalcStandardDirectoryStatistics.this.m_searchFile, fi.filePath);
            this.lastFileData = new CalcStandardStatistics.FileData(fi.filePath);
            this.counts.add(this.lastFileData);
            this.global.addFile(this.lastFileData);
        }

        @Override
        protected void fileFinished() {
            super.fileFinished();
        }

        @Override
        protected void addSegment(String id, short segmentIndex, String segmentSource, List<ProtectedPart> protectedParts, SourceTextEntry.SourceTranslationInfo traInfo, String prevSegment, String nextSegment, String path) {
            String src = segmentSource;
            if (protectedParts != null) {
                for (ProtectedPart pp : protectedParts) {
                    src = src.replace(pp.getTextInSourceSegment(), pp.getReplacementUniquenessCalculation());
                }
            }
            this.global.register(src, traInfo != null && traInfo.isTranslated());
            this.lastFileData.register(src, traInfo != null && traInfo.isTranslated());
        }

        public String buildProjectStats(IStatisticsPanel.Standard callback) {
            StringBuilder result = new StringBuilder();
            result.append(OStrings.getString("CT_STATS_Project_Statistics"));
            result.append("\n\n");
            String[][] headerTable = CalcStandardStatistics.calcHeaderTable(new StatCount[]{this.global.total, this.global.remaining, this.global.unique, this.global.remainingUnique});
            if (callback != null) {
                callback.setProjectTableData(CalcStandardStatistics.htHeaders, headerTable);
            }
            result.append(TextUtil.showTextTable(CalcStandardStatistics.htHeaders, headerTable, CalcStandardStatistics.htAlign));
            result.append("\n\n");
            result.append(OStrings.getString("CT_STATS_FILE_Statistics"));
            result.append("\n\n");
            String[][] filesTable = CalcStandardStatistics.calcFilesTable((CalcStandardDirectoryStatistics.this.m_searchFile.isDirectory() ? CalcStandardDirectoryStatistics.this.m_searchFile : CalcStandardDirectoryStatistics.this.m_searchFile.getParentFile()).toString(), this.counts);
            if (callback != null) {
                callback.setFilesTableData(CalcStandardStatistics.ftHeaders, filesTable);
            }
            result.append(TextUtil.showTextTable(CalcStandardStatistics.ftHeaders, filesTable, CalcStandardStatistics.ftAlign));
            return result.toString();
        }
    }
}

