/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters2.html2;

import java.awt.Dialog;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.htmlparser.Parser;
import org.htmlparser.util.ParserException;
import org.htmlparser.visitors.NodeVisitor;
import org.omegat.filters2.AbstractFilter;
import org.omegat.filters2.FilterContext;
import org.omegat.filters2.Instance;
import org.omegat.filters2.TranslationException;
import org.omegat.filters2.html2.EditOptionsDialog;
import org.omegat.filters2.html2.FilterVisitor;
import org.omegat.filters2.html2.HTMLOptions;
import org.omegat.filters2.html2.HTMLReader;
import org.omegat.filters2.html2.HTMLWriter;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.StringUtil;

public class HTMLFilter2
extends AbstractFilter {
    private String sourceEncoding;
    private String targetEncoding;
    private Pattern skipRegExpPattern;
    private HashMap<String, String> skipMetaAttributes;
    private HashMap<String, String> ignoreTagsAttributes;

    @Override
    protected boolean requirePrevNextFields() {
        return true;
    }

    @Override
    public BufferedReader createReader(File infile, String encoding) throws UnsupportedEncodingException, IOException {
        HTMLReader hreader = new HTMLReader(infile.getAbsolutePath(), encoding);
        this.sourceEncoding = hreader.getEncoding();
        return new BufferedReader(hreader);
    }

    @Override
    public BufferedWriter createWriter(File outfile, String encoding) throws UnsupportedEncodingException, IOException {
        HTMLOptions options = new HTMLOptions(this.processOptions);
        this.targetEncoding = encoding == null ? this.sourceEncoding : encoding;
        HTMLWriter hwriter = new HTMLWriter(outfile.getAbsolutePath(), this.targetEncoding, options);
        return new BufferedWriter(hwriter);
    }

    @Override
    public void processFile(BufferedReader infile, BufferedWriter outfile, FilterContext fc) throws IOException, TranslationException {
        StringBuilder all = null;
        try {
            all = new StringBuilder();
            char[] cbuf = new char[1000];
            int len = -1;
            while ((len = infile.read(cbuf)) > 0) {
                all.append(cbuf, 0, len);
            }
        }
        catch (OutOfMemoryError e) {
            all = null;
            System.gc();
            throw new IOException(OStrings.getString("HTML__FILE_TOO_BIG"));
        }
        HTMLOptions options = new HTMLOptions(this.processOptions);
        String skipRegExp = options.getSkipRegExp();
        if (!StringUtil.isEmpty(skipRegExp)) {
            try {
                this.skipRegExpPattern = Pattern.compile(skipRegExp, 2);
            }
            catch (PatternSyntaxException e) {
                Log.log(e);
            }
        }
        String skipMetaString = options.getSkipMeta();
        this.skipMetaAttributes = new HashMap();
        String[] skipMetaAttributesStringarray = skipMetaString.split(",");
        for (int i = 0; i < skipMetaAttributesStringarray.length; ++i) {
            String keyvalue = skipMetaAttributesStringarray[i].trim().toUpperCase();
            this.skipMetaAttributes.put(keyvalue, "");
        }
        String ignoreTagString = options.getIgnoreTags();
        this.ignoreTagsAttributes = new HashMap();
        String[] ignoreTagsAttributesStringarray = ignoreTagString.split(",");
        for (int i = 0; i < ignoreTagsAttributesStringarray.length; ++i) {
            String keyvalue = ignoreTagsAttributesStringarray[i].trim().toUpperCase();
            this.ignoreTagsAttributes.put(keyvalue, "");
        }
        Parser parser = new Parser();
        try {
            parser.setInputHTML(all.toString());
            parser.visitAllNodesWith((NodeVisitor)new FilterVisitor(this, outfile, options));
        }
        catch (ParserException pe) {
            System.out.println((Object)pe);
        }
        catch (StringIndexOutOfBoundsException se) {
            throw new StringIndexOutOfBoundsException(OStrings.getString("HTML__INVALID_HTML"));
        }
    }

    public String privateProcessEntry(String entry, String comment) {
        if (this.skipRegExpPattern != null) {
            if (this.skipRegExpPattern.matcher(entry).matches()) {
                return entry;
            }
            return super.processEntry(entry, comment);
        }
        return super.processEntry(entry, comment);
    }

    @Override
    public boolean isTargetEncodingVariable() {
        return true;
    }

    @Override
    public boolean isSourceEncodingVariable() {
        return true;
    }

    @Override
    public String getFileFormatName() {
        return OStrings.getString("HTML__FILTER_NAME");
    }

    @Override
    public Instance[] getDefaultInstances() {
        return new Instance[]{new Instance("*.htm", null, "UTF-8"), new Instance("*.html", null, "UTF-8"), new Instance("*.xhtml", null, "UTF-8"), new Instance("*.xht", null, "UTF-8")};
    }

    @Override
    public String getHint() {
        return OStrings.getString("HTML_NOTE");
    }

    @Override
    public boolean hasOptions() {
        return true;
    }

    @Override
    public Map<String, String> changeOptions(Dialog parent, Map<String, String> config) {
        try {
            EditOptionsDialog dialog = new EditOptionsDialog(parent, config);
            dialog.setVisible(true);
            if (1 == dialog.getReturnStatus()) {
                return dialog.getOptions().getOptionsMap();
            }
            return null;
        }
        catch (Exception e) {
            Log.logErrorRB("HTML_EXC_EDIT_OPTIONS", new Object[0]);
            Log.log(e);
            return null;
        }
    }

    public String getTargetEncoding() {
        return this.targetEncoding;
    }

    public boolean checkDoSkipMetaTag(String key, String value) {
        return this.skipMetaAttributes.containsKey(key.toUpperCase() + "=" + value.toUpperCase());
    }

    public boolean checkIgnoreTags(String key, String value) {
        return this.ignoreTagsAttributes.containsKey(key.toUpperCase() + "=" + value.toUpperCase());
    }

    @Override
    public String getInEncodingLastParsedFile() {
        return this.sourceEncoding;
    }
}

