/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters2.latex;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.omegat.filters2.AbstractFilter;
import org.omegat.filters2.FilterContext;
import org.omegat.filters2.Instance;
import org.omegat.util.LinebreakPreservingReader;
import org.omegat.util.Log;
import org.omegat.util.OStrings;

public class LatexFilter
extends AbstractFilter {
    private LinkedList<String> oneArgNoText = new LinkedList();
    private LinkedList<String> oneArgInlineText = new LinkedList();
    private LinkedList<String> oneArgParText = new LinkedList();

    @Override
    public String getFileFormatName() {
        return OStrings.getString("LATEXFILTER_FILTER_NAME");
    }

    @Override
    public Instance[] getDefaultInstances() {
        return new Instance[]{new Instance("*.tex"), new Instance("*.latex")};
    }

    @Override
    public boolean isSourceEncodingVariable() {
        return true;
    }

    @Override
    public boolean isTargetEncodingVariable() {
        return true;
    }

    @Override
    protected boolean requirePrevNextFields() {
        return true;
    }

    @Override
    public void processFile(BufferedReader in, BufferedWriter out, FilterContext fc) throws IOException {
        in.mark(1);
        int ch = in.read();
        if (ch != 65279) {
            in.reset();
        }
        this.init();
        this.processLatexFile(in, out);
    }

    private int findStringCategory(String c) {
        if (c.equals("\\")) {
            return 0;
        }
        if (c.equals("{")) {
            return 1;
        }
        if (c.equals("}")) {
            return 2;
        }
        if (c.equals("$")) {
            return 3;
        }
        if (c.equals("&")) {
            return 4;
        }
        if (c.equals("\n")) {
            return 5;
        }
        if (c.equals("#")) {
            return 6;
        }
        if (c.equals("^")) {
            return 7;
        }
        if (c.equals("_")) {
            return 8;
        }
        if (c.equals("\u0000")) {
            return 9;
        }
        if (c.matches("[ \t]")) {
            return 10;
        }
        if (c.matches("[a-zA-Z]")) {
            return 11;
        }
        if (c.equals("~")) {
            return 13;
        }
        if (c.equals("%")) {
            return 14;
        }
        return 12;
    }

    private void processLatexFile(BufferedReader in, Writer out) throws IOException {
        String s;
        LinebreakPreservingReader lpin = new LinebreakPreservingReader(in);
        StringBuilder par = new StringBuilder();
        StringBuilder comment = new StringBuilder();
        LinkedList<String> commands = new LinkedList<String>();
        while ((s = lpin.readLine()) != null) {
            String[] c = !s.isEmpty() ? s.split("(?!^)") : new String[]{};
            String state = "N";
            for (int idx = 0; idx < c.length; ++idx) {
                String cidx = c[idx];
                int cat = this.findStringCategory(cidx);
                if (cat == 0) {
                    StringBuilder cmd = new StringBuilder();
                    cmd.append(cidx);
                    ++idx;
                    while (idx < c.length) {
                        String cmdc = c[idx];
                        if (this.findStringCategory(cmdc) != 11) {
                            if (cmd.length() == 1) {
                                cmd.append(cmdc);
                                state = "M";
                                break;
                            }
                            --idx;
                            state = "M";
                            break;
                        }
                        cmd.append(cmdc);
                        ++idx;
                    }
                    if (!commands.contains(cmd.toString())) {
                        commands.add(cmd.toString());
                    }
                    par.append((CharSequence)cmd);
                    continue;
                }
                if (cat == 4) {
                    out.write(this.processParagraph(commands, par.toString()));
                    out.write("&");
                    par.setLength(0);
                    commands.clear();
                    continue;
                }
                if (cat == 10) {
                    if (!state.equals("M")) continue;
                    state = "S";
                    par.append(cidx);
                    continue;
                }
                if (cat == 14) {
                    comment.append(cidx);
                    ++idx;
                    while (idx < c.length) {
                        String commentc = c[idx];
                        comment.append(commentc);
                        ++idx;
                    }
                    continue;
                }
                state = "M";
                par.append(cidx);
            }
            if (state.equals("N")) {
                String endOfLine = lpin.getLinebreak();
                if (par.length() > 0) {
                    out.write(this.processParagraph(commands, par.toString()));
                    out.write(endOfLine);
                    out.write(endOfLine);
                    par.setLength(0);
                }
                commands.clear();
                if (comment.length() <= 0) continue;
                out.write(comment.toString());
                out.write(endOfLine);
                comment.setLength(0);
                continue;
            }
            if (!state.equals("M")) continue;
            par.append(" ");
        }
        if (par.length() > 0) {
            out.write(this.processParagraph(commands, par.toString()));
        }
    }

    private String substituteUnicode(String par) {
        par = par.replaceAll("\\\\\\\\", "<br0>");
        par = par.replaceAll("\\{?\\\\ss\\}?", "\u00df");
        par = par.replaceAll("\\{?\\\\glqq\\}?(\\{\\})?", "\u301f");
        par = par.replaceAll("\\{?\\\\grqq\\}?(\\{\\})?", "\u301d");
        par = par.replaceAll("\\{?\\\\glq\\}?(\\{\\})?", "\u201a");
        par = par.replaceAll("\\{?\\\\grq\\}?(\\{\\})?", "\u2018");
        par = par.replaceAll("\\\\%", "%");
        par = par.replaceAll("\\\\-", "\u00ad");
        par = par.replaceAll("\\\\,", "\u2009");
        par = par.replaceAll("~", "\u00a0");
        return par;
    }

    private String resubstituteTex(String par) {
        par = par.replaceAll("\u00a0", "~");
        par = par.replaceAll("\u2009", "\\\\,");
        par = par.replaceAll("\u00ad", "\\\\-");
        par = par.replaceAll("%", "\\\\%");
        par = par.replaceAll("<br0>", "\\\\\\\\");
        return par;
    }

    private void init() {
        this.oneArgNoText.add("\\begin");
        this.oneArgNoText.add("\\end");
        this.oneArgNoText.add("\\cite");
        this.oneArgNoText.add("\\label");
        this.oneArgNoText.add("\\ref");
        this.oneArgNoText.add("\\pageref");
        this.oneArgNoText.add("\\pagestyle");
        this.oneArgNoText.add("\\thispagestyle");
        this.oneArgNoText.add("\\vspace");
        this.oneArgNoText.add("\\hspace");
        this.oneArgNoText.add("\\vskip");
        this.oneArgNoText.add("\\hskip");
        this.oneArgNoText.add("\\put");
        this.oneArgNoText.add("\\includegraphics");
        this.oneArgNoText.add("\\documentclass");
        this.oneArgNoText.add("\\usepackage");
        this.oneArgInlineText.add("\\emph");
        this.oneArgInlineText.add("\\textbf");
        this.oneArgInlineText.add("\\texttt");
        this.oneArgInlineText.add("\\textsf");
        this.oneArgInlineText.add("\\textit");
        this.oneArgInlineText.add("\\hbox");
        this.oneArgInlineText.add("\\mbox");
        this.oneArgInlineText.add("\\vbox");
        this.oneArgParText.add("\\typeout");
        this.oneArgParText.add("\\footnote");
        this.oneArgParText.add("\\author");
        this.oneArgParText.add("\\index");
        this.oneArgParText.add("\\title");
        this.oneArgParText.add("\\Chapter");
        this.oneArgParText.add("\\chapter");
        this.oneArgParText.add("\\section");
    }

    private String replaceOneArgNoText(LinkedList<String[]> substituted, LinkedList<String> commands, String par) {
        int counter = 0;
        for (String command : commands) {
            StringBuffer sb = new StringBuffer();
            if (!this.oneArgNoText.contains(command)) continue;
            String find = "\\" + command + "\\*?(\\[[^\\]]*\\]|\\([^\\)]*\\))?\\s*\\{[^\\}]*+\\}";
            Pattern p = Pattern.compile(find);
            Matcher m = p.matcher(par);
            while (m.find()) {
                String replace = "<n" + String.valueOf(counter) + ">";
                String[] subst = new String[]{this.reHarden(m.group(0)), this.reHarden(replace)};
                substituted.addFirst(subst);
                m.appendReplacement(sb, replace);
                ++counter;
            }
            m.appendTail(sb);
            par = sb.toString();
        }
        return par;
    }

    private String replaceOneArgInlineText(LinkedList<String[]> substituted, LinkedList<String> commands, String par) {
        int counter = 0;
        for (String command : commands) {
            StringBuffer sb = new StringBuffer();
            if (!this.oneArgInlineText.contains(command)) continue;
            String find = "(\\" + command + "\\s*\\{)([^\\}]*+)\\}";
            Pattern p = Pattern.compile(find);
            Matcher m = p.matcher(par);
            while (m.find()) {
                String preReplace = "<i" + String.valueOf(counter) + ">";
                String postReplace = "</i" + String.valueOf(counter) + ">";
                String[] s1 = new String[]{this.reHarden(m.group(1)), this.reHarden(preReplace)};
                substituted.addFirst(s1);
                String[] s2 = new String[]{this.reHarden("}"), this.reHarden(postReplace)};
                substituted.addFirst(s2);
                String replace = preReplace + "$2" + postReplace;
                m.appendReplacement(sb, replace);
                ++counter;
            }
            m.appendTail(sb);
            par = sb.toString();
        }
        return par;
    }

    private String replaceOneArgParText(LinkedList<String[]> substituted, LinkedList<String> commands, String par) {
        int counter = 0;
        for (String command : commands) {
            StringBuffer sb = new StringBuffer();
            if (!this.oneArgParText.contains(command)) continue;
            String find = "(\\" + command + "\\*?\\s*)\\{([^\\}]*+)\\}";
            Pattern p = Pattern.compile(find);
            Matcher m = p.matcher(par);
            while (m.find()) {
                String replace = "<p" + String.valueOf(counter) + ">";
                String content = "";
                if (m.group(2) != null) {
                    content = this.processParagraph(commands, m.group(2));
                }
                String[] subst = new String[]{this.reHarden(m.group(1) + "{" + content + "}"), this.reHarden(replace)};
                substituted.addFirst(subst);
                m.appendReplacement(sb, replace);
                ++counter;
            }
            m.appendTail(sb);
            par = sb.toString();
        }
        return par;
    }

    /*
     * WARNING - void declaration
     */
    private String replaceUnknownCommand(LinkedList<String[]> substituted, LinkedList<String> commands, String par) {
        int counter = 0;
        for (String string : commands) {
            void var6_6;
            if (string.equals("\\\\") || string.equals("\\{") || string.equals("\\[") || string.equals("\\|")) {
                String string2 = "\\" + string;
            }
            StringBuffer sb = new StringBuffer();
            String find = "\\" + (String)var6_6;
            try {
                Pattern p = Pattern.compile(find);
                Matcher m = p.matcher(par);
                while (m.find()) {
                    String replace = "<u" + String.valueOf(counter) + ">";
                    String[] subst = new String[]{this.reHarden(m.group(0)), this.reHarden(replace)};
                    substituted.addFirst(subst);
                    m.appendReplacement(sb, replace);
                    ++counter;
                }
                m.appendTail(sb);
                par = sb.toString();
            }
            catch (PatternSyntaxException e) {
                Log.log("LaTeX PatternSyntaxException: " + e.getMessage());
                Log.log((String)var6_6);
            }
        }
        return par;
    }

    private String reHarden(String re) {
        re = re.replaceAll("\\\\", "\\\\\\\\");
        re = re.replaceAll("\\[", "\\\\[");
        re = re.replaceAll("\\^", "\\\\^");
        re = re.replaceAll("\\$", "\\\\\\$");
        re = re.replaceAll("\\{", "\\\\{");
        return re;
    }

    private String processParagraph(LinkedList<String> commands, String par) {
        LinkedList<String[]> substituted = new LinkedList<String[]>();
        par = this.substituteUnicode((String)par);
        par = this.replaceOneArgNoText(substituted, commands, (String)par);
        par = this.replaceOneArgInlineText(substituted, commands, (String)par);
        par = this.replaceOneArgParText(substituted, commands, (String)par);
        par = this.replaceUnknownCommand(substituted, commands, (String)par);
        String find = "^((\\s*</?[nipu]\\d+>\\s*)*)(.*?)((\\s*</?[nipu]\\d+>\\s*)*)$";
        Pattern p = Pattern.compile(find);
        Matcher m = p.matcher((CharSequence)par);
        if (m.find()) {
            par = "";
            if (m.group(1) != null) {
                par = (String)par + m.group(1);
            }
            if (m.group(3) != null) {
                par = (String)par + this.processEntry(m.group(3));
            }
            if (m.group(4) != null) {
                par = (String)par + m.group(4);
            }
        }
        par = this.resubstituteTex((String)par);
        ListIterator it = substituted.listIterator();
        while (it.hasNext()) {
            String[] subst = (String[])it.next();
            par = ((String)par).replaceAll(subst[1], subst[0]);
        }
        return par;
    }
}

