/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters2.master;

import gen.core.filters.Files;
import gen.core.filters.Filter;
import javax.swing.table.AbstractTableModel;
import org.omegat.filters2.IFilter;
import org.omegat.filters2.master.FilterMaster;
import org.omegat.util.OStrings;

public class OneFilterTableModel
extends AbstractTableModel {
    private final Filter filter;
    private boolean sourceEncodingVariable;
    private boolean targetEncodingVariable;
    private static final String ENC_AUTO_NAME = OStrings.getString("ENCODING_AUTO");

    public OneFilterTableModel(Filter f) {
        this.filter = f;
        IFilter fi = FilterMaster.getFilterInstance(f.getClassName());
        this.sourceEncodingVariable = fi.isSourceEncodingVariable();
        this.targetEncodingVariable = fi.isTargetEncodingVariable();
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return OStrings.getString("ONEFILTER_SOURCE_FILENAME_MASK");
            }
            case 1: {
                return OStrings.getString("ONEFILTER_SOURCE_FILE_ENCODING");
            }
            case 2: {
                return OStrings.getString("ONEFILTER_TARGET_FILE_ENCODING");
            }
            case 3: {
                return OStrings.getString("ONEFILTER_TARGET_FILENAME_ENCODING");
            }
        }
        return null;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public int getRowCount() {
        return this.filter.getFiles().size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Files instance = this.filter.getFiles().get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return instance.getSourceFilenameMask();
            }
            case 1: {
                return this.getEncodingName(instance.getSourceEncoding());
            }
            case 2: {
                return this.getEncodingName(instance.getTargetEncoding());
            }
            case 3: {
                return instance.getTargetFilenamePattern();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        Files instance = this.filter.getFiles().get(rowIndex);
        switch (columnIndex) {
            case 0: {
                instance.setSourceFilenameMask(aValue.toString());
                break;
            }
            case 1: {
                instance.setSourceEncoding(this.setEncodingName(aValue.toString()));
                break;
            }
            case 2: {
                instance.setTargetEncoding(this.setEncodingName(aValue.toString()));
                break;
            }
            case 3: {
                instance.setTargetFilenamePattern(aValue.toString());
            }
        }
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: 
            case 3: {
                return true;
            }
            case 1: {
                return this.sourceEncodingVariable;
            }
            case 2: {
                return this.targetEncodingVariable;
            }
        }
        return false;
    }

    private String getEncodingName(String enc) {
        return enc != null ? enc : ENC_AUTO_NAME;
    }

    private String setEncodingName(String encName) {
        return ENC_AUTO_NAME.equals(encName) ? null : encName;
    }
}

