/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters2.mozlang;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.omegat.core.data.ProtectedPart;
import org.omegat.filters2.AbstractFilter;
import org.omegat.filters2.FilterContext;
import org.omegat.filters2.Instance;
import org.omegat.filters2.TranslationException;
import org.omegat.util.OStrings;
import org.omegat.util.PatternConsts;
import org.omegat.util.TagUtil;

public class MozillaLangFilter
extends AbstractFilter {
    protected static Pattern LOCALIZATION_NOTE = Pattern.compile("# (.*)");
    protected static Pattern PATTERN_SOURCE = Pattern.compile("^;(.*)");
    private StringBuilder source;
    private StringBuilder target;
    private StringBuilder localizationNote;
    private BufferedWriter out;

    @Override
    public String getFileFormatName() {
        return OStrings.getString("MOZLANG_FILTER_NAME");
    }

    @Override
    public Instance[] getDefaultInstances() {
        return new Instance[]{new Instance("*.lang")};
    }

    @Override
    public BufferedReader createReader(File infile, String encoding) throws UnsupportedEncodingException, IOException {
        return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(infile), "UTF-8"));
    }

    @Override
    public BufferedWriter createWriter(File outfile, String encoding) throws UnsupportedEncodingException, IOException {
        return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outfile), "UTF-8"));
    }

    @Override
    public boolean isSourceEncodingVariable() {
        return false;
    }

    @Override
    public boolean isTargetEncodingVariable() {
        return false;
    }

    @Override
    public String getInEncodingLastParsedFile() {
        return "UTF-8";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processFile(File inFile, File outFile, FilterContext fc) throws IOException, TranslationException {
        this.inEncodingLastParsedFile = fc.getInEncoding();
        try (BufferedReader reader = this.createReader(inFile, this.inEncodingLastParsedFile);
             BufferedWriter writer = outFile != null ? this.createWriter(outFile, fc.getOutEncoding()) : null;){
            this.processFile(reader, writer, fc);
        }
    }

    @Override
    protected void processFile(BufferedReader inFile, BufferedWriter outFile, FilterContext fc) throws IOException, TranslationException {
        String s;
        this.source = new StringBuilder();
        this.target = new StringBuilder();
        this.localizationNote = new StringBuilder();
        this.out = outFile;
        READ_STATE state = READ_STATE.WAIT_SOURCE;
        block4: while ((s = inFile.readLine()) != null) {
            s = s.trim();
            switch (state) {
                case WAIT_SOURCE: {
                    Matcher m = PATTERN_SOURCE.matcher(s);
                    if (m.matches()) {
                        this.source.append(m.group(1));
                        state = READ_STATE.WAIT_TARGET;
                    }
                    if (LOCALIZATION_NOTE.matcher(s).matches()) {
                        this.localizationNote.append(s);
                    }
                    this.target.setLength(0);
                    this.eol(s);
                    continue block4;
                }
                case WAIT_TARGET: {
                    this.target.append(s);
                    this.flushTranslation(fc);
                    state = READ_STATE.WAIT_SOURCE;
                    continue block4;
                }
            }
            this.eol(s);
        }
    }

    protected void eol(String s) throws IOException {
        if (this.out != null) {
            this.out.write(s);
            this.out.write(10);
        }
    }

    protected void align(int pair) {
        String s = this.source.toString();
        Object c = "";
        String t = s.equals(this.target.toString()) ? null : this.target.toString();
        if (this.localizationNote.length() > 0) {
            c = (String)c + "\n" + OStrings.getString("LANGFILTER_LOCALIZATION_NOTE") + "\n" + this.localizationNote.toString();
        }
        if (((String)c).length() == 0) {
            c = null;
        }
        this.align(s, t, (String)c);
    }

    protected void align(String source, String translation, String comments) {
        if (this.entryParseCallback != null) {
            List<ProtectedPart> protectedParts = TagUtil.applyCustomProtectedParts(source, PatternConsts.PRINTF_VARS, null);
            this.entryParseCallback.addEntry(null, source, translation, false, comments, null, this, protectedParts);
        } else if (this.entryAlignCallback != null) {
            this.entryAlignCallback.addTranslation(null, source, translation, false, null, this);
        }
    }

    protected void flushTranslation(FilterContext fc) throws IOException {
        if (this.out != null) {
            Object tr = this.entryTranslateCallback.getTranslation(null, this.source.toString(), null);
            if (tr == null) {
                tr = this.source.toString();
            } else if (((String)tr).equals(this.source.toString())) {
                tr = (String)tr + " {ok}";
            }
            this.eol((String)tr);
        } else {
            this.align(0);
        }
        this.source.setLength(0);
        this.target.setLength(0);
        this.localizationNote.setLength(0);
    }

    @Override
    public boolean hasOptions() {
        return false;
    }

    static enum READ_STATE {
        WAIT_SOURCE,
        WAIT_TARGET;

    }
}

