/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters3.xml;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.omegat.core.Core;
import org.omegat.core.data.ProtectedPart;
import org.omegat.filters2.FilterContext;
import org.omegat.filters2.TranslationException;
import org.omegat.filters3.Attribute;
import org.omegat.filters3.Attributes;
import org.omegat.filters3.Element;
import org.omegat.filters3.Entry;
import org.omegat.filters3.Tag;
import org.omegat.filters3.xml.Comment;
import org.omegat.filters3.xml.DTD;
import org.omegat.filters3.xml.Entity;
import org.omegat.filters3.xml.ProcessingInstruction;
import org.omegat.filters3.xml.Translator;
import org.omegat.filters3.xml.XMLContentBasedTag;
import org.omegat.filters3.xml.XMLDialect;
import org.omegat.filters3.xml.XMLEntityText;
import org.omegat.filters3.xml.XMLIntactTag;
import org.omegat.filters3.xml.XMLOutOfTurnTag;
import org.omegat.filters3.xml.XMLTag;
import org.omegat.filters3.xml.XMLText;
import org.omegat.filters3.xml.XMLUtils;
import org.omegat.util.OStrings;
import org.omegat.util.StringUtil;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class Handler
extends DefaultHandler
implements LexicalHandler,
DeclHandler {
    private Translator translator;
    private XMLDialect dialect;
    private File inFile;
    private File outFile;
    private FilterContext context;
    private BufferedWriter mainWriter;
    private BufferedWriter extWriter = null;
    private final Stack<String> currentTagPath = new Stack();
    private Entity extEntity = null;
    Entry entry;
    Stack<Entry> outofturnEntries = new Stack();
    Entry intacttagEntry = null;
    Attributes intacttagAttributes = null;
    Stack<Attributes> paragraphTagAttributes = new Stack();
    Stack<Attributes> preformatTagAttributes = new Stack();
    Stack<Attributes> xmlTagAttributes = new Stack();
    String intacttagName = null;
    Stack<String> paragraphTagName = new Stack();
    Stack<String> preformatTagName = new Stack();
    Stack<String> translatableTagName = new Stack();
    Stack<String> xmlTagName = new Stack();
    private boolean spacePreserve = false;
    private List<Entity> externalEntities = new ArrayList<Entity>();
    private Map<String, Entity> internalEntities = new HashMap<String, Entity>();
    private Entity internalEntityStarted = null;
    private boolean inCDATA = false;
    private DTD dtd = null;
    private boolean inDTD = false;
    private List<File> processedFiles = new ArrayList<File>();
    private static final String START_JARSCHEMA = "jar:";
    private static final String START_FILESCHEMA = "file:";
    private String sourceFolderAbsolutePath = null;

    private BufferedWriter currWriter() {
        if (this.extWriter != null) {
            return this.extWriter;
        }
        return this.mainWriter;
    }

    private boolean collectingOutOfTurnText() {
        return !this.outofturnEntries.empty();
    }

    private boolean collectingIntactText() {
        return this.intacttagEntry != null;
    }

    private boolean isTranslatableTag() {
        return !this.translatableTagName.empty();
    }

    private boolean isSpacePreservingTag() {
        if (Core.getFilterMaster().getConfig().isPreserveSpaces()) {
            return true;
        }
        return this.spacePreserve;
    }

    private void resetSpacePreservingTag() {
        this.spacePreserve = false;
    }

    private Entry currEntry() {
        if (this.collectingIntactText()) {
            return this.intacttagEntry;
        }
        if (this.collectingOutOfTurnText()) {
            return this.outofturnEntries.peek();
        }
        return this.entry;
    }

    public List<File> getProcessedFiles() {
        return this.processedFiles.isEmpty() ? null : this.processedFiles;
    }

    private void reportFatalError(SAXParseException e) throws SAXException, MalformedURLException, URISyntaxException {
        File errorfile;
        int linenum = e.getLineNumber();
        String filename = e.getSystemId() != null ? ((errorfile = new File(this.inFile.getParentFile(), this.localizeSystemId(e.getSystemId()))).exists() ? errorfile.getAbsolutePath() : this.inFile.getAbsolutePath()) : this.inFile.getAbsolutePath();
        throw new SAXException("\n" + StringUtil.format(e.getMessage() + "\n" + OStrings.getString("XML_FATAL_ERROR"), filename, linenum));
    }

    public Handler(Translator translator, XMLDialect dialect, File inFile, File outFile, FilterContext fc) throws IOException {
        this.translator = translator;
        this.dialect = dialect;
        this.inFile = inFile;
        this.outFile = outFile;
        this.context = fc;
        this.mainWriter = translator.createWriter(outFile, fc.getOutEncoding());
    }

    public FilterContext getContext() {
        return this.context;
    }

    private String getSourceFolderAbsolutePath() {
        if (this.sourceFolderAbsolutePath == null) {
            Object res = this.inFile.getAbsoluteFile().getParent();
            try {
                res = this.inFile.getCanonicalFile().getParent();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (((String)res).codePointBefore(((String)res).length()) != File.separatorChar) {
                res = (String)res + File.separatorChar;
            }
            this.sourceFolderAbsolutePath = res;
        }
        return this.sourceFolderAbsolutePath;
    }

    private String localizeSystemId(String systemId) throws URISyntaxException, MalformedURLException {
        File thisOutFile;
        String thisOutPath;
        if (systemId.startsWith(START_FILESCHEMA) && (thisOutPath = (thisOutFile = new File(new URL(systemId).toURI())).getAbsolutePath()).startsWith(this.getSourceFolderAbsolutePath())) {
            return thisOutPath.substring(this.getSourceFolderAbsolutePath().length());
        }
        return systemId;
    }

    private boolean isInSource(String systemId) throws URISyntaxException, MalformedURLException {
        File thisOutFile;
        return systemId.startsWith(START_FILESCHEMA) && (thisOutFile = new File(new URL(systemId).toURI())).getAbsolutePath().startsWith(this.getSourceFolderAbsolutePath());
    }

    private Entity findExternalEntity(String publicId, String systemId) {
        if (publicId == null && systemId == null) {
            return null;
        }
        for (Entity entity : this.externalEntities) {
            if (entity.isInternal() || !StringUtil.equal(publicId, entity.getPublicId()) || !StringUtil.equal(systemId, entity.getSystemId())) continue;
            return entity;
        }
        return null;
    }

    private void doStartEntity(String name) {
        if (this.inDTD) {
            return;
        }
        this.internalEntityStarted = this.internalEntities.get(name);
    }

    private void doEndEntity(String name) throws SAXException, TranslationException, IOException {
        if (this.inDTD || this.extEntity == null) {
            return;
        }
        if (this.extEntity.getOriginalName().equals(name)) {
            boolean parameterEntiry = this.extEntity.isParameter();
            this.extEntity = null;
            this.translateAndFlush();
            this.extWriter.close();
            this.extWriter = null;
            if (parameterEntiry) {
                this.mainWriter.write(name + ";");
            } else {
                this.mainWriter.write("&" + name + ";");
            }
        }
    }

    public InputSource doResolve(String publicId, String systemId) throws SAXException, TranslationException, IOException, URISyntaxException {
        if (this.dtd != null && StringUtil.equal(publicId, this.dtd.getPublicId()) && (StringUtil.equal(systemId, this.dtd.getSystemId()) || StringUtil.equal(this.localizeSystemId(systemId), this.dtd.getSystemId()))) {
            this.inDTD = true;
        }
        if (systemId != null && (systemId.startsWith(START_JARSCHEMA) || systemId.startsWith(START_FILESCHEMA))) {
            InputSource entity = new InputSource(systemId);
            if (systemId.startsWith(START_FILESCHEMA) && !new File(new URI(systemId)).exists()) {
                entity = null;
            }
            if (entity != null) {
                if (!this.inDTD && this.outFile != null && this.isInSource(systemId) && this.extEntity == null) {
                    this.extEntity = this.findExternalEntity(publicId, this.localizeSystemId(systemId));
                    if (this.extEntity != null) {
                        this.translateAndFlush();
                        File extFile = new File(this.outFile.getParentFile(), this.localizeSystemId(systemId));
                        this.processedFiles.add(new File(this.inFile.getParent(), this.localizeSystemId(systemId)));
                        this.extWriter = this.translator.createWriter(extFile, this.context.getOutEncoding());
                        this.extWriter.write("<?xml version=\"1.0\"?>\n");
                    }
                }
                return entity;
            }
            return new InputSource(new StringReader(""));
        }
        InputSource source = this.dialect.resolveEntity(publicId, systemId);
        if (source != null) {
            return source;
        }
        return new InputSource(new StringReader(""));
    }

    private void queueText(String s) {
        if (!this.translator.isInIgnored()) {
            this.translator.text(s);
        }
        if (this.internalEntityStarted != null && s.equals(this.internalEntityStarted.getValue())) {
            this.currEntry().add(new XMLEntityText(this.internalEntityStarted));
        } else {
            XMLText text;
            Element elem;
            boolean added = false;
            if (!this.currEntry().isEmpty() && (elem = this.currEntry().get(this.currEntry().size() - 1)) instanceof XMLText && (text = (XMLText)elem).isInCDATA() == this.inCDATA) {
                this.currEntry().resetTagDetected();
                text.append(s);
                added = true;
            }
            if (!added) {
                this.currEntry().add(new XMLText(s, this.inCDATA));
            }
        }
    }

    private void queueTag(String tag, org.xml.sax.Attributes attributes) {
        Tag xmltag = null;
        XMLIntactTag intacttag = null;
        this.setTranslatableTag(tag, XMLUtils.convertAttributes(attributes));
        this.setSpacePreservingTag(XMLUtils.convertAttributes(attributes));
        if (!this.collectingIntactText()) {
            if (this.isContentBasedTag(tag, XMLUtils.convertAttributes(attributes))) {
                intacttag = new XMLContentBasedTag(this.dialect, this, tag, this.getShortcut(tag), this.dialect.getContentBasedTags().get(tag), attributes);
                xmltag = intacttag;
                this.intacttagName = tag;
                this.intacttagAttributes = XMLUtils.convertAttributes(attributes);
            } else if (this.isIntactTag(tag, XMLUtils.convertAttributes(attributes))) {
                intacttag = new XMLIntactTag(this.dialect, this, tag, this.getShortcut(tag), attributes);
                xmltag = intacttag;
                this.intacttagName = tag;
                this.intacttagAttributes = XMLUtils.convertAttributes(attributes);
            }
        }
        if (xmltag == null) {
            xmltag = new XMLTag(tag, this.getShortcut(tag), Tag.Type.BEGIN, attributes, this.translator.getTargetLanguage());
            this.xmlTagName.push(xmltag.getTag());
            this.xmlTagAttributes.push(xmltag.getAttributes());
        }
        this.currEntry().add(xmltag);
        if (intacttag != null) {
            this.intacttagEntry = intacttag.getIntactContents();
        }
        if (!this.collectingIntactText()) {
            for (int i = 0; i < xmltag.getAttributes().size(); ++i) {
                Attribute attr = xmltag.getAttributes().get(i);
                if (!this.dialect.getTranslatableAttributes().contains(attr.getName()) && !this.dialect.getTranslatableTagAttributes().containsPair(tag, attr.getName()) || !this.dialect.validateTranslatableTagAttribute(tag, attr.getName(), xmltag.getAttributes()).booleanValue()) continue;
                attr.setValue(StringUtil.makeValidXML(this.translator.translate(StringUtil.unescapeXMLEntities(attr.getValue()), null)));
            }
        }
    }

    private void queueIgnoredTag(String tag, org.xml.sax.Attributes attributes) {
        XMLTag xmltag = null;
        this.setSpacePreservingTag(XMLUtils.convertAttributes(attributes));
        if (xmltag == null) {
            xmltag = new XMLTag(tag, this.getShortcut(tag), Tag.Type.BEGIN, attributes, this.translator.getTargetLanguage());
            this.xmlTagName.push(xmltag.getTag());
            this.xmlTagAttributes.push(xmltag.getAttributes());
        }
        this.currEntry().add(xmltag);
    }

    private void queueEndTag(String tag) {
        int len = this.currEntry().size();
        if (len > 0 && this.currEntry().get(len - 1) instanceof XMLTag && ((XMLTag)this.currEntry().get(len - 1)).getTag().equals(tag) && ((XMLTag)this.currEntry().get(len - 1)).getType() == Tag.Type.BEGIN && !this.isClosingTagRequired()) {
            if (((XMLTag)this.currEntry().get(len - 1)).getTag().equals(this.xmlTagName.lastElement())) {
                this.xmlTagName.pop();
                this.xmlTagAttributes.pop();
            }
            ((XMLTag)this.currEntry().get(len - 1)).setType(Tag.Type.ALONE);
        } else {
            XMLTag xmltag = new XMLTag(tag, this.getShortcut(tag), Tag.Type.END, null, this.translator.getTargetLanguage());
            if (xmltag.getTag().equals(this.xmlTagName.lastElement())) {
                this.xmlTagName.pop();
                xmltag.setStartAttributes(this.xmlTagAttributes.pop());
            }
            this.currEntry().add(xmltag);
        }
    }

    private void queueComment(String comment) {
        if (!this.translator.isInIgnored()) {
            this.translator.comment(comment);
        }
        this.currEntry().add(new Comment(comment));
    }

    private void queueProcessingInstruction(String data, String target) {
        this.currEntry().add(new ProcessingInstruction(data, target));
    }

    private void queueDTD(DTD dtd) {
        this.currEntry().add(dtd);
    }

    private void start(String tag, org.xml.sax.Attributes attributes) throws SAXException, TranslationException {
        boolean prevIgnored = this.translator.isInIgnored();
        this.translatorTagStart(tag, attributes);
        if (!this.translator.isInIgnored()) {
            if (this.isOutOfTurnTag(tag)) {
                XMLOutOfTurnTag ootTag = new XMLOutOfTurnTag(this.dialect, this, tag, this.getShortcut(tag), attributes);
                this.currEntry().add(ootTag);
                this.outofturnEntries.push(ootTag.getEntry());
            } else {
                if (this.isParagraphTag(tag, XMLUtils.convertAttributes(attributes)) && !this.collectingOutOfTurnText() && !this.collectingIntactText()) {
                    this.translateAndFlush();
                }
                this.queueTag(tag, attributes);
            }
        } else {
            if (!prevIgnored) {
                this.translateAndFlush();
            }
            this.queueIgnoredTag(tag, attributes);
        }
    }

    private void end(String tag) throws SAXException, TranslationException {
        boolean prevIgnored = this.translator.isInIgnored();
        if (!this.translator.isInIgnored()) {
            if (this.collectingIntactText() && tag.equals(this.intacttagName) && (this.isIntactTag(tag, null) || this.isContentBasedTag(tag, null))) {
                this.intacttagEntry = null;
                this.intacttagName = null;
                this.intacttagAttributes = null;
                this.removeTranslatableTag();
            } else if (this.collectingOutOfTurnText() && this.isOutOfTurnTag(tag)) {
                this.translateButDontFlash();
                this.outofturnEntries.pop();
            } else {
                this.queueEndTag(tag);
                if (this.isParagraphTag(tag) && !this.collectingOutOfTurnText() && !this.collectingIntactText()) {
                    this.translateAndFlush();
                }
                this.removeTranslatableTag();
            }
        } else {
            this.queueEndTag(tag);
        }
        this.translatorTagEnd(tag);
        if (!this.translator.isInIgnored() && prevIgnored) {
            this.flushButDontTranslate();
        }
    }

    private void translateButDontFlash() throws TranslationException {
        if (this.currEntry().isEmpty()) {
            return;
        }
        ArrayList<ProtectedPart> shortcutDetails = new ArrayList<ProtectedPart>();
        boolean tagsAggregation = this.isTagsAggregationEnabled();
        String src = this.currEntry().sourceToShortcut(tagsAggregation, this.dialect, shortcutDetails);
        Element lead = this.currEntry().get(0);
        String translation = src;
        if (lead instanceof Tag && (this.isPreformattingTag(((Tag)lead).getTag(), ((Tag)lead).getAttributes()) || this.isSpacePreservingTag()) && this.isTranslatableTag() && !StringUtil.isEmpty(src)) {
            this.resetSpacePreservingTag();
            translation = this.translator.translate(src, shortcutDetails);
        } else {
            String compressed = src;
            if (Core.getFilterMaster().getConfig().isRemoveSpacesNonseg()) {
                compressed = StringUtil.compressSpaces(src);
            }
            if (this.isTranslatableTag()) {
                translation = this.translator.translate(compressed, shortcutDetails);
            }
            if (compressed.equals(translation)) {
                translation = src;
            }
        }
        this.currEntry().setTranslation(translation, this.dialect, new ArrayList<ProtectedPart>());
    }

    private void translateAndFlush() throws SAXException, TranslationException {
        this.translateButDontFlash();
        try {
            this.currWriter().write(this.currEntry().translationToOriginal());
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
        this.currEntry().clear();
    }

    private void flushButDontTranslate() throws SAXException, TranslationException {
        try {
            this.currWriter().write(this.currEntry().translationToOriginal());
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
        this.currEntry().clear();
    }

    private boolean isParagraphTag(String tag, Attributes atts) {
        this.paragraphTagName.push(tag);
        this.paragraphTagAttributes.push(atts);
        this.preformatTagName.push(tag);
        this.preformatTagAttributes.push(atts);
        if (this.dialect.getParagraphTags() != null && this.dialect.getParagraphTags().contains(tag) || this.isPreformattingTag(tag, atts)) {
            return true;
        }
        return this.dialect.validateParagraphTag(tag, atts);
    }

    private boolean isParagraphTag(String tag) {
        if (this.dialect.getParagraphTags() != null && this.dialect.getParagraphTags().contains(tag) || this.isPreformattingTag(tag)) {
            return true;
        }
        Attributes atts = null;
        if (tag.equals(this.paragraphTagName.lastElement())) {
            this.paragraphTagName.pop();
            atts = this.paragraphTagAttributes.pop();
        }
        return this.dialect.validateParagraphTag(tag, atts);
    }

    public boolean isParagraphTag(Tag tag) {
        if (this.dialect.getParagraphTags() != null && this.dialect.getParagraphTags().contains(tag.getTag()) || this.isPreformattingTag(tag.getTag(), tag.getAttributes())) {
            return true;
        }
        if (tag.getType() == Tag.Type.END && this.isPreformattingTag(tag.getTag(), tag.getStartAttributes())) {
            return true;
        }
        return this.dialect.validateParagraphTag(tag.getTag(), tag.getAttributes());
    }

    private boolean isContentBasedTag(String tag, Attributes atts) {
        if (this.dialect.getContentBasedTags() != null && this.dialect.getContentBasedTags().containsKey(tag)) {
            return true;
        }
        if (atts == null && tag.equals(this.intacttagName)) {
            atts = this.intacttagAttributes;
        }
        return this.dialect.validateContentBasedTag(tag, atts);
    }

    private boolean isPreformattingTag(String tag, Attributes atts) {
        if (this.dialect.getPreformatTags() != null && this.dialect.getPreformatTags().contains(tag)) {
            return true;
        }
        return this.dialect.validatePreformatTag(tag, atts);
    }

    private boolean isPreformattingTag(String tag) {
        if (this.dialect.getPreformatTags() != null && this.dialect.getPreformatTags().contains(tag)) {
            return true;
        }
        Attributes atts = null;
        if (tag.equals(this.preformatTagName.lastElement())) {
            this.preformatTagName.pop();
            atts = this.preformatTagAttributes.pop();
        }
        return this.dialect.validatePreformatTag(tag, atts);
    }

    private boolean isIntactTag(String tag, Attributes atts) {
        if (this.dialect.getIntactTags() != null && this.dialect.getIntactTags().contains(tag)) {
            return true;
        }
        if (atts == null && tag.equals(this.intacttagName)) {
            atts = this.intacttagAttributes;
        }
        return this.dialect.validateIntactTag(tag, atts);
    }

    void setTranslatableTag(String tag, Attributes atts) {
        if (!this.isTranslatableTag()) {
            if (this.dialect.validateTranslatableTag(tag, atts).booleanValue()) {
                this.translatableTagName.push(tag);
            }
        } else {
            this.translatableTagName.push(tag);
        }
    }

    void removeTranslatableTag() {
        if (this.isTranslatableTag()) {
            this.translatableTagName.pop();
        }
    }

    private void translatorTagStart(String tag, org.xml.sax.Attributes atts) {
        this.currentTagPath.push(tag);
        this.translator.tagStart(this.constructCurrentPath(), atts);
    }

    private void translatorTagEnd(String tag) {
        this.translator.tagEnd(this.constructCurrentPath());
        while (!this.currentTagPath.pop().equals(tag)) {
        }
    }

    private String constructCurrentPath() {
        StringBuilder path = new StringBuilder(256);
        for (String t : this.currentTagPath) {
            path.append('/').append(t);
        }
        return path.toString();
    }

    private void setSpacePreservingTag(Attributes atts) {
        if (this.isSpacePreservingSet(atts)) {
            this.spacePreserve = true;
        }
    }

    private boolean isClosingTagRequired() {
        return this.dialect.getClosingTagRequired();
    }

    private boolean isTagsAggregationEnabled() {
        return this.dialect.getTagsAggregationEnabled();
    }

    private boolean isOutOfTurnTag(String tag) {
        return this.dialect.getOutOfTurnTags() != null && this.dialect.getOutOfTurnTags().contains(tag);
    }

    private String getShortcut(String tag) {
        if (this.dialect.getShortcuts() != null) {
            return this.dialect.getShortcuts().get(tag);
        }
        return null;
    }

    private boolean isSpacePreservingSet(Attributes currentAttributes) {
        if (this.dialect.getForceSpacePreserving().booleanValue()) {
            return true;
        }
        boolean preserve = false;
        for (int i = 0; i < currentAttributes.size(); ++i) {
            Attribute oneAttribute = currentAttributes.get(i);
            if (!oneAttribute.getName().equalsIgnoreCase("xml:space") || !oneAttribute.getValue().equalsIgnoreCase("preserve")) continue;
            preserve = true;
        }
        return preserve;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        try {
            return this.doResolve(publicId, systemId);
        }
        catch (URISyntaxException e) {
            throw new SAXException(e);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
        catch (TranslationException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, org.xml.sax.Attributes attributes) throws SAXException {
        try {
            this.start(qName, attributes);
        }
        catch (TranslationException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            this.end(qName);
        }
        catch (TranslationException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.inDTD) {
            return;
        }
        this.queueText(new String(ch, start, length));
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.inDTD) {
            return;
        }
        this.queueText(new String(ch, start, length));
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        if (this.inDTD) {
            return;
        }
        this.queueComment(new String(ch, start, length));
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        if (this.inDTD) {
            return;
        }
        this.queueProcessingInstruction(target, data);
    }

    @Override
    public void startDocument() throws SAXException {
        try {
            this.mainWriter.write("<?xml version=\"1.0\"?>\n");
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
        this.entry = new Entry(this.dialect, this);
    }

    @Override
    public void endDocument() throws SAXException {
        try {
            this.translateAndFlush();
            if (this.extWriter != null) {
                this.extWriter.close();
                this.extWriter = null;
            }
            this.translateAndFlush();
            this.currWriter().close();
        }
        catch (TranslationException e) {
            throw new SAXException(e);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        try {
            this.reportFatalError(e);
        }
        catch (MalformedURLException ex) {
            throw new SAXException(ex);
        }
        catch (URISyntaxException ex) {
            throw new SAXException(ex);
        }
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        this.dtd = new DTD(name, publicId, systemId);
    }

    @Override
    public void endDTD() throws SAXException {
        this.queueDTD(this.dtd);
        this.inDTD = false;
        this.dtd = null;
    }

    @Override
    public void startCDATA() throws SAXException {
        this.inCDATA = true;
    }

    @Override
    public void endCDATA() throws SAXException {
        this.inCDATA = false;
    }

    @Override
    public void startEntity(String name) throws SAXException {
        this.doStartEntity(name);
    }

    @Override
    public void endEntity(String name) throws SAXException {
        try {
            this.doEndEntity(name);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
        catch (TranslationException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void internalEntityDecl(String name, String value) throws SAXException {
        if (this.inDTD) {
            return;
        }
        Entity entity = new Entity(name, value);
        this.internalEntities.put(name, entity);
        this.dtd.addEntity(entity);
    }

    @Override
    public void externalEntityDecl(String name, String publicId, String systemId) throws SAXException {
        if (this.inDTD) {
            return;
        }
        try {
            Entity entity = new Entity(name, publicId, this.localizeSystemId(systemId));
            if (this.isInSource(systemId)) {
                this.externalEntities.add(entity);
            }
            this.dtd.addEntity(entity);
        }
        catch (MalformedURLException ex) {
            throw new SAXException(ex);
        }
        catch (URISyntaxException ex) {
            throw new SAXException(ex);
        }
    }

    @Override
    public void elementDecl(String name, String model) {
    }

    @Override
    public void attributeDecl(String eName, String aName, String type, String valueDefault, String value) {
    }
}

