/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters4.xml.xliff;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.omegat.core.Core;
import org.omegat.core.data.EntryKey;
import org.omegat.core.data.IProject;
import org.omegat.core.data.ITMXEntry;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.filters2.FilterContext;
import org.omegat.filters2.Instance;
import org.omegat.filters4.xml.xliff.Xliff1Filter;
import org.omegat.util.Preferences;

public class SdlXliff
extends Xliff1Filter {
    private String currentMid = null;
    private Map<String, StringBuffer> sdlComments = new HashMap<String, StringBuffer>();
    private StringBuffer commentBuf = null;
    private Map<UUID, String> omegatNotes = new HashMap<UUID, String>();
    private Map<String, UUID> defaultNoteLocations = new HashMap<String, UUID>();
    private Map<EntryKey, UUID> altNoteLocations = new HashMap<EntryKey, UUID>();
    private Map<String, StringBuffer> tagDefs = new WeakHashMap<String, StringBuffer>();
    private String currentTagId = null;
    private Map<String, StringBuffer> segProps = new HashMap<String, StringBuffer>();
    private String currentProp = null;
    private Set<String> midSet = new HashSet<String>();
    private boolean has_seg_defs = false;
    private static final Pattern OUT_PTN = Pattern.compile("(\\w) id=\"([\\d\\w\\-]+)\"");
    private static final Pattern IN_PTN1 = Pattern.compile("<cf (italic|bold|strong|size)=True");
    private static final Pattern IN_PTN2 = Pattern.compile("name=(italic|bold|strong|size)");
    private final SimpleDateFormat TRADOS_DATE_FORMAT = new SimpleDateFormat("M/d/y H:m:s");

    @Override
    public String getFileFormatName() {
        return "SDL-Xliff";
    }

    @Override
    public Instance[] getDefaultInstances() {
        return new Instance[]{new Instance("*.sdlxliff")};
    }

    @Override
    public boolean isFileSupported(File inFile, Map<String, String> config, FilterContext context) {
        try {
            StartElement el = this.findEvent(inFile, Pattern.compile(".*/.*:xliff"));
            if (el == null) {
                return false;
            }
            this.namespace = el.getName().getNamespaceURI();
            if (el.getAttributeByName(new QName("http://sdl.com/FileTypes/SdlXliff/1.0", "version")) != null) {
                return true;
            }
            return super.isFileSupported(inFile, config, context);
        }
        catch (Exception npe) {
            return false;
        }
    }

    @Override
    protected void checkCurrentCursorPosition(XMLStreamReader reader, boolean doWrite) {
        if (reader.getEventType() == 1) {
            String name = reader.getLocalName();
            if (name.equals("cmt-defs")) {
                this.isEventMode = true;
            }
            if (name.equals("tag")) {
                this.currentTagId = reader.getAttributeValue(null, "id");
                this.tagDefs.put(this.currentTagId, new StringBuffer());
            }
            if (this.currentTagId != null) {
                StringBuffer buf = this.tagDefs.get(this.currentTagId);
                buf.append("<").append(name);
                int len = reader.getAttributeCount();
                for (int i = 0; i < len; ++i) {
                    buf.append(" ").append(reader.getAttributeLocalName(i)).append("=").append(reader.getAttributeValue(i));
                }
                buf.append(">");
            }
        } else if (reader.getEventType() == 4) {
            if (this.currentTagId != null) {
                this.tagDefs.get(this.currentTagId).append(reader.getText());
            }
        } else if (reader.getEventType() == 2) {
            if (reader.getLocalName().equals("tag")) {
                this.currentTagId = null;
            }
            if (this.currentTagId != null) {
                this.tagDefs.get(this.currentTagId).append("</").append(reader.getLocalName()).append(">");
            }
        }
        super.checkCurrentCursorPosition(reader, doWrite);
    }

    @Override
    protected boolean processStartElement(StartElement startElement, XMLStreamWriter writer) throws XMLStreamException {
        if (startElement.getName().getLocalPart().equals("cmt-def")) {
            this.commentBuf = new StringBuffer();
            this.sdlComments.put(startElement.getAttributeByName(new QName("id")).getValue(), this.commentBuf);
            return true;
        }
        if (startElement.getName().getLocalPart().equals("mrk")) {
            if (startElement.getAttributeByName(new QName("mtype")).getValue().equals("seg")) {
                this.currentMid = startElement.getAttributeByName(new QName("mid")).getValue();
                this.midSet.add(this.currentMid);
            } else if (startElement.getAttributeByName(new QName("mtype")).getValue().equals("x-sdl-comment")) {
                String id = startElement.getAttributeByName(new QName("http://sdl.com/FileTypes/SdlXliff/1.0", "cid")).getValue();
                this.addNoteFromSource(this.currentMid, this.sdlComments.get(id).toString());
            }
        }
        if (startElement.getName().equals("tag-defs")) {
            this.isEventMode = false;
        }
        if (startElement.getName().equals(new QName("http://sdl.com/FileTypes/SdlXliff/1.0", "seg"))) {
            this.segProps.clear();
            this.currentProp = null;
            this.has_seg_defs = true;
            Attribute mid = startElement.getAttributeByName(new QName("id"));
            if (mid != null) {
                this.currentMid = mid.getValue();
            }
            if (writer != null) {
                this.fromEventToWriter(eFactory.createStartElement(startElement.getName(), null, startElement.getNamespaces()), writer);
                Iterator<Attribute> I = startElement.getAttributes();
                while (I.hasNext()) {
                    ITMXEntry entry;
                    Attribute A = I.next();
                    if (!A.getName().getLocalPart().equals("conf")) {
                        writer.writeAttribute(A.getName().getPrefix(), A.getName().getNamespaceURI(), A.getName().getLocalPart(), A.getValue());
                        continue;
                    }
                    if (mid == null) {
                        writer.writeAttribute("conf", A.getValue());
                        continue;
                    }
                    String value = "Translated";
                    if (Core.getMainWindow() != null && Core.getMainWindow().getMainMenu().getRevisionMenuItem().isSelected() && (entry = this.currentEntryTranslation(mid.getValue())).getPropValue("revisor") != null) {
                        value = "ApprovedTranslation";
                    }
                    writer.writeAttribute("conf", value);
                }
                return false;
            }
        }
        if (startElement.getName().equals(new QName("http://sdl.com/FileTypes/SdlXliff/1.0", "value"))) {
            this.currentProp = startElement.getAttributeByName(new QName("key")).getValue();
            this.commentBuf = new StringBuffer();
            this.segProps.put(this.currentProp, this.commentBuf);
        }
        if (startElement.getName().getLocalPart().equals("trans-unit")) {
            this.has_seg_defs = false;
        }
        return super.processStartElement(startElement, writer);
    }

    @Override
    protected boolean processEndElement(EndElement endElement, XMLStreamWriter writer) throws XMLStreamException {
        if (endElement.getName().equals(new QName("http://sdl.com/FileTypes/SdlXliff/1.0", "value"))) {
            this.commentBuf = null;
            this.currentProp = null;
        }
        if (endElement.getName().getLocalPart().equals("seg")) {
            ITMXEntry entry = this.currentEntryTranslation(this.currentMid);
            this.midSet.remove(this.currentMid);
            this.currentMid = null;
            if (writer != null && entry != null) {
                if (this.segProps.get("last_modified_by") == null) {
                    writer.writeStartElement("http://sdl.com/FileTypes/SdlXliff/1.0", "value");
                    writer.writeAttribute("key", "last_modified_by");
                    writer.writeCharacters(entry.getChanger() != null ? entry.getChanger() : Preferences.getPreferenceDefault("team_Author", System.getProperty("user.name")));
                    writer.writeEndElement();
                }
                if (this.segProps.get("modified_on") == null) {
                    writer.writeStartElement("http://sdl.com/FileTypes/SdlXliff/1.0", "value");
                    writer.writeAttribute("key", "modified_on");
                    writer.writeCharacters(this.TRADOS_DATE_FORMAT.format(entry.getChangeDate() != 0L ? new Date(entry.getChangeDate()) : new Date()));
                    writer.writeEndElement();
                }
            }
        }
        if (endElement.getName().getLocalPart().equals("trans-unit")) {
            if (writer != null) {
                if (this.midSet.size() > 0 && !this.has_seg_defs) {
                    writer.writeStartElement("sdl", "http://sdl.com/FileTypes/SdlXliff/1.0", "seg-defs");
                }
                for (String mid0 : this.midSet) {
                    writer.writeStartElement("http://sdl.com/FileTypes/SdlXliff/1.0", "seg");
                    writer.writeAttribute("id", mid0);
                    ITMXEntry entry = this.currentEntryTranslation(this.currentMid);
                    if (entry != null) {
                        String value = "Translated";
                        if (Core.getMainWindow() != null && Core.getMainWindow().getMainMenu().getRevisionMenuItem().isSelected() && entry.getPropValue("revisor") != null) {
                            value = "ApprovedTranslation";
                        }
                        writer.writeAttribute("conf", value);
                        writer.writeStartElement("http://sdl.com/FileTypes/SdlXliff/1.0", "value");
                        writer.writeAttribute("key", "last_modified_by");
                        writer.writeCharacters(entry.getChanger() != null ? entry.getChanger() : Preferences.getPreferenceDefault("team_Author", System.getProperty("user.name")));
                        writer.writeEndElement();
                        writer.writeStartElement("http://sdl.com/FileTypes/SdlXliff/1.0", "value");
                        writer.writeAttribute("key", "modified_on");
                        writer.writeCharacters(this.TRADOS_DATE_FORMAT.format(entry.getChangeDate() != 0L ? new Date(entry.getChangeDate()) : new Date()));
                        writer.writeEndElement();
                    }
                    writer.writeStartElement("sdl", "http://sdl.com/FileTypes/SdlXliff/1.0", "seg");
                }
                if (this.midSet.size() > 0 && !this.has_seg_defs) {
                    writer.writeEndElement();
                }
            }
            this.midSet.clear();
        }
        if (endElement.getName().getLocalPart().equals("seg-value")) {
            this.commentBuf = null;
        }
        if (endElement.getName().getLocalPart().equals("tag")) {
            this.currentBuffer = null;
        }
        if (endElement.getName().getLocalPart().equals("cmt-def")) {
            this.commentBuf = null;
        }
        if (endElement.getName().getLocalPart().equals("cmt-defs")) {
            this.isEventMode = false;
            if (writer != null) {
                IProject proj = Core.getProject();
                proj.iterateByDefaultTranslations((source, trans) -> {
                    if (!trans.hasNote()) {
                        return;
                    }
                    UUID id = UUID.randomUUID();
                    this.omegatNotes.put(id, trans.note);
                    this.defaultNoteLocations.put(source, id);
                    SdlXliff.createSdlNote(id, trans, writer);
                });
                proj.iterateByMultipleTranslations((key, trans) -> {
                    if (!trans.hasNote()) {
                        return;
                    }
                    UUID id = UUID.randomUUID();
                    this.omegatNotes.put(id, trans.note);
                    this.altNoteLocations.put(key, id);
                    SdlXliff.createSdlNote(id, trans, writer);
                });
            }
        }
        if (endElement.getName().getLocalPart().equals("tag-defs")) {
            this.isEventMode = false;
            if (writer != null) {
                for (String type : new String[]{"italic", "bold", "underline", "superscript", "subscript"}) {
                    if (this.tagDefs.get("omegat-" + type) != null) continue;
                    writer.writeStartElement("http://sdl.com/FileTypes/SdlXliff/1.0", "tag");
                    writer.writeAttribute("id", "omegat-" + type);
                    writer.writeStartElement("http://sdl.com/FileTypes/SdlXliff/1.0", "bpt");
                    writer.writeAttribute("name", "cf");
                    writer.writeAttribute("word-end", "false");
                    writer.writeAttribute("can-hide", "true");
                    writer.writeCharacters("<cf " + type + "=\"true\">");
                    writer.writeEndElement();
                    writer.writeStartElement("http://sdl.com/FileTypes/SdlXliff/1.0", "ept");
                    writer.writeAttribute("name", "cf");
                    writer.writeAttribute("word-end", "false");
                    writer.writeAttribute("can-hide", "true");
                    writer.writeCharacters("</cf>");
                    writer.writeEndElement();
                    writer.writeEndElement();
                }
            }
        }
        return super.processEndElement(endElement, writer);
    }

    @Override
    protected boolean isUntaggedTag(StartElement stEl) {
        return stEl.getName().equals(new QName("urn:oasis:names:tc:xliff:document:1.2", "mrk")) && (stEl.getAttributeByName(new QName("mtype")).getValue().equals("x-sdl-comment") || stEl.getAttributeByName(new QName("mtype")).getValue().equals("x-sdl-added")) || super.isUntaggedTag(stEl);
    }

    @Override
    protected boolean isDeletedTag(StartElement stEl) {
        return stEl.getName().equals(new QName("urn:oasis:names:tc:xliff:document:1.2", "mrk")) && stEl.getAttributeByName(new QName("mtype")).getValue().equals("x-sdl-deleted") || super.isUntaggedTag(stEl);
    }

    @Override
    protected char findPrefix(StartElement stEl) {
        if (stEl.getName().getLocalPart().equals("g")) {
            try {
                String txt = this.tagDefs.get(stEl.getAttributeByName(new QName("id")).getValue()).toString();
                if (txt.contains("italic=True") && !txt.contains("bold=True") && !txt.contains("strong=True")) {
                    return 'i';
                }
                if (!txt.contains("italic=True") && (txt.contains("bold=True") || txt.contains("strong=True"))) {
                    return 'b';
                }
                if (txt.contains("<bpt name=italic") || txt.contains("<ept name=italic")) {
                    return 'i';
                }
                if (txt.contains("<bpt name=bold") || txt.contains("<ept name=bold")) {
                    return 'b';
                }
                if (txt.contains("<bpt name=strong") || txt.contains("<ept name=strong")) {
                    return 'b';
                }
                if (txt.contains("size")) {
                    return 's';
                }
                if (txt.contains("color")) {
                    return 'c';
                }
                if (txt.contains("footnote")) {
                    return 'n';
                }
                if (txt.contains("<cf")) {
                    return 'f';
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return super.findPrefix(stEl);
    }

    @Override
    protected String buildProtectedPartDetails(List<XMLEvent> saved) {
        String base = super.buildProtectedPartDetails(saved);
        Matcher matcher = OUT_PTN.matcher(base);
        if (matcher.find()) {
            if (!this.tagDefs.containsKey(matcher.group(2))) {
                return base;
            }
            String text = this.tagDefs.get(matcher.group(2)).toString();
            Matcher inMatcher = IN_PTN1.matcher(text);
            if (inMatcher.find()) {
                return inMatcher.group(1);
            }
            inMatcher = IN_PTN2.matcher(text);
            if (inMatcher.find()) {
                return inMatcher.group(1);
            }
            return base + ">\n" + text;
        }
        return base;
    }

    @Override
    public boolean isUsingStandardNote() {
        return false;
    }

    private static void createSdlNote(UUID id, TMXEntry trans, XMLStreamWriter writer) {
        try {
            writer.writeStartElement("http://sdl.com/FileTypes/SdlXliff/1.0", "cmt-def");
            writer.writeAttribute("id", id.toString());
            writer.writeStartElement("http://sdl.com/FileTypes/SdlXliff/1.0", "Comments");
            writer.writeStartElement("http://sdl.com/FileTypes/SdlXliff/1.0", "Comment");
            writer.writeCharacters(trans.note);
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeEndElement();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected boolean processCharacters(Characters event, XMLStreamWriter writer) throws XMLStreamException {
        if (this.commentBuf != null) {
            this.commentBuf.append(event.toString());
            if (this.currentMid != null) {
                ITMXEntry entry = this.currentEntryTranslation(this.currentMid);
                if (writer != null && entry != null) {
                    if ("last_modified_by".equals(this.currentProp)) {
                        writer.writeCharacters(entry.getChanger() != null ? entry.getChanger() : Preferences.getPreferenceDefault("team_Author", System.getProperty("user.name")));
                        return false;
                    }
                    if ("modified_on".equals(this.currentProp)) {
                        writer.writeCharacters(this.TRADOS_DATE_FORMAT.format(entry.getChangeDate() != 0L ? new Date(entry.getChangeDate()) : new Date()));
                        return false;
                    }
                }
            }
        }
        return super.processCharacters(event, writer);
    }

    @Override
    protected List<XMLEvent> restoreTags(String unitId, String path, String src, String tra) {
        List<XMLEvent> res = super.restoreTags(unitId, path, src, tra);
        EntryKey key = new EntryKey("", src, unitId, null, null, path);
        UUID addNote = null;
        if (this.altNoteLocations.get(key) != null) {
            addNote = this.altNoteLocations.get(key);
        } else if (this.defaultNoteLocations.get(src) != null) {
            addNote = this.defaultNoteLocations.get(src);
        }
        if (addNote != null && this.omegatNotes.get(addNote) != null) {
            LinkedList<Attribute> attr = new LinkedList<Attribute>();
            attr.add(eFactory.createAttribute("sdl", "http://sdl.com/FileTypes/SdlXliff/1.0", "cid", addNote.toString()));
            attr.add(eFactory.createAttribute(new QName("mtype"), "x-sdl-comment"));
            res.add(0, eFactory.createStartElement(new QName("urn:oasis:names:tc:xliff:document:1.2", "mrk"), attr.iterator(), null));
            res.add(eFactory.createEndElement(new QName("urn:oasis:names:tc:xliff:document:1.2", "mrk"), null));
        }
        return res;
    }

    @Override
    public StartElement createAddTagElement(char type, int idx) {
        List<Object> attrs = Collections.emptyList();
        switch (type) {
            case '\u2460': {
                attrs = Collections.singletonList(eFactory.createAttribute(new QName("id"), "omegat-italic"));
                break;
            }
            case '\u2461': {
                attrs = Collections.singletonList(eFactory.createAttribute(new QName("id"), "omegat-bold"));
                break;
            }
            case '\u2462': {
                attrs = Collections.singletonList(eFactory.createAttribute(new QName("id"), "omegat-underline"));
                break;
            }
            case '\u2463': {
                attrs = Collections.singletonList(eFactory.createAttribute(new QName("id"), "omegat-superscript"));
                break;
            }
            case '\u2464': {
                attrs = Collections.singletonList(eFactory.createAttribute(new QName("id"), "omegat-subscript"));
            }
        }
        return eFactory.createStartElement(new QName("urn:oasis:names:tc:xliff:document:1.2", "g"), attrs.iterator(), null);
    }

    @Override
    protected boolean isToIgnore(String src, String tra) {
        if (tra == null) {
            return false;
        }
        while (src.startsWith("<")) {
            src = src.substring(Math.max(1, src.indexOf(">") + 1));
        }
        while (tra.startsWith("<")) {
            tra = tra.substring(Math.max(1, tra.indexOf(">") + 1));
        }
        return src.length() == 0 && tra.length() == 0;
    }

    @Override
    protected SourceTextEntry.SourceTranslationInfo buildTranlsationInfo(String tra, String note) {
        long creationDate = 0L;
        long changeDate = 0L;
        StringBuffer buf = this.segProps.get("created_by");
        String creator = buf == null ? null : buf.toString();
        try {
            creationDate = this.TRADOS_DATE_FORMAT.parse(this.segProps.get("created_on").toString()).getTime();
        }
        catch (Exception exception) {
            // empty catch block
        }
        buf = this.segProps.get("last_modified_by");
        String changer = buf == null ? null : buf.toString();
        try {
            changeDate = this.TRADOS_DATE_FORMAT.parse(this.segProps.get("modified_on").toString()).getTime();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (creator == null) {
            creator = changer;
        }
        if (changer != null) {
            return new SourceTextEntry.SourceTranslationEntry(tra, note, false, creator, creationDate, changer, changeDate);
        }
        return super.buildTranlsationInfo(tra, note);
    }

    @Override
    protected boolean isStandardTranslationState() {
        return false;
    }
}

