/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.editor;

import java.awt.Font;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.Position;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import org.omegat.gui.editor.EditorController;
import org.omegat.util.gui.Styles;

public class Document3
extends DefaultStyledDocument {
    protected final EditorController controller;
    Position activeTranslationBeginM1;
    Position activeTranslationEndP1;
    int infoStart;
    int infoEnd;
    protected boolean trustedChangesInProgress = false;
    protected boolean textBeingComposed = false;

    public Document3(EditorController controller) {
        this.controller = controller;
        Style defaultStyle = this.getDefaultStyle();
        StyleConstants.setForeground(defaultStyle, Styles.EditorColor.COLOR_FOREGROUND.getColor());
        StyleConstants.setBackground(defaultStyle, Styles.EditorColor.COLOR_BACKGROUND.getColor());
        this.setFont(controller.font);
    }

    private Style getDefaultStyle() {
        StyleContext styleContext = (StyleContext)this.getAttributeContext();
        return styleContext.getStyle("default");
    }

    void setFont(Font font) {
        Style defaultStyle = this.getDefaultStyle();
        StyleConstants.setFontFamily(defaultStyle, font.getFamily());
        StyleConstants.setFontSize(defaultStyle, font.getSize());
        StyleConstants.setBold(defaultStyle, font.isBold());
        StyleConstants.setItalic(defaultStyle, font.isItalic());
    }

    public int getTranslationStart() {
        return this.activeTranslationBeginM1.getOffset() + 1;
    }

    public int getTranslationEnd() {
        return this.activeTranslationEndP1.getOffset() - 1;
    }

    boolean isEditMode() {
        return this.activeTranslationBeginM1 != null && this.activeTranslationEndP1 != null;
    }

    void stopEditMode() {
        this.activeTranslationBeginM1 = null;
        this.activeTranslationEndP1 = null;
    }

    String extractTranslation() {
        if (!this.isEditMode()) {
            return null;
        }
        int start = this.getTranslationStart();
        int end = this.getTranslationEnd();
        try {
            return this.getText(start, end - start);
        }
        catch (BadLocationException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setAlignment(int beginOffset, int endOffset, boolean isRightAlignment) {
        try {
            this.writeLock();
            AbstractDocument.DefaultDocumentEvent changes = new AbstractDocument.DefaultDocumentEvent(this, beginOffset, endOffset - beginOffset, DocumentEvent.EventType.CHANGE);
            Element root = this.getDefaultRootElement();
            int parBeg = root.getElementIndex(beginOffset);
            int parEnd = root.getElementIndex(endOffset - 1);
            for (int par = parBeg; par <= parEnd; ++par) {
                Element el = root.getElement(par);
                MutableAttributeSet attr = (MutableAttributeSet)el.getAttributes();
                attr.addAttribute(StyleConstants.Alignment, isRightAlignment ? 2 : 0);
            }
            changes.end();
            this.fireChangedUpdate(changes);
        }
        finally {
            this.writeUnlock();
        }
    }

    public static enum ORIENTATION {
        ALL_LTR,
        ALL_RTL,
        DIFFER;

    }
}

