/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.editor;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.LinkedList;
import javax.swing.JPopupMenu;
import javax.swing.text.JTextComponent;
import org.omegat.gui.editor.SegmentBuilder;
import org.omegat.util.MultiMap;
import org.omegat.util.gui.DockingUI;

public class PopupMenuDisplayer
extends MouseAdapter {
    public final MultiMap<Integer, IPopupMenuConstructor> popupConstructors = new MultiMap(true);
    private JTextComponent receiver;

    public PopupMenuDisplayer(JTextComponent receiver) {
        this.receiver = receiver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerPopupMenuConstructors(int priority, IPopupMenuConstructor constructor) {
        MultiMap<Integer, IPopupMenuConstructor> multiMap = this.popupConstructors;
        synchronized (multiMap) {
            this.popupConstructors.put(priority, constructor);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int mousepos;
        JPopupMenu popup;
        if ((e.isPopupTrigger() || e.getButton() == 3) && (popup = this.makePopupMenu(mousepos = this.receiver.viewToModel(e.getPoint()))).getComponentCount() > 0) {
            popup.show(this.receiver, (int)e.getPoint().getX(), (int)e.getPoint().getY());
        }
    }

    public boolean isInActiveEntry(int pos) {
        return true;
    }

    public boolean isInActiveTranslation(int pos) {
        return true;
    }

    public SegmentBuilder getSegmentBuilder(int pos) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JPopupMenu makePopupMenu(int pos) {
        LinkedList<IPopupMenuConstructor> cons = new LinkedList<IPopupMenuConstructor>();
        MultiMap<Integer, IPopupMenuConstructor> multiMap = this.popupConstructors;
        synchronized (multiMap) {
            for (IPopupMenuConstructor cons0 : this.popupConstructors.values()) {
                cons.add(cons0);
            }
        }
        JPopupMenu popup = new JPopupMenu();
        for (IPopupMenuConstructor c : cons) {
            c.addItems(popup, this.receiver, pos, this.isInActiveEntry(pos), this.isInActiveTranslation(pos), this.getSegmentBuilder(pos));
        }
        DockingUI.removeUnusedMenuSeparators(popup);
        return popup;
    }

    public static interface IPopupMenuConstructor {
        public void addItems(JPopupMenu var1, JTextComponent var2, int var3, boolean var4, boolean var5, SegmentBuilder var6);
    }
}

