/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.editor;

import java.awt.Color;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.Position;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.omegat.core.Core;
import org.omegat.core.data.ProjectTMX;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.gui.editor.Document3;
import org.omegat.gui.editor.EditorController;
import org.omegat.gui.editor.EditorSettings;
import org.omegat.gui.editor.EditorUtils;
import org.omegat.gui.editor.MarkerController;
import org.omegat.gui.editor.ModificationInfoManager;
import org.omegat.util.Language;
import org.omegat.util.Log;
import org.omegat.util.OConsts;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.StringUtil;
import org.omegat.util.gui.StaticUIUtils;
import org.omegat.util.gui.Styles;
import org.omegat.util.gui.UIThreadsUtil;

public class SegmentBuilder {
    public static final String SEGMENT_MARK_ATTRIBUTE = "SEGMENT_MARK_ATTRIBUTE";
    public static final String SEGMENT_SPELL_CHECK = "SEGMENT_SPELL_CHECK";
    private static final DecimalFormat NUMBER_FORMAT = new DecimalFormat("0000");
    private static final String BIDI_LRE = "\u202a";
    private static final String BIDI_RLE = "\u202b";
    private static final String BIDI_PDF = "\u202c";
    public static final String BIDI_LRM = "\u200e";
    public static final String BIDI_RLM = "\u200f";
    public static final char BIDI_LRM_CHAR = '\u200e';
    public static final char BIDI_RLM_CHAR = '\u200f';
    public static final String TRA_TO_MARKER = "\u200c";
    static AtomicLong globalVersions = new AtomicLong();
    final SourceTextEntry ste;
    final int segmentNumberInProject;
    private volatile long displayVersion;
    private String sourceText;
    private String translationText;
    private boolean active;
    private boolean transExist;
    private boolean transDiffer;
    private boolean noteExist;
    private boolean defaultTranslation;
    private final Document3 doc;
    private final EditorController controller;
    private final EditorSettings settings;
    protected int activeTranslationBeginOffset;
    protected int activeTranslationEndOffset;
    protected Position beginPosP1;
    protected Position endPosM1;
    protected Position posSourceBeg;
    protected int posSourceLength;
    protected Position posTranslationBeg;
    protected int posTranslationLength;
    protected int offset;
    protected List<MarkerController.MarkInfo>[] marks;
    protected final boolean hasRTL;
    private boolean isInsertSource = false;
    private static final AttributeSet NO_ATTRIBUTES = new SimpleAttributeSet();
    private List<Insertion> eventsList = new ArrayList<Insertion>();
    public AttributeSet autoInsertAttributes = null;

    public SegmentBuilder(EditorController controller, Document3 doc, EditorSettings settings, SourceTextEntry ste, int segmentNumberInProject, boolean hasRTL) {
        this.controller = controller;
        this.doc = doc;
        this.settings = settings;
        this.ste = ste;
        this.segmentNumberInProject = segmentNumberInProject;
        this.hasRTL = hasRTL;
    }

    public boolean isDefaultTranslation() {
        return this.defaultTranslation;
    }

    public void setDefaultTranslation(boolean defaultTranslation) {
        this.defaultTranslation = defaultTranslation;
    }

    public void createSegmentElement(boolean isActive, TMXEntry trans) {
        this.createSegmentElement(isActive, this.doc.getLength(), trans);
    }

    public void prependSegmentElement(boolean isActive, TMXEntry trans) {
        this.createSegmentElement(isActive, 0, trans);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSegmentElement(boolean isActive, int initialOffset, TMXEntry trans) {
        UIThreadsUtil.mustBeSwingThread();
        this.displayVersion = globalVersions.incrementAndGet();
        this.active = isActive;
        this.doc.trustedChangesInProgress = true;
        StaticUIUtils.setCaretUpdateEnabled(this.controller.editor, false);
        try {
            try {
                int endOffset;
                int beginOffset;
                if (this.beginPosP1 != null && this.endPosM1 != null) {
                    beginOffset = this.beginPosP1.getOffset() - 1;
                    endOffset = this.endPosM1.getOffset() + 1;
                    this.doc.remove(beginOffset, endOffset - beginOffset);
                    this.offset = beginOffset;
                } else {
                    this.offset = initialOffset;
                }
                this.defaultTranslation = trans.defaultTranslation;
                if (!Core.getProject().getProjectProperties().isSupportDefaultTranslations()) {
                    this.defaultTranslation = false;
                }
                this.transExist = trans.isTranslated();
                this.noteExist = trans.hasNote();
                if (this.settings.isMarkAutoPopulated() && trans.linked != null) {
                    this.autoInsertAttributes = this.attrs(true, false, false, false);
                    StyleConstants.setBackground((MutableAttributeSet)this.autoInsertAttributes, this.colorForLinked(trans.linked));
                }
                this.transDiffer = trans.changer != null ? !trans.changer.equals(Preferences.getPreferenceDefault("team_Author", System.getProperty("user.name"))) : !Preferences.getPreferenceDefault("team_Author", System.getProperty("user.name")).equals(trans.creator);
                beginOffset = this.offset;
                if (isActive) {
                    this.createActiveSegmentElement(trans);
                } else {
                    this.createInactiveSegmentElement(trans);
                }
                endOffset = this.offset;
                this.beginPosP1 = this.doc.createPosition(beginOffset + 1);
                this.endPosM1 = this.doc.createPosition(endOffset - 1);
            }
            catch (BadLocationException ex) {
                throw new RuntimeException(ex);
            }
        }
        finally {
            this.doc.trustedChangesInProgress = false;
            StaticUIUtils.setCaretUpdateEnabled(this.controller.editor, true);
        }
    }

    public boolean hasBeenCreated() {
        return this.beginPosP1 != null && this.endPosM1 != null;
    }

    public void addSegmentSeparator() {
        this.addSegmentSeparator(this.doc.getLength());
    }

    public void prependSegmentSeparator() {
        this.addSegmentSeparator(0);
    }

    public void addSegmentSeparator(int index) {
        this.doc.trustedChangesInProgress = true;
        StaticUIUtils.setCaretUpdateEnabled(this.controller.editor, false);
        try {
            try {
                this.doc.insertString(index, "\n", null);
            }
            catch (BadLocationException ex) {
                throw new RuntimeException(ex);
            }
        }
        finally {
            this.doc.trustedChangesInProgress = false;
            StaticUIUtils.setCaretUpdateEnabled(this.controller.editor, true);
        }
    }

    private Color colorForLinked(TMXEntry.ExternalLinked linked) {
        switch (linked) {
            case xICE: {
                return Styles.EditorColor.COLOR_MARK_COMES_FROM_TM_XICE.getColor();
            }
            case x100PC: {
                return Styles.EditorColor.COLOR_MARK_COMES_FROM_TM_X100PC.getColor();
            }
            case xAUTO: {
                return Styles.EditorColor.COLOR_MARK_COMES_FROM_TM_XAUTO.getColor();
            }
            case xSRC: {
                return Styles.EditorColor.COLOR_MARK_COMES_FROM_SOURCE_FILE.getColor();
            }
        }
        return null;
    }

    private void createActiveSegmentElement(TMXEntry trans) throws BadLocationException {
        try {
            if (EditorSettings.DISPLAY_MODIFICATION_INFO_ALL.equals(this.settings.getDisplayModificationInfo()) || EditorSettings.DISPLAY_MODIFICATION_INFO_SELECTED.equals(this.settings.getDisplayModificationInfo())) {
                this.addModificationInfoPart(trans);
            }
            int prevOffset = this.offset;
            this.sourceText = this.addInactiveSegPart(true, this.ste.getSrcText());
            Map<Language, ProjectTMX> otherLanguageTMs = Core.getProject().getOtherTargetLanguageTMs();
            for (Map.Entry<Language, ProjectTMX> entry : otherLanguageTMs.entrySet()) {
                TMXEntry altTrans = entry.getValue().getMultipleTranslation(this.ste.getKey());
                if (altTrans == null) {
                    altTrans = entry.getValue().getDefaultTranslation(this.ste.getSrcText());
                }
                if (altTrans == null || !altTrans.isTranslated()) continue;
                Language language = entry.getKey();
                this.addOtherLanguagePart(altTrans.translation, language);
            }
            this.posSourceBeg = this.doc.createPosition(prevOffset + (this.hasRTL ? 1 : 0));
            this.posSourceLength = this.sourceText.length();
            this.isInsertSource = false;
            if (trans.isTranslated()) {
                this.translationText = trans.translation;
            } else {
                boolean insertSource;
                boolean bl = insertSource = !Preferences.isPreference("wf_noSourceText");
                if (this.controller.entriesFilter != null && this.controller.entriesFilter.isSourceAsEmptyTranslation()) {
                    insertSource = true;
                }
                if (insertSource) {
                    String srcText = this.ste.getSrcText();
                    if (Preferences.isPreference("glossary_replace_on_insert")) {
                        srcText = EditorUtils.replaceGlossaryEntries(srcText);
                    }
                    this.translationText = srcText;
                    this.isInsertSource = true;
                    this.autoInsertAttributes = this.attrs(true, false, false, false);
                    StyleConstants.setBackground((MutableAttributeSet)this.autoInsertAttributes, Styles.EditorColor.COLOR_INSERT_SOURCE.getColor());
                } else {
                    this.translationText = "";
                }
            }
            this.translationText = this.addActiveSegPart(this.translationText, trans.linked, trans.defaultTranslation);
            this.posTranslationBeg = null;
            this.doc.activeTranslationBeginM1 = this.doc.createPosition(this.activeTranslationBeginOffset - 1);
            this.doc.activeTranslationEndP1 = this.doc.createPosition(this.activeTranslationEndOffset + 1);
        }
        catch (OutOfMemoryError oome) {
            this.doc.remove(0, this.doc.getLength());
            System.gc();
            long memory = Runtime.getRuntime().maxMemory() / 1024L / 1024L;
            Log.logErrorRB("OUT_OF_MEMORY", memory);
            Log.log(oome);
            Core.getMainWindow().showErrorDialogRB("TF_ERROR", "OUT_OF_MEMORY", memory);
            System.exit(0);
        }
    }

    private void createInactiveSegmentElement(TMXEntry trans) throws BadLocationException {
        int prevOffset;
        if (EditorSettings.DISPLAY_MODIFICATION_INFO_ALL.equals(this.settings.getDisplayModificationInfo())) {
            this.addModificationInfoPart(trans);
        }
        this.sourceText = null;
        this.translationText = null;
        if (this.settings.isDisplaySegmentSources()) {
            this.sourceText = this.ste.getSrcText();
        }
        if (trans.isTranslated()) {
            this.translationText = trans.translation;
            if (StringUtil.isEmpty(this.translationText)) {
                this.translationText = OStrings.getString("EMPTY_TRANSLATION");
            }
        } else if (this.sourceText == null) {
            this.sourceText = this.ste.getSrcText();
        }
        if (this.sourceText != null) {
            prevOffset = this.offset;
            this.sourceText = this.addInactiveSegPart(true, this.sourceText);
            this.posSourceBeg = this.doc.createPosition(prevOffset + (this.hasRTL ? 1 : 0));
            this.posSourceLength = this.sourceText.length();
        } else {
            this.posSourceBeg = null;
        }
        if (this.translationText != null) {
            prevOffset = this.offset;
            this.translationText = this.addInactiveSegPart(false, this.translationText);
            this.posTranslationBeg = this.doc.createPosition(prevOffset + (this.hasRTL ? 1 : 0));
            this.posTranslationLength = this.translationText.length();
        } else {
            this.posTranslationBeg = null;
        }
    }

    public SourceTextEntry getSourceTextEntry() {
        return this.ste;
    }

    public long getDisplayVersion() {
        return this.displayVersion;
    }

    public boolean isActive() {
        return this.active;
    }

    public String getSourceText() {
        return this.sourceText;
    }

    public String getTranslationText() {
        return this.translationText;
    }

    public int getStartSourcePosition() {
        if (this.posSourceBeg != null) {
            return this.posSourceBeg.getOffset();
        }
        return -1;
    }

    public int getStartTranslationPosition() {
        if (this.posTranslationBeg != null) {
            return this.posTranslationBeg.getOffset();
        }
        return -1;
    }

    public int getStartPosition() {
        return this.beginPosP1.getOffset() - 1;
    }

    public int getEndPosition() {
        return this.endPosM1.getOffset() + 1;
    }

    private void setAlignment(int begin, int end, boolean isRTL) {
        boolean rtl = false;
        switch (this.controller.currentOrientation) {
            case ALL_LTR: {
                rtl = false;
                break;
            }
            case ALL_RTL: {
                rtl = true;
                break;
            }
            case DIFFER: {
                rtl = isRTL;
            }
        }
        this.doc.setAlignment(begin, end, rtl);
    }

    public boolean isInsideSegment(int location) {
        return this.beginPosP1.getOffset() - 1 <= location && location < this.endPosM1.getOffset() + 1;
    }

    private String addInactiveSegPart(boolean isSource, String text) throws BadLocationException {
        int prevOffset = this.offset;
        boolean rtl = isSource ? this.controller.sourceLangIsRTL : this.controller.targetLangIsRTL;
        this.insertDirectionEmbedding(rtl);
        String result = this.insertTextWithTags(text, isSource);
        this.insertDirectionEndEmbedding();
        this.insert("\n", null);
        this.setAlignment(prevOffset, this.offset, rtl);
        return result;
    }

    private void addOtherLanguagePart(String text, Language language) throws BadLocationException {
        int prevOffset = this.offset;
        boolean rtl = EditorUtils.isRTL(language.getLanguageCode());
        this.insertDirectionEmbedding(false);
        AttributeSet normal = this.attrs(true, false, false, false);
        this.insert(language.getLanguage() + ": ", normal);
        this.insertDirectionEndEmbedding();
        this.insertDirectionEmbedding(rtl);
        AttributeSet attrs = this.settings.getOtherLanguageTranslationAttributeSet();
        this.insert(text, attrs);
        this.insertDirectionEndEmbedding();
        this.insert("\n", null);
        this.setAlignment(prevOffset, this.offset, rtl);
    }

    private void addModificationInfoPart(TMXEntry trans) throws BadLocationException {
        Object text;
        if (!trans.isTranslated()) {
            return;
        }
        if (Preferences.isPreference("view_option_template_active")) {
            text = ModificationInfoManager.apply(trans);
        } else {
            String template;
            String author;
            String string = author = trans.changer == null ? OStrings.getString("TF_CUR_SEGMENT_UNKNOWN_AUTHOR") : trans.changer;
            if (trans.changeDate != 0L) {
                template = OStrings.getString("TF_CUR_SEGMENT_AUTHOR_DATE");
                Date changeDate = new Date(trans.changeDate);
                String changeDateString = DateFormat.getDateInstance().format(changeDate);
                String changeTimeString = DateFormat.getTimeInstance().format(changeDate);
                Object[] args = new Object[]{author, changeDateString, changeTimeString};
                text = StringUtil.format(template, args);
            } else {
                template = OStrings.getString("TF_CUR_SEGMENT_AUTHOR");
                Object[] args = new Object[]{author};
                text = StringUtil.format(template, args);
            }
            if (trans.revisor != null) {
                text = (String)text + "\nLast revised by: " + trans.revisor;
            }
        }
        int prevOffset = this.offset;
        boolean rtl = EditorUtils.localeIsRTL();
        this.insertDirectionEmbedding(rtl);
        AttributeSet attrs = this.settings.getModificationInfoAttributeSet();
        this.insert((String)text, attrs);
        this.insertDirectionEndEmbedding();
        this.insert("\n", null);
        this.setAlignment(prevOffset, this.offset, rtl);
    }

    private String addActiveSegPart(String text, TMXEntry.ExternalLinked linked, boolean defaultTranslation) throws BadLocationException {
        this.eventsList.clear();
        int prevOffset = this.offset;
        boolean rtl = this.controller.targetLangIsRTL;
        AttributeSet attrSegmentMark = this.settings.getSegmentMarkerAttributeSet();
        if (Preferences.isPreferenceDefault("view_editor_zone_start_end", true)) {
            this.insertDirectionEmbedding(EditorUtils.localeIsRTL());
            this.insertSegmentMarkText(attrSegmentMark, text, linked, defaultTranslation);
            if (Preferences.isPreferenceDefault("view_editor_zone_line_breaks", true)) {
                this.insert("\n", null);
            }
        }
        this.insertDirectionEmbedding(rtl);
        this.activeTranslationBeginOffset = this.offset;
        String result = this.insertTextWithTags(text, false);
        this.activeTranslationEndOffset = this.offset;
        this.insertDirectionEndEmbedding();
        this.insertDirectionMarker(rtl);
        if (Preferences.isPreferenceDefault("view_editor_zone_line_breaks", true)) {
            this.insert("\n", null);
        } else {
            this.insert(TRA_TO_MARKER, null);
        }
        if (Preferences.isPreferenceDefault("view_editor_zone_start_end", true)) {
            this.insert(OStrings.getString("TF_CUR_SEGMENT_END"), attrSegmentMark);
        } else {
            this.insertSegmentMarkText(attrSegmentMark, text, linked, defaultTranslation);
        }
        this.insert("\n\n", attrSegmentMark);
        this.insertDirectionEndEmbedding();
        this.setAlignment(prevOffset, this.offset, rtl);
        return result;
    }

    void createInputAttributes(Element element, MutableAttributeSet set) {
        set.addAttributes(this.attrs(false, false, false, false));
    }

    private void insert(String text, AttributeSet attrs) throws BadLocationException {
        this.doc.insertString(this.offset, text, attrs);
        this.offset += text.length();
    }

    private void insertSegmentMarkText(AttributeSet attrSegmentMark, String text, TMXEntry.ExternalLinked linked, boolean defaultTranslation) throws BadLocationException {
        String fullMarker = OConsts.segmentMarkerString;
        if (fullMarker.contains("0000")) {
            String replacement = NUMBER_FORMAT.format(this.segmentNumberInProject);
            if (Preferences.isPreference("mark_non_unique_segments") && this.ste.getDuplicate() != SourceTextEntry.DUPLICATE.NONE) {
                replacement = StringUtil.format(OStrings.getString("SW_FILE_AND_NR_OF_MORE"), replacement, this.ste.getNumberOfDuplicates());
            }
            fullMarker = fullMarker.replace("0000", replacement);
        }
        fullMarker = fullMarker.trim().replace(' ', '\u00a0');
        this.insert(fullMarker, attrSegmentMark);
        if (Preferences.isPreferenceDefault("view_editor_zone_display_origin", true)) {
            this.doc.infoStart = this.offset - 1;
            --this.offset;
            if (this.isInsertSource && text.equals(this.sourceText)) {
                this.insert("\u00a0**\u00a0" + OStrings.getString("TF_SEG_COMESFROM_SOURCE") + "\u00a0**\u00a0", null);
            } else if (linked == TMXEntry.ExternalLinked.xSRC) {
                this.insert("\u00a0**\u00a0" + OStrings.getString("TF_SEG_COMESFROM_SOURCE_FILE") + "\u00a0**\u00a0", null);
            } else if (linked != null) {
                this.insert("\u00a0**\u00a0" + OStrings.getString("TF_SEG_COMESFROM_TM_AUTO") + "\u00a0**\u00a0", null);
            } else if (text != null && text.length() > 0) {
                if (defaultTranslation) {
                    this.insert("\u00a0**\u00a0" + OStrings.getString("TF_SEG_COMESFROM_TRA_DEF") + "\u00a0**\u00a0", null);
                } else {
                    this.insert("\u00a0**\u00a0" + OStrings.getString("TF_SEG_COMESFROM_TRA_ALT") + "\u00a0**\u00a0", null);
                }
            } else {
                this.insert("\u00a0**\u00a0" + OStrings.getString("TF_SEG_COMESFROM_EMPTY") + "\u00a0**\u00a0", null);
            }
            this.doc.infoEnd = this.offset++;
        }
    }

    void onActiveEntryChanged() {
        this.translationText = this.doc.extractTranslation();
        this.displayVersion = globalVersions.incrementAndGet();
    }

    public AttributeSet attrs(boolean isSource, boolean isPlaceholder, boolean isRemoveText, boolean isNBSP) {
        return this.settings.getAttributeSet(isSource, isPlaceholder, isRemoveText, this.ste.getDuplicate(), this.active, this.transExist, this.transDiffer, this.noteExist, isNBSP);
    }

    private String insertTextWithTags(String text, boolean isSource) throws BadLocationException {
        if (!isSource && this.hasRTL && this.controller.targetLangIsRTL) {
            text = EditorUtils.addBidiAroundTags(text, this.ste);
        }
        this.insert(text, !isSource && this.autoInsertAttributes != null ? this.autoInsertAttributes : this.attrs(isSource, false, false, false));
        return text;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetTextAttributes(DocumentEvent ev) {
        this.doc.trustedChangesInProgress = true;
        try {
            int tLen;
            int tBeg;
            AttributeSet attrs;
            if (this.posSourceBeg != null) {
                int sBeg = this.posSourceBeg.getOffset();
                int sLen = this.posSourceLength;
                attrs = this.attrs(true, false, false, false);
                this.doc.setCharacterAttributes(sBeg, sLen, attrs, true);
            }
            if (this.active) {
                tBeg = this.doc.getTranslationStart();
                tLen = this.posTranslationLength;
                int tEnd = this.doc.getTranslationEnd();
                if (Preferences.isPreferenceDefault("view_editor_zone_blank_typing", false)) {
                    if (ev != null && ev.getType() == DocumentEvent.EventType.INSERT && ev.getOffset() >= tBeg && ev.getOffset() <= tEnd) {
                        boolean over = false;
                        for (Insertion ins0 : this.eventsList) {
                            if (ins0.pos < ev.getOffset()) continue;
                            ins0.pos += ev.getLength();
                        }
                        if (!over) {
                            this.eventsList.add(new Insertion(ev.getOffset(), ev.getLength()));
                        }
                    } else if (ev != null && ev.getType() == DocumentEvent.EventType.REMOVE) {
                        for (Insertion ins0 : this.eventsList) {
                            if (ins0.pos < ev.getOffset()) continue;
                            ins0.pos -= ev.getLength();
                        }
                    }
                }
                AttributeSet attrs2 = this.attrs(false, false, false, false);
                if (this.autoInsertAttributes != null) {
                    attrs2 = this.autoInsertAttributes;
                }
                this.doc.setCharacterAttributes(tBeg, tEnd - tBeg, attrs2, true);
                if (Preferences.isPreferenceDefault("view_editor_zone_blank_typing", false)) {
                    for (Insertion ins0 : this.eventsList) {
                        this.doc.setCharacterAttributes(ins0.pos, ins0.length, NO_ATTRIBUTES, true);
                    }
                }
            } else if (this.posTranslationBeg != null) {
                tBeg = this.posTranslationBeg.getOffset();
                tLen = this.posTranslationLength;
                attrs = this.attrs(false, false, false, false);
                this.doc.setCharacterAttributes(tBeg, tLen, attrs, true);
            }
        }
        finally {
            this.doc.trustedChangesInProgress = false;
        }
    }

    private void insertDirectionEmbedding(boolean isRTL) throws BadLocationException {
        if (this.hasRTL) {
            this.insert(isRTL ? BIDI_RLE : BIDI_LRE, null);
        }
    }

    private void insertDirectionEndEmbedding() throws BadLocationException {
        if (this.hasRTL) {
            this.insert(BIDI_PDF, null);
        }
    }

    private void insertDirectionMarker(boolean isRTL) throws BadLocationException {
        if (this.hasRTL) {
            this.insert(isRTL ? BIDI_RLM : BIDI_LRM, null);
        }
    }

    static class Insertion {
        int pos;
        int length;

        public Insertion(int pos, int len) {
            this.pos = pos;
            this.length = len;
        }
    }
}

