/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.editor.autotext;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.omegat.core.Core;
import org.omegat.gui.editor.autotext.Autotext;
import org.omegat.gui.editor.autotext.AutotextPair;
import org.omegat.util.OStrings;
import org.omegat.util.StringUtil;

public class AutotextTableModel
extends AbstractTableModel {
    private List<AutotextPair> data = new ArrayList<AutotextPair>();
    private String[] columnNames = new String[]{OStrings.getString("AC_AUTOTEXT_ABBREVIATION"), OStrings.getString("AC_AUTOTEXT_TEXT"), OStrings.getString("AC_AUTOTEXT_COMMENT")};

    public void load() {
        this.data.clear();
        for (AutotextPair pair : Core.getAutoText().getList()) {
            this.data.add(new AutotextPair(pair.source, pair.target, pair.comment));
        }
    }

    public void store(Autotext autotext) {
        List<AutotextPair> list = autotext.getList();
        list.clear();
        for (AutotextPair pair : this.data) {
            if (StringUtil.isEmpty(pair.target)) continue;
            list.add(new AutotextPair(pair.source == null ? "" : pair.source, pair.target, pair.comment == null ? "" : pair.comment));
        }
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public Object getValueAt(int i, int i1) {
        AutotextPair pair = this.data.get(i);
        switch (i1) {
            case 0: {
                return pair.source;
            }
            case 1: {
                return pair.target;
            }
            case 2: {
                return pair.comment;
            }
        }
        return null;
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        AutotextPair pair = this.data.get(row);
        switch (col) {
            case 0: {
                pair.source = (String)value;
                break;
            }
            case 1: {
                pair.target = (String)value;
                break;
            }
            case 2: {
                pair.comment = (String)value;
            }
        }
        this.fireTableCellUpdated(row, col);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return true;
    }

    public int addRow(AutotextPair pair, int position) {
        int newPosition = position == -1 ? this.data.size() : position;
        this.data.add(newPosition, pair);
        this.fireTableDataChanged();
        return newPosition;
    }

    public void removeRow(int position) {
        this.data.remove(position);
        this.fireTableDataChanged();
    }
}

