/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.editor.mark;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.Highlighter;
import org.omegat.core.Core;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.gui.editor.Document3;
import org.omegat.gui.editor.MarkerController;
import org.omegat.gui.editor.mark.IFastMarker;
import org.omegat.gui.editor.mark.Mark;

public abstract class CharMarker
implements IFastMarker {
    protected Highlighter.HighlightPainter PAINTER;
    protected String toolTip;
    protected AttributeSet ATTRIBUTES;
    protected char patternChar;

    protected abstract boolean isEnabled();

    @Override
    public List<Mark> getMarksForEntry(SourceTextEntry ste, String sourceText, String translationText, boolean isActive) throws Exception {
        Mark m;
        int pos;
        if (!this.isEnabled()) {
            return null;
        }
        if (this.patternChar == '\u0000') {
            return null;
        }
        ArrayList<Mark> r = new ArrayList<Mark>();
        if (isActive || Core.getEditor().getSettings().isDisplaySegmentSources() || translationText == null) {
            this.initDrawers(true, isActive);
            if (this.patternChar != '\u0000') {
                pos = -1;
                while ((pos = sourceText.indexOf(this.patternChar, pos + 1)) >= 0) {
                    m = new Mark(Mark.ENTRY_PART.SOURCE, pos, pos + 1);
                    m.painter = this.PAINTER;
                    m.toolTipText = this.toolTip;
                    m.attributes = this.ATTRIBUTES;
                    r.add(m);
                }
            }
        }
        if (translationText != null) {
            this.initDrawers(false, isActive);
            if (this.patternChar != '\u0000') {
                pos = -1;
                while ((pos = translationText.indexOf(this.patternChar, pos + 1)) >= 0) {
                    m = new Mark(Mark.ENTRY_PART.TRANSLATION, pos, pos + 1);
                    m.painter = this.PAINTER;
                    m.toolTipText = this.toolTip;
                    m.attributes = this.ATTRIBUTES;
                    r.add(m);
                }
            }
        }
        return r;
    }

    protected void initDrawers(boolean isSource, boolean isActive) {
    }

    @Override
    public List<MarkerController.MarkInfo> toRemove(DocumentEvent ev, List<MarkerController.MarkInfo> oriList) {
        if (!this.isEnabled()) {
            return Collections.EMPTY_LIST;
        }
        if (ev.getType() == DocumentEvent.EventType.INSERT) {
            return Collections.EMPTY_LIST;
        }
        this.initDrawers(false, true);
        ArrayList<MarkerController.MarkInfo> res = new ArrayList<MarkerController.MarkInfo>(ev.getLength() / 2 + 1);
        for (MarkerController.MarkInfo ori : oriList) {
            if (ori.highlight == null || ori.highlight.getStartOffset() != ori.highlight.getEndOffset()) continue;
            res.add(ori);
        }
        return res;
    }

    @Override
    public List<Mark> toAdd(DocumentEvent ev) throws Exception {
        if (!this.isEnabled()) {
            return Collections.EMPTY_LIST;
        }
        if (ev.getType() == DocumentEvent.EventType.REMOVE) {
            return Collections.EMPTY_LIST;
        }
        this.initDrawers(false, true);
        int pos = -1;
        int shift = ev.getOffset() - ((Document3)ev.getDocument()).getTranslationStart();
        if (shift < 0) {
            return Collections.EMPTY_LIST;
        }
        if (shift > ((Document3)ev.getDocument()).getTranslationEnd()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Mark> res = new ArrayList<Mark>(ev.getLength() / 2 + 1);
        String addedContents = ev.getDocument().getText(ev.getOffset(), ev.getLength());
        while ((pos = addedContents.indexOf(this.patternChar, pos + 1)) >= 0) {
            Mark m = new Mark(Mark.ENTRY_PART.TRANSLATION, pos + shift, pos + shift + 1);
            m.painter = this.PAINTER;
            m.toolTipText = this.toolTip;
            m.attributes = this.ATTRIBUTES;
            res.add(m);
        }
        return res;
    }

    @Override
    public List<MarkerController.MarkInfo> toRemove(String newTra, List<MarkerController.MarkInfo> oriList) {
        if (!this.isEnabled()) {
            return Collections.EMPTY_LIST;
        }
        this.initDrawers(false, true);
        ArrayList<MarkerController.MarkInfo> res = new ArrayList<MarkerController.MarkInfo>(oriList.size() / 2 + 1);
        for (MarkerController.MarkInfo ori : oriList) {
            if (ori.highlight == null || ori.highlight.getStartOffset() != ori.highlight.getEndOffset()) continue;
            res.add(ori);
        }
        return res;
    }

    @Override
    public List<Mark> toAdd(String newTra) throws Exception {
        if (!this.isEnabled()) {
            return Collections.EMPTY_LIST;
        }
        this.initDrawers(false, true);
        int pos = -1;
        ArrayList<Mark> res = new ArrayList<Mark>();
        while ((pos = newTra.indexOf(this.patternChar, pos + 1)) >= 0) {
            Mark m = new Mark(Mark.ENTRY_PART.TRANSLATION, pos, pos + 1);
            m.painter = this.PAINTER;
            m.toolTipText = this.toolTip;
            m.attributes = this.ATTRIBUTES;
            res.add(m);
        }
        return res;
    }
}

