/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.exttrans;

import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.omegat.core.Core;
import org.omegat.core.data.ProjectProperties;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.core.machinetranslators.CachedTranslate;
import org.omegat.core.machinetranslators.LocalTranslate;
import org.omegat.filters2.master.PluginUtils;
import org.omegat.gui.common.EntryInfoSearchThread;
import org.omegat.gui.common.EntryInfoThreadPane;
import org.omegat.gui.exttrans.IMachineTranslation;
import org.omegat.gui.exttrans.MachineTranslationInfo;
import org.omegat.gui.main.DockableScrollPane;
import org.omegat.util.Language;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.StringUtil;
import org.omegat.util.gui.StaticUIUtils;
import org.omegat.util.gui.Styles;
import org.omegat.util.gui.UIThreadsUtil;

public class MachineTranslateTextArea
extends EntryInfoThreadPane<MachineTranslationInfo> {
    private static final AttributeSet NO_ATTRIBUTES = Styles.createAttributeSet(null, null, false, null);
    private static final AttributeSet RESULT_OK = Styles.createAttributeSet(Styles.EditorColor.COLOR_EXTTRANS_OK.getColor(), null, false, null);
    private static final AttributeSet RESULT_ERROR = Styles.createAttributeSet(Styles.EditorColor.COLOR_EXTTRANS_FAIL.getColor(), null, false, null);
    private static final AttributeSet DURATION_ATTRIBUTES = Styles.createAttributeSet(Styles.EditorColor.COLOR_EXTTRANS_INFO.getColor(), null, false, null);
    private static final String EXPLANATION = OStrings.getString("GUI_MACHINETRANSLATESWINDOW_explanation");
    public final IMachineTranslation[] translators;
    protected Map<IMachineTranslation, MachineTranslationInfo> displayed = new TreeMap<IMachineTranslation, MachineTranslationInfo>((a, b) -> a.getName().compareTo(b.getName()));
    private SourceTextEntry currentEntry;
    private Iterator<MachineTranslationInfo> cycle;
    private List<FindThread> threads;
    private boolean doInsert_inEditor = Preferences.isPreference("wf_insertMt");

    public MachineTranslateTextArea() {
        super(true);
        this.setEditable(false);
        StaticUIUtils.makeCaretAlwaysVisible(this);
        this.setText(EXPLANATION);
        this.setDragEnabled(true);
        this.setMinimumSize(new Dimension(100, 50));
        String title = OStrings.getString("GUI_MATCHWINDOW_SUBWINDOWTITLE_MachineTranslate");
        Core.getMainWindow().addDockable(new DockableScrollPane("MACHINE_TRANSLATE", title, this, true));
        ArrayList<IMachineTranslation> tr = new ArrayList<IMachineTranslation>();
        for (Class<?> mtc : PluginUtils.getMachineTranslationClasses()) {
            try {
                tr.add((IMachineTranslation)mtc.newInstance());
            }
            catch (Exception ex) {
                Log.log(ex);
            }
        }
        this.translators = tr.toArray(new IMachineTranslation[tr.size()]);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (MachineTranslateTextArea.this.displayed.isEmpty()) {
                    return;
                }
                int mousepos = MachineTranslateTextArea.this.viewToModel(e.getPoint());
                MachineTranslationInfo selected = null;
                for (MachineTranslationInfo info : MachineTranslateTextArea.this.displayed.values()) {
                    if (mousepos <= info.position) continue;
                    selected = info;
                }
                if (selected == null) {
                    return;
                }
                if (selected.isException()) {
                    return;
                }
                if (e.isPopupTrigger() || e.getButton() == 3) {
                    MachineTranslationInfo selectedCopy = selected;
                    JPopupMenu popup = new JPopupMenu();
                    JMenuItem item1 = popup.add(MessageFormat.format(OStrings.getString("MT_INSERT"), selected.origin.getName()));
                    item1.addActionListener(ev -> Core.getEditor().insertText(selectedCopy.getDisplayedResult()));
                    JMenuItem item2 = popup.add(MessageFormat.format(OStrings.getString("MT_REPLACE"), selected.origin.getName()));
                    item2.addActionListener(ev -> {
                        Core.getEditor().replaceEditTextWithColor(selectedCopy.getDisplayedResult(), Styles.EditorColor.COLOR_MARK_COMES_FROM_MACHINE_TRANSLATION.getColor(), true);
                        Core.getEditor().insertInfo(" " + OStrings.getString("TF_SEG_COMESFROM_MT_PANE") + " (" + selectedCopy.origin.getName() + ")");
                    });
                    popup.show(MachineTranslateTextArea.this, e.getPoint().x, e.getPoint().y);
                }
            }
        });
    }

    public MachineTranslationInfo getDisplayedTranslation() {
        if (this.cycle == null || !this.cycle.hasNext()) {
            this.cycle = this.displayed.values().iterator();
            String pref = Preferences.getPreference("wf_preferredMt");
            if (pref != null) {
                for (Map.Entry<IMachineTranslation, MachineTranslationInfo> entry : this.displayed.entrySet()) {
                    if (!entry.getKey().getClass().getName().equals(pref) || entry.getValue() == null || entry.getValue().isException()) continue;
                    return entry.getValue();
                }
            }
        }
        try {
            MachineTranslationInfo next = this.cycle.next();
            if (next.isException()) {
                if (this.cycle.hasNext()) {
                    return this.getDisplayedTranslation();
                }
                return null;
            }
            return next;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    protected void onProjectClose() {
        UIThreadsUtil.mustBeSwingThread();
        this.setText(EXPLANATION);
    }

    public void forceLoad() {
        this.startSearchThread(this.currentlyProcessedEntry, true);
    }

    @Override
    protected void startSearchThread(SourceTextEntry newEntry) {
        this.startSearchThread(newEntry, false);
    }

    private void startSearchThread(SourceTextEntry newEntry, boolean force) {
        UIThreadsUtil.mustBeSwingThread();
        this.clear();
        this.currentEntry = newEntry;
        if (this.threads != null) {
            for (FindThread t : this.threads) {
                t.cancel();
            }
            this.threads.clear();
        } else {
            this.threads = new ArrayList<FindThread>(this.translators.length);
        }
        for (IMachineTranslation mt : this.translators) {
            FindThread newThread;
            try {
                CachedTranslate cmt = (CachedTranslate)mt;
                if (!cmt.isEnabled()) continue;
                newThread = new FindThreadWithCache(cmt, newEntry, force);
                newThread.start();
                this.threads.add(newThread);
            }
            catch (ClassCastException cce) {
                newThread = new FindThreadNoCache(mt, newEntry);
                newThread.start();
                this.threads.add(newThread);
            }
        }
        this.doInsert_inEditor = Preferences.isPreference("wf_insertMt");
    }

    @Override
    protected void setFoundResult(SourceTextEntry se, MachineTranslationInfo data) {
        UIThreadsUtil.mustBeSwingThread();
        if (se != this.currentEntry) {
            this.setText("");
            this.displayed.clear();
            this.currentEntry = se;
        }
        if (data != null) {
            TMXEntry te;
            if (data.result != null) {
                this.displayed.put(data.origin, data);
            } else if (data.origin != null) {
                this.displayed.remove(data.origin);
            }
            StyledDocument doc = this.getStyledDocument();
            this.setText("");
            for (Map.Entry<IMachineTranslation, MachineTranslationInfo> entry : this.displayed.entrySet()) {
                try {
                    MachineTranslationInfo info = entry.getValue();
                    info.position = doc.getLength();
                    if (this.displayed.size() > 1) {
                        doc.insertString(info.position, info.getDisplayedResult() + "\n", info.isException() ? RESULT_ERROR : RESULT_OK);
                        doc.insertString(doc.getLength(), "<" + entry.getKey().getName() + ">", NO_ATTRIBUTES);
                        if (Preferences.isPreferenceDefault("mt_show_duration", false)) {
                            doc.insertString(doc.getLength(), " " + StringUtil.format(OStrings.getString("TF_OPTIONSMENU_MACHINETRANSLATE_SHOW_DURATION_SECONDS"), NumberFormat.getInstance().format((double)info.duration / 1000.0)), DURATION_ATTRIBUTES);
                        }
                        doc.insertString(doc.getLength(), "\n\n", NO_ATTRIBUTES);
                        continue;
                    }
                    if (info.origin instanceof LocalTranslate) {
                        doc.insertString(info.position, info.getDisplayedResult(), NO_ATTRIBUTES);
                        continue;
                    }
                    doc.insertString(info.position, info.getDisplayedResult(), info.isException() ? RESULT_ERROR : RESULT_OK);
                }
                catch (BadLocationException bde) {
                    bde.printStackTrace();
                    StringBuffer buf = new StringBuffer(this.getText());
                    buf.append(entry.getValue().getDisplayedResult()).append("\n");
                    if (this.displayed.size() <= 1) continue;
                    buf.append("<").append(entry.getKey().getName()).append(">\n\n");
                }
            }
            if (Preferences.isPreference("wf_insertMt") && !(te = Core.getProject().getTranslationInfo(this.currentEntry.getKey())).isTranslated()) {
                Thread.yield();
                if (!Core.getMatcher().isInsertMatch()) {
                    if (data.isException()) {
                        return;
                    }
                    if (data.origin != null && data.origin.getClass().getName().equals(Preferences.getPreference("wf_preferredMt"))) {
                        Core.getEditor().replaceEditTextWithColor(data.result.toString(), Styles.EditorColor.COLOR_MARK_COMES_FROM_MACHINE_TRANSLATION.getColor(), false);
                        Core.getEditor().insertInfo(" " + OStrings.getString("TF_SEG_COMESFROM_MT_PANE") + " (" + data.origin.getName() + ")");
                        this.doInsert_inEditor = false;
                    } else if (this.doInsert_inEditor) {
                        Core.getEditor().replaceEditTextWithColor(data.result.toString(), Styles.EditorColor.COLOR_MARK_COMES_FROM_MACHINE_TRANSLATION.getColor(), false);
                        Core.getEditor().insertInfo(" " + OStrings.getString("TF_SEG_COMESFROM_MT_PANE") + " (" + data.origin.getName() + ")");
                        this.doInsert_inEditor = false;
                    }
                }
            }
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.displayed.clear();
    }

    protected abstract class FindThread
    extends EntryInfoSearchThread<MachineTranslationInfo> {
        protected final String srcText;
        protected boolean cancelled;
        protected long start;

        protected FindThread(SourceTextEntry newEntry) {
            super(MachineTranslateTextArea.this, newEntry);
            this.cancelled = false;
            this.start = System.currentTimeMillis();
            this.srcText = newEntry.getSrcText();
        }

        public void cancel() {
            this.cancelled = true;
        }

        @Override
        protected MachineTranslationInfo search() throws Exception {
            ProjectProperties pp = Core.getProject().getProjectProperties();
            if (pp == null) {
                return null;
            }
            Language sourceLang = pp.getSourceLanguage();
            if (sourceLang == null) {
                return null;
            }
            Language targetLang = pp.getTargetLanguage();
            if (targetLang == null) {
                return null;
            }
            return this.getTranslationInfo(sourceLang, targetLang);
        }

        protected abstract MachineTranslationInfo getTranslationInfo(Language var1, Language var2);
    }

    protected final class FindThreadWithCache
    extends FindThread {
        private final CachedTranslate translator;
        private final boolean force;

        public FindThreadWithCache(CachedTranslate translator, SourceTextEntry newEntry, boolean force) {
            super(newEntry);
            this.translator = translator;
            this.force = force;
        }

        @Override
        protected MachineTranslationInfo getTranslationInfo(Language sourceLang, Language targetLang) {
            try {
                String result = this.getTranslation(sourceLang, targetLang);
                return result == null ? null : new MachineTranslationInfo(this.translator, this.start, result);
            }
            catch (Exception e) {
                return new MachineTranslationInfo(this.translator, this.start, e);
            }
        }

        private String getTranslation(Language sourceLang, Language targetLang) throws Exception {
            if (this.cancelled) {
                return null;
            }
            if (!this.force) {
                TMXEntry entry;
                if (!Preferences.isPreferenceDefault("mt_auto_fetch", true)) {
                    return this.translator.getCachedTranslation(sourceLang, targetLang, this.srcText);
                }
                if (Preferences.isPreference("mt_only_untranslated") && (entry = Core.getProject().getTranslationInfo(this.currentlyProcessedEntry.getKey())).isTranslated()) {
                    return this.translator.getCachedTranslation(sourceLang, targetLang, this.srcText);
                }
            }
            return this.translator.getTranslation(sourceLang, targetLang, this.srcText);
        }
    }

    protected final class FindThreadNoCache
    extends FindThread {
        private final IMachineTranslation translator;

        public FindThreadNoCache(IMachineTranslation translator, SourceTextEntry newEntry) {
            super(newEntry);
            this.translator = translator;
        }

        @Override
        protected MachineTranslationInfo getTranslationInfo(Language sourceLang, Language targetLang) {
            if (this.cancelled) {
                return null;
            }
            try {
                String result = this.translator.getTranslation(sourceLang, targetLang, this.srcText);
                return result == null ? null : new MachineTranslationInfo(this.translator, this.start, result);
            }
            catch (Exception e) {
                return new MachineTranslationInfo(this.translator, this.start, e);
            }
        }
    }
}

