/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.glossary;

import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import org.omegat.core.Core;
import org.omegat.core.glossaries.GlossaryEntryStore;
import org.omegat.core.glossaries.IGlossary;
import org.omegat.filters2.master.PluginUtils;
import org.omegat.gui.glossary.GlossaryReaderCSV;
import org.omegat.gui.glossary.GlossaryReaderTBX;
import org.omegat.gui.glossary.GlossaryReaderTSV;
import org.omegat.gui.glossary.GlossaryTextArea;
import org.omegat.util.DirectoryMonitor;
import org.omegat.util.Language;
import org.omegat.util.Log;

public class GlossaryManager
implements DirectoryMonitor.Callback {
    protected DirectoryMonitor monitor;
    private final GlossaryTextArea pane;
    protected final Map<String, IGlossary> glossaries = new TreeMap<String, IGlossary>();
    protected File priorityGlossary;

    public GlossaryManager(GlossaryTextArea pane) {
        this.pane = pane;
        for (Class<?> glc : PluginUtils.getGlossaryClasses()) {
            try {
                IGlossary instance = (IGlossary)glc.newInstance();
                this.glossaries.put(instance.getLongName(), instance);
            }
            catch (Exception ex) {
                Log.log(ex);
            }
        }
    }

    public void addGlossaryProvider(IGlossary provider) {
        this.glossaries.put(provider.getLongName(), provider);
    }

    public IGlossary getPriorityGlossary() {
        return this.glossaries.get(this.priorityGlossary.getPath());
    }

    public void start() {
        File dir = new File(Core.getProject().getProjectProperties().getGlossaryRoot());
        this.priorityGlossary = new File(Core.getProject().getProjectProperties().getWriteableGlossary());
        this.monitor = new DirectoryMonitor(dir, this);
        this.monitor.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.monitor.fin();
        GlossaryManager glossaryManager = this;
        synchronized (glossaryManager) {
            this.glossaries.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fileChanged(File file) {
        block9: {
            GlossaryManager glossaryManager = this;
            synchronized (glossaryManager) {
                this.glossaries.remove(file.getPath());
            }
            if (file.exists()) {
                try {
                    IGlossary glos = GlossaryManager.loadGlossaryFile(file);
                    if (glos == null || !glos.hasContents()) break block9;
                    GlossaryManager glossaryManager2 = this;
                    synchronized (glossaryManager2) {
                        Log.logRB("CT_LOADING_GLOSSARY_DETAILS", "", file.getName());
                        this.glossaries.put(file.getPath(), glos);
                    }
                }
                catch (Exception ex) {
                    Log.logRB("CT_ERROR_ACCESS_GLOSSARY_DIR", new Object[0]);
                    Log.log(ex);
                }
            }
        }
        this.pane.refresh();
    }

    public void forceReloadTBX() {
        Set<File> files = this.monitor.getExistFiles();
        for (File f : files) {
            if (!f.getName().toLowerCase().endsWith(".tbx")) continue;
            this.fileChanged(f);
        }
    }

    public void forceUpdateGlossary() {
        this.pane.refresh();
    }

    public static IGlossary loadGlossaryFile(File file) throws Exception {
        String fname_lower = file.getName().toLowerCase();
        if (fname_lower.endsWith(".tab")) {
            Log.logRB("CT_LOADING_GLOSSARY", file.getName());
            return new GlossaryReaderTSV(file);
        }
        if (fname_lower.endsWith(".utf8") || fname_lower.endsWith(".txt")) {
            Log.logRB("CT_LOADING_GLOSSARY", file.getName());
            return new GlossaryReaderTSV(file);
        }
        if (fname_lower.endsWith(".csv")) {
            Log.logRB("CT_LOADING_GLOSSARY", file.getName());
            return new GlossaryReaderCSV(file);
        }
        if (fname_lower.endsWith(".tbx")) {
            Log.logRB("CT_LOADING_GLOSSARY", file.getName());
            return new GlossaryReaderTBX(file);
        }
        if (fname_lower.endsWith(".properties")) {
            Properties config = new Properties();
            config.load(new FileInputStream(file));
            if (config.getProperty("name") == null) {
                config.setProperty("name", file.toString());
            }
            Class<?> glosClass = PluginUtils.getPluginsClassLoader().loadClass(config.getProperty("class"));
            Constructor<?> cons = glosClass.getConstructor(Properties.class);
            return (IGlossary)cons.newInstance(config);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GlossaryEntryStore> getGlossaryEntries(String src) {
        Language source = Core.getProject().getProjectProperties().getSourceLanguage();
        Language target = Core.getProject().getProjectProperties().getTargetLanguage();
        ArrayList<GlossaryEntryStore> result = new ArrayList<GlossaryEntryStore>();
        GlossaryManager glossaryManager = this;
        synchronized (glossaryManager) {
            for (IGlossary en : this.glossaries.values()) {
                try {
                    for (GlossaryEntryStore ge : en.search(source, target, src)) {
                        result.add(ge);
                    }
                }
                catch (Exception ex) {
                    Log.log(ex);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GlossaryEntryStore> search(String src) {
        Language source = Core.getProject().getProjectProperties().getSourceLanguage();
        Language target = Core.getProject().getProjectProperties().getTargetLanguage();
        ArrayList<GlossaryEntryStore> result = new ArrayList<GlossaryEntryStore>();
        GlossaryManager glossaryManager = this;
        synchronized (glossaryManager) {
            for (IGlossary en : this.glossaries.values()) {
                if (en.isExternal()) continue;
                try {
                    for (GlossaryEntryStore ge : en.search(source, target, src)) {
                        result.add(ge);
                    }
                }
                catch (Exception ex) {
                    Log.log(ex);
                }
            }
        }
        return result;
    }
}

