/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.main;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.StandardCopyOption;
import java.util.HashSet;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import javax.swing.text.JTextComponent;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.KnownException;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.core.matching.NearString;
import org.omegat.core.segmentation.ISegmentationData;
import org.omegat.core.spellchecker.ISpellChecker;
import org.omegat.core.tagvalidation.ErrorReport;
import org.omegat.filehooks.IFileHook;
import org.omegat.filehooks.SdlxliffFileHook;
import org.omegat.filehooks.XliffFileHook;
import org.omegat.filters2.master.FilterMaster;
import org.omegat.filters2.master.PluginUtils;
import org.omegat.gui.dialogs.AboutDialog;
import org.omegat.gui.dialogs.AutotextAutoCompleterOptionsDialog;
import org.omegat.gui.dialogs.CharTableAutoCompleterOptionsDialog;
import org.omegat.gui.dialogs.CustomColorSelectionDialog;
import org.omegat.gui.dialogs.ExternToolsDialog;
import org.omegat.gui.dialogs.ExternalTMXMatchesDialog;
import org.omegat.gui.dialogs.FontSelectionDialog;
import org.omegat.gui.dialogs.GlossaryAutoCompleterOptionsDialog;
import org.omegat.gui.dialogs.GlossaryConfigDialog;
import org.omegat.gui.dialogs.GoToSegmentDialog;
import org.omegat.gui.dialogs.LastChangesDialog;
import org.omegat.gui.dialogs.LogDialog;
import org.omegat.gui.dialogs.SaveOptionsDialog;
import org.omegat.gui.dialogs.SpellcheckerConfigurationDialog;
import org.omegat.gui.dialogs.TagProcessingOptionsDialog;
import org.omegat.gui.dialogs.TeamOptionsDialog;
import org.omegat.gui.dialogs.UserPassDialog;
import org.omegat.gui.dialogs.ViewOptionsDialog;
import org.omegat.gui.dialogs.WorkflowOptionsDialog;
import org.omegat.gui.editor.EditorSettings;
import org.omegat.gui.editor.EditorUtils;
import org.omegat.gui.editor.IEditor;
import org.omegat.gui.editor.SegmentExportImport;
import org.omegat.gui.exttrans.MachineTranslationInfo;
import org.omegat.gui.filters2.FiltersCustomizer;
import org.omegat.gui.main.MainWindow;
import org.omegat.gui.main.MainWindowUI;
import org.omegat.gui.main.ProjectUICommands;
import org.omegat.gui.search.DirectorySearchWindow;
import org.omegat.gui.search.FullProjectSearchWindow;
import org.omegat.gui.search.PreTranslateDialog;
import org.omegat.gui.search.ReplaceDialog;
import org.omegat.gui.search.SearchWindow;
import org.omegat.gui.segmentation.SegmentationCustomizer;
import org.omegat.gui.stat.StatisticsWindow;
import org.omegat.help.Help;
import org.omegat.util.Language;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.StaticUtils;
import org.omegat.util.StringUtil;
import org.omegat.util.TagUtil;
import org.omegat.util.gui.Styles;

public class MainWindowMenuHandler {
    private final MainWindow mainWindow;

    public MainWindowMenuHandler(MainWindow mainWindow) {
        this.mainWindow = mainWindow;
    }

    public void projectNewMenuItemActionPerformed() {
        ProjectUICommands.projectCreate();
    }

    public void projectTeamNewMenuItemActionPerformed() {
        ProjectUICommands.projectTeamCreate();
    }

    public void projectOpenMenuItemActionPerformed() {
        ProjectUICommands.projectOpen(null);
    }

    public void projectMedOpenMenuItemActionPerformed() {
        ProjectUICommands.projectOpenMED();
    }

    public void projectMedCreateMenuItemActionPerformed() {
        ProjectUICommands.projectCreateMED();
    }

    public void projectImportMenuItemActionPerformed() {
        this.mainWindow.doPromptImportSourceFiles();
    }

    public void projectWikiImportMenuItemActionPerformed() {
        this.mainWindow.doWikiImport();
    }

    public void projectReloadMenuItemActionPerformed() {
        ProjectUICommands.projectReload();
    }

    public void projectCloseMenuItemActionPerformed() {
        ProjectUICommands.projectClose();
    }

    public void projectSaveMenuItemActionPerformed() {
        ProjectUICommands.projectSave();
    }

    public void projectCompileMenuItemActionPerformed() {
        List<ErrorReport> stes;
        if (Preferences.isPreference("tags_valid_required") && (stes = Core.getTagValidation().listInvalidTags()) != null) {
            Core.getTagValidation().displayTagValidationErrors(stes, OStrings.getString("TF_MESSAGE_COMPILE"));
            return;
        }
        if (!ProjectUICommands.projectPatternCompile(".*", true)) {
            JOptionPane.showMessageDialog(null, "Could not generate files. Please close any translated document(s) in Office and try again.", "", 0);
        }
    }

    public void projectSingleCompileMenuItemActionPerformed() {
        this.compileSingleFile(true);
    }

    private void compileSingleFile(boolean viewException) {
        List<ErrorReport> stes;
        String midName = Core.getEditor().getCurrentFile();
        if (StringUtil.isEmpty(midName)) {
            return;
        }
        String sourcePattern = StaticUtils.escapeNonRegex(midName);
        if (Preferences.isPreference("tags_valid_required") && (stes = Core.getTagValidation().listInvalidTags(sourcePattern)) != null) {
            Core.getTagValidation().displayTagValidationErrors(stes, OStrings.getString("TF_MESSAGE_COMPILE"));
            return;
        }
        if (!ProjectUICommands.projectPatternCompile(sourcePattern, viewException)) {
            JOptionPane.showMessageDialog(null, "Could not generate files. Please close any translated document(s) in Office and try again.", "", 0);
        }
    }

    public void projectOpenStudioMenuItemActionPerformed() {
        try {
            File targetRoot = new File(Core.getProject().getProjectProperties().getTargetRoot());
            StaticUtils.deltree(targetRoot);
            this.projectSingleCompileMenuItemActionPerformed();
            Object fileStr1 = Core.getProject().getProjectProperties().getTargetRoot() + Core.getEditor().getCurrentTargetFile();
            IFileHook hook = IFileHook.hookForFile((String)fileStr1, Core.getProject());
            Object fileStr = fileStr1 = hook.getTradosTargetFile((String)fileStr1);
            new Thread(() -> this.lambda$projectOpenStudioMenuItemActionPerformed$0((String)fileStr, targetRoot)).start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void projectSyncStudioMenuItemActionPerformed() {
        try {
            String fileStr = Core.getProject().getProjectProperties().getTargetRoot() + Core.getEditor().getCurrentTargetFile();
            File fileInProject = XliffFileHook.readOriginalFileName(fileStr);
            File parent = fileInProject.getParentFile();
            if (!(fileInProject.exists() || parent != null && parent.exists())) {
                File fileInProject2 = SdlxliffFileHook.findTradosProject(fileStr);
                if (fileInProject2 != null) {
                    fileInProject = fileInProject2;
                    parent = fileInProject2.getParentFile();
                }
            }
            Files.copy(fileInProject.toPath(), new File(Core.getEditor().getCurrentFile()).toPath(), StandardCopyOption.REPLACE_EXISTING);
            ProjectUICommands.projectReload();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void projectEditMenuItemActionPerformed() {
        ProjectUICommands.projectEditProperties();
    }

    public void viewFileListMenuItemActionPerformed() {
        if (this.mainWindow.m_projWin == null) {
            this.mainWindow.menu.viewFileListMenuItem.setSelected(false);
            return;
        }
        this.mainWindow.m_projWin.setActive(!this.mainWindow.m_projWin.isActive());
    }

    public void projectAccessRootMenuItemActionPerformed() {
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        String path = Core.getProject().getProjectProperties().getProjectRoot();
        this.openFile(new File(path));
    }

    public void projectAccessDictionaryMenuItemActionPerformed() {
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        String path = Core.getProject().getProjectProperties().getDictRoot();
        this.openFile(new File(path));
    }

    public void projectAccessGlossaryMenuItemActionPerformed() {
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        String path = Core.getProject().getProjectProperties().getGlossaryRoot();
        this.openFile(new File(path));
    }

    public void projectAccessSourceMenuItemActionPerformed() {
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        String path = Core.getProject().getProjectProperties().getSourceRoot();
        this.openFile(new File(path));
    }

    public void projectAccessTargetMenuItemActionPerformed() {
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        String path = Core.getProject().getProjectProperties().getTargetRoot();
        this.openFile(new File(path));
    }

    public void projectAccessTMMenuItemActionPerformed() {
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        String path = Core.getProject().getProjectProperties().getTMRoot();
        this.openFile(new File(path));
    }

    public void projectAccessCurrentSourceDocumentMenuItemActionPerformed(int modifier) {
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        Object path = Core.getEditor().getCurrentFile();
        if (StringUtil.isEmpty((String)path)) {
            return;
        }
        path = Core.getProject().getProjectProperties().getSourceRoot() + (String)path;
        path = IFileHook.hookForFile((String)path, Core.getProject()).getNativeSourceFile((String)path, Core.getEditor().getCurrentEntry());
        File toOpen = new File((String)path);
        if ((modifier & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0) {
            toOpen = toOpen.getParentFile();
        }
        this.openFile(toOpen);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void projectAccessCurrentTargetDocumentMenuItemActionPerformed(int modifier) {
        block25: {
            if (!Core.getProject().isProjectLoaded()) {
                return;
            }
            Object path = Core.getEditor().getCurrentTargetFile();
            if (StringUtil.isEmpty((String)path)) {
                return;
            }
            if ((modifier & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0) {
                this.openFile(new File(Core.getProject().getProjectProperties().getTargetRoot(), (String)path).getParentFile());
            } else {
                try {
                    if (ProjectUICommands.checkOpenedTargetFiles(Core.getProject().getProjectProperties().getTargetRoot())) {
                        JOptionPane.showMessageDialog(null, "Could not generate files. Please close any translated document(s) in Office and try again.", "", 0);
                        return;
                    }
                    if (ProjectUICommands.checkOpenedTargetFiles(Core.getProject().getProjectProperties().getProjectRoot() + "/target-native")) {
                        JOptionPane.showMessageDialog(null, "Could not generate files. Please close any translated document(s) in Office and try again.", "", 0);
                        return;
                    }
                    File targetRoot = new File(Core.getProject().getProjectProperties().getTargetRoot());
                    try {
                        StaticUtils.deltree(targetRoot);
                    }
                    catch (NoSuchFileException noSuchFileException) {
                        // empty catch block
                    }
                    this.compileSingleFile(false);
                    path = Core.getProject().getProjectProperties().getTargetRoot() + (String)path;
                    while (Core.getProject().lastCompileException() == null && !targetRoot.exists()) {
                        Thread.yield();
                    }
                    IFileHook hook = IFileHook.hookForFile(Core.getEditor().getCurrentFile(), Core.getProject());
                    path = hook.getNativeTargetFile((String)path);
                    System.err.println("Opening " + (String)path);
                    if (Core.getProject().lastCompileException() != null) {
                        JOptionPane.showMessageDialog(null, "Could not generate files: " + Core.getProject().lastCompileException().getMessage(), "", 0);
                        break block25;
                    }
                    if (hook.lastCompileException() != null) {
                        JOptionPane.showMessageDialog(null, "Could not generate files: " + hook.lastCompileException().getMessage(), "", 0);
                        break block25;
                    }
                    File f = new File((String)path);
                    if (f.exists()) {
                        HashSet id = new HashSet();
                        ProcessHandle.allProcesses().forEach(p -> id.add(p.pid()));
                        Desktop.getDesktop().open(f);
                        try (FileOutputStream fos = new FileOutputStream(f.getParentFile() + "/!lock-" + f.getName());){
                            ProcessHandle.allProcesses().forEach(p -> {
                                if (!id.contains(p.pid())) {
                                    try (OutputStreamWriter buf = new OutputStreamWriter(fos);){
                                        buf.write(Long.toString(p.pid()));
                                        buf.write("\n");
                                    }
                                    catch (IOException iOException) {
                                        // empty catch block
                                    }
                                }
                            });
                            break block25;
                        }
                    }
                    JOptionPane.showMessageDialog(null, "Could not generate files. Please close any translated document(s) in Office and try again.", "", 0);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    if (Core.getProject().lastCompileException() != null) {
                        Core.getProject().lastCompileException().printStackTrace();
                    }
                }
            }
        }
    }

    public void projectAccessWriteableGlossaryMenuItemActionPerformed(int modifier) {
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        String path = Core.getProject().getProjectProperties().getWriteableGlossary();
        if (StringUtil.isEmpty(path)) {
            return;
        }
        File toOpen = new File(path);
        if ((modifier & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0) {
            toOpen = toOpen.getParentFile();
        }
        this.openFile(toOpen);
    }

    private void openFile(File path) {
        try {
            path = path.getCanonicalFile();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!path.exists()) {
            Core.getMainWindow().showStatusMessageRB("LFC_ERROR_FILE_DOESNT_EXIST", path);
            return;
        }
        try {
            Desktop.getDesktop().open(path);
        }
        catch (Exception ex) {
            Log.logErrorRB(ex, "RPF_ERROR", new Object[0]);
            Core.getMainWindow().displayErrorRB(ex, "RPF_ERROR", new Object[0]);
        }
    }

    public void projectExitMenuItemActionPerformed() {
        boolean save;
        int choice = 1;
        if (Core.getProject().isProjectLoaded() && Core.getProject().isProjectModified()) {
            choice = JOptionPane.showConfirmDialog(this.mainWindow, OStrings.getString("MW_QUIT_SAVEBEFORE"), OStrings.getString("CONFIRM_DIALOG_TITLE"), 1);
            if (choice == 2) {
                return;
            }
        } else if (Preferences.isPreference("always_confirm_quit")) {
            choice = JOptionPane.showConfirmDialog(this.mainWindow, OStrings.getString("MW_QUIT_CONFIRM"), OStrings.getString("CONFIRM_DIALOG_TITLE"), 0);
            if (choice != 0) {
                Preferences.save();
                return;
            }
            choice = 1;
        }
        boolean bl = save = choice == 0;
        if (save) {
            SegmentExportImport.flushExportedSegments();
        }
        new SwingWorker<Object, Void>(){

            @Override
            protected Object doInBackground() throws Exception {
                if (save) {
                    try {
                        Core.getProject().saveProject();
                    }
                    catch (KnownException knownException) {
                        // empty catch block
                    }
                }
                CoreEvents.fireApplicationShutdown();
                PluginUtils.unloadPlugins();
                return null;
            }

            @Override
            protected void done() {
                try {
                    this.get();
                    MainWindowUI.saveScreenLayout(MainWindowMenuHandler.this.mainWindow);
                    if (save) {
                        Preferences.save();
                    }
                    System.exit(0);
                }
                catch (Exception ex) {
                    Log.logErrorRB(ex, "PP_ERROR_UNABLE_TO_READ_PROJECT_FILE", new Object[0]);
                    Core.getMainWindow().displayErrorRB(ex, "PP_ERROR_UNABLE_TO_READ_PROJECT_FILE", new Object[0]);
                }
            }
        }.execute();
    }

    public void editUndoMenuItemActionPerformed() {
        Component focused = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (focused.equals(Core.getNotes())) {
            Core.getNotes().undo();
        } else {
            Core.getEditor().undo();
        }
    }

    public void editRedoMenuItemActionPerformed() {
        Component focused = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (focused.equals(Core.getNotes())) {
            Core.getNotes().redo();
        } else {
            Core.getEditor().redo();
        }
    }

    public void editOverwriteTranslationMenuItemActionPerformed() {
        this.mainWindow.doRecycleTrans();
    }

    public void editInsertTranslationMenuItemActionPerformed() {
        this.mainWindow.doInsertTrans();
    }

    public void editOverwriteMachineTranslationMenuItemActionPerformed() {
        MachineTranslationInfo tr = Core.getMachineTranslatePane().getDisplayedTranslation();
        if (tr == null) {
            Core.getMachineTranslatePane().forceLoad();
        } else if (!StringUtil.isEmpty(tr.result.toString())) {
            Core.getEditor().replaceEditTextWithColor(tr.result.toString(), Styles.EditorColor.COLOR_MARK_COMES_FROM_MACHINE_TRANSLATION.getColor(), true);
            Core.getEditor().insertInfo(" " + OStrings.getString("TF_SEG_COMESFROM_MT_PANE") + " (" + tr.origin.getName() + ")");
        }
    }

    public void editOverwriteSourceMenuItemActionPerformed() {
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        String toInsert = Core.getEditor().getCurrentEntry().getSrcText();
        if (Preferences.isPreference("glossary_replace_on_insert")) {
            toInsert = EditorUtils.replaceGlossaryEntries(toInsert);
        }
        Core.getEditor().replaceEditTextWithColor(toInsert, Styles.EditorColor.COLOR_INSERT_SOURCE.getColor(), false);
    }

    public void editInsertSourceMenuItemActionPerformed() {
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        String toInsert = Core.getEditor().getCurrentEntry().getSrcText();
        if (Preferences.isPreference("glossary_replace_on_insert")) {
            toInsert = EditorUtils.replaceGlossaryEntries(toInsert);
        }
        Core.getEditor().insertText(toInsert);
    }

    public void editExportSelectionMenuItemActionPerformed() {
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        String selection = Core.getEditor().getSelectedText();
        if (selection == null) {
            SourceTextEntry ste = Core.getEditor().getCurrentEntry();
            TMXEntry te = Core.getProject().getTranslationInfo(ste.getKey());
            selection = te.isTranslated() ? te.translation : ste.getSrcText();
        }
        SegmentExportImport.exportCurrentSelection(selection);
    }

    public void editCreateGlossaryEntryMenuItemActionPerformed() {
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        Core.getGlossary().showCreateGlossaryEntryDialog();
    }

    public void editFindInProjectMenuItemActionPerformed() {
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        FullProjectSearchWindow search = new FullProjectSearchWindow(this.mainWindow, this.getTrimmedSelectedTextInMainWindow());
        this.mainWindow.addSearchWindow(search);
        search.setVisible(true);
    }

    public void editFindInDirectoryMenuItemActionPerformed() {
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        DirectorySearchWindow search = new DirectorySearchWindow(this.mainWindow, this.getTrimmedSelectedTextInMainWindow());
        this.mainWindow.addSearchWindow(search);
        search.setVisible(true);
    }

    void findInProjectReuseLastWindow() {
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        List<SearchWindow> windows = this.mainWindow.getSearchWindows();
        for (int i = windows.size() - 1; i >= 0; --i) {
            SearchWindow swc = windows.get(i);
            if (!(swc instanceof FullProjectSearchWindow)) continue;
            swc.getMainSearchTextField().setSelectedItem(this.getTrimmedSelectedTextInMainWindow());
            swc.setVisible(true);
        }
        this.editFindInProjectMenuItemActionPerformed();
    }

    public void editReplaceInProjectMenuItemActionPerformed() {
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        ReplaceDialog dialog = new ReplaceDialog(this.mainWindow, this.getTrimmedSelectedTextInMainWindow(), null);
        dialog.setVisible(true);
    }

    public void editPreTranslateMenuItemActionPerformed() {
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        PreTranslateDialog dialog = new PreTranslateDialog(this.mainWindow, this.getTrimmedSelectedTextInMainWindow());
        dialog.setVisible(true);
    }

    private String getTrimmedSelectedTextInMainWindow() {
        String selection = Core.getEditor().getSelectedText();
        if (selection == null) {
            selection = ((JTextComponent)((Object)Core.getMatcher())).getSelectedText();
        }
        if (selection == null) {
            selection = Core.getMachineTranslatePane().getSelectedText();
        }
        if (selection == null) {
            selection = Core.getGlossary().getSelectedText();
        }
        if (selection == null) {
            selection = ((JTextComponent)((Object)Core.getNotes())).getSelectedText();
        }
        if (selection == null) {
            selection = ((JTextComponent)((Object)Core.getComments())).getSelectedText();
        }
        if (selection == null) {
            selection = ((JTextComponent)((Object)Core.getDictionaries())).getSelectedText();
        }
        return selection;
    }

    public void editSelectFuzzy1MenuItemActionPerformed() {
        Core.getMatcher().setActiveMatch(0);
    }

    public void editSelectFuzzy2MenuItemActionPerformed() {
        Core.getMatcher().setActiveMatch(1);
    }

    public void editSelectFuzzy3MenuItemActionPerformed() {
        Core.getMatcher().setActiveMatch(2);
    }

    public void editSelectFuzzy4MenuItemActionPerformed() {
        Core.getMatcher().setActiveMatch(3);
    }

    public void editSelectFuzzy5MenuItemActionPerformed() {
        Core.getMatcher().setActiveMatch(4);
    }

    public void editSelectFuzzyNextMenuItemActionPerformed() {
        Core.getMatcher().setNextActiveMatch();
    }

    public void editSelectFuzzyPrevMenuItemActionPerformed() {
        Core.getMatcher().setPrevActiveMatch();
    }

    public void insertCharsLRMActionPerformed() {
        Core.getEditor().insertText("\u200e");
    }

    public void insertCharsRLMActionPerformed() {
        Core.getEditor().insertText("\u200f");
    }

    public void insertCharsLREActionPerformed() {
        Core.getEditor().insertText("\u202a");
    }

    public void insertCharsRLEActionPerformed() {
        Core.getEditor().insertText("\u202b");
    }

    public void insertCharsPDFActionPerformed() {
        Core.getEditor().insertText("\u202c");
    }

    public void editMultipleDefaultActionPerformed() {
        Core.getEditor().setAlternateTranslationForCurrentEntry(false);
    }

    public void editMultipleAlternateActionPerformed() {
        Core.getEditor().setAlternateTranslationForCurrentEntry(true);
    }

    public void editRegisterUntranslatedMenuItemActionPerformed() {
        Core.getEditor().registerUntranslated();
    }

    public void editRegisterEmptyMenuItemActionPerformed() {
        Core.getEditor().registerEmptyTranslation();
    }

    public void editRegisterIdenticalMenuItemActionPerformed() {
        Core.getEditor().registerIdenticalTranslation();
    }

    public void cycleSwitchCaseMenuItemActionPerformed() {
        Core.getEditor().changeCase(IEditor.CHANGE_CASE_TO.CYCLE);
    }

    public void sentenceCaseMenuItemActionPerformed() {
        Core.getEditor().changeCase(IEditor.CHANGE_CASE_TO.SENTENCE);
    }

    public void titleCaseMenuItemActionPerformed() {
        Core.getEditor().changeCase(IEditor.CHANGE_CASE_TO.TITLE);
    }

    public void upperCaseMenuItemActionPerformed() {
        Core.getEditor().changeCase(IEditor.CHANGE_CASE_TO.UPPER);
    }

    public void lowerCaseMenuItemActionPerformed() {
        Core.getEditor().changeCase(IEditor.CHANGE_CASE_TO.LOWER);
    }

    public void gotoNextUntranslatedMenuItemActionPerformed() {
        Core.getEditor().nextUntranslatedEntry();
    }

    public void gotoNextUniqueMenuItemActionPerformed() {
        Core.getEditor().nextUniqueEntry();
    }

    public void gotoNextTranslatedMenuItemActionPerformed() {
        Core.getEditor().nextTranslatedEntry();
    }

    public void gotoNextSegmentMenuItemActionPerformed() {
        Core.getEditor().nextEntry();
    }

    public void gotoPreviousSegmentMenuItemActionPerformed() {
        Core.getEditor().prevEntry();
    }

    public void gotoNextNoteMenuItemActionPerformed() {
        Core.getEditor().nextEntryWithNote();
    }

    public void gotoPreviousNoteMenuItemActionPerformed() {
        Core.getEditor().prevEntryWithNote();
    }

    public void gotoNextUnrevisedMenuItemActionPerformed() {
        Core.getEditor().nextUnrevisedEntry();
    }

    public void gotoNextRevisedMenuItemActionPerformed() {
        Core.getEditor().nextRevisedChangedEntry();
    }

    public void gotoPreviousRevisedMenuItemActionPerformed() {
        Core.getEditor().prevRevisedChangedEntry();
    }

    public void gotoSegmentMenuItemActionPerformed() {
        GoToSegmentDialog dialog = new GoToSegmentDialog(this.mainWindow);
        dialog.setVisible(true);
        int jumpTo = dialog.getResult();
        if (jumpTo != -1) {
            Core.getEditor().gotoEntry(jumpTo);
        }
    }

    public void gotoHistoryBackMenuItemActionPerformed() {
        Core.getEditor().gotoHistoryBack();
    }

    public void gotoHistoryForwardMenuItemActionPerformed() {
        Core.getEditor().gotoHistoryForward();
    }

    public void gotoMatchSourceSegmentActionPerformed() {
        NearString ns = Core.getMatcher().getActiveMatch();
        if (ns != null && ns.comesFrom == NearString.MATCH_SOURCE.MEMORY) {
            Core.getEditor().gotoEntry(ns.source, ns.key);
        }
    }

    public void viewMarkTranslatedSegmentsCheckBoxMenuItemActionPerformed() {
        Core.getEditor().getSettings().setMarkTranslated(this.mainWindow.menu.viewMarkTranslatedSegmentsCheckBoxMenuItem.isSelected());
    }

    public void viewMarkUntranslatedSegmentsCheckBoxMenuItemActionPerformed() {
        Core.getEditor().getSettings().setMarkUntranslated(this.mainWindow.menu.viewMarkUntranslatedSegmentsCheckBoxMenuItem.isSelected());
    }

    public void viewMarkParagraphStartCheckBoxMenuItemActionPerformed() {
        Core.getEditor().getSettings().setMarkParagraphDelimitations(this.mainWindow.menu.viewMarkParagraphStartCheckBoxMenuItem.isSelected());
    }

    public void viewDisplaySegmentSourceCheckBoxMenuItemActionPerformed() {
        Core.getEditor().getSettings().setDisplaySegmentSources(this.mainWindow.menu.viewDisplaySegmentSourceCheckBoxMenuItem.isSelected());
    }

    public void viewHideTagonlyCheckBoxMenuItemActionPerformed() {
        boolean isSelected = this.mainWindow.menu.viewHideTagonlyCheckBoxMenuItem.isSelected();
        if (isSelected) {
            String val = JOptionPane.showInputDialog(null, "Regular expression for segments to be hidden", Preferences.getPreferenceDefault("expr_tagonly_segments", "^[\\p{Zs}\\u200C]*(<[^>]+>[\\p{Zs}\\u200C]*)+$"));
            if (val != null) {
                Preferences.setPreference("expr_tagonly_segments", val);
            } else {
                isSelected = false;
                this.mainWindow.menu.viewHideTagonlyCheckBoxMenuItem.setSelected(false);
            }
        }
        Core.getEditor().getSettings().setHideTagonlySegments(isSelected);
    }

    public void viewMarkNonUniqueSegmentsCheckBoxMenuItemActionPerformed() {
        Core.getEditor().getSettings().setMarkNonUniqueSegments(this.mainWindow.menu.viewMarkNonUniqueSegmentsCheckBoxMenuItem.isSelected());
    }

    public void viewMarkNotedSegmentsCheckBoxMenuItemActionPerformed() {
        Core.getEditor().getSettings().setMarkNotedSegments(this.mainWindow.menu.viewMarkNotedSegmentsCheckBoxMenuItem.isSelected());
    }

    public void viewMarkRevisedSegmentsCheckBoxMenuItemActionPerformed() {
        Core.getEditor().getSettings().setMarkRevisedSegments(this.mainWindow.menu.viewMarkRevisedSegmentsCheckBoxMenuItem.isSelected());
        if (this.mainWindow.menu.viewMarkRevisedSegmentsCheckBoxMenuItem.isSelected()) {
            Preferences.setPreference("ext_tmx_match_template", Preferences.getPreference("ext_tmx_match_template").replace("${targetText}", "${diffTra}"));
        } else {
            Preferences.setPreference("ext_tmx_match_template", Preferences.getPreference("ext_tmx_match_template").replace("${diffTra}", "${targetText}"));
        }
    }

    public void viewMarkNBSPCheckBoxMenuItemActionPerformed() {
        Core.getEditor().getSettings().setMarkNBSP(this.mainWindow.menu.viewMarkNBSPCheckBoxMenuItem.isSelected());
    }

    public void viewMarkWhitespaceCheckBoxMenuItemActionPerformed() {
        Core.getEditor().getSettings().setMarkWhitespace(this.mainWindow.menu.viewMarkWhitespaceCheckBoxMenuItem.isSelected());
    }

    public void viewMarkBidiCheckBoxMenuItemActionPerformed() {
        Core.getEditor().getSettings().setMarkBidi(this.mainWindow.menu.viewMarkBidiCheckBoxMenuItem.isSelected());
    }

    public void viewMarkAutoPopulatedCheckBoxMenuItemActionPerformed() {
        Core.getEditor().getSettings().setMarkAutoPopulated(this.mainWindow.menu.viewMarkAutoPopulatedCheckBoxMenuItem.isSelected());
    }

    public void viewMarkLanguageCheckerCheckBoxMenuItemActionPerformed() {
        Core.getEditor().getSettings().setMarkLanguageChecker(this.mainWindow.menu.viewMarkLanguageCheckerCheckBoxMenuItem.isSelected());
    }

    public void viewMarkFontFallbackCheckBoxMenuItemActionPerformed() {
        Core.getEditor().getSettings().setDoFontFallback(this.mainWindow.menu.viewMarkFontFallbackCheckBoxMenuItem.isSelected());
    }

    public void viewDisplayModificationInfoNoneRadioButtonMenuItemActionPerformed() {
        Core.getEditor().getSettings().setDisplayModificationInfo(EditorSettings.DISPLAY_MODIFICATION_INFO_NONE);
    }

    public void viewDisplayModificationInfoSelectedRadioButtonMenuItemActionPerformed() {
        Core.getEditor().getSettings().setDisplayModificationInfo(EditorSettings.DISPLAY_MODIFICATION_INFO_SELECTED);
    }

    public void viewDisplayModificationInfoAllRadioButtonMenuItemActionPerformed() {
        Core.getEditor().getSettings().setDisplayModificationInfo(EditorSettings.DISPLAY_MODIFICATION_INFO_ALL);
    }

    public void toolsValidateTagsMenuItemActionPerformed() {
        Core.getTagValidation().displayTagValidationErrors(Core.getTagValidation().listInvalidTags(), null);
    }

    public void toolsSingleValidateTagsMenuItemActionPerformed() {
        String midName = Core.getEditor().getCurrentFile();
        List<ErrorReport> stes = null;
        if (!StringUtil.isEmpty(midName)) {
            String sourcePattern = StaticUtils.escapeNonRegex(midName);
            stes = Core.getTagValidation().listInvalidTags(sourcePattern);
        }
        Core.getTagValidation().displayTagValidationErrors(stes, null);
    }

    public void editTagPainterMenuItemActionPerformed() {
        for (TagUtil.Tag tag : TagUtil.getAllTagsMissingFromTarget()) {
            Core.getEditor().insertTag(tag.tag);
        }
    }

    public void editTagNextMissedMenuItemActionPerformed() {
        List<TagUtil.Tag> tags = TagUtil.getAllTagsMissingFromTarget();
        if (tags.isEmpty()) {
            return;
        }
        Core.getEditor().insertTag(tags.get((int)0).tag);
    }

    public void toolsShowStatisticsStandardMenuItemActionPerformed() {
        new StatisticsWindow(StatisticsWindow.STAT_TYPE.STANDARD).setVisible(true);
    }

    public void toolsShowStatisticsMatchesMenuItemActionPerformed() {
        new StatisticsWindow(StatisticsWindow.STAT_TYPE.MATCHES).setVisible(true);
    }

    public void toolsShowStatisticsMatchesPerFileMenuItemActionPerformed() {
        new StatisticsWindow(StatisticsWindow.STAT_TYPE.MATCHES_PER_FILE).setVisible(true);
    }

    public void toolsShowStatisticsRevisionMenuItemActionPerformed() {
        new StatisticsWindow(StatisticsWindow.STAT_TYPE.REVISION).setVisible(true);
    }

    public void optionsTabAdvanceCheckBoxMenuItemActionPerformed() {
        Core.getEditor().getSettings().setUseTabForAdvance(this.mainWindow.menu.optionsTabAdvanceCheckBoxMenuItem.isSelected());
    }

    public void optionsAlwaysConfirmQuitCheckBoxMenuItemActionPerformed() {
        Preferences.setPreference("always_confirm_quit", this.mainWindow.menu.optionsAlwaysConfirmQuitCheckBoxMenuItem.isSelected());
    }

    public void optionsMTshowDurationActionPerformed() {
        Preferences.setPreference("mt_show_duration", this.mainWindow.menu.optionsMTshowDuration.isSelected());
    }

    public void revisionModeMenuItemActionPerformed() {
        this.mainWindow.updateTitle();
        this.mainWindow.menu.gotoNextUntranslatedMenuItem.setEnabled(!this.mainWindow.menu.revisionModeMenuItem.isSelected());
        this.mainWindow.menu.gotoNextTranslatedMenuItem.setEnabled(!this.mainWindow.menu.revisionModeMenuItem.isSelected());
        this.mainWindow.menu.gotoNextRevisedMenuItem.setEnabled(!this.mainWindow.menu.revisionModeMenuItem.isSelected());
        this.mainWindow.menu.gotoPreviousRevisedMenuItem.setEnabled(!this.mainWindow.menu.revisionModeMenuItem.isSelected());
        this.mainWindow.menu.gotoNextUnrevisedMenuItem.setEnabled(this.mainWindow.menu.revisionModeMenuItem.isSelected());
        this.mainWindow.menu.viewMarkRevisedSegmentsCheckBoxMenuItem.setEnabled(!this.mainWindow.menu.revisionModeMenuItem.isSelected());
        if (this.mainWindow.menu.revisionModeMenuItem.isSelected()) {
            this.mainWindow.menu.viewMarkRevisedSegmentsCheckBoxMenuItem.setSelected(false);
        }
    }

    public void optionsGlossaryConfigMenuItemActionPerformed() {
        GlossaryConfigDialog dlg = new GlossaryConfigDialog(Core.getMainWindow().getApplicationFrame());
        dlg.setVisible(true);
    }

    public void optionsAutoCompleteShowAutomaticallyItemActionPerformed() {
        Preferences.setPreference("ac_show_suggestions_automatically", this.mainWindow.menu.optionsAutoCompleteShowAutomaticallyItem.isSelected());
    }

    public void optionsAutoCompleteGlossaryMenuItemActionPerformed() {
        new GlossaryAutoCompleterOptionsDialog(this.mainWindow).setVisible(true);
    }

    public void optionsAutoCompleteAutoTextMenuItemActionPerformed() {
        new AutotextAutoCompleterOptionsDialog(this.mainWindow).setVisible(true);
    }

    public void optionsAutoCompleteCharTableMenuItemActionPerformed() {
        new CharTableAutoCompleterOptionsDialog(this.mainWindow).setVisible(true);
    }

    public void optionsMTAutoFetchCheckboxMenuItemActionPerformed() {
        boolean enabled = this.mainWindow.menu.optionsMTAutoFetchCheckboxMenuItem.isSelected();
        Preferences.setPreference("mt_auto_fetch", enabled);
        this.mainWindow.menu.optionsMTOnlyUntranslatedCheckboxMenuItem.setEnabled(enabled);
    }

    public void optionsMTOnlyUntranslatedCheckboxMenuItemActionPerformed() {
        Preferences.setPreference("mt_only_untranslated", this.mainWindow.menu.optionsMTOnlyUntranslatedCheckboxMenuItem.isSelected());
    }

    public void optionsGlossaryTBXDisplayContextCheckBoxMenuItemActionPerformed() {
        Preferences.setPreference("glossary_tbx_display_context", this.mainWindow.menu.optionsGlossaryTBXDisplayContextCheckBoxMenuItem.isSelected());
        Preferences.save();
        Core.getGlossaryManager().forceReloadTBX();
    }

    public void optionsGlossaryReplacementCheckBoxMenuItemActionPerformed() {
        Preferences.setPreference("glossary_replace_on_insert", this.mainWindow.menu.optionsGlossaryReplacementCheckBoxMenuItem.isSelected());
    }

    public void optionsDictionaryFuzzyMatchingCheckBoxMenuItemActionPerformed() {
        Preferences.setPreference("dictionary_fuzzy_matching", this.mainWindow.menu.optionsDictionaryFuzzyMatchingCheckBoxMenuItem.isSelected());
        Preferences.save();
        Core.getDictionaries().refresh();
    }

    public void optionsFontSelectionMenuItemActionPerformed() {
        FontSelectionDialog dlg = new FontSelectionDialog((Frame)Core.getMainWindow().getApplicationFrame(), Core.getMainWindow().getApplicationFont());
        dlg.setVisible(true);
        if (dlg.getReturnStatus() == 1) {
            this.mainWindow.setApplicationFont(dlg.getSelectedFont());
        }
    }

    public void optionsColorsSelectionMenuItemActionPerformed() {
        CustomColorSelectionDialog dlg = new CustomColorSelectionDialog(Core.getMainWindow().getApplicationFrame());
        dlg.setVisible(true);
    }

    public void optionsSetupFileFiltersMenuItemActionPerformed() {
        FiltersCustomizer dlg = null;
        if (Core.getProject().isProjectLoaded() && new File(Core.getProject().getProjectProperties().getProjectInternal() + File.separator + "filters.xml").exists()) {
            switch (JOptionPane.showConfirmDialog(this.mainWindow, OStrings.getString("MW_FILTER_SPECIFIC_QUESTION"), OStrings.getString("CONFIRM_DIALOG_TITLE"), 1)) {
                case 0: {
                    dlg = new FiltersCustomizer(this.mainWindow, true, FilterMaster.createDefaultFiltersConfig(), FilterMaster.loadConfig(StaticUtils.getConfigDir()), FilterMaster.loadConfig(Core.getProject().getProjectProperties().getProjectInternal()));
                    break;
                }
                case 1: {
                    dlg = new FiltersCustomizer(this.mainWindow, false, FilterMaster.createDefaultFiltersConfig(), FilterMaster.loadConfig(StaticUtils.getConfigDir()), null);
                    break;
                }
                case 2: {
                    return;
                }
            }
        } else {
            dlg = new FiltersCustomizer(this.mainWindow, false, FilterMaster.createDefaultFiltersConfig(), FilterMaster.loadConfig(StaticUtils.getConfigDir()), null);
        }
        dlg.setVisible(true);
        if (dlg.getReturnStatus() == 1) {
            if (!dlg.isProjectSpecific()) {
                FilterMaster.saveConfig(dlg.result, StaticUtils.getConfigDir());
                if (Core.getProject().isProjectLoaded()) {
                    if (FilterMaster.loadConfig(Core.getProject().getProjectProperties().getProjectInternal()) != null) {
                        return;
                    }
                    int res = JOptionPane.showConfirmDialog(this.mainWindow, OStrings.getString("MW_REOPEN_QUESTION"), OStrings.getString("MW_REOPEN_TITLE"), 0);
                    if (res == 0) {
                        ProjectUICommands.projectReload();
                    }
                }
            } else {
                FilterMaster.saveConfig(dlg.result, Core.getProject().getProjectProperties().getProjectInternal());
                int res = JOptionPane.showConfirmDialog(this.mainWindow, OStrings.getString("MW_REOPEN_QUESTION"), OStrings.getString("MW_REOPEN_TITLE"), 0);
                if (res == 0) {
                    ProjectUICommands.projectReload();
                }
            }
        }
    }

    public void optionsSentsegMenuItemActionPerformed() {
        SegmentationCustomizer segment_window = new SegmentationCustomizer(this.mainWindow, false, ISegmentationData.getDefault(), Preferences.getSegmentationData().toSRX(), null);
        segment_window.setVisible(true);
        if (segment_window.getReturnStatus() == 1) {
            int res;
            Preferences.setSegmentationData(segment_window.getSRX());
            if (Core.getProject().isProjectLoaded() && Core.getProject().getProjectProperties().getProjectSegmentationData() == null && (res = JOptionPane.showConfirmDialog(this.mainWindow, OStrings.getString("MW_REOPEN_QUESTION"), OStrings.getString("MW_REOPEN_TITLE"), 0)) == 0) {
                ProjectUICommands.projectReload();
            }
        }
    }

    public void optionsSpellCheckMenuItemActionPerformed() {
        Language currentLanguage = Core.getProject().isProjectLoaded() ? Core.getProject().getProjectProperties().getTargetLanguage() : new Language(Preferences.getPreference("target_lang"));
        SpellcheckerConfigurationDialog sd = new SpellcheckerConfigurationDialog((Frame)this.mainWindow, currentLanguage);
        sd.setVisible(true);
        if (sd.getReturnStatus() == 1) {
            boolean isNeedToSpell = Preferences.isPreference("allow_auto_spellchecking");
            if (isNeedToSpell && Core.getProject().isProjectLoaded()) {
                ISpellChecker sc = Core.getSpellChecker();
                sc.destroy();
                sc.initialize();
            }
            Core.getEditor().getSettings().setAutoSpellChecking(isNeedToSpell);
        }
    }

    public void optionsWorkflowMenuItemActionPerformed() {
        new WorkflowOptionsDialog(this.mainWindow).setVisible(true);
    }

    public void optionsTagValidationMenuItemActionPerformed() {
        TagProcessingOptionsDialog tagProcessingOptionsDialog = new TagProcessingOptionsDialog(this.mainWindow);
        tagProcessingOptionsDialog.setVisible(true);
        if (tagProcessingOptionsDialog.getReturnStatus() == 1 && Core.getProject().isProjectLoaded()) {
            Core.getEditor().getSettings().updateTagValidationPreferences();
            int res = JOptionPane.showConfirmDialog(this.mainWindow, OStrings.getString("MW_REOPEN_QUESTION"), OStrings.getString("MW_REOPEN_TITLE"), 0);
            if (res == 0) {
                ProjectUICommands.projectReload();
            }
        }
    }

    public void optionsTeamMenuItemActionPerformed() {
        new TeamOptionsDialog(this.mainWindow).setVisible(true);
    }

    public void optionsExtTMXMenuItemActionPerformed() {
        int res;
        ExternalTMXMatchesDialog externalTMXOptions = new ExternalTMXMatchesDialog(this.mainWindow);
        externalTMXOptions.setVisible(true);
        if (externalTMXOptions.getReturnStatus() == 1 && Core.getProject().isProjectLoaded() && (res = JOptionPane.showConfirmDialog(this.mainWindow, OStrings.getString("MW_REOPEN_QUESTION"), OStrings.getString("MW_REOPEN_TITLE"), 0)) == 0) {
            ProjectUICommands.projectReload();
        }
    }

    public void optionsViewOptionsMenuItemActionPerformed() {
        ViewOptionsDialog viewOptions = new ViewOptionsDialog(this.mainWindow);
        viewOptions.setVisible(true);
        if (viewOptions.getReturnStatus() == 1 && Core.getProject().isProjectLoaded()) {
            Core.getEditor().getSettings().updateViewPreferences();
        }
    }

    public void optionsSaveOptionsMenuItemActionPerformed() {
        SaveOptionsDialog saveOptions = new SaveOptionsDialog(this.mainWindow);
        saveOptions.setVisible(true);
    }

    public void optionsExternOptionsMenuItemActionPerformed() {
        ExternToolsDialog ext = new ExternToolsDialog(this.mainWindow);
        ext.setVisible(true);
    }

    public void optionsRestoreGUIMenuItemActionPerformed() {
        MainWindowUI.resetDesktopLayout(this.mainWindow);
    }

    public void optionsAccessConfigDirMenuItemActionPerformed() {
        this.openFile(new File(StaticUtils.getConfigDir()));
    }

    public void helpContentsMenuItemActionPerformed() {
        try {
            Help.showHelp();
        }
        catch (Exception ex) {
            Log.log(ex);
        }
    }

    public void helpAboutMenuItemActionPerformed() {
        new AboutDialog(this.mainWindow).setVisible(true);
    }

    public void helpLastChangesMenuItemActionPerformed() {
        new LastChangesDialog(this.mainWindow).setVisible(true);
    }

    public void helpHaikuMenuItemActionPerformed() {
        LastChangesDialog dialog = new LastChangesDialog(this.mainWindow);
        dialog.load("something-not-existing");
        dialog.setVisible(true);
    }

    public void helpLogMenuItemActionPerformed() {
        new LogDialog(this.mainWindow).setVisible(true);
    }

    public void optionsViewOptionsMenuLoginItemActionPerformed() {
        UserPassDialog proxyOptions = new UserPassDialog(this.mainWindow);
        String encodedUser = Preferences.getPreference("proxy_user_name");
        String encodedPassword = Preferences.getPreference("proxy_password");
        try {
            proxyOptions.userText.setText(new String(StringUtil.decodeBase64(encodedUser)));
            proxyOptions.passwordField.setText(new String(StringUtil.decodeBase64(encodedPassword)));
        }
        catch (IllegalArgumentException ex) {
            Log.logErrorRB("LOG_DECODING_ERROR", new Object[0]);
            Log.log(ex);
        }
        proxyOptions.setVisible(true);
        if (proxyOptions.getReturnStatus() == 1) {
            encodedUser = StringUtil.encodeBase64(proxyOptions.userText.getText().getBytes());
            encodedPassword = StringUtil.encodeBase64(new String(proxyOptions.passwordField.getPassword()).getBytes());
            Preferences.setPreference("proxy_user_name", encodedUser);
            Preferences.setPreference("proxy_password", encodedPassword);
        }
    }

    private /* synthetic */ void lambda$projectOpenStudioMenuItemActionPerformed$0(String fileStr, File targetRoot) {
        try {
            System.err.println("Opening " + fileStr);
            File f = new File(fileStr);
            while (!targetRoot.exists()) {
                Thread.yield();
            }
            if (f.exists()) {
                Core.getMainWindow().showProgressMessage("Reading sdlxliff");
                File fileInProject = XliffFileHook.readOriginalFileName(fileStr);
                File parent = fileInProject.getParentFile();
                if (!(fileInProject.exists() || parent != null && parent.exists())) {
                    File fileInProject2 = SdlxliffFileHook.findTradosProject(fileStr);
                    if (fileInProject2 != null) {
                        fileInProject = fileInProject2;
                        parent = fileInProject2.getParentFile();
                    }
                }
                if (fileInProject.exists() || parent != null && parent.exists()) {
                    File sdlproj = null;
                    block3: while (parent != null) {
                        parent = parent.getParentFile();
                        for (File child : parent.listFiles()) {
                            if (!child.getName().endsWith(".sdlproj")) continue;
                            sdlproj = child;
                            break block3;
                        }
                    }
                    if (sdlproj != null) {
                        Log.log("Found project: " + sdlproj);
                        Files.copy(f.toPath(), new File(sdlproj.getParentFile(), Core.getProject().getProjectProperties().getTargetLanguage() + File.separator + f.getName()).toPath(), StandardCopyOption.REPLACE_EXISTING);
                        Runtime.getRuntime().exec(new String[]{Preferences.getPreference("trados_path") + "\\SdlTradosStudio.exe", "/openProject", sdlproj.getCanonicalPath()});
                        return;
                    }
                }
                Process proc = Runtime.getRuntime().exec(new String[]{Preferences.getPreference("trados_path") + "\\SdlTradosStudio.exe", "/openDocument", fileStr});
                Core.getMainWindow().showProgressMessage("");
                this.mainWindow.menu.projectSyncStudioMenuItem.setEnabled(true);
                if (Preferences.getPreferenceDefault("trados_auto_sync", 0) > 0) {
                    File curSource = new File(Core.getEditor().getCurrentFile());
                    while (proc.isAlive()) {
                        Thread.sleep(Preferences.getPreferenceDefault("trados_auto_sync", 0) * 1000);
                        if (fileInProject.length() == curSource.length() || JOptionPane.showConfirmDialog(null, "File " + curSource.getName() + " modified in Studio, synchronize?", OStrings.getString("CONFIRM_DIALOG_TITLE"), 0) != 0) continue;
                        Files.copy(fileInProject.toPath(), curSource.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    }
                }
            } else {
                JOptionPane.showMessageDialog(null, "Could not generate files. Please close any translated document(s) in Office and try again.", "", 0);
            }
        }
        catch (Exception io) {
            io.printStackTrace();
        }
    }
}

