/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.search;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.text.JTextComponent;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.glossaries.GlossaryEntryStore;
import org.omegat.core.search.FullProjectSearcher;
import org.omegat.core.search.ProjectSearcher;
import org.omegat.core.search.Searcher;
import org.omegat.core.search.TextExpression;
import org.omegat.core.search.TranslationStateFilter;
import org.omegat.gui.editor.EditorPopups;
import org.omegat.gui.editor.PopupMenuDisplayer;
import org.omegat.gui.editor.filter.SearchFilter;
import org.omegat.gui.main.MainWindow;
import org.omegat.gui.search.ProjectSearchWindow;
import org.omegat.gui.search.SearchWindow;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.StringUtil;
import org.openide.awt.Mnemonics;

public class FullProjectSearchWindow
extends ProjectSearchWindow {
    private static final Map<String, Set<String>> theMap = new HashMap<String, Set<String>>();
    public static final Set<String> L_FILES;
    private JCheckBox m_sourceSearchCB;
    private JCheckBox m_tmSearchCB;
    private JCheckBox m_ongoingSearchCB;
    private JCheckBox m_orphansSearchCB;
    private JCheckBox m_glossaryCB;
    private ProjectSearchWindow.MemoryTextField m_FileNameField;
    private JRadioButton m_searchTranslated;
    private JRadioButton m_searchUntranslated;
    private JRadioButton m_searchTranslatedUntranslated;
    private ProjectSearchWindow.MemoryTextField m_searchSource;
    private ProjectSearchWindow.MemoryTextField m_searchTarget;
    private ProjectSearchWindow.MemoryTextField m_searchNotes;
    private JCheckBox m_searchAllSame;
    private JRadioButton m_AND;
    private JRadioButton m_OR;
    private JRadioButton m_ANDTHEN;
    private JButton m_filterButton;
    private JButton m_removeAttachedFilterButton;

    @Override
    public void refreshLists(boolean removeContents) {
        this.m_searchSource.changeValuesSet(theMap.get("SW_SEARCH_SOURCE:" + this.m_modePanel.searchTypeString()), removeContents);
        this.m_searchTarget.changeValuesSet(theMap.get("SW_SEARCH_TRANSLATION:" + this.m_modePanel.searchTypeString()), removeContents);
        this.m_searchNotes.changeValuesSet(theMap.get("SW_SEARCH_NOTES:" + this.m_modePanel.searchTypeString()), removeContents);
        this.m_FileNameField.changeValuesSet(theMap.get("SW_SEARCH_FILE:" + this.m_modePanel.searchTypeString()), removeContents);
    }

    public FullProjectSearchWindow(MainWindow par, String startText) {
        super(par, startText);
        this.refreshLists(true);
        HashMap<ProjectSearchWindow.MemoryTextField, PopupMenuDisplayer> factories = new HashMap<ProjectSearchWindow.MemoryTextField, PopupMenuDisplayer>();
        for (ProjectSearchWindow.MemoryTextField box : new ProjectSearchWindow.MemoryTextField[]{this.m_searchSource, this.m_searchTarget, this.m_searchNotes}) {
            JTextComponent searchFieldArea = (JTextComponent)box.getTextField().getEditor().getEditorComponent();
            factories.put(box, FullProjectSearchWindow.getPopupFactory(searchFieldArea));
            searchFieldArea.addMouseListener((MouseListener)factories.get(box));
        }
        ((PopupMenuDisplayer)factories.get((Object)this.m_searchSource)).popupConstructors.put(600, (menu, comp, mousepos, isInActiveEntry, isInActiveTranslation, sb) -> {
            if (this.m_searchTarget.getValue() != null && this.m_searchTarget.getValue().trim().length() > 0) {
                TreeSet<String> entries = new TreeSet<String>();
                for (GlossaryEntryStore entry : Core.getGlossaryManager().getGlossaryEntries(this.m_searchTarget.getValue())) {
                    if (!this.m_searchTarget.getValue().equals(entry.getLocText())) continue;
                    entries.add(entry.getSrcText());
                }
                EditorPopups.IMenuReceiver receiver = EditorPopups.createReceiver(menu, entries.size(), "Insert from glossary");
                for (String entry : entries) {
                    receiver.addItem(entry, ev -> this.m_searchTarget.getTextField().setSelectedItem(entry));
                }
                menu.addSeparator();
            }
        });
        ((PopupMenuDisplayer)factories.get((Object)this.m_searchTarget)).popupConstructors.put(600, (menu, comp, mousepos, isInActiveEntry, isInActiveTranslation, sb) -> {
            if (this.m_searchSource.getValue() != null && this.m_searchSource.getValue().trim().length() > 0) {
                TreeSet<String> entries = new TreeSet<String>();
                for (GlossaryEntryStore entry : Core.getGlossaryManager().getGlossaryEntries(this.m_searchSource.getValue())) {
                    if (!this.m_searchSource.getValue().equals(entry.getSrcText())) continue;
                    entries.add(entry.getLocText());
                }
                EditorPopups.IMenuReceiver receiver = EditorPopups.createReceiver(menu, entries.size(), "Insert from glossary");
                for (String entry : entries) {
                    receiver.addItem(entry, ev -> this.m_searchTarget.getTextField().setSelectedItem(entry));
                }
                menu.addSeparator();
            }
        });
        if (startText != null) {
            this.getMainSearchTextField().setSelectedItem(startText);
        }
        this.m_modePanel.addModeChangeListener(new SearchWindow.RegexModeSwitchListener(this, this.m_modePanel, (JTextComponent)this.m_searchSource.getTextField().getEditor().getEditorComponent()));
        this.m_modePanel.addModeChangeListener(new SearchWindow.RegexModeSwitchListener(this, this.m_modePanel, (JTextComponent)this.m_searchTarget.getTextField().getEditor().getEditorComponent()));
        this.m_modePanel.addModeChangeListener(new SearchWindow.RegexModeSwitchListener(this, this.m_modePanel, (JTextComponent)this.m_searchNotes.getTextField().getEditor().getEditorComponent()));
        this.getMainSearchTextField().requestFocus();
    }

    @Override
    protected String getScopeText() {
        return OStrings.getString("SW_HELP_SCOPE_PROJECT");
    }

    @Override
    protected boolean isReplace() {
        return false;
    }

    @Override
    protected JComponent textPanel(String startText) {
        Box bSearch = Box.createVerticalBox();
        bSearch.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), OStrings.getString("SW_ZONE_TEXT")));
        this.m_searchNotes = new ProjectSearchWindow.MemoryTextField(this, "SW_SEARCH_NOTES|SW_SEARCH_PROPS", true, theMap.get("SW_SEARCH_NOTES:EXACT"));
        this.m_searchTarget = new ProjectSearchWindow.MemoryTextField(this, "SW_SEARCH_TRANSLATION", true, theMap.get("SW_SEARCH_TRANSLATION:EXACT"));
        this.m_searchSource = new ProjectSearchWindow.MemoryTextField(this, "SW_SEARCH_SOURCE", true, theMap.get("SW_SEARCH_SOURCE:EXACT"));
        this.m_searchAllSame = new JCheckBox();
        Mnemonics.setLocalizedText(this.m_searchAllSame, OStrings.getString("SW_ZONE_TEXT_ALL"));
        this.m_AND = new JRadioButton(OStrings.getString("SW_SEARCH_TEXT_AND"));
        this.m_OR = new JRadioButton(OStrings.getString("SW_SEARCH_TEXT_OR"));
        this.m_ANDTHEN = new JRadioButton(OStrings.getString("SW_SEARCH_TEXT_AND_THEN"));
        ButtonGroup gOptions = new ButtonGroup();
        gOptions.add(this.m_AND);
        gOptions.add(this.m_OR);
        gOptions.add(this.m_ANDTHEN);
        bSearch.add(this.m_searchSource);
        bSearch.add(Box.createHorizontalStrut(10));
        bSearch.add(this.m_searchTarget);
        bSearch.add(Box.createHorizontalStrut(10));
        bSearch.add(this.m_searchNotes);
        bSearch.add(Box.createHorizontalStrut(10));
        Box bOptions = Box.createHorizontalBox();
        bSearch.add(bOptions);
        bOptions.add(this.m_searchAllSame);
        bOptions.add(this.m_AND);
        bOptions.add(this.m_OR);
        bOptions.add(this.m_ANDTHEN);
        this.m_AND.setSelected(true);
        this.m_searchAllSame.addActionListener(new ActionListener(){
            private final KeyListener dispatch = new KeyListener(){

                @Override
                public void keyPressed(KeyEvent e) {
                }

                @Override
                public void keyTyped(KeyEvent e) {
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    FullProjectSearchWindow.this.m_searchTarget.setValue(FullProjectSearchWindow.this.m_searchSource.getValue());
                    FullProjectSearchWindow.this.m_searchNotes.setValue(FullProjectSearchWindow.this.m_searchSource.getValue());
                }
            };

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FullProjectSearchWindow.this.m_searchAllSame.isSelected()) {
                    FullProjectSearchWindow.this.m_searchTarget.setValue(FullProjectSearchWindow.this.m_searchSource.getValue());
                    FullProjectSearchWindow.this.m_searchNotes.setValue(FullProjectSearchWindow.this.m_searchSource.getValue());
                    FullProjectSearchWindow.this.m_searchTarget.getTextField().setEnabled(false);
                    FullProjectSearchWindow.this.m_searchNotes.getTextField().setEnabled(false);
                    FullProjectSearchWindow.this.m_searchSource.getTextField().addKeyListener(this.dispatch);
                    FullProjectSearchWindow.this.m_ANDTHEN.setEnabled(false);
                    FullProjectSearchWindow.this.m_AND.setSelected(true);
                } else {
                    FullProjectSearchWindow.this.m_searchTarget.getTextField().setEnabled(FullProjectSearchWindow.this.m_searchTarget.isOpen());
                    FullProjectSearchWindow.this.m_searchNotes.getTextField().setEnabled(FullProjectSearchWindow.this.m_searchNotes.isOpen());
                    FullProjectSearchWindow.this.m_searchSource.getTextField().removeKeyListener(this.dispatch);
                    FullProjectSearchWindow.this.m_ANDTHEN.setEnabled(true);
                }
            }
        });
        return bSearch;
    }

    @Override
    public JComboBox getMainSearchTextField() {
        for (ProjectSearchWindow.MemoryTextField field : new ProjectSearchWindow.MemoryTextField[]{this.m_searchSource, this.m_searchTarget, this.m_searchNotes, this.m_authorField}) {
            if (!field.isOpen()) continue;
            return field.getTextField();
        }
        return this.m_searchSource.getTextField();
    }

    @Override
    protected Box optionsPanel() {
        this.m_searchTranslated = new JRadioButton();
        this.m_searchUntranslated = new JRadioButton();
        this.m_searchTranslatedUntranslated = new JRadioButton();
        Mnemonics.setLocalizedText(this.m_searchTranslated, OStrings.getString("SW_SEARCH_TRANSLATED"));
        Mnemonics.setLocalizedText(this.m_searchUntranslated, OStrings.getString("SW_SEARCH_UNTRANSLATED"));
        Mnemonics.setLocalizedText(this.m_searchTranslatedUntranslated, OStrings.getString("SW_SEARCH_TRANSLATEDUNTRANSLATED"));
        Box bOB = super.optionsPanel();
        bOB.add(this.m_searchTranslated);
        bOB.add(this.m_searchUntranslated);
        bOB.add(this.m_searchTranslatedUntranslated);
        this.addFocusToSearchListener(this.m_searchTranslated);
        this.addFocusToSearchListener(this.m_searchUntranslated);
        this.addFocusToSearchListener(this.m_searchTranslatedUntranslated);
        ButtonGroup gOptions = new ButtonGroup();
        gOptions.add(this.m_searchTranslated);
        gOptions.add(this.m_searchUntranslated);
        gOptions.add(this.m_searchTranslatedUntranslated);
        return bOB;
    }

    @Override
    public Box wherePanel() {
        Box bWhere = Box.createHorizontalBox();
        this.m_sourceSearchCB = new JCheckBox();
        this.m_tmSearchCB = new JCheckBox();
        this.m_ongoingSearchCB = new JCheckBox();
        this.m_orphansSearchCB = new JCheckBox();
        this.m_glossaryCB = new JCheckBox();
        Mnemonics.setLocalizedText(this.m_sourceSearchCB, OStrings.getString("SW_SEARCH_IN_SOURCE"));
        Mnemonics.setLocalizedText(this.m_tmSearchCB, OStrings.getString("SW_SEARCH_IN_TMS"));
        Mnemonics.setLocalizedText(this.m_ongoingSearchCB, OStrings.getString("SW_SEARCH_IN_ONGOING"));
        Mnemonics.setLocalizedText(this.m_orphansSearchCB, OStrings.getString("SW_SEARCH_IN_ORPHANS"));
        Mnemonics.setLocalizedText(this.m_glossaryCB, OStrings.getString("SW_SEARCH_IN_GLOSSARIES"));
        bWhere.add(this.m_sourceSearchCB);
        bWhere.add(this.m_ongoingSearchCB);
        bWhere.add(this.m_orphansSearchCB);
        bWhere.add(this.m_tmSearchCB);
        bWhere.add(this.m_glossaryCB);
        bWhere.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), OStrings.getString("SW_SEARCH_SCOPE")));
        bWhere.add(Box.createHorizontalStrut(10));
        this.m_FileNameField = new ProjectSearchWindow.MemoryTextField(this, "SW_SEARCH_FILE", false, L_FILES);
        bWhere.add(this.m_FileNameField);
        this.addFocusToSearchListener(this.m_sourceSearchCB);
        this.addFocusToSearchListener(this.m_tmSearchCB);
        this.addFocusToSearchListener(this.m_ongoingSearchCB);
        this.addFocusToSearchListener(this.m_orphansSearchCB);
        this.addFocusToSearchListener(this.m_glossaryCB);
        return bWhere;
    }

    @Override
    protected Box buttonsPanel() {
        Box bCB = super.buttonsPanel();
        this.m_removeAttachedFilterButton = new JButton();
        this.m_removeAttachedFilterButton.setEnabled(false);
        this.m_filterButton = new JButton();
        this.m_filterButton.setEnabled(false);
        Mnemonics.setLocalizedText(this.m_filterButton, OStrings.getString("BUTTON_FILTER"));
        Mnemonics.setLocalizedText(this.m_removeAttachedFilterButton, OStrings.getString("BUTTON_REMOVEFILTER"));
        bCB.add(this.m_removeAttachedFilterButton);
        bCB.add(this.m_filterButton);
        this.m_filterButton.addActionListener(e -> {
            Core.getEditor().setFilter(new SearchFilter(this.m_viewer.getEntryList()));
            this.m_removeAttachedFilterButton.setEnabled(true);
        });
        this.m_removeAttachedFilterButton.addActionListener(e -> {
            this.m_removeAttachedFilterButton.setEnabled(false);
            Core.getEditor().removeAttachedFilter();
        });
        return bCB;
    }

    @Override
    protected void loadPreferences() {
        super.loadPreferences();
        this.m_searchSource.setOpen(Preferences.isPreferenceDefault("search_window_search_source", true));
        this.m_searchTarget.setOpen(Preferences.isPreferenceDefault("search_window_search_translation", false));
        this.m_searchNotes.setOpen(Preferences.isPreferenceDefault("search_window_search_notes", false));
        this.m_FileNameField.setOpen(Preferences.isPreferenceDefault("search_window_search_translator", false));
        this.m_sourceSearchCB.setSelected(Preferences.isPreferenceDefault("search_window_source_files", false));
        this.m_ongoingSearchCB.setSelected(Preferences.isPreferenceDefault("search_window_ongoing", true));
        this.m_orphansSearchCB.setSelected(Preferences.isPreferenceDefault("search_window_orphans", true));
        this.m_tmSearchCB.setSelected(Preferences.isPreferenceDefault("search_window_tm_search", true));
        this.m_glossaryCB.setSelected(Preferences.isPreferenceDefault("search_window_glossary_search", true));
        String searchState = Preferences.getPreference("search_window_search_state");
        if (StringUtil.isEmpty(searchState)) {
            searchState = "TRANSLATED_AND_UNTRANSLATED";
        }
        this.m_searchTranslated.setSelected(TranslationStateFilter.TRANSLATED_ONLY.toString().equals(searchState));
        this.m_searchUntranslated.setSelected(TranslationStateFilter.UNTRANSLATED_ONLY.toString().equals(searchState));
        this.m_searchTranslatedUntranslated.setSelected(TranslationStateFilter.TRANSLATED_AND_UNTRANSLATED.toString().equals(searchState));
    }

    @Override
    protected void savePreferences() {
        Preferences.setPreference("search_window_search_source", Boolean.toString(this.m_searchSource.isOpen()));
        Preferences.setPreference("search_window_search_translation", Boolean.toString(this.m_searchTarget.isOpen()));
        Preferences.setPreference("search_window_search_notes", Boolean.toString(this.m_searchNotes.isOpen()));
        Preferences.setPreference("search_window_source_files", Boolean.toString(this.m_sourceSearchCB.isSelected()));
        Preferences.setPreference("search_window_ongoing", Boolean.toString(this.m_ongoingSearchCB.isSelected()));
        Preferences.setPreference("search_window_orphans", Boolean.toString(this.m_orphansSearchCB.isSelected()));
        Preferences.setPreference("search_window_tm_search", Boolean.toString(this.m_tmSearchCB.isSelected()));
        Preferences.setPreference("search_window_glossary_search", Boolean.toString(this.m_glossaryCB.isSelected()));
        Preferences.setPreference("search_window_search_state", this.buildTranslationStateFilter().toString());
        super.savePreferences();
    }

    @Override
    protected ProjectSearcher buildSearcher(Searcher previous) throws IllegalArgumentException {
        TextExpression exprSource = null;
        TextExpression exprTarget = null;
        TextExpression exprNote = null;
        if (this.m_searchSource.isUsed()) {
            exprSource = this.m_modePanel.buildExpression(this.m_searchSource.getValue(), this.m_searchSource.isNot(), true);
        }
        if (this.m_searchTarget.isUsed()) {
            exprTarget = this.m_modePanel.buildExpression(this.m_searchTarget.getValue(), this.m_searchTarget.isNot(), false);
        }
        if (this.m_searchNotes.isUsed()) {
            exprNote = this.m_modePanel.buildExpression(this.m_searchNotes.getValue(), this.m_searchNotes.isNot(), false);
        }
        if (exprSource == null && exprTarget == null && exprNote == null) {
            throw new IllegalArgumentException(OStrings.getString("SW_ERROR_ALMOST_ONE_FIELD"));
        }
        int whereFlags = (this.m_sourceSearchCB.isSelected() ? 16 : 0) + (this.m_ongoingSearchCB.isSelected() ? 1 : 0) + (this.m_orphansSearchCB.isSelected() ? 2 : 0) + (this.m_tmSearchCB.isSelected() ? 4 : 0) + (this.m_glossaryCB.isSelected() ? 8 : 0);
        if (whereFlags == 0) {
            throw new IllegalArgumentException(OStrings.getString("SW_ERROR_ALMOST_ONE_SCOPE"));
        }
        return new FullProjectSearcher(this, Core.getProject(), this.m_removeDupCB.isSelected(), this.m_trueMissingCB.isSelected(), (Integer)this.m_numberOfResults.getValue(), this.buildTranslationStateFilter(), whereFlags, this.m_FileNameField.isUsed() ? this.m_FileNameField.getValue() : null, exprSource, exprTarget, exprNote, this.m_searchNotes.getSelectedField(), this.m_AND.isSelected(), this.m_ANDTHEN.isSelected(), this.m_authorField.isUsed() ? this.m_modePanel.buildExpression(this.m_authorField.getValue(), this.m_authorField.isNot(), false) : null, this.m_translatorField.isUsed() ? this.m_modePanel.buildExpression(this.m_translatorField.getValue(), this.m_translatorField.isNot(), false) : null, this.m_dateFrom.isUsed() ? this.m_dateFrom.getValue().getTime() : Long.MAX_VALUE, this.m_dateTo.isUsed() ? this.m_dateTo.getValue().getTime() : Long.MIN_VALUE);
    }

    private TranslationStateFilter buildTranslationStateFilter() {
        return this.m_searchTranslated.isSelected() ? TranslationStateFilter.TRANSLATED_ONLY : (this.m_searchUntranslated.isSelected() ? TranslationStateFilter.UNTRANSLATED_ONLY : TranslationStateFilter.TRANSLATED_AND_UNTRANSLATED);
    }

    @Override
    protected JComponent[] componentsEnabledWhenResults() {
        if (this.m_viewer.getEntryList().size() > 0) {
            return new JComponent[]{this.m_filterButton};
        }
        return new JComponent[0];
    }

    @Override
    protected JTextComponent[] textFieldsList() {
        return new JTextComponent[0];
    }

    @Override
    protected boolean isSearchPossible() {
        return (this.m_tmSearchCB.isSelected() || this.m_ongoingSearchCB.isSelected() || this.m_orphansSearchCB.isSelected() || this.m_sourceSearchCB.isSelected() || this.m_glossaryCB.isSelected()) && super.isSearchPossible();
    }

    static {
        for (String field : new String[]{"SW_SEARCH_SOURCE", "SW_SEARCH_TRANSLATION", "SW_SEARCH_NOTES"}) {
            for (String mode : new String[]{"EXACT", "KEYWORD", "REGEXP"}) {
                theMap.put(field + ":" + mode, new TreeSet());
            }
        }
        TreeSet fileSet = new TreeSet();
        theMap.put("SW_SEARCH_FILE:EXACT", fileSet);
        theMap.put("SW_SEARCH_FILE:KEYWORD", fileSet);
        theMap.put("SW_SEARCH_FILE:REGEXP", fileSet);
        CoreEvents.registerProjectChangeListener(new SearchWindow.SearchesLoader<Set<String>>("FullProjectSearchWindow", theMap));
        L_FILES = new TreeSet<String>();
    }
}

